<?php

	include "library.php";

	$cxn = start_code();


		/* start the page  */

		// don't put this before a jump_to_page()
//	page_header( "View Profiles", $cxn );

	if (val( $_GET, 'country' ) != "")
		$curr_country = urldecode( val( $_GET, 'country' ) );
	else
		$curr_country = "";


		/* not required */

	$account_id = val( $_SESSION, 'account_id' );


		/* determine the search criteria */

	$min_price = str_replace( "'", "''", val( $_SESSION, "min_price" ) );
	$max_price = str_replace( "'", "''", val( $_SESSION, "max_price" ) );
	$industry = str_replace( "'", "''", val( $_SESSION, "industry" ) );
	$suburb = str_replace( "'", "''", val( $_SESSION, "suburb" ) );
	$city = str_replace( "'", "''", val( $_SESSION, "city" ) );
	$province = str_replace( "'", "''", val( $_SESSION, "province" ) );
	$country = str_replace( "'", "''", val( $_SESSION, "country" ) );
//	$region = str_replace( "'", "''", val( $_SESSION, "region" ) );
	$search_for_word = str_replace( "'", "''", val( $_SESSION, "search_for_word" ) );

	$start_pos = val( $_GET, "startpos" );



	crash_if_missing( $start_pos, "start pos missing in view_listings", $cxn );

    log_hits( "search", $cxn );


	$query = "SELECT account.id as account_id, listing.id as listing_id, listing.currency_code, listing.price, listing.show_price_on_site, listing.city, listing.province, listing.country, listing.headline_title, listing.short_description from listing INNER JOIN account ON listing.account_id = account.id WHERE account.deleted = 'no' AND listing.deleted = 'no' ";

	if ($min_price <> "")
		$query = $query." AND price >= ".$min_price;

	if ($max_price <> "")
		$query = $query." AND price <= ".$max_price;

	if ($industry <> "")
		$query = $query." AND industry like '%".$industry."%'";

	if ($city <> "")
		$query = $query." AND listing.city = '".$city."'";

	if ($province <> "")
		$query = $query." AND listing.province = '".$province."'";

	if ($country <> "")
		$query = $query." AND listing.country = '".$country."'";
		
//	if ($region <> "")
//		$query = $query." AND listing.region = '".$region."'";

	if ($search_for_word != "")
		$query = $query." AND (headline_title like '%".$search_for_word."%' OR short_description like '%".$search_for_word."%' OR long_description like '%".$search_for_word."%' )";


	$query .= " ORDER BY listing.id DESC";


		/* run the query */

	$result = run_query( $query, $cxn );

	$found_one = "false";


		/* put rows in the range into the array */

	$num_rows = 0;

	for ($i=0; $i < query_num_rows($result); $i++)
	{
		$this_row = get_row( $result );

		$include = true;

		if ($include)
		{
			$data[$num_rows] = $this_row;

			$key_values[$num_rows] = $this_row['listing_id'];
			
			$num_rows++;
		}
	}

		/* sort by the relevant key/score */

	if ($num_rows != 0)
	{
		$key_values = sort_array( $key_values, $num_rows );

		for ($i=0; $i < $num_rows; $i++)
			$data2[$i] = $data[$key_values[$i]];

		$data = $data2;
	}
	

		/* if the user's search result was too restrictive, widen it */

//	if (val( $_SESSION, 'search_attempt' ) == "1" && $num_rows < 10 && $start_pos == "0" && $logged_on != "on")
//		widen_search( $min_price, $max_price, $country, $cxn );


		/* page output starts here */

	page_header( "View Listings", $cxn );


	if (val( $_SESSION, 'search_attempt' ) == "2" && $num_rows != 0)
		echo "<p align='center'>".black( "Your search returned a small number of results. This is a wider search." )."</p>";


		/* listing numbers in the list start at 0 */
		/* move down the list to the starting position */

	$num_per_page = 25;

	if ($start_pos + $num_per_page <= $num_rows)
		$num_this_page = $num_per_page;
	else
		$num_this_page = $num_rows - $start_pos;


		/* show the profile list display */

	for ($i=$start_pos; $i < $start_pos + $num_this_page; $i++)
	{
		$found_one = "true";

		echo "<a name='id".$data[$i]['listing_id']."'>";		/* bookmark to go back to search screen */

//		echo "<table width='100%' style='table-layout: fixed; width: 100%;'><tr><td width='5%'></td><td width='10%'></td><td width='10%'></td><td width='40%'></td><td width='15%'></td><td width='15%'></td></tr>";

		echo "<table width='100%'<tr>";

		echo "<td width='5%'>";
		
		echo watermark( $data[$i]['listing_id'] );

//		if ($data[$i]['logged_in'] != "")
//			echo "<br><br>".watermark( "online now" );

		echo "</td><td width='16%' align='center' valign='center' rowspan='2'>";

		show_photo( $data[$i]['listing_id'], 125, -1, true, false, $cxn );

		echo "</td><td width='10%' align='center'>";

        if ($data[$i]['show_price_on_site'] == "on")
			echo black( $data[$i]['currency_code']." ".number_format( floatval( $data[$i]['price'] )));
			
		echo "</td>";

		echo "<td width='42%'><br><b>";
		
		echo show_listing_heading($data[$i]['listing_id'], $data[$i]['headline_title'], "search", $start_pos )."</b><br><br>";

		echo black( convert_to_html( $data[$i]['short_description'] ) )."<br><br></td>";
		
		echo "<td width='2%'></td>";

        if (! low_res_screen())
        {
    		echo "<td width='8%' aligh='left'>".black( name_case( $data[$i]['city'] ) )."</td>";
    		
            if ($data[$i]['province'] != "")
        		echo "<td width='8%' aligh='left'>".black( name_case( $data[$i]['province'] ) )."</td>";
        	else
    		    echo "<td width='8%' aligh='left'></td>";

			echo "<td width='8%' aligh='left'>".black( $data[$i]['country'] )."</td>";
        }
        else
        {
    		echo "<td width='10%' aligh='left'>".black( name_case( $data[$i]['city'] ) )."<br><br>";

            if ($data[$i]['province'] != "")
        		echo black( name_case( $data[$i]['province'] ) )."<br><br>";
    		
			echo black( $data[$i]['country'] )."</td>";
        }

		echo "</tr></table><hr>";
	}

	if ($found_one == "false")
	{
//		if ($logged_on == "on")
//			echo "<br><br><br><br><p align='center'>".black( "There are no members logged on who match your search criteria" )."</p><br>";
//		else

			echo "<br><br><br><br><p align='center'>".black( "There are no listings matching your search criteria" )."</p><br>";

			echo "<p align='center'>".black( "This is a new site. We welcome new listings (free)." )."</p><br>";
			
	}
	else
	{
			/* show the next-page and previous-page links */

		$prev_page = $start_pos - $num_per_page;
		$next_page = $start_pos + $num_per_page;
		$end_pos = $start_pos + $num_this_page - 1;

		echo "<br><br>";
		
		echo "<p align='center'>";

		$start = $start_pos + 1;
		$end = $end_pos + 1;

		
		echo red( "Listings ".$start." to ".$end."<br><br>" );

		echo red( "This is a new site. We welcome new listings (free)." )."<br><br>";


		if ($start_pos > 1)
			echo show_link( "Previous Page", "view_listings.php", "startpos", $prev_page );

		if ($start_pos + $num_per_page < $num_rows)
		{
			if ($start_pos > 1)
				echo sp(10);

			echo show_link( "Next Page", "view_listings.php", "startpos", $next_page );
		}

		echo "</p>";
	}

	echo "<p align='center'>";


		/* a few blank lines so text is not crammed at the end of the screen */

	echo "<br>";

//	echo "<p align='center'>".black( "To see a search of all members " ).show_link( "click here", "search_all.php" )."</p>";


		/* show ads for non-charging countries */

	echo "<br><br><br><br>";

    if (! low_res_screen())
	    show_ads( $cxn );
	else
	    show_ads_large_square();
	    

	echo "<br><br><br><br><br><br><br><br>";
	
	
	echo "</body></html>";



		/* widen the search parameters and re-run the search */

	function widen_search( $min_price, $max_price, $country, $cxn )
	{
		$_SESSION['search_attempt'] = "2";

		$_SESSION['state'] = "";
		$_SESSION['city'] = "";

			/* eliminate country restriction if less than 50 listings */

		$query = "SELECT count(*) as num FROM listing WHERE country = '".$country."'";

		$result = run_query( $query, $cxn );

		if (mysql_num_rows($result) > 0)
		{
			$data = get_row( $result );

			if ($data['num'] < 30)
				$_SESSION['country'] = "";

		}

			/* must happen before print output */
			
		jump_to_page( "view_listings.php", "startpos", "0" );

		exit();
	}



		/* sort an array of sort keys */

	function sort_array( $key_values, $num_rows )
	{
		arsort( $key_values );

		$i = 0;

		foreach ($key_values as $key => $val)
		{
			$key_data2[$i] = $key;
			$i++;
		}

		return ($key_data2);
	}
?>