<?php

	define( "error_log_filename", "/home/academi1/public_html/philbusinessesforsale/error_log.txt" );
    define( "online_status_filename", "/home/academi1/public_html/philbusinessesforsale/online_status/online_status.txt" );
	define( "database_name", "academi1_philbusinessesforsale" );
	define( "domain", "philbusinessesforsale.com" );
	define( "pathroot", "/home/academi1/public_html/philbusinessesforsale" );
	define( "http_protocol", "https" );
    define( "sitename", "Philippines Businesses for Sale .com" );
	define( "common_data_database_name", "academi1_commondata" );

	include "/home/academi1/public_html/common_code/common_library.php";
	include "/home/academi1/public_html/common_code/forms_library.php";



	function start_code( $first=false, $db="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

		session_start();


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", pathroot."/error_log.txt" );

			// don't enable these options as they my expose technical details of the site to viewers
		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
		ini_set( "gc_maxlifetime", 3*60*60 );		/* set session timeout to 3 hours */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
		if (! $first )
			check_url();

		$cxn = db_login( database_name );

//                if ($cxn == 0)
//                    echo $domain."<br>";


		return ($cxn);
	}

		
		/* generate the heading line for a page */

		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn, $dont_jump=false )
	{

//		echo "<html><head><meta http-equiv='expires' content='".date( "D, d M Y", time() + 60*60*24*2 )." 00:00:00 GMT'>";

//		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'><meta http-equiv='expires' content='".date( "D, d M Y", time() - 60*60*24 )." 00:00:00 GMT'>";
		
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

        echo "<meta name=\"keywords\" content='Philippines,Business,Businesses,Listing,Listings,Sale'>";

        echo "<meta name='description' content='".sitename." is a free website for listing Businesses for Sale in the Philippines. The site is suitable for listing businesses of all sizes for sale and is completely free to use.'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";
		
		
        echo "<link rel='apple-touch-icon' sizes='57x57' href='/apple-icon-57x57.png'>";
        echo "<link rel='apple-touch-icon' sizes='60x60' href='/apple-icon-60x60.png'>";
        echo "<link rel='apple-touch-icon' sizes='72x72' href='/apple-icon-72x72.png'>";
        echo "<link rel='apple-touch-icon' sizes='76x76' href='/apple-icon-76x76.png'>";
        echo "<link rel='apple-touch-icon' sizes='114x114' href='/apple-icon-114x114.png'>";
        echo "<link rel='apple-touch-icon' sizes='120x120' href='/apple-icon-120x120.png'>";
        echo "<link rel='apple-touch-icon' sizes='144x144' href='/apple-icon-144x144.png'>";
        echo "<link rel='apple-touch-icon' sizes='152x152' href='/apple-icon-152x152.png'>";
        echo "<link rel='apple-touch-icon' sizes='180x180' href='/apple-icon-180x180.png'>";
        echo "<link rel='icon' type='image/png' sizes='192x192' href='/android-icon-192x192.png'>";
        echo "<link rel='icon' type='image/png' sizes='32x32' href='/favicon-32x32.png'>";
        echo "<link rel='icon' type='image/png' sizes='96x96' href='/favicon-96x96.png'>";
        echo "<link rel='icon' type='image/png' sizes='16x16' href='/favicon-16x16.png'>";

			/* javascript functions for chat etc. */


// commented out due to crashes. previously fully functional
//
//		write_js_functions();


//	$_SESSION['sitename'] = 'Philippines Businesses For Sale';


			/* define styles */

        echo "<style>";
        
		write_common_styles();
		
		$data = define_styles();

        echo "</style>";

		$bg = $data['bg'];
		$rose = $data['rose'];


        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();

		if ($heading != "")
		{
			echo "<title>".sitename.": ".$heading."</title></head>";
		}
		else
		{
			echo "<title>".sitename."</title></head>";
		}


        if (val( $_SESSION, "screen_width" ) == "")
    		echo "<body onload='js_set_screen_parameters();' bgcolor='".$bg."'>";
    	else
    		echo "<body bgcolor='".$bg."'>";


		if ($heading != "")
		{
		    $show_heading_bar = false;
		    
            if ($show_heading_bar)
            {
            	echo "<style> html, body {";
            	echo "margin:0;";
            	echo "padding:0;";
            	echo "}";
            	echo "</style>";

        		echo "<table cellspacing='0' width='100%'><tr><td style='padding-top: 3; padding-bottom: 3; font-family: Calibri; font-size: 13pt; color: #ffffff; background-color: #004499' valign='middle' align='left'>&nbsp;&nbsp;Philippines Businesses For Sale</td></tr></table>";
            }
            else
            {
    			echo "<table width='100%'><td width='30%'><span class='pgheading' valign='center'>".$heading."</span></td>";
    
    			if (! low_res_screen())
    			{
        			echo "<td width='10%' valign='center'><a class='redlink' href='".url_encode( "search_listings.php" )."'>search</a></td>";
        			echo "<td width='10%'></td>";
        			echo "<td width='10%' valign='center'><a class='redlink' href='".url_encode( "mailboxes.php", "box", "inbox" )."'>messages</a></td>";
        			echo "<td width='10%'></td>";
    			}
    			
    			echo "<td width='5%'></td>";
            }

			if ($show_heading_bar)
			    echo "<table width='100%'><tr>";
            
////			if (! low_res_screen())
//				show_google_translate();

			if ($show_heading_bar)
			    echo "<td width='55%' align='left'></td>";
			    
    		echo "<td width='20%' align='center'>";
    		
    		show_green_button( "Home", 80, "/" );
    		
    		echo "</td></tr></table>";

			echo "<br>";
		}
		else
		{
//    		if (! low_res_screen() && ! $home_page)    		
//			{
//				echo "<table width='100%'><tr><td width='80%'></td><td>";
//
//				show_google_translate();
//
//				echo "</td></tr></table>";
//			}
		}

	
		log_page_view( $cxn );
			
	}

		/* define the CSS styles */

	function define_styles()
	{
//		echo "<!--";

		$color_scheme = val( $_SESSION, 'color_scheme' );

				/* standard */

//		if ($color_scheme == "" || $color_scheme == 0 || $color_scheme == 3)

		{
			$bg = '#ffffff';

			$rose = "images/rose.gif";
			
			echo "body   		{ color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo "a:visited	{color: #0000bb; text-decoration: underline}";
			echo "a:link	{color: #0000bb; text-decoration: underline}";

			if (! low_res_screen())
			{			
				echo ".mainmenuheading    { color: #cc0000; background-color: #dddddd; font-family: verdana; font-size: ".fs( 12 )."pt}";
							
				echo ".mainmenuitem		{color: #0000cc; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:visited	{color: #0000cc; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:link	{color: #0000cc; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:hover	{color: #cc0000; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
			}
			else
			{
				echo ".mainmenuheading    { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
							
				echo ".mainmenuitem		{color: #0000cc; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:visited	{color: #0000cc; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:link	{color: #0000cc; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:hover	{color: green; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
			}
			echo ".hl {cursor: pointer; color: #bb0000; background-color: #e0e0e0; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
			echo ".uhl {color: #0000bb; background-color: #f3f3f3; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

			echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".ggrey          { color: #bbbbbb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".gemail         { color: #ff0000; font-family: courier; font-size: ".fs( 12 )."pt}";

			echo ".fprompt        { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".dtext          { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".paraheading    { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".pgheading      { color: #007500; font-family: verdana; font-size: ".fs( 16 )."pt}";
			
			if (! low_res_screen())
				echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 26 )."pt}";
			else
				echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 20 )."pt}";
				
			echo ".glink		  { color: #008500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:link	  { color: #008500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #008500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:hover    { color: darkgreen; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".redlink:visited { text-decoration: none; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:link  { text-decoration: none; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:hover { text-decoration: underline; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			
			echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".smalllink:visited { text-decoration: none; color: #000000; font-family: verdana; font-size: ".fs( 10 )."pt}";
			echo ".smalllink:link  { text-decoration: none; color: #000000; font-family: verdana; font-size: ".fs( 10 )."pt}";
			echo ".smalllink:hover { text-decoration: underline; color: #000000; font-family: verdana; font-size: ".fs( 10 )."pt}";

			echo ".chat		      { color: #000000; font-family: verdana; font-size: ".fs( 10 )."pt}";

		}
		


			/* mouseover highlight bar */

		echo "<script>";
		echo "function hl( idx )	{	document.getElementById(idx).className = \"hl\"; }";
		echo "function uhl( idx )	{	document.getElementById(idx).className = \"uhl\"; }";
		echo "</script>";

		$data['bg'] = $bg;
		$data['rose'] = $rose;

		return ($data);
	}


        
    function log_page_view( $cxn )
    {
        $ip_country = get_ip_country( $cxn );
        
        $today_date = date( "Y-m-d" );
        
        $query = "SELECT id FROM page_views WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."'";
        
        
            // on rare occasions there may be two records created for one date if two users are checking and adding at the same time.
            
        if (query_has_rows( $query, $cxn ))
        {
            $query = "UPDATE page_views SET count = count + 1 WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."'";
            
            $result = run_query( $query, $cxn );
        }
        else
        {
            $query = "INSERT INTO page_views (page_view_date, ip_country, count) VALUES ('".$today_date."', '".$ip_country."', 1 )";
            
            $result = run_query( $query, $cxn );            
        }
    }


		/* create a list of industries for a drop-down list */

	function build_industry_list( $cxn )
	{
//		$query = "SELECT * FROM static_data WHERE type = 'industry' ORDER BY value";
		$query = "SELECT * FROM industry ORDER BY display_name";
		
		$result = run_query( $query, $cxn );

		$industries = "<option></option>";

		for ($i=0; $i < query_num_rows($result); $i++)
		{
			$data = get_row( $result );

			$industries = $industries."<option>".$data['display_name']."</option>";
		}

		return $industries;
	}



	function show_photo( $listing_id, $height, $photo_number, $allow_zoom, $large, $cxn )
	{
		if ($photo_number == -1)
			$query = "SELECT * FROM photos WHERE listing_id = ".$listing_id." AND primary_photo = 'yes'";
		else
			$query = "SELECT * FROM photos WHERE listing_id = ".$listing_id." AND photo_number = ".$photo_number;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
		{
            show_no_photo( $height );
		}
		else
		{
			$data = get_row( $result );

			$width = $height * $data['aspect_ratio'];
			
			$version = $data['version'];
			
			
			    // allow for revised versions of photos due to rotating them etc.
			    
			if ($version == "")
			    $version_str = "";
			else
			    $version_str = "_v".$version;

			if ($large)
				$filename = "/photos/photo_".$listing_id."_".$data['photo_number']."_l".$version_str.".".$data['file_extension'];
			else
				$filename = "/photos/photo_".$listing_id."_".$data['photo_number']."_sm".$version_str.".".$data['file_extension'];

			if ($allow_zoom)
			{
				echo "<a href='".url_encode( "show_large_photo.php", "showid", $listing_id, "photonumber", $photo_number )."'>";
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."' border='0'>";
				echo "</a>";
			}
			else
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."'>";
		}
	}





	function show_listing_number( $listing_id, $returnpoint, $startpos )
	{
		if ($startpos == "")
			$startpos = "x";

		$url = url_encode( "display_listing.php", "showid", $listing_id, "returnpoint", $returnpoint, "startpos", $startpos );

		return ("<a href='".$url."'><span class='glink'>".$listing_id."</span></a>");
	}


	function show_listing_heading( $listing_id, $headline_title, $returnpoint, $startpos )
	{
		if ($startpos == "")
			$startpos = "x";

		$url = url_encode( "/display_listing.php", "showid", $listing_id, "returnpoint", $returnpoint, "startpos", $startpos );

		return ("<a class='glink' href='".$url."'>".$headline_title."</a>");
	}



		// don't put in the common library because there is a different tracking ID for each site
		
		// currently uses the Academic Dating tracking ID
		
	function show_google_translate( $background )
    {
        echo "<td width='15%' valign='top' style='background: ".$background."'>";
        echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
        echo ' function googleTranslateElementInit() { ';
        echo " new google.translate.TranslateElement({pageLanguage: 'en', gaTrack: true, gaId: 'UA-97849346-2'}, 'google_translate_element'); ";            
        echo ' } ';
        echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
        echo "</td>";
    }



		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
			// azure login credentials
		
//		$host="mlmlocalhost.mysql.database.azure.com";
//		$user="mlm1@mlmlocalhost";
//		$password="Tree$%12";
		
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";


        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}




		// Log into the common database. Must happen AFTER the login to the normal local database $cxn as it's set up for this
		// function only to create a second connection
		
//	function db_common_login()
//	{
//		$host="localhost";
//		$user="academi1_mlm1";
//		$password="plastic1";
//
//
//      $cxn_common = new mysqli( $host, $user, $password, "academi1_commondata" );
//  
//		if ($cxn_common->connect_errno)
//		{
//			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
//			
//			echo "Error number: ".$cxn_common->connect_errno."<br>";
//			echo "Error text: ".$cxn_common->connect_error."<br>";
//
//			exit();
//		}
//
//
//		return $cxn_common;
//	}	


		/* send an email to a member */

	function send_external( $to_id, $subject, $text_body, $html_body, $cxn, $queue )
	{
		$from_name = sitename;
		$from_addr = "noreply@philbusinessesforsale.com";
		$reply_name = sitename;
		$reply_addr = "noreply@philbusinessesforsale.com";

		$query = "SELECT email_address FROM account WHERE id = ".$to_id;

		$result = run_query( $query, $cxn );

		$data = get_row( $result );

			/* for prod use the live address, otherwise redirect */

		$domain = val( $_SERVER, "HTTP_HOST" );

		$to_addr = $data['email_address'];


		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );


		return ($to_addr);
	}


	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	
		if ($form_name == "pbfs_account")
		{
			$screen_data['confirm_email_address'] = $screen_data['email_address'];
			
			$screen_data['confirm_password'] = $screen_data['password'];
			
			if ($newrecord == "false")
				$screen_data['accepts_conditions'] = "on";
		}
		
	}


	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn )
	{
	    
		if ($form_name == "pbfs_account")
        {		
			if (! check_username( $newrecord, $screen_data['username'], $id, $cxn ))
			{
				$validation_errors = $validation_errors."This username name has already been used for an existing account<br>";
				$screen_data_error['username'] = "true";
			}
	    }
	
		if ($form_name == "pbfs_account" || $form_name == "pbfs_listing")
		{
			if ($screen_data['accepts_conditions'] != "on")
			{
				$validation_errors = $validation_errors."You must tick the checkbox at the bottom of the page signifying that you accept the conditions of use of this website.<br>";
	
				$screen_data_error['accepts_conditions'] = "true";
			}
		}
		
	}


		// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	}


	function show_ads( $cxn )
	{
	    echo "<table width='100%'><tr><td width='100%' align='center'>";
	    
	    show_ads_large_banner();
	    
	    echo "</td></tr></table>";
	}


	
		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
			//lightskyblue  #cceeff azure
			// lighter color first
			
		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #fcfcfc)'>\n";

	}

        // show the menu bar for the FAQ, Policies etc pages
        
	function show_info_menu( $cxn )
	{
		$bg = "#73b8bb";

        echo "<style>";
        echo "table.infomenubartable td {";
        echo "    color: #000000;";
//        echo "    line-height: 25pt;";
        echo "    font-size: ".fs( 12) ."pt;";
        echo "    font-family:verdana;";
        echo "    background-color: #73b8bb;";
        echo "}";
        
        echo "table.infomenubartable td:hover {";
        echo "      background-color: #eeeeee;";
        echo "      cursor: pointer;";
        echo "}";        
        echo "</style>";

		echo "<table class='infomenubartable' width='100%' border='0' cellspacing='0'>";

		echo "<tr bgcolor='".$bg."' >";

		echo show_one_info_menu_item( "FAQ", "faq.php" );
		
		echo show_one_info_menu_item( "Policies", "policies.php" );		
		
		echo show_one_info_menu_item( "Costs", "charges.php" );		

		echo show_one_info_menu_item( "About Us", "about_us.php" );		

		echo show_one_info_menu_item( "Contact Us", "contact_us.php" );		
		
//		echo show_one_info_menu_item( "Tips", "tips.php" );

		echo "</tr>";

		echo "</table>";
	}


        // show one item on the information menu bar
        
	function show_one_info_menu_item( $prompt, $page )
	{
		return "<td height='40' style='background-color: #73b8bb' width='4%'></td><td width='6%' align='center' onclick='location.href=\"".url_encode( $page )."\"'>".$prompt."</td><td style='background-color: #73b8bb' width='4%'></td>";
	}


		/* send the email to the user allowing them to verify their email address */

	function send_verification_email( $id, $email_verification_code, $cxn )
	{
		$first_name = "";
	
		$query = "SELECT first_name FROM account WHERE id = ".$id;

		if (query_has_rows( $query, $cxn ))
		{
			$result = run_query( $query, $cxn );
			$data = get_row( $result );
			$first_name = $data['first_name'];
		}

		$domain = val( $_SERVER, "HTTP_HOST" );
		
		$subject = "Verification email from ".sitename;

		$url = url_encode( http_protocol."://".domain."/verify_email.php", "verifyid", $id, "code", $email_verification_code );
		

		$text_body = "Hi ".$first_name.",\n\nThank you for joining Philippines Businesses for Sale.\n\nTo activate your account please copy and paste the following text into your browser address bar and press enter\n\n";
		$text_body .= $url;

		$text_body .= "If the link does not work when you click on it please copy and paste the following text into your browser address bar and press enter:<br><br>";
		
		$text_body .= $url;


		$html_body = "Hi ".$first_name.",<br><br>Thank you for joining Philippines Businesses for Sale.<br><br>To activate your account please click on the link below<br><br>";
//		$html_body .= show_link( "activate account", http_protocol."://".$domain."/verify_email.php", "verifyid", $id, "code", $email_verification_code );

		$html_body .= "<a href='".$url."'>activate account</a><br><br><br><br>";		
		
		$html_body .= "If the link does not work when you click on it please copy and paste the following text into your browser address bar and press enter:<br><br>";
		
		$html_body .= $url;
		

		return (send_external( $id, $subject, $text_body, $html_body, $cxn, "live" ));
	}


			/* check to see whether a new user has selected an existing handle */

	function check_username($newprofile, $username, $id, $cxn)
	{
		$username = str_replace( "'", "''", $username);

		if ($newprofile == "true")
			$query = "SELECT username FROM username_history WHERE username = '".$username."'";
		else
			$query = "SELECT username FROM username_history WHERE username = '".$username."' AND account_id <> ".$id;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
			return true;
		else
			return false;
	}

    function generate_custom_fields( $newrecord, $form_name, $field_name, $right_side_pane, $screen_data, $screen_data_error, $cxn )
    {
    }


    function show_city_links( $cxn )
    {
        echo "<span style='gblack'>&nbsp;&nbsp;City links</span><br><br>";

        echo "<table><tr><td width='2%'></td>";
        
        if (! low_res_screen())
            echo "<td>";

		$count = 1;
		show_city_link( $count, "Alaminos", $cxn );
		$count++;
		show_city_link( $count, "Angeles", $cxn );
		$count++;
		show_city_link( $count, "Antipolo", $cxn );
		$count++;
		show_city_link( $count, "Bacolod", $cxn );
		$count++;
		show_city_link( $count, "Bacoor", $cxn );
		$count++;
		show_city_link( $count, "Bago", $cxn );
		$count++;
		show_city_link( $count, "Baguio", $cxn );
		$count++;
		show_city_link( $count, "Bais", $cxn );
		$count++;
		show_city_link( $count, "Balanga", $cxn );
		$count++;
		show_city_link( $count, "Batac", $cxn );
		$count++;
		show_city_link( $count, "Batangas City", $cxn );
		$count++;
		show_city_link( $count, "Bayawan", $cxn );
		$count++;
		show_city_link( $count, "Baybay", $cxn );
		$count++;
		show_city_link( $count, "Bayugan", $cxn );
		$count++;
		show_city_link( $count, "Bislig", $cxn );
		$count++;
		show_city_link( $count, "Biñan", $cxn );
		$count++;
		show_city_link( $count, "Bogo", $cxn );
		$count++;
		show_city_link( $count, "Borongan", $cxn );
		$count++;
		show_city_link( $count, "Butuan", $cxn );
		$count++;
		show_city_link( $count, "Cabadbaran", $cxn );
		$count++;
		show_city_link( $count, "Cabanatuan", $cxn );
		$count++;
		show_city_link( $count, "Cabuyao", $cxn );
		$count++;
		show_city_link( $count, "Cadiz", $cxn );
		$count++;
		show_city_link( $count, "Cagayan de Oro", $cxn );
		$count++;
		show_city_link( $count, "Calamba", $cxn );
		$count++;
		show_city_link( $count, "Calapan", $cxn );
		$count++;
		show_city_link( $count, "Calbayog", $cxn );
		$count++;
		show_city_link( $count, "Caloocan", $cxn );
		$count++;
		show_city_link( $count, "Candon", $cxn );
		$count++;
		show_city_link( $count, "Canlaon", $cxn );
		$count++;
		show_city_link( $count, "Carcar", $cxn );
		$count++;
		show_city_link( $count, "Catbalogan", $cxn );
		$count++;
		show_city_link( $count, "Cauayan", $cxn );
		$count++;
		show_city_link( $count, "Cavite City", $cxn );
		$count++;
		show_city_link( $count, "Cebu City", $cxn );
		$count++;
		show_city_link( $count, "Cotabato City", $cxn );
		$count++;
		show_city_link( $count, "Dagupan", $cxn );
		$count++;
		show_city_link( $count, "Danao", $cxn );
		$count++;
		show_city_link( $count, "Dapitan", $cxn );
		$count++;
		show_city_link( $count, "Dasmariñas", $cxn );
		$count++;
		show_city_link( $count, "Davao City", $cxn );
		$count++;
		show_city_link( $count, "Digos", $cxn );
		$count++;
		show_city_link( $count, "Dipolog", $cxn );
		$count++;
		show_city_link( $count, "Dumaguete", $cxn );
		$count++;
		show_city_link( $count, "El Salvador", $cxn );
		$count++;
		show_city_link( $count, "Escalante", $cxn );
		$count++;
		show_city_link( $count, "Gapan", $cxn );
		$count++;
		show_city_link( $count, "General Santos", $cxn );
		$count++;
		show_city_link( $count, "General Trias", $cxn );
		$count++;
		show_city_link( $count, "Gingoog", $cxn );
		$count++;
		show_city_link( $count, "Guihulngan", $cxn );
		$count++;
		show_city_link( $count, "Himamaylan", $cxn );
		$count++;
		show_city_link( $count, "Ilagan", $cxn );
		$count++;
		show_city_link( $count, "Iligan", $cxn );
		$count++;
		show_city_link( $count, "Iloilo City", $cxn );
		$count++;
		show_city_link( $count, "Imus", $cxn );
		$count++;
		show_city_link( $count, "Iriga", $cxn );
		$count++;
		show_city_link( $count, "Isabela", $cxn );
		$count++;
		show_city_link( $count, "Kabankalan", $cxn );
		$count++;
		show_city_link( $count, "Kidapawan", $cxn );
		$count++;
		show_city_link( $count, "Koronadal", $cxn );
		$count++;
		show_city_link( $count, "La Carlota", $cxn );
		$count++;
		show_city_link( $count, "Lamitan", $cxn );
		$count++;
		show_city_link( $count, "Laoag", $cxn );
		$count++;
		show_city_link( $count, "Lapu‑Lapu", $cxn );
		$count++;
		show_city_link( $count, "Las Piñas", $cxn );
		$count++;
		show_city_link( $count, "Legazpi", $cxn );
		$count++;
		show_city_link( $count, "Ligao", $cxn );
		$count++;
		show_city_link( $count, "Lipa", $cxn );
		$count++;
		show_city_link( $count, "Lucena", $cxn );
		$count++;
		show_city_link( $count, "Maasin", $cxn );
		$count++;
		show_city_link( $count, "Mabalacat", $cxn );
		$count++;
		show_city_link( $count, "Makati", $cxn );
		$count++;
		show_city_link( $count, "Malabon", $cxn );
		$count++;
		show_city_link( $count, "Malaybalay", $cxn );
		$count++;
		show_city_link( $count, "Malolos", $cxn );
		$count++;
		show_city_link( $count, "Mandaluyong", $cxn );
		$count++;
		show_city_link( $count, "Mandaue", $cxn );
		$count++;
		show_city_link( $count, "Manila", $cxn );
		$count++;
		show_city_link( $count, "Marawi", $cxn );
		$count++;
		show_city_link( $count, "Marikina", $cxn );
		$count++;
		show_city_link( $count, "Masbate City", $cxn );
		$count++;
		show_city_link( $count, "Mati", $cxn );
		$count++;
		show_city_link( $count, "Meycauayan", $cxn );
		$count++;
		show_city_link( $count, "Muntinlupa", $cxn );
		$count++;
		show_city_link( $count, "Muñoz", $cxn );
		$count++;
		show_city_link( $count, "Naga", $cxn );
		$count++;
		show_city_link( $count, "Naga", $cxn );
		$count++;
		show_city_link( $count, "Navotas", $cxn );
		$count++;
		show_city_link( $count, "Olongapo", $cxn );
		$count++;
		show_city_link( $count, "Ormoc", $cxn );
		$count++;
		show_city_link( $count, "Oroquieta", $cxn );
		$count++;
		show_city_link( $count, "Ozamiz", $cxn );
		$count++;
		show_city_link( $count, "Pagadian", $cxn );
		$count++;
		show_city_link( $count, "Palayan", $cxn );
		$count++;
		show_city_link( $count, "Panabo", $cxn );
		$count++;
		show_city_link( $count, "Parañaque", $cxn );
		$count++;
		show_city_link( $count, "Pasay", $cxn );
		$count++;
		show_city_link( $count, "Pasig", $cxn );
		$count++;
		show_city_link( $count, "Passi", $cxn );
		$count++;
		show_city_link( $count, "Puerto Princesa", $cxn );
		$count++;
		show_city_link( $count, "Quezon City", $cxn );
		$count++;
		show_city_link( $count, "Roxas", $cxn );
		$count++;
		show_city_link( $count, "Sagay", $cxn );
		$count++;
		show_city_link( $count, "Samal", $cxn );
		$count++;
		show_city_link( $count, "San Carlos", $cxn );
		$count++;
		show_city_link( $count, "San Carlos", $cxn );
		$count++;
		show_city_link( $count, "San Fernando", $cxn );
		$count++;
		show_city_link( $count, "San Fernando", $cxn );
		$count++;
		show_city_link( $count, "San Jose del Monte", $cxn );
		$count++;
		show_city_link( $count, "San Jose", $cxn );
		$count++;
		show_city_link( $count, "San Juan", $cxn );
		$count++;
		show_city_link( $count, "San Pablo", $cxn );
		$count++;
		show_city_link( $count, "San Pedro", $cxn );
		$count++;
		show_city_link( $count, "Santa Rosa", $cxn );
		$count++;
		show_city_link( $count, "Santiago", $cxn );
		$count++;
		show_city_link( $count, "Silay", $cxn );
		$count++;
		show_city_link( $count, "Sipalay", $cxn );
		$count++;
		show_city_link( $count, "Sorsogon City", $cxn );
		$count++;
		show_city_link( $count, "Surigao City", $cxn );
		$count++;
		show_city_link( $count, "Tabaco", $cxn );
		$count++;
		show_city_link( $count, "Tabuk", $cxn );
		$count++;
		show_city_link( $count, "Tacloban", $cxn );
		$count++;
		show_city_link( $count, "Tacurong", $cxn );
		$count++;
		show_city_link( $count, "Tagaytay", $cxn );
		$count++;
		show_city_link( $count, "Tagbilaran", $cxn );
		$count++;
		show_city_link( $count, "Taguig", $cxn );
		$count++;
		show_city_link( $count, "Tagum", $cxn );
		$count++;
		show_city_link( $count, "Talisay", $cxn );
		$count++;
		show_city_link( $count, "Talisay", $cxn );
		$count++;
		show_city_link( $count, "Tanauan", $cxn );
		$count++;
		show_city_link( $count, "Tandag", $cxn );
		$count++;
		show_city_link( $count, "Tangub", $cxn );
		$count++;
		show_city_link( $count, "Tanjay", $cxn );
		$count++;
		show_city_link( $count, "Tarlac City", $cxn );
		$count++;
		show_city_link( $count, "Tayabas", $cxn );
		$count++;
		show_city_link( $count, "Toledo", $cxn );
		$count++;
		show_city_link( $count, "Trece Martires", $cxn );
		$count++;
		show_city_link( $count, "Tuguegarao", $cxn );
		$count++;
		show_city_link( $count, "Urdaneta", $cxn );
		$count++;
		show_city_link( $count, "Valencia", $cxn );
		$count++;
		show_city_link( $count, "Valenzuela", $cxn );
		$count++;
		show_city_link( $count, "Victorias", $cxn );
		$count++;
		show_city_link( $count, "Vigan", $cxn );
		$count++;
		show_city_link( $count, "Zamboanga City", $cxn );
		$count++;

        if (! low_res_screen())
            echo "</td>";

        echo "<td width='2%'>&nbsp;</td></tr></table>";
    }
    

	function show_city_link( $count, $city, $cxn )
	{
    
		if (low_res_screen() && $count > 1 && ($count-1) % 5 == 0)
			echo "<td width='2%'>&nbsp;</td></tr><tr><td style='font-size: 4pt'>&nbsp;</td></tr><tr><td></td>";

		if (! low_res_screen() && $count > 1)
			echo " &middot ";

		if (! low_res_screen())
    	    echo "<a href='/city/".$city.".php' class='smalllink'>".$city."</a>";
    	else
    	    echo "<td><a href='/city/".$city.".php' class='smalllink'>".$city."</a></td>";
	}
    
    
    function show_latest_listings( $cxn )
    {
    	$query = "SELECT account.id as account_id, listing.id as listing_id, listing.currency_code, listing.price, listing.show_price_on_site, listing.city, listing.province, listing.country, listing.headline_title, listing.short_description from listing INNER JOIN account ON listing.account_id = account.id WHERE account.deleted = 'no' AND listing.deleted = 'no' ORDER BY listing.id DESC LIMIT 10";

    	$result = run_query( $query, $cxn );
    
    	$found_one = "false";
    

    	for ($i=0; $i < query_num_rows($result); $i++)
    	{
    		$found_one = "true";
    
    		$data = get_row( $result );

    		echo "<a name='id".$data['listing_id']."'>";		/* bookmark to go back to search screen */
    
        		echo "<table width='100%'<tr>";
    
    		echo "<td width='5%'>";
    		
    		echo "&nbsp;".watermark( $data['listing_id'] );
    
    		echo "</td><td width='16%' align='center'>";
    
    		show_photo( $data['listing_id'], 125, -1, true, false, $cxn );
    
    		echo "</td><td width='10%' align='center'>";
    
            if ($data['show_price_on_site'] == "on")
    			echo black( $data['currency_code']." ".number_format( floatval( $data['price'] )));
    			
    		echo "</td>";
    
    		echo "<td width='42%'><b>";
    		
            $start_pos = 0;
    
    		echo show_listing_heading( $data['listing_id'], $data['headline_title'], "search", $start_pos )."</b><br><br>";

    		echo black( convert_to_html( $data['short_description'] ) )."<br><br></td>";
    		
    		echo "<td width='2%'></td>";
    
            if (! low_res_screen())
            {
        		echo "<td width='8%' aligh='left'>".black( name_case( $data['city'] ) )."</td>";
        		
                if ($data['province'] != "")
            		echo "<td width='8%' aligh='left'>".black( name_case( $data['province'] ) )."</td>";
            	else
            		echo "<td width='8%' aligh='left'></td>";
        		
    			echo "<td width='8%' aligh='left'>".black( $data['country'] )."</td>";
            }
            else
            {
        		echo "<td width='10%' aligh='left'>".black( name_case( $data['city'] ) )."<br><br>";
    
                if ($data['province'] != "")
            		echo black( name_case( $data['province'] ) )."<br><br>";
        		
    			echo black( $data['country'] )."</td>";
            }
    

    		echo "</tr></table><hr>";
    	}

    }
