<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";

	$cxn = start_code();

	page_header( "Upcoming transactions, next 7 days", $cxn );
	

	$today = date_create( date( "Y-m-d" ) );
	
	$today_plus_7_days = date_create( date( "Y-m-d" ) );

	date_add( $today_plus_7_days, date_interval_create_from_date_string( "7 days" ));


    $today_str = $today->format( "j M Y" );
    
    $today_plus_7_days_str = $today_plus_7_days->format( "Y-m-d" );		


	echo "<style type='text/css'>\n";
	echo "td ";
	echo " { ";
	echo " padding:0 8px 0 8px; ";
	echo " } ";
	echo "</style>";
	
	echo "<table>";


	echo "<tr>";
	echo "<td><b>".black( "Date" )."</b></td>";
	echo "<td><b>".black( "Description" )."</b></td>";
	echo "<td><b>".black( "Amount" )."</b></td>";
	echo "</tr>";

	echo "<tr><td>&nbsp;</td></tr>";

    echo "<tr>";
    echo "<td>".black( $today_str )."</td>";
    echo "<td>".black( 'Today' )."</td>";
    echo "</tr>";




	$query = "SELECT * FROM regular_transactions LEFT JOIN accounts ON regular_transactions.account = accounts.display_name WHERE next_due <= '".$today_plus_7_days_str."' ORDER BY next_due";

	$result = run_query( $query, $cxn );


	for ($i=0; $i < query_num_rows( $result ); $i++)
	{
		$data = get_row( $result );

    	$due_date = date_create( $data['next_due'] );

        $due_date_str = $due_date->format( "j M Y" );		

        echo "<tr>";
        echo "<td>".black( $due_date_str )."</td>";
        echo "<td>".black( $data['description'] )."</td>";
        
        if ($data['type'] == 'Expense' || $data['type'] == 'Transfer Out')
            echo "<td align='right'>".black( "-".number_format( $data['amount'], 2 ) )."</td>";
        else
            echo "<td align='right'>".black( number_format( $data['amount'], 2 ) )."</td>";
        
        echo "</tr>";
	}
	
	echo "</table>";

	echo "<br><br><br>";

	echo "&nbsp;&nbsp;";
		
	echo show_home_link();

	echo "<br><br><br>";

?>