<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";
	
//	include "/home/".hosting_account_name."/public_html/common_code/forms_library.php";

	$cxn = start_code();
	

	$start_date = val( $_POST, "start_date" );

	$end_date = val( $_POST, "end_date" );
	

    if ($start_date == "")
         $start_date = $_SESSION['start_date'];
         
    if ($end_date == "")
         $end_date = $_SESSION['end_date'];
         
         
     
	$report_start_date = convert_date_to_yyyymmdd( $start_date, "dd/mm/yyyy", $cxn );

	$report_end_date = convert_date_to_yyyymmdd( $end_date, "dd/mm/yyyy", $cxn );


    $report_start_date_dt = date_create( $report_start_date );
    
    $report_end_date_dt = date_create( $report_end_date );


    $number_days = date_diff( $report_start_date_dt, $report_end_date_dt )->format( "%a" );


  

    $_SESSION['start_date'] = $start_date;

    $_SESSION['end_date'] = $end_date;
    
    
	
	page_header( "P & L Combined", $cxn );
	

	echo black( $start_date." to ".$end_date."<br><br><br><br>" );

//	echo black( "&nbsp;&nbsp;&nbsp;".$start_date." to ".$end_date."<br><br><br><br>" );


	echo "<style type='text/css'>\n";
	echo "td ";
	echo " { ";
	echo " padding:0 8px 0 8px; ";
	echo " } ";
	echo "</style>";
	
	echo "<table>";


	echo "<tr>";
	echo "<td><b>".black( "Income" )."</b></td>";
	echo "<td></td>";
	
	if (! low_res_screen( $cxn ))
    	echo "<td></td>";
    	
	echo "<td>".black( "/week" )."</td>";
	echo "</tr>";

	$query = "SELECT transaction.effective_date, transaction.transaction_amount, transaction.account, accounts.display_name as account_description FROM transaction INNER JOIN accounts ON accounts.code = transaction.account WHERE accounts.type = 'Income' and effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."' AND (exclude_from_combined_p_and_l IS NULL OR exclude_from_combined_p_and_l <> 'yes')";
	
	$query .= " UNION ALL SELECT transaction.effective_date, transaction.net_amount as transaction_amount, transaction.account, accounts.display_name as account_description FROM aitkencv_accounts.transaction INNER JOIN aitkencv_accounts.accounts ON accounts.code = transaction.account WHERE accounts.type = 'Revenue' and effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."' AND (exclude_from_combined_p_and_l IS NULL OR exclude_from_combined_p_and_l <> 'yes') ";  
	
	$query .= " ORDER BY account_description, effective_date";	

	
    $revenue = show_transactions( $query, $report_start_date, $report_end_date, $number_days, false, $total_regular_amounts, $cxn );
	
	$total_revenue_regular_amounts = $total_regular_amounts;
	

	echo "<tr><td>&nbsp;</td></tr>";		
	echo "<tr><td>&nbsp;</td></tr>";		

	echo "<tr>";
	echo "<td><b>".black( "Expenses" )."</b></td>";
	echo "<td></td>";
	echo "<td></td>";
	echo "<td></td>";
	echo "</tr>";

	$query = "SELECT transaction.effective_date, transaction.transaction_amount, transaction.account, accounts.display_name as account_description FROM transaction INNER JOIN accounts ON accounts.code = transaction.account WHERE accounts.type = 'Expense' and effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."'  AND (exclude_from_combined_p_and_l IS NULL OR exclude_from_combined_p_and_l <> 'yes')";
	
	$query .= " UNION ALL SELECT transaction.effective_date, transaction.net_amount as transaction_amount, transaction.account, accounts.display_name as account_description FROM aitkencv_accounts.transaction INNER JOIN aitkencv_accounts.accounts ON accounts.code = transaction.account WHERE accounts.type = 'Expense' and effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."' AND (exclude_from_combined_p_and_l IS NULL OR exclude_from_combined_p_and_l <> 'yes')";  
	
	$query .= " ORDER BY account_description, effective_date";	

    $expenses = show_transactions( $query, $report_start_date, $report_end_date, $number_days, true, $total_regular_amounts, $cxn );
    
	$total_expenses_regular_amounts = $total_regular_amounts;
    
	echo "<tr><td>&nbsp;</td></tr>";		
	

/*
	echo "<tr><td>&nbsp;</td></tr>";		


	echo "<tr>";
	echo "<td><b>".black( "Net (regular amounts)" )."</b></td>";
	
	if (! low_res_screen( $cxn ))
        echo "<td></td>";
	        
	echo "<td align='right'>".black( number_format( $total_revenue_regular_amounts - $total_expenses_regular_amounts, 2 ) )."</td><td align='right'>".blue( number_format( (($total_revenue_regular_amounts - $total_expenses_regular_amounts) / $number_days) * 7, 0 ) )."</td>";
	echo "</tr>";
*/

	echo "<tr>";
	echo "<td><b>".black( "Net" )."</b></td>";
	
	if (! low_res_screen( $cxn ))
        echo "<td></td>";
	        
	echo "<td align='right'>".black( number_format( $revenue - $expenses, 2 ) )."</td><td align='right'>".blue( number_format( (($revenue - $expenses) / $number_days) * 7, 0 ) )."</td>";
	echo "</tr>";

/*
	$query = "SELECT sum(transaction_amount) as total FROM ".hosting_account_name."_personal_acc.transaction INNER JOIN ".hosting_account_name."_personal_acc.accounts ON accounts.code = transaction.account WHERE effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."' AND accounts.type = 'Transfer In'";
	
	$result = run_query( $query, $cxn );
	
	$data = get_row( $result );

    $bank_account_transfers_in = $data['total'];


	$query = "SELECT sum(transaction_amount) as total FROM ".hosting_account_name."_personal_acc.transaction INNER JOIN ".hosting_account_name."_personal_acc.accounts ON accounts.code = transaction.account WHERE effective_date >= '".$report_start_date."' AND effective_date <= '".$report_end_date."' AND accounts.type = 'Transfer Out'";
	$result = run_query( $query, $cxn );
	
	$data = get_row( $result );

    $bank_account_transfers_out = $data['total'];


	echo "<tr><td>&nbsp;</td></tr>";		
	echo "<tr><td>&nbsp;</td></tr>";		

	echo "<tr>";
	echo "<td><b>".black( "Transfers in" )."</b></td>";
		
	if (! low_res_screen( $cxn ))
        echo "<td></td>";
	        
	echo "<td align='right'>".black( number_format( $bank_account_transfers_in - $bank_account_transfers_out, 2 ) )."</td><td align='right'>".blue( number_format( (($bank_account_transfers_in - $bank_account_transfers_out) / $number_days) * 7, 0 ) )."</td>";
	echo "</tr>";
*/

/*
	echo "<tr><td>&nbsp;</td></tr>";		
	echo "<tr><td>&nbsp;</td></tr>";		

	$query = "SELECT sum(transaction_amount) as total FROM ".hosting_account_name."_accounts.transaction INNER JOIN ".hosting_account_name."_accounts.accounts ON transaction.account = accounts.code WHERE transaction.effective_date < '".$report_start_date."' AND accounts.type = 'Bank'";
	
	$result = run_query( $query, $cxn );
	
	$data = get_row( $result );

    $previous_total = $data['total'];
    

	$query = "SELECT sum(transaction_amount) as total FROM ".hosting_account_name."_accounts.transaction INNER JOIN ".hosting_account_name."_accounts.accounts ON transaction.account = accounts.code WHERE transaction.effective_date <= '".$report_end_date."' AND accounts.type = 'Bank'";
	
	$result = run_query( $query, $cxn );
	
	$data = get_row( $result );

    $total_current_month = $data['total'];

	echo "<tr>";
	echo "<td><b>".black( "Net change in ACV bank balances" )."</b></td>";
		
	if (! low_res_screen( $cxn ))
        echo "<td></td>";
	        
	echo "<td align='right'>".black( number_format( $total_current_month - $previous_total, 2 ) )."</td><td align='right'>".blue( number_format( (($total_current_month - $previous_total) / $number_days) * 7, 0 ) )."</td>";
	echo "</tr>";
*/

	
/*	
	$amount = $bank_account_transfers_in - $bank_account_transfers_out + $total_current_month - $previous_total;

	echo "<tr>";
	echo "<td><b>".black( "Net transfers in" )."</b></td>";
		
	if (! low_res_screen( $cxn ))
        echo "<td></td>";
	        
	echo "<td align='right'>".black( number_format( $amount, 2 ) )."</td><td align='right'>".blue( number_format( (($amount) / $number_days) * 7, 0 ) )."</td>";
	echo "</tr>";
*/

    echo "</table>";
    




    function show_transactions( $query, $report_start_date, $report_end_date, $number_days, $expenses, &$total_regular_amounts, $cxn )
    {
    	$gtotal = 0;
    	
    	$result = run_query( $query, $cxn );
    	
    	if (query_num_rows( $result ) == 0)
    	{
    		$gtotal_regular_amounts = 0;
			
//    		echo black( "There are no transactions listed in this report.<br><br>" );
    		
//    		echo show_home_link();
    		
//    		exit();
    	}
    	else
    	{

    		$total_income = 0;
    		
    		echo "<tr><td>&nbsp;</td></tr>";		
    
            $previous_type = "";
            $previous_account = "";
			$previous_account_description = "";
    		$total = 0;
            $gtotal = 0;
			$gtotal_regular_amounts = 0;            
    
    		for ($i=0; $i < query_num_rows( $result ); $i++)
    		{
    			$data = get_row( $result );
    
    			if ($data['account_description'] != $previous_account_description && $previous_account_description != "")
    			{
        			echo "<tr>";
        			
        			if (! low_res_screen( $cxn ))
        			    echo "<td>&nbsp;</td>";
        			    
        			echo "<td>".black( $previous_account_description )."</td>";
        			
        			$previous_account_url = urlencode( $previous_account_description );
        			
            		echo "<td align='right'><a href='show_transactions_combined.php?account_description=".$previous_account_url."&startdate=".$report_start_date."&enddate=".$report_end_date."&pageback=reports_p_and_l_combined.php' class='reportlink'>".blue( number_format( $total, 2 ) )."</td><td align='right'>".blue( number_format( ($total / $number_days) * 7, 0 ) )."</td>";
        			echo "</tr>";
        			
        			$total = 0;
    			}

    			$previous_account = $data['account'];
    			$previous_account_description = $data['account_description'];
    			
    			$total = $total + $data['transaction_amount'];
    			$gtotal = $gtotal + $data['transaction_amount'];
				
//				if ($data['regular_amount'] == 'yes')
//					$gtotal_regular_amounts += $data['transaction_amount'];			
    		}
    
    		echo "<tr>";

			if (! low_res_screen( $cxn ))
        		echo "<td>&nbsp;</td>";

    		echo "<td>".black( $previous_account_description )."</td>";

        	$previous_account_url = urlencode( $previous_account_description );
			
    		echo "<td align='right'><a href='show_transactions_combined.php?account_description=".$previous_account_url."&startdate=".$report_start_date."&enddate=".$report_end_date."&pageback=reports_p_and_l_combined.php' class='reportlink'>".blue( number_format( $total, 2 ) )."</td><td align='right'>".blue( number_format( ($total / $number_days) * 7, 0 ) )."</td>";

    		echo "</tr>";

    		echo "<tr><td>&nbsp;</td></tr>";
/*
    		echo "<tr>";

			if (! low_res_screen( $cxn ))
        		echo "<td>&nbsp;</td>";
        		
    		echo "<td>".black( "Total (regular amounts)" )."</td>";
    		echo "<td align='right'>".black( number_format( $gtotal_regular_amounts, 2 ) )."</td><td align='right'>".blue( number_format( ($gtotal_regular_amounts / $number_days) * 7, 0 ) )."</td>";
    		echo "</tr>";
*/

    		echo "<tr>";

			if (! low_res_screen( $cxn ))
        		echo "<td>&nbsp;</td>";

    		echo "<td>".black( "Total" )."</td>";
    		echo "<td align='right'>".black( number_format( $gtotal, 2 ) )."</td><td align='right'>".blue( number_format( ($gtotal / $number_days) * 7, 0 ) )."</td>";
    		echo "</tr>";
    	}

		$total_regular_amounts = $gtotal_regular_amounts;
		     	
    	return ($gtotal);
    }
    
				
	echo "</table>";

	echo "<br><br><br>";

	echo "&nbsp;&nbsp;";
		
	echo show_home_link( $cxn );

	echo "<br><br><br>";

?>