<?php
			// (c) Copyright Mark McIlroy 2020

	define( "common_data_database_name", "aitkencv_commondata" );
	define( "sitecode", "~PERSONAL_ACCOUNTS~" );
	define( "sitename", "Personal Accounts" );
	define( "translation_active", false );
	
	define( "error_log_filename", "/home/aitkencv/public_html/personal_acc/error_log.txt" );
    define( "database_name", "aitkencv_personal_acc" );

    define( "mail_library", "/home/aitkencv/public_html/common_code/mail_library.php" );

	include "/home/aitkencv/public_html/common_code/common_library.php";
	include "/home/aitkencv/public_html/common_code/forms_library.php";


    			/* startup code to be called at the top of each file */

	function start_code( $first=false, $db="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

		ini_set( "session_save_path", "/home/aitkencv/public_html/datingsites/sessions_tmp" );

		$session_id = val( $_COOKIE, "ACV_SESSION_ID" );
		
		if ($session_id == '')
		{
			$session_id = RAND( 100000000, 400000000 );
			
			$new_session = $session_id;
			
			setcookie( "ACV_SESSION_ID", $session_id, 0, "/", "", false, false );	
		}
		
        if (session_status() != PHP_SESSION_ACTIVE)
        {
    		$stat = session_start();
   		
//    		[
//                'use_cookies' => '0',
//                'use_only_cookie' => '0'
//    		]);

    		if ($stat == false)
    		    log_error_and_continue( "Session start failed" );
        }

		$_SESSION['domain'] = $domain;

		$_SESSION['pathroot'] = "/home/aitkencv/public_html/personal_acc";


			/* set up variables */

		$database = "aitkencv_personal_acc";


		$user = val( $_GET, "user" );


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", $_SESSION['pathroot']."/error_log.txt" );

			// don't enable these options as they my expose technical details of the site to viewers
		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
//		ini_set( "gc_maxlifetime", 1*60*60 );		/* set session timeout to 1 hour */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
//		if (! $first )
//			check_url();

		$cxn = db_login( $database );


		return ($cxn);
	}



		/* generate the heading line for a page */


		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn )
	{
    	echo "<style> html, body {";
    	echo "margin:0;";
    	echo "padding:0;";
    	echo "}";
    	echo "</style>";

        $amp = false;


        if (! low_res_screen( $cxn ))    
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='line-height: 45px; font-family: Calibri; font-size: 18pt; color: #ffffff; background-color: ".acv_bg_color."' align='left'>&nbsp;&nbsp;&nbsp;Personal Accounts</td></tr></table>";
        else
        	echo "<table cellpadding='0' cellspacing='0' width='100%'><tr><td style='line-height: 30px; font-family: Calibri; font-size: 14pt; color: #ffffff; background-color: ".acv_bg_color."' align='left'>&nbsp;&nbsp;&nbsp;Personal Accounts</td></tr></table>";

	    echo "<br>";

//        if (low_res_screen( $cxn ))    
//    	    echo "<br>";


        $_SESSION['sitename'] = sitename;

//		$_SESSION['session_active'] = "yes";
		
		echo '<html><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"><meta name="viewport" content="width=device-width, initial-scale=1.0">';

		echo "";

		echo '<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">';
		echo '<link rel="icon" href="/favicon.ico" type="image/x-icon">';



			/* define styles */

		echo "<style>";


		write_acv_styles();
		
		define_styles( $cxn );


		echo "</style>";


        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();


		if ($heading != "")
			echo "<title>".sitename.": ".$heading."</title></head>";
		else
			echo "<title>".sitename."</title></head>";


        if (val( $_SESSION, "screen_width" ) == "")
    		echo "<body onload='js_set_screen_parameters();'>";
    	else
    		echo "<body>";


		echo "<table width='100%'><tr><td width='2%'>&nbsp</td><td width='98%'>";

		if ($heading != "")
		{
		    if (! low_res_screen( $cxn ))
		    {
        		echo "<table width='100%' cellpadding='0' cellspacing='0'><tr>";
        		
        		echo "<td width='2%'>&nbsp;</td>";
    
        		echo "<td width='20%' class='pgheading' valign='center' style='padding: 0px; border-collapse: collapse;'>".$heading."</td>";
        		
        		echo "<td width='78%' align='left'>";
    
    			show_green_button( $cxn, "Home", 80, $amp, "index.php", "internaljump", "true" );
    
    			echo "</td></tr></table>";
    
                echo "<br>";
		    }
		    else
		    {
        		echo "<table width='100%' cellpadding='0' cellspacing='0'><tr><td width='80%' class='pgheading' valign='center' style='padding: 0px; border-collapse: collapse;'>".$heading."</td>";
    
    			echo "<td width='20%' align='center'>";
    
    			show_green_button( $cxn, "Home", 80, $amp, "index.php", "internaljump", "true" );
    			
    			echo "</td></tr></table>";
		    }

//			echo "<span style='font-size: 6pt'>&nbsp;<br></span>";
		}

/*
		if ($heading != "")
		{
    		echo "<table width='100%' cellpadding='0' cellspacing='0'><tr><td width='80%' class='pgheading' valign='center' style='padding: 0px; border-collapse: collapse;'>".$heading."</td>";

			echo "<td width='20%' align='center'>";

			show_green_button( "Home", 80, "index.php", "internaljump", "true" );
			
			echo "</td></tr></table>";
				
			echo "<span style='font-size: 6pt'>&nbsp;<br></span>";
		}
*/		
	}


		/* define the CSS styles */

	function define_styles( $cxn )
	{
		echo ".body   		{ color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo "a:visited	{color: #0000bb; text-decoration: underline}";
		echo "a:link	{color: #0000bb; text-decoration: underline}";

		echo "a.menubaritem			{color: #000000; font-size:".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:visited {color: #000000; font-size:".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:link	{color: #000000; font-size:".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:hover   {color: #000000; font-weight: bold; background-color: #eeeeee; font-size:".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".hl {cursor: pointer; color: #bb0000; background-color: #eeeeee; font-size:".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration: none}";
		echo ".uhl {color: #0000bb; font-size:".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gblue          { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".ggreen         { color: #00bb00; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".ggray          { color: #8f8f8f; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".gbrown         { color: #bf7d40; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".numbergreen    { color: #00a000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".numberred      { color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";


		if (! low_res_screen( $cxn ))
        {				
			echo ".fprompt        { padding-left: 8px; padding-right: 10px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
			echo ".finput         { padding-left: 8px; margin-right: 3px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";			
			echo ".fradio         { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

			echo ".fprompt_error  { padding-left: 8px; color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
			echo ".finput_error   { padding-left: 8px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
			echo ".fradio_error   { padding-left: 2px; color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
        }
        else
        {
			echo ".fprompt        { padding-left: 8px; padding-right: 10px; color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
			echo ".finput         { padding-left: 8px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";			
			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

			echo ".fprompt_error  { padding-left: 8px; color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
			echo ".finput_error   { padding-left: 8px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
        }

		echo ".dprompt        { padding-left: 2px; margin-right: 3px; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".dtext          { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".paraheading    { color: ".acv_bg_color."; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".mainmenuheading    { color: #000000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		
		echo ".mainmenuitem			{color: #0000bb; font-size: ".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:hover	{cursor: pointer; color: #00b000; font-size: ".fs( $cxn, 12 )."pt; font-family:verdana; text-decoration:none; background: #eeeeee;}";

	    echo ".menulink2      	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:link  	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:hover	{color: #bbbbbb; cursor: pointer; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    

		echo ".pgheading      { color: ".acv_bg_color."; font-family: verdana; font-size: ".fs( $cxn, 18 )."pt}";
//		echo ".pgheading      { color: #1E90FF; font-family: verdana; font-size: ".fs( 30 )."pt}";
		echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".glink		  { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".glink:visited  { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".glink:link     { color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".glink:hover    { color: #000080; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".reportlink		   { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".reportlink:visited  { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".reportlink:link     { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".reportlink:hover    { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".redlink:visited { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".redlink:link  { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".redlink:hover { text-decoration: underline; color: #ff0000; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		
		echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";

		echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
		echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( $cxn, 12 )."pt}";
	}



		// must have a blank function with this name because it is called by the central validation routine
		
	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn )
	{
/*
	    if ($form_name == "mpl_quote")
	    {
	        if ($screen_data['adviser'] == "" && $screen_data['practice'] == "")
	        {
    			$validation_errors = $validation_errors."You must select either a Practice or an Adviser<br>";
				
				$screen_data_error['practice'] = "true";
				$screen_data_error['adviser'] = "true";				
	        }
	    }
*/
	}
	
	
	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
/*
	    if ($form_name == "mpl_quote" && $newrecord == "true")
	    {
	        $screen_data['effective_date'] = date( "d/m/Y" );
	        $screen_data['status'] = "not_sent";
	    }
	    
	    if ($form_name == "mpl_credit_note" && $newrecord == "true")
	    {
	        $screen_data['effective_date'] = date( "d/m/Y" );
	        $screen_data['amount_paid'] = "0";
	    }
*/
	}
	
			// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
/*	
		if ($form_name == "task")
		{
			if ($newrecord == "true")
				$screen_data['date_created'] = date("Y-m-d H:i:s");
			
			$screen_data['date_modified'] = date("Y-m-d H:i:s");
		}
	
*/
	}



		// don't put in the common library because there is a different tracking ID for each site
		
		// currently uses the Academic Dating tracking ID
		
	function show_google_translate()
    {
        echo "<td width='15%' valign='top'>";
        echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
        echo ' function googleTranslateElementInit() { ';
        echo " new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";
        echo ' } ';
        echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
        echo "</td>";
    }



        /* send an email to a member */

	function send_external( $to_addr, $subject, $text_body, $html_body, $cxn, $queue )
	{
		$from_name = business_name;
		$from_addr = from_email_address;
		$reply_name = business_name;
		$reply_addr = reply_email_address;

		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );

		return ($to_addr);
	}



		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
		$host="localhost";
		$user="aitkencv_mlm1";
		$password="IndieLogin12%$";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}



    function sign_format( $number, $text )
    {
        if ($number >= 0)
            return( "<span class='numbergreen'>".$text."</span>" );
        else
            return( "<span class='numberred'>".$text."</span>" );
    }
    
    
    
        // sum of a transaction type within date range
        
    function get_transaction_total( $type, $start_date, $end_date, $cxn )
    {
    	$query = "SELECT sum(transaction_amount) as total FROM transaction INNER JOIN accounts ON accounts.code = transaction.account WHERE accounts.type = '".$type."' and effective_date >= '".$start_date."' AND effective_date <= '".$end_date."'";

    	$result = run_query( $query, $cxn );

    	if (query_num_rows( $result ) == 0)
            $total = 0;
        else
        {
		    $data = get_row( $result );

    		$total = $data['total'];
        }

        return ($total);
    }
    

		// don't put in the common library because different sites have different color schemes
		
	function form_start( $cxn, $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="" )
	{
			//lightskyblue  #cceeff azure
			// lighter color first
			 //linear-gradient(#fcfcfc, #e1e1e1)
			 // linear-gradient(#fcfcfc, #e1e1e1)
			 
		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: #F8FbFF; border-radius: 10px'>\n";
		
//		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(mintcream, teal)'>\n";
	}
	
	
    function generate_custom_fields( $newrecord, $form_name, $field_name, $right_side_pane, $screen_data, $screen_data_error, $cxn )
    {
/*        
        if ($form_name == "task" || $form_name == "mpl_quote")
*/  
    }

	
    function write_update_function()
    {
        echo "<script>";
        
        echo "function UpdateFee()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var soa_fee = document.getElementById( 'quoted_price' );";

        echo "  var paraplanner_commission = document.getElementById( 'paraplanner_commission' );";

        echo "  soa_fee.value = ".fee_calc_formula;

        echo "  paraplanner_commission.value = ".commission_calc_formula;

        echo "  checker_commission.value = ".checker_commission_calc_formula;
        echo "}";
        

        echo "function UpdateFee2()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var amount = document.getElementById( 'amount' );";

        echo "  amount_ex_gst.value = ".fee_calc_formula;
        
          echo "   gst.value =  parseInt(amount_ex_gst.value) * 0.1; ";
        
        echo "   if (gst.value.substr(gst.value.length-2, 1 ) == '.') ";
        echo "      gst.value = gst.value + '0'; ";

        echo "   total.value =  parseFloat(amount_ex_gst.value) + parseFloat(gst.value); ";

        echo "   if (total.value.substr(total.value.length-2, 1 ) == '.') ";
        echo "      total.value = total.value + '0'; ";
        
        echo "}";

        echo "</script>";
    }        

	
	function acv_bank_balances( $effective_date, $cxn )
	{
		$query = "SELECT sum(transaction_amount) as total FROM ".hosting_account_name."_accounts.transaction INNER JOIN ".hosting_account_name."_accounts.accounts ON transaction.account = accounts.code WHERE transaction.effective_date <= '".$effective_date."' AND accounts.type = 'Bank'";
		
		$result = run_query( $query, $cxn );
		
		$data = get_row( $result );
	
	    return ($data['total']);
	}



	function update_account_balances( $cxn )
	{
		$datetime_today = date( "Y-m-d H:i:s" );
					
		$query2 = "SELECT * FROM bank_account ORDER BY id";
		
    	$result2 = run_query( $query2, $cxn );
        
        for ($i=0; $i < query_num_rows( $result2 ); $i++)
        {
        	$data2 = get_row( $result2 );	
    
            $bank_account_code = $data2['account_code'];


        	$query = "SELECT sum(transaction_amount) as total FROM transaction INNER JOIN accounts ON accounts.code = transaction.account WHERE effective_date <= '".$datetime_today."' AND accounts.code = '".$bank_account_code."'";
        	
        	$result = run_query( $query, $cxn );
        	
        	$data = get_row( $result );
        
		    $account_balance = $data['total'];

		    if ($account_balance == '')
		    	$account_balance = '0';
		    
            $query3 = "UPDATE bank_account SET account_balance = ".round( $account_balance, 2 )." WHERE id = ".$data2['id'];
		
        	run_query( $query3, $cxn );
		}
	}
		
		
		
		
    function process_one_timeframe( $effective_date, $home_page, $show_data, $change_since_previous_month, $include_investments, $include_avalable_credit, $cxn )
    {
//    	if ($home_page)
			$decimals = 2;
//		else
//			$decimals = 0;
			
        if ($change_since_previous_month)
    	    $query2 = "SELECT * FROM bank_account WHERE include_in_month_total = 'yes'";
        else        
        if ($home_page)
    	    $query2 = "SELECT * FROM bank_account WHERE home_page_display_order IS NOT NULL ORDER BY home_page_display_order";
    	else
    	    $query2 = "SELECT * FROM bank_account WHERE display_order IS NOT NULL ORDER BY display_order";


		$query2 = "SELECT * FROM bank_account ORDER BY home_page_display_order";
		
			    
    	$result2 = run_query( $query2, $cxn );
    	
        $total_balance = 0;

		$total_cash_balance = 0;
        
        $total_available_credit = 0;
        
        for ($i=0; $i < query_num_rows( $result2 ); $i++)
        {
        	$data2 = get_row( $result2 );	
    
            $bank_account_code = $data2['account_code'];


//        	$query = "SELECT sum(transaction_amount) as total FROM transaction INNER JOIN accounts ON accounts.code = transaction.account WHERE effective_date <= '".$effective_date."' AND accounts.code = '".$bank_account_code."'";
        	
//        	$result = run_query( $query, $cxn );
        	
//        	$data = get_row( $result );
        
//            $account_balance = $data['total'];
        
            $account_balance = $data2['account_balance'];
			
			
        
            $total_balance += $account_balance;

			 
            if (($data2['credit_limit'] == '' || $data2['credit_limit'] == 0) && $data2['include_in_available_funds'] == 'yes')
		        $total_cash_balance += $account_balance;


            if ($data2['credit_limit'] > 0 && $data2['include_in_available_funds'] == 'yes')
                $total_available_credit += $data2['credit_limit'] + $account_balance;


            if ($show_data)            
            {
                if ($account_balance < 0)
                    $prefix = '-$';
                else
                    $prefix = "$";
                    
       	    	if (round( $account_balance, 2 ) != 0)
       	    	{
	        	    echo "<tr><td>";
	        	    
	        	    if ($data2['include_in_available_funds'] == 'yes')
	        	    	echo black( "*" );
	        	    	
	        	    echo black( $data2['display_name'] );
				}

                if ($account_balance > 0)
                    $account_balance_display = $account_balance;
                else
                    $account_balance_display = - $account_balance;

                if ($data2['credit_limit'] == 0)
                {
//                    echo black( " credit" );
        	    
        	    	if ($account_balance_display != 0)
	        	        echo "&nbsp;&nbsp;</td><td align='right'>".black( $prefix.number_format( $account_balance_display, $decimals ) )."</td></tr>";
                }
                else
                {
        	        echo "&nbsp;&nbsp;</td><td align='right'>".black( $prefix.number_format( $account_balance_display, $decimals ) )."</td></tr>";

            	    echo "<tr><td align='right'>".gray( "Avail" );
            	    
        	        echo "</td><td align='right'>".gray( "$".number_format( $data2['credit_limit'] + $account_balance, $decimals ) )."</td></tr>";
                }        
        	    
      	    	if ($account_balance_display != 0)
                    echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
            }
        }
        
        
    	$query = "SELECT display_name, account_balance as total, include_in_available_funds, bank_accounts.account_code as account_code FROM ".hosting_account_name."_accounts.bank_accounts INNER JOIN ".hosting_account_name."_accounts.accounts ON bank_accounts.account_code = accounts.code WHERE accounts.type = 'Bank' AND include_in_totals = 'yes'";

    	$result = run_query( $query, $cxn );

        for ($i=0; $i < query_num_rows( $result ); $i++)
        {
        	$data = get_row( $result );	


			$query2 = "SELECT * FROM ".hosting_account_name."_accounts.unrealised_pl WHERE account_code = '".$data['account_code']."' AND effective_date <= '".$effective_date."' ORDER BY effective_date DESC";

	    	$result2 = run_query( $query2, $cxn );

			if (query_num_rows( $result2 ) > 0)
			{
        		$data2 = get_row( $result2 );	

				$bank_effect = $data2['account_value'];
			}
			else			
		        $bank_effect = $data['total'];
			
	        
			if ($data['include_in_available_funds'] == 'yes')
			{
		        $total_balance += $bank_effect;
	
		        $total_cash_balance += $bank_effect;
			}
			
	        if ($show_data && round( $bank_effect, 2 ) != 0)            
	        {
				if ($data['include_in_available_funds'] == 'yes')
	        		$text = "*".$data['display_name'];
				else
	        		$text = $data['display_name'];
				
	        	echo "<tr><td>".black( $text )."</td><td align='right'>".black( "$".number_format( $bank_effect, $decimals ) )."</td></tr>";
	
	            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
	        }
		}
		
        
        if ($include_investments)
        {
            $query = "SELECT DISTINCT description FROM investments ORDER BY description";

        	$result = run_query( $query, $cxn );

            for ($i=0; $i < query_num_rows( $result ); $i++)
            {
            	$data = get_row( $result );	

                $query2 = "SELECT * FROM investments WHERE description = '".$data['description']."' AND effective_date <= '".$effective_date."' ORDER BY effective_date DESC LIMIT 1";
                
            	$result2 = run_query( $query2, $cxn );
    
                for ($i=0; $i < query_num_rows( $result2 ); $i++)
                {
                	$data2 = get_row( $result2 );	
    
                    if ($data2['value'] > 0)
                    {
                        $total_balance += $data2['value'];
                        
                        if ($show_data)            
                        {
                        	echo "<tr><td style='border-top: 1px solid #000000;'>".black( $data2['description'] )."</td><td style='border-top: 1px solid #000000;' align='right'>".black( "$".number_format( $data2['value'], $decimals ) )."</td></tr>";
    
                            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
                            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
                        }
                    }
                }
            }
        }


    	$query = "SELECT account_balance FROM cash_on_hand WHERE effective_date <= '".$effective_date."' ORDER BY effective_date DESC";
    	
    	$result = run_query( $query, $cxn );
    	
    	$data = get_row( $result );

        $total_balance += $data['account_balance'];

		$total_cash_balance += $data['account_balance'];

		$stripe_balance = stripe_current_balance();
		
		if ($stripe_balance > 0)
		{
	        $total_balance += $stripe_balance;

			$total_cash_balance += $stripe_balance;
			
	        if ($show_data && (! $home_page))
			{            
	        	echo "<tr><td>".black( "Stripe account balance" )."</td><td align='right'>".black( "$".number_format( $stripe_balance, $decimals ) )."</td></tr>";
	
	            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
	            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
			}
		}
        
        if ($show_data)            
        {
        	echo "<tr><td>".black( "*Cash on hand" )."</td><td align='right'>".black( "$".number_format( $data['account_balance'], $decimals ) )."</td></tr>";

            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
//            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
        }

        if ($show_data && (! $home_page))
        {
            echo "<tr><td style='border-top: 1px solid #000000;'>".black( "Total cash balance" )."</td><td style='border-top: 1px solid #000000;' align='right'>".black( "$".number_format( $total_cash_balance, $decimals ) )."</td></tr>";

            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
          	echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
        }
		
        if ($show_data)            
        {
            if (! $home_page)
            {
                echo "<tr><td style='border-top: 1px solid #000000;'>".black( "Credit" )."</td><td style='border-top: 1px solid #000000;' align='right'>".black( "$".number_format( $total_available_credit, $decimals ) )."</td></tr>";
			}
                                
            if (! $home_page)
			{
	            echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
				echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
            	echo "<tr><td style='border-top: 1px solid #000000; padding-right: 45px'>".black( "Bank balances + Credit" )."</td><td style='border-top: 1px solid #000000;' align='right'>".black( "$".number_format( $total_cash_balance + $total_available_credit, $decimals ) )."</td></tr>";
			}
			else
			{
				echo "<tr><td style='padding-right: 45px'>".black( "*Bank balances + Cash" )."</td><td align='right'>".black( "$".number_format( $total_cash_balance, $decimals ) )."</td></tr>";

				echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";

				echo "<tr><td style='padding-right: 45px'>".black( "*Bank balances + Cash + Credit" )."</td><td align='right'>".black( "$".number_format( $total_cash_balance + $total_available_credit, $decimals ) )."</td></tr>";
			}
				
            if (! $home_page)
            {
                echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
                echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";

                echo "<tr><td style='border-top: 1px solid #000000;'>".black( "Net balances" )."</td><td style='border-top: 1px solid #000000;' align='right'>".black( "$".number_format( $total_balance, $decimals ) )."</td></tr>";
    
                echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
                echo "<tr><td style='font-size: 4pt'>&nbsp;</td></tr>";
            }
        }

		if ($include_avalable_credit)        
        	return ($total_balance + $total_available_credit);
		else 
			return ($total_balance);
    }



	function update_acv_account_balances( $cxn )
	{
		$datetime_today = date( "Y-m-d H:i:s" );
					
		$query2 = "SELECT * FROM ".hosting_account_name."_accounts.bank_accounts ORDER BY id";
		
    	$result2 = run_query( $query2, $cxn );
        
        for ($i=0; $i < query_num_rows( $result2 ); $i++)
        {
        	$data2 = get_row( $result2 );	
    
            $bank_account_code = $data2['account_code'];


        	$query = "SELECT sum(net_amount) as total FROM ".hosting_account_name."_accounts.transaction INNER JOIN ".hosting_account_name."_accounts.accounts ON accounts.code = transaction.account WHERE effective_date <= '".$datetime_today."' AND accounts.code = '".$bank_account_code."'";
        	
        	$result = run_query( $query, $cxn );
        	
        	$data = get_row( $result );
        
		    $account_balance = $data['total'];

		    if ($account_balance == '')
		    	$account_balance = '0';
		    
            $query3 = "UPDATE ".hosting_account_name."_accounts.bank_accounts SET account_balance = ".round( $account_balance, 2 )." WHERE id = ".$data2['id'];
		
        	run_query( $query3, $cxn );
		}
	}
    
    function stripe_current_balance()
    {
		$headers = array(
				"Authorization: Bearer sk_live_wArc1tiWol4YtoUVvojLLA4y003myRdMQn", 
				"Content-Type: application/json; charset=UTF-8",
				"Accept: application/json; charset=UTF-8"
			);
						

		$ch = curl_init( "https://api.stripe.com/v1/balance" );

		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
		curl_setopt( $ch, CURLOPT_VERBOSE, 0 );
		curl_setopt( $ch, CURLOPT_HEADER, 1 );
		curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
		
		$result = curl_exec( $ch );

		$header_size = curl_getinfo( $ch, CURLINFO_HEADER_SIZE );

//		$header = substr( $result, 0, $header_size );
		
		$body = substr( $result, $header_size );
		
 		$returned_data = json_decode( $body, true );
		
		if (isset( $returned_data['pending'][0]['amount'] ))
			return ($returned_data['pending'][0]['amount'] / 100);
		else 
			return (0);
    }
	
	
?>