<?php
			// (c) Copyright Mark McIlroy 2020
 
    define( "hosting_account_name", "aitkencv" );
    define( "acv_bg_color", "darkblue" );
    define( "acv_bg_color_hover", "#000060" );
    define( "db_session_table", "aitkencv_aitkencv.session_var" );

 
	define( "ip_override_ip_address", "2001:8004:1520:1a25:ff:c001:ede8:2438" );
    define( "ip_country_override", "" );
//	define( "ip_country_override", "Kenya" );

    define( "ip_city_override", "" );
   
//    define( "ip_country_override", "Philippines" );

//	define( "override_screen_size", true );

	define( "override_screen_size", false );


	include mail_library;


		// global variables
		
	$new_session = "";
	$session_variables;
	$sys_cache_variables;


		// run an SQL query and terminate if it fails

    function run_query( $queryx, $cxn )
	{
//		if (get_ip_address() == '175.34.138.151')
//			$u1 = microtime( true );
 
/*		
		if (get_ip_address() == '49.199.49.106')
		{
		    $start_time = microtime( true );
		    
	        $result = $cxn->query( $queryx );
	
		    $end_time = microtime( true );
	
	        write_to_error_log( number_format( $end_time - $start_time, 4 )." seconds: ".$queryx );
		}
		else
*/		
	    $start_time = microtime( true );

	    $result = $cxn->query( $queryx );

	    $end_time = microtime( true );


	    if (($end_time - $start_time) > 0.5)
	    {
    		$ip_address = get_ip_address();
    
    		$page = val( $_SERVER, "REQUEST_URI" );
    		
        	$date_now = date( "Y-m-d H:i:s" );
    
            $addr_length = strlen( $ip_address );
            
            for ($i=(15-$addr_length); $i < 20 && $i > 0; $i--)
                $ip_address .= " ";

            write_to_error_log( $date_now." ".$ip_address." ".$page." Slow query ".number_format( $end_time - $start_time, 4 )." seconds: ".$queryx );
	    }


		if ($result == false)
		{
		    $page = val( $_SERVER, "PHP_SELF" );
		    
		    $result2 = $cxn->query( "SELECT CURRENT_USER();" );

            $data = $result2->fetch_assoc();		    

		    if ($data['CURRENT_USER()'] == hosting_account_name."_read@localhost")
		    {
		        echo red( "<i>Database is open in sample read-only mode, update not processed.</i><br><br>" );
		    }
    		else
			{
				$ip_address = get_ip_address();
				
		
		        $today_minus_7_days = date_create( date( "Y-m-d" ) );
		     
		    	date_sub( $today_minus_7_days, date_interval_create_from_date_string( '7 days' ));
		        	
		        $today_minus_7_days_str = $today_minus_7_days->format( "Y-m-d" );
		
				
				$query2 = "SELECT id FROM ".hosting_account_name."_aitkencv.logins WHERE login_date >= '".$today_minus_7_days_str."' AND ip_address = '".$ip_address."'";
				
				$result = $cxn->query( $query2 );
				
			    if (query_num_rows( $result ) > 0)
			    	echo "System login<br>Query: ".$queryx."<br>".$cxn->error."<br>";
	
    			crash( "Internal error: ".($cxn->errno)." ".($cxn->error)." Query: ".$queryx, $cxn );
			}
		}

		return $result;
	}


	function sright( $s, $items )
	{
		if (strlen( $s ) == 0)
			$s2 = '';
		else
		if ($items > strlen( $s ))
			$s2 = $s;
		else
			$s2 = substr( $s, strlen( $s ) - $items, $items );
		
		return ($s2);
	}
	
	
	function sleft( $s, $items )
	{
		if ($items > strlen( $s ))
			$s2 = $s;
		else
			$s2 = substr( $s, 0, $items );	

		return ($s2);
	}



		// $local_time in decimal, 0 to 23.99
		
	function convert_to_au_time( $php_timezone, $local_time )
	{
		if ($php_timezone == '')
			$au_time = $local_time;
		else
		{	
//			$tz_au = new DateTimeZone( 'Australia/Melbourne' );
			
//			$dt_au = new DateTime( 'now', $tz_au );
			
//			$timezone_offset_au = $tz_au->getOffset( $dt_au ) / 3600;
	
	
			$timezone_offset_au = current_timezone_gmt_offset( 'Australia/Melbourne' );
	
			$timezone_offset_local = current_timezone_gmt_offset( $php_timezone );
	
	
//			$tz_local = new DateTimeZone( $php_timezone );
			
//			$dt_local = new DateTime( 'now', $tz_local );
			
//			$timezone_offset_local = $tz_local->getOffset( $dt_local ) / 3600;
			
			
			$au_time = $local_time + ($timezone_offset_au - $timezone_offset_local);  
			
			if ($au_time >= 24)
				$au_time = $au_time - 24;
		}
				
		return ($au_time);
		
/*		
		ini_set( "date.timezone", "Australia/Melbourne" );		
	
		if (date_create( date( "Y-m-d H:i:s" ) )->format( 'I' ) == 1)
			$daylight_savings_offset_of_au = 1;
		else
			$daylight_savings_offset_of_au = 0;
	
	
		if ($php_timezone != '')
			$daylight_savings_offset_of_this_timezone = timezone_is_in_daylight_savings( $php_timezone );
		else
			$daylight_savings_offset_of_this_timezone = 0;

				
		return ($local_time + (10-$timezone_gmt_without_daylight_savings) + $daylight_savings_offset_of_au - $daylight_savings_offset_of_this_timezone );
*/ 
	}		
	

		// returns the current offset from GMT of timezone '$php_timezone', including the effects of daylight savings if any
		 
	function current_timezone_gmt_offset( $php_timezone )
	{
		$tz = new DateTimeZone( $php_timezone );
		
		$dt = new DateTime( 'now', $tz );
		
		return ($tz->getOffset( $dt ) / 3600);
	}
	
	
		
		// Returns 1 if the PHP timezone $this_timezone is currently in daylight savings and 0 otherwise
		
	function timezone_is_in_daylight_savings( $this_timezone )
	{
		$curr_timezone = ini_get( 'date.timezone' );
		 
		ini_set( "date.timezone", $this_timezone );		
		
		if (date_create( date( "Y-m-d H:i:s" ) )->format( 'I' ) == 1)
			$daylight_savings_offset_of_this_timezone = 1;
		else
			$daylight_savings_offset_of_this_timezone = 0;
		

		ini_set( "date.timezone", $curr_timezone );		
		
		return ($daylight_savings_offset_of_this_timezone);
	}
	
		
	function acv_session_set( $var, $value, $cxn )
	{
		global $new_session;
		global $session_variables;
		
		$session_id = val( $_COOKIE, "ACV_SESSION_ID" );
		
		if ($session_id == '')
			$session_id = $new_session;
		
		if ($session_id != '' && $var != '')
		{
	 		if (query_has_rows( "SELECT id FROM ".db_session_table." WHERE session_id = '".$session_id."' AND var = '".$var."'", $cxn ))
			{
				$query = "UPDATE ".db_session_table." SET value = '".prep_for_sql( $value )."' WHERE session_id = '".$session_id."' AND var = '".$var."'";
				
				run_query( $query, $cxn );
			}
			else 
			{
				$datetime_now = date( "Y-m-d H:i:s" );
				
				$query = "INSERT INTO ".db_session_table." (session_id, var, value, added) VALUES ('".$session_id."', '".$var."', '".prep_for_sql( $value )."', '".$datetime_now."')";
				run_query( $query, $cxn );
			}
			
			$session_variables[$var] = $value; 
		}
		
//		echo "set: ".$session_id.": ".$var.": ".$value."<br>";
	}


	function acv_session_get( $var, $cxn )
	{
		global $new_session;
		global $session_variables;
		
		$session_id = val( $_COOKIE, "ACV_SESSION_ID" );
		
		if ($session_id == '')
			$session_id = $new_session;

//		if ($session_id == '')
//			echo "ACV sessions not active<br>";
		
		$value = "";
		
		if ($session_id != '' && $var != '')
		{
			if (isset( $session_variables[$var] ))
				$value = $session_variables[$var];
			else
			{
				$query = "SELECT value FROM ".db_session_table." WHERE session_id = '".$session_id."' AND var = '".$var."'";
		
				$result = run_query( $query, $cxn );
		        
		        if (query_num_rows( $result ) > 0)
				{
		        	$data = get_row( $result );
		        	
		        	$value = $data['value'];
		        }
		        
		        		// set to '' if variable is not defined, e.g. data_saving_mode when user is not logged in
				$session_variables[$var] = $value;
	 		}
		}
				
//		echo $session_id.": ".$var.": ".$value."<br>";
		
		return ($value);
	}


	function acv_session_id()
	{
		$session_id = val( $_COOKIE, "ACV_SESSION_ID" );
		
		return ($session_id);
	}	
	
	
    function opt_set( $flags, $opt )
    {
        if (($flags & $opt) != 0)
            $opt_is_set = true;
        else
            $opt_is_set = false;
            
        return ($opt_is_set);
    }


    function process_external_entry_point( $cxn )
    {
		acv_session_set( 'session_active', "yes", $cxn );
    }



	function acv_login( $next_page, $scripts_path, $cxn )
	{
		$ip_address = get_ip_address();
		

        $today_minus_7_days = date_create( date( "Y-m-d" ) );
     
    	date_sub( $today_minus_7_days, date_interval_create_from_date_string( '7 days' ));
        	
        $today_minus_7_days_str = $today_minus_7_days->format( "Y-m-d" );

		
		$query = "SELECT id FROM ".hosting_account_name."_aitkencv.logins WHERE login_date >= '".$today_minus_7_days_str."' AND ip_address = '".$ip_address."'";
		
		$result = run_query( $query, $cxn );
		
	    if (query_num_rows( $result ) == 0)
		{
			$_SESSION['nextpage'] = url_encode( $next_page );
	
			jump_to_page( $scripts_path."login.php" );
	
			exit();
		}
	}
	
	
    function convert_date2( $day_text, $month_text, $year_text, $cxn )
    {
        $day = "01";
        
	    if (strlen( $day_text ) == 1)
	    {
	        if (is_digit( $day_text ))
    	        $day = "0".$day_text;
	    }
	    else
	    if (strlen( $day_text ) == 2)
	    {
            if (is_digit( substr( $day_text, 0, 1 ) ) && is_digit( substr( $day_text, 1, 1 ) ))
                $day = $day_text;
	    }

	    if ($month_text == "Jan" || $month_text == "January" || $month_text == lookup( "January", $cxn ))			    $month = '01';
	    else
	    if ($month_text == "Feb" || $month_text == "February" || $month_text == lookup( "February", $cxn ))			    $month = '02';
	    else
	    if ($month_text == "Mar" || $month_text == "March" || $month_text == lookup( "March", $cxn ))			        $month = '03';
	    else
	    if ($month_text == "Apr" || $month_text == "April" || $month_text == lookup( "April", $cxn ))			        $month = '04';
	    else
	    if ($month_text == "May" || $month_text == lookup( "May", $cxn ))			    						        $month = '05';
	    else
	    if ($month_text == "Jun" || $month_text == "June" || $month_text == lookup( "June", $cxn ))			            $month = '06';
	    else
	    if ($month_text == "Jul" || $month_text == "July" || $month_text == lookup( "July", $cxn ))			            $month = '07';
	    else
	    if ($month_text == "Aug" || $month_text == "August" || $month_text == lookup( "August", $cxn ))			        $month = '08';
	    else
	    if ($month_text == "Sep" || $month_text == "September" || $month_text == lookup( "September", $cxn ))		    $month = '09';
	    else
	    if ($month_text == "Oct" || $month_text == "October" || $month_text == lookup( "October", $cxn ))			    $month = '10';
	    else
	    if ($month_text == "Nov" || $month_text == "November" || $month_text == lookup( "November", $cxn ))			    $month = '11';
	    else
	    if ($month_text == "Dec" || $month_text == "December" || $month_text == lookup( "December", $cxn ))			    $month = '12';
        else
            $month = '01';

	    return ($year_text."-".$month."-".$day);
    }


        // don't put on pages that should be indexed by search engines

    function exit_if_search_bot()
    {
        if (is_search_bot())
        {
            echo "<meta name='robots' content='noindex'>";

            exit();
        }
    }


        // don't put on pages that are external entry points or should be indexed by search engines
        
    function exit_if_session_expired( $cxn )
    {
//        if (session_status() != PHP_SESSION_ACTIVE)
//            session_start();

//            jump_to_page( "/" );

/*
        if (acv_session_get( "session_active", $cxn ) == "")
        {
            page_header( "", $cxn );
            
            echo black( "<br>Your session has expired. Please go to the home page to continue.<br><br>" );
            
        	echo show_home_link( $cxn );
        	
        	exit();
        }
*/
    }

    function is_search_bot()
    {
////            strpos( $user_agent, "Mediapartners-Google" ) !== false)            // 'Mediapartners-Google' is Adsense scanning pages
////            strpos( $user_agent, "Google-Ads-Overview" ) !== false)

        $user_agent = val( $_SERVER, "HTTP_USER_AGENT" );

	    $is_bot = false;

        if (strpos( $user_agent, "Googlebot" ) !== false ||
            strpos( $user_agent, "Crawler" ) !== false ||
            strpos( $user_agent, "spider" ) !== false ||
            strpos( $user_agent, "Spider" ) !== false ||
            strpos( $user_agent, "bot" ) !== false ||
            strpos( $user_agent, "Bot" ) !== false ||
            strpos( $user_agent, "Google Favicon" ) !== false ||
            strpos( $user_agent, "Google-Read-Aloud" ) !== false ||
            strpos( $user_agent, "http://researchscan.comsys.rwth-aachen.de" ) !== false ||
            strpos( $user_agent, "Baiduspider" ) !== false)
			    $is_bot = true;

		return ($is_bot);
    }
        

		/* read a row from a query and return it in the format $data['fieldname'] */

	function get_row( $result )
	{
        $data = $result->fetch_assoc();

		return $data;
	}


		/* scale font sizes for low res screens */

	function fs( $cxn, $font_size )
	{
   		$color_scheme = acv_session_get( 'color_scheme', $cxn );

		$fs2 = $font_size * 0.75;


                    /* large font sizes */
                    
        if ($color_scheme == 3)
            $fs2 *= 1.25;

        if (low_res_screen( $cxn ))
            $fs2 = $fs2 * 1.15;

		if ($color_scheme == 2 && (! low_res_screen( $cxn )) )		// black background
			$fs2 = $fs2 * 1.3;
		else
		if ($color_scheme == 1  && (! low_res_screen( $cxn )) )	// pink italics
			$fs2 = $fs2 * 1.2;

        if ((!low_res_screen( $cxn )) && acv_session_get( "screen_width", $cxn ) > 0 && acv_session_get( "screen_width", $cxn ) <= 1025)
			$fs2 = scale_for_low_res_desktop( $cxn, $fs2 );
 

        if (is_opera_mini())
            $fs2 = $fs2 * 1.3;


		if (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Mac OS" ) !== false)
            $fs2 = $fs2 * 1.2;


        $font_size = round( $fs2, 1 );
        
        $font_size = $font_size."";
        

        if (strlen( $font_size ) > 5)
            $font_size = substr( $font_size, 0, 5 );
            
		return ($font_size."");
	}



	function is_opera_mini()
	{
        if (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Opera Mini" ) !== false)
			$is_opera_mini = true;
		else
			$is_opera_mini = false;
		
		return ($is_opera_mini);
	}



    function scale_for_low_res_desktop( $cxn, $font_size )
    {
        $fs2 = $font_size;
    
        if ((!low_res_screen( $cxn )) && acv_session_get( "screen_width", $cxn ) > 0 && acv_session_get( "screen_width", $cxn ) <= 1025)
			$fs2 = $fs2 * 0.88;
			
		return ($fs2);
    }


    function day_of_week_to_text( $day_of_week )
    {
        if ($day_of_week == 1)
            return ("Monday");
        else
        if ($day_of_week == 2)
            return ("Tuesday");
        else
        if ($day_of_week == 3)
            return( "Wednesday");
        else
        if ($day_of_week == 4)
            return ("Thursday");
        else
        if ($day_of_week == 5)
            return ("Friday");
        else
        if ($day_of_week == 6)
            return ("Saturday");
        else
        if ($day_of_week == 0)
            return ("Sunday");
    }

		/* return TRUE if a query returned at least one record */

	function query_has_rows( $query, $cxn )
	{
	    if (strpos( $query, 'LIMIT' ) === false && strpos( $query, 'limit' ) === false)
	        $query .= ' LIMIT 1';
	        
		$result = run_query( $query, $cxn );

		if ($result->num_rows != 0)
			return (true);
		else
			return (false);
	}


        // return a single value from a totalling query
        
	function query_get_num( $query, $item_name, $cxn )
	{
		$result = run_query( $query, $cxn );

		if ($result->num_rows == 0)
		    $item = 0;
		else
        {
    		$data = get_row( $result );
    		
    		$item = $data[$item_name];
    		
    		if ($item == "")
    		    $item = 0;
        }
        
        return ($item);
	}


		// return the number of records in a result

	function query_get_number_rows( $query, $cxn )
	{
		$result = run_query( $query, $cxn );

		return ($result->num_rows);
	}



	function get_current_exchange_rate( $currency, $cxn )
	{
		$rate = 0;
		
		$query = "SELECT rate FROM ".common_data_database_name.".exchange_rate WHERE currency = '".$currency."' ORDER BY effective_date DESC LIMIT 1";
		
   		$result = run_query( $query, $cxn );

        if (query_num_rows( $result ) > 0)
        {
   		    $data = get_row( $result );
			
			$rate = $data['rate'];
		}
		
		return ($rate);			
	}
	
	
	
		/* convert a string into a format suitable for HTML display */
		/* replaces '\n' with '<br>' and '<' with '&lt' */

	function convert_to_html( $text )
	{
//		$text = htmlspecialchars( $text );		/* changes '<' to '&lt' */

		$text3 = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			$ch = substr( $text, $i, 1 );

			if ($ch == "\n")
				$text3 = $text3."<br>";
			else
			if ($ch == "&")
				$text3 = $text3."&amp;";
			else
			if ($ch == "\"")
				$text3 = $text3."&quot;";
			else
			if ($ch == "'")
				$text3 = $text3."&#039;";
			else
			if ($ch == "<")
				$text3 = $text3."&lt;";
			else
			if ($ch == ">")
				$text3 = $text3."&gt;";
            else
				$text3 = $text3.$ch;
		}

		return $text3;
	}



		// show a static image such as on the home page.
		// set the 'width' and 'height' in HTML so the browser can format the page before the image has loaded
		
		// Note that the file paths should start with /home/mlm1, or otherwise not have a leading /
		
		
	function show_image( $file_path, $height="", $amp=false, $cxn )
	{
		list( $this_width, $this_height, $type, $attr ) = getimagesize( pathroot."/".$file_path );

		if ($height != "")
		{ 
			$this_width = $height * ($this_width / $this_height);
			
			$this_height = $height;
		}
		
		
		if ($amp)
		{
			if (use_cdn)
    			echo "<amp-img src='".cdn_domain."/".$file_path."' width='".$this_width."px' height='".$this_height."px'></amp-img>";
			else
		   		echo "<amp-img src='".url_encode_file( $file_path )."' width='".$this_width."px' height='".$this_height."px'></amp-img>";
		}
    	else
		{
			if (use_cdn)
	    	    echo "<img alt='Image' src='".cdn_domain."/".$file_path."' width='".$this_width."' height='".$this_height."'>";
			else
    	    	echo "<img style='border: 1px solid #EEEEEE;' alt='Image' src='".url_encode_file( $file_path )."' width='".$this_width."' height='".$this_height."'>";
		}

//    	$data = file_get_contents( pathroot."/".$file_path );
		
//   		$base64 = 'data:image/jpeg;base64,'.base64_encode($data);
		
//		echo "<img ";

//		echo "<img style='";
		
//        if (opt_set( $flags, OPT_SHOW_PHOTO_SHOW_BORDER ))
//		    echo "border: 8px solid #FFFFFF; ";

//    	echo " src='".$base64."'>";
				    
//    	echo "' src='".$base64."'>";
  	}



		// Note that the file paths should start with /home/mlm1, or otherwise not have a leading /

/*
	function show_image2( $file_path, $url_path, $height="", $amp=false, $show_border=false )
	{
		list( $this_width, $this_height, $type, $attr ) = getimagesize( $file_path );

		if ($height != "")
		{ 
			$this_width = $height * ($this_width / $this_height);
			
			$this_height = $height;
		}
		
        if ($show_border)
        {
        	if ($amp)
        		echo "<amp-img style='border: 1px solid #000000;' src='https://".cdn_domain.$url_path."' width='".$this_width."' height='".$this_height."'></amp-img>";
            else    		
                echo "<img style='border: 1px solid #000000;' src='https://".cdn_domain.$url_path."' width='".$this_width."' height='".$this_height."'>";
        }
        else
        {
    		if ($amp)
        		echo "<amp-img src='https://".cdn_domain.$url_path."' width='".$this_width."' height='".$this_height."'></amp-img>";
            else
                echo "<img src='https://".cdn_domain.$url_path."' width='".$this_width."' height='".$this_height."'>";
        }
	}
*/

		/* generate a URL with parameters, session id and parameter checking */

	function url_encode_file( $page )
	{
		return ($page);
	}



		/* create a url complete with session id and magic number checking */

	function url_encode( ... $arguments)
	{
	    $i = 0;
	    $url = "";
	    
        foreach ($arguments as $arg1)
            $arg_list[$i++] = $arg1;
            
        $count = $i;

        if ($count == 0)
            crash( "Arg list null in url_encode()", $cxn );
        else
        {
            $url = $arg_list[0];
            $param_list = "";
            
    		for ($i=1; $i < $count-1; $i+=2)
    		{
    		    if ($arg_list[$i] != "" && $arg_list[$i+1] != "")
    		    {
    		        if ($param_list != "")
    		            $param_list .= "&";
    		    
    		        $param_list .= $arg_list[$i]."=".$arg_list[$i+1];
    		    }
    		}
            
            if ($param_list != "")
                $url .= "?".$param_list;
        }


/*
        foreach ($arguments as $arg1)
        {
            if ($arg1 != "")
            {
                if ($i == 0)    
                    $url = $arg1;
                else
                if ($i == 1)
                    $url .= "?".$arg1;
                else
                if ($i % 2 == 0)
                    $url .= "=".$arg1;
                else
                    $url .= "&".$arg1;
            }
            
            $i++;
        }
*/        
//        echo $url."<br>";
        
        return (make_url( $url ));
	}

		/* add a magic number checksum to a URL */

	function make_url( $url )
	{
	
// commented out while url checking is not active
		
		return ($url);
		
		
// The code below needs to be updated for https://
//			
//		if (strpos( $url, "?" ) == false)
//			$url = $url."?";
//		else
//			$url = $url."&";
//
//		$tail = $url;
//
//				/* absolute URL */
//
//		if (substr( $url, 0, 7 ) == "http://"  || substr( $url, 0, 4 ) == "www.")
//		{
//			$tail = substr( $url, 8, strlen( $url ) - 8 );
//
//			$tail = substr( $tail, strpos( $tail, "/" ) + 1, strlen( $tail ) - strpos( $tail, "/" ) - 1 );
//		}
//
//
//		return ($url."magic=".substr( md5( $tail ), 0, 8));
//
//		if (SID == "")
//			return ($url."magic=".substr( md5( $tail ), 0, 8));
//		else
//			return ($url."magic=".substr( md5( $tail ), 0, 8)."&".SID);
	}



		/* check that the magic number in the URL correctly identifies the parameters, i.e. someone */
		/* isnt trying the bookmark url with changed parmaeters */


	function check_url()
	{
		$url = $_SERVER['REQUEST_URI'];

		$url = substr( $url, 1, strlen( $url ) - 1 );		/* delete leading '/' */

		$pos = strpos( $url, "magic=" );

		$orig_url = substr( $url, 0, $pos );
		
		$hash = substr( $url, $pos + 6, 8 );		

// 27/10/16 commented out. If the following few lines are activated, the system will prevent the user
// from going directly to site pages without going through the menu options. This was a security procedure when the site was paid.
// I commented these out to allow search engines to scan the site sub-pages.
//		if ($hash != md5( $orig_url ))
//		{
//			echo "<span class='gblack'>Corrupted URL<br><br>script terminated</span>";
//			exit();
//		}
	}



		/* show a hyperlink */

//	function show_link( ...$arguments )

	function show_link( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5="", $param6="", $value6="", $param7="", $value7="", $param8="", $value8="", $param9="", $value9="", $param10="", $value10="", $param11="", $value11="", $param12="", $value12="", $param13="", $value13="", $param14="", $value14="" )

	{
//	    for ($i=0; $i < count($arguments)-1; $i++)
//	        $arguments2[$i] = $arguments[$i+1];
	        
//		return "<a class='glink' href='".url_encode( $arguments2 )."'>".$arguments[0]."</a>";

		return "<a class='glink' href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4, $param5, $value5, $param6, $value6, $param7, $value7, $param8, $value8, $param9, $value9, $param10, $value10, $param11, $value11, $param12, $value12, $param13, $value13, $param14, $value14 )."'>".$prompt."</a>";
	}


	function show_brown_link( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="" )
	{
		return "<a class='brownlink' href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4 )."'>".$prompt."</a>";		
	}


	function show_green_link( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="" )
	{
		return "<a class='ggreenlink' href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4 )."'>".$prompt."</a>";		
	}


	function show_dark_green_link( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="" )
	{
		return "<a class='gdarkgreenlink' href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4 )."'>".$prompt."</a>";		
	}


	function show_link_encoded( $prompt, $url )
	{
		echo "<a href='".$url."' class='glink'>".$prompt."</a>";
	}


		// show a main menu option on the home page
		
	function show_menu_option( $cxn, $menu_id, $prompt, $option1="", $option2="", $option3="", $option4="", $option5="", $option6="", $option7="", $option8="", $option9="" )
	{
		$url = url_encode( $option1, $option2, $option3, $option4, $option5, $option6, $option7, $option8, $option9 );

		if (! low_res_screen( $cxn ))
			echo "<td width='15%' valign='top' id='".$menu_id."' class='mainmenuitem' onclick='location.href=\"".$url."\"';'>";			
		else
			echo "<td width='15%' valign='top' id='".$menu_id."' class='mainmenuitem' onclick='location.href=\"".$url."\"'>";

		echo $prompt."</td>";
	}


	function show_menu_option2( $cxn, $menu_id, $prompt, $option1="", $option2="", $option3="", $option4="", $option5="" )
	{
		$url = url_encode( $option1, $option2, $option3, $option4, $option5 );

		if (! low_res_screen( $cxn ))
			echo "<td valign='top' id='".$menu_id."' class='mainmenuitem' onclick='location.href=\"".$url."\"';'>";			
		else
			echo "<td colspan='3' valign='top' id='".$menu_id."' class='mainmenuitem' onclick='location.href=\"".$url."\"'>";

		echo $prompt."</td>";
	}

		/* redirect the browser to a new page */

		/* NOTE: must happen before print output */

	function jump_to_page( $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5="" )
	{
		header( "Location: ".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4, $param5, $value5 ) );
		
        exit();
	}



		/* show a form field in printed output (not data entry) */

	function show_field( $prompt, $value, $force_show=false, $cxn )
	{
		echo "<tr><td class='dprompt'>".$prompt."</td><td ";
		
		if (acv_session_get( "data_saving_mode", $cxn ) != "on")
		    echo "class='dtext'";

        echo ">".convert_to_html( $value )."</td></tr>";
	}


		/* show a form field in printed output (not data entry) */

	function show_field_if_present( $prompt, $value, $cxn )
	{
		if ($value != "")
		{
    		echo "<tr><td class='dprompt'>".$prompt."</td><td ";
    		
    		if (acv_session_get( "data_saving_mode", $cxn ) != "on")
    		    echo "class='dtext'";
    		    
    		echo ">".convert_to_html( $value )."</td></tr>";
		}
	}



		/* display an error message and stop if an input parameter is blank */

	function crash_if_missing( $val, $msg, $cxn )
	{
		if ($val == "")
			crash( "Internal Error: ".$msg, $cxn );
	}



    function lookup( $text, $cxn, $language="" )
    {
        
        return ($text);

/*        
//        if (get_ip_address() == "49.176.227.110" )
//            return "**".$text."##";
    
	    if (translation_active)
        {
            if (strlen( $text ) > 350)
                log_error_and_continue( "Text value length exceeds 350 characters: ".$text );
            else
            {
                $last_read = date( "Y-m-d H:i:s" );
                
                $text2 = prep_for_sql( $text );
                
                $query = "SELECT value FROM ".common_data_database_name.".text WHERE language = 'ENGLISH' AND lookup_value = '".$text2."'";
        
                $result = run_query( $query, $cxn );            
        
                if (query_num_rows( $result ) == 0)
                {
                    $query = "INSERT INTO ".common_data_database_name.".text (language, lookup_value, value, last_read) VALUES ('ENGLISH', '".$text2."', NULL, '".$last_read."')";
        
                    $result = run_query( $query, $cxn );            
                }
                else
                {
                    $query = "UPDATE ".common_data_database_name.".text SET last_read = '".$last_read."' WHERE language = 'ENGLISH' AND lookup_value = '".$text2."'";
        
                    $result = run_query( $query, $cxn );            
                }

                $site_language = "";

                if ($language != "")
                    $site_language = $language;
                else
                if (isset(  ))
                    $site_language = val( , 'site_language' );

                $site_language = strtoupper( $site_language );
                

                if ($site_language == "SWAHILI")
                {
                    $query = "SELECT value FROM ".common_data_database_name.".text WHERE language = '".$site_language."' AND lookup_value = '".$text2."'";
            
                    $result = run_query( $query, $cxn );            
            
                    if (query_num_rows( $result ) > 0)
                    {
            			$data = get_row( $result );
            			
        	    		$text = utf8_encode( $data['value'] );
        	    		
//        	    		$text = str_replace( "& nbsp", "&nbsp", $text );
                    }
                }
            }
        }
        
        return ($text);
*/
    }


	function write_to_error_log( $msg )
	{
		$ip_address = get_ip_address();

		$page = val( $_SERVER, "REQUEST_URI" );
		
    	$date_now = date( "Y-m-d H:i:s" );

        $addr_length = strlen( $ip_address );
        
        for ($i=(15-$addr_length); $i < 20 && $i > 0; $i--)
            $ip_address .= " ";

            
        error_log( $date_now." ".$ip_address." ".$page." ".$msg."\n", 3, error_log_filename );
	}


    function equivalent_in_english( $text, $cxn )
    {
        return ($text);
        
/*        
	    if (translation_active)
        {
            if (strlen( $text ) > 350)
                log_error_and_continue( "Text value length exceeds 350 characters: ".$text );
            else
            {
                $site_language = val( , "site_language" );
                
                if ($site_language != "" && $site_language != "ENGLISH")
                {
                    $text2 = prep_for_sql( $text );
                    
                    $query = "SELECT value FROM ".common_data_database_name.".text WHERE language = '".$site_language."' AND value = '".$text2."'";
            
                    $result = run_query( $query, $cxn );            
            
                    if (query_num_rows( $result ) > 0)
                    {
            			$data = get_row( $result );
                			
        	    		$text2 = val( $data, 'lookup_value' );
        	    		
        	    		if ($text2 != "")
        	    		    $text = $text2;
                    }
                }
            }
        }
        
        return ($text);
*/
    }


		/* send an email message with text and html alternatives */

   	function send_email( $identifier, $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue, $this_sitecode="", $this_sitename="" )
    {
        if ($to_addr != "")
        {
            $lodged = date( "Y-m-d H:i:s" );
    
            $this_from_name = prep_for_sql( $from_name );
            $this_from_addr = prep_for_sql( $from_addr );
            $this_to_addr = prep_for_sql( $to_addr );
            $this_reply_name = prep_for_sql( $reply_name );
            $this_reply_addr = prep_for_sql( $reply_addr );
            $this_subject = prep_for_sql( $subject );
            $this_text_body = prep_for_sql( $text_body );
            $this_html_body = prep_for_sql( $html_body );


                    // requires 	include "/home/****/public_html/common_code/mail_library.php";
//            if ($queue == "live" || $queue == "urgent")

			if ($this_sitecode == '')
				$this_sitecode = sitecode;

			if ($this_sitename == '')
				$this_sitename = sitename; 

//	        if ($queue == "urgent")
//				$queue = 'live';

            if ($queue == "urgent" || $queue == "live")
                send_email_actual( $identifier, $this_sitecode, $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn );
            else
            {
        		$query = "INSERT INTO ".common_data_database_name.".emails_to_send_".$queue." (sitecode, identifier, site_name, from_name, from_addr, to_addr, reply_name, reply_addr, subject, text_body, html_body, lodged) ";
        
        	    $query .=" VALUES( '".$this_sitecode."', '".$identifier."', '".$this_sitename."', '".$this_from_name."', '".$this_from_addr."', '".$this_to_addr."', '".$this_reply_name."', '".$this_reply_addr."', '".$this_subject."', '".$this_text_body."', '".$this_html_body."', '".$lodged."')";
        	
                $result = run_query( $query, $cxn );
            }
			
/*			
			$data = array( "queue" => $queue,
							'identifier' => $identifier,
						    'from_name' => $from_name,
				            'from_addr' => $from_addr,
				            'to_addr' => $to_addr,
				            'reply_name' => $reply_name,
				            'reply_addr' => $reply_addr,
				            'subject' => $subject,
				            'text_body' => $text_body,
				            'html_body' => $html_body );
			
			$data_string = json_encode( $data );
			
			$ch = curl_init( 'https://www.aitkencv.com/acv_new_mail.php' );
			
			curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, "POST" );
			curl_setopt( $ch, CURLOPT_VERBOSE, 0 );
			curl_setopt( $ch, CURLOPT_HEADER, 1 );
			curl_setopt( $ch, CURLOPT_POSTFIELDS, $data_string );
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
			
			curl_setopt( $ch, CURLOPT_HTTPHEADER, array( 'Content-Type: application/json', 'charset=UTF-8' ) );
			
			$result = curl_exec( $ch );
*/			
        }
    }


		/* keep a database log of hits from users with each screen size */

	function log_screen_size( $width, $height, $cxn )
	{
		$size_key = date("Y").": width: ".$width.", height: ".$height;
		
		$query = "SELECT * FROM sys_data WHERE param = 'screen_size' AND value = '".$size_key."'";

		$result = run_query( $query, $cxn );
		
		if (query_num_rows( $result ) > 0)
		{
			$data = get_row( $result );

			$new_count = $data['hits'] + 1;

			$query = "UPDATE sys_data SET hits = ".$new_count." WHERE param = 'screen_size' AND value = '".$size_key."'";
			$result = run_query( $query, $cxn );
		}
		else
		{
			$query = "INSERT INTO sys_data (param, value, hits) VALUES ('screen_size', '".$size_key."', 1)";
			$result = run_query( $query, $cxn );
		}
	}

	
	function is_sys_logon( $cxn )
	{
		$is_sys_logon = false;
/*		
		$query = "SELECT * FROM sys_data WHERE param = 'sys_logon_ip_address'";

		$result = run_query( $query, $cxn );
		
		if (query_num_rows( $result ) > 0)
		{
			$data = get_row( $result );
			
			if (get_ip_address() == $data['value'])
				$is_sys_logon = true;
		}
*/
		
		return ($is_sys_logon);
	}


    	// log the source of our hits

	function log_hits( $source, $cxn )
	{
		$log_seconds_between_page_loads = false;
		$log_hits_per_hour = false;
		$log_hits_per_minute = false;
		
//		$log_user_agents = false;
    		
//        if (! is_search_bot())
        {
    		$ip_address = get_ip_address();

    		get_ip_details( $ip_country, $ip_region, $ip_city, $cxn );

    
    		$hit_date = date( "Y-m-d" );
    		
    		$latest_hit = date( "Y-m-d H:i:s" );


    		$query = "SELECT * FROM hits WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND source = '".$source."' AND ip_address = '".$ip_address."'";

			$result = run_query( $query, $cxn );


    		if (query_num_rows( $result ) > 0)
    		{
    			$data = get_row( $result );
    
                        // Seconds between page loads
                        
                if ($log_seconds_between_page_loads)
				{
	            	$date1 = date_create_from_format( "Y-m-d H:i:s", $data['latest_hit'] );
	            
	            	$date2 = date_create_from_format( "Y-m-d H:i:s", $latest_hit );
	            	
					$seconds_to_new_page = date_diff( $date1, $date2 )->s;
	                        
	                if ($seconds_to_new_page < 60*10)
	                {
	        			$query2 = "SELECT id FROM seconds_to_new_page WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND ip_country = '".$ip_country."' AND seconds_to_new_page = ".$seconds_to_new_page;

	        			$result2 = run_query( $query2, $cxn );
							    
	                    if (query_num_rows( $result2 ) > 0)
	                    {
	                    	$data2 = get_row( $result2 );
	                    
	            			$query3 = "UPDATE seconds_to_new_page SET count = count + 1 WHERE id = ".$data2['id'];
						}
	                    else
	            			$query3 = "INSERT INTO seconds_to_new_page (sitecode, hit_date, ip_country, seconds_to_new_page, count) VALUES ('".sitecode."', '".$hit_date."', '".$ip_country."', ".$seconds_to_new_page.", 1)";
	    
	        			run_query( $query3, $cxn );
	                }
				} 

 				
 				$query = "UPDATE hits SET hits = hits + 1, latest_hit = '".$latest_hit."' WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND source = '".$source."' AND ip_address = '".$ip_address."'";

    			$result = run_query( $query, $cxn );
			}
    		else
    		{
    		    $device = device_type( $cxn );
  
    			$query = "INSERT INTO hits (source, sitecode, ip_country, ip_address, ip_region, ip_city, hit_date, latest_hit, hits, device) VALUES ('".$source."', '".sitecode."', '".$ip_country."', '".$ip_address."', '".$ip_region."', '".$ip_city."', '".$hit_date."', '".$latest_hit."', 1, '".$device."')";
    
    			$result = run_query( $query, $cxn );
    		}
    		

                // Hits per hour

 	    	$hour = date( "H" );
   
			if ($log_hits_per_hour)
            {
	    		$query2 = "SELECT id FROM hits_per_hour WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND ip_country = '".$ip_country."' AND hour = ".$hour;
	
    			$result2 = run_query( $query2, $cxn );
					    
                if (query_num_rows( $result2 ) > 0)
                {
                	$data2 = get_row( $result2 );
	
	    			$query5 = "UPDATE hits_per_hour SET hits = hits + 1 WHERE id = ".$data2['id'];
	    		}
	            else
	    			$query5 = "INSERT INTO hits_per_hour (sitecode, hit_date, ip_country, hour, hits) VALUES ('".sitecode."', '".$hit_date."', '".$ip_country."', ".$hour.", 1)";
	
				run_query( $query5, $cxn );
	
				
//				$query4 = "SELECT id FROM hits_per_hour WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND ip_country = 'TOTAL_HITS' AND hour = ".$hour;
//	
//	            if (query_has_rows( $query4, $cxn ))
//	    			$query5 = "UPDATE hits_per_hour SET count = count + 1 WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND ip_country = 'TOTAL_HITS' AND hour = ".$hour;
//	            else
//	    			$query5 = "INSERT INTO hits_per_hour (sitecode, hit_date, ip_country, hour, count) VALUES ('".sitecode."', '".$hit_date."', 'TOTAL_HITS', ".$hour.", 1)";
//	
//				run_query( $query5, $cxn );
			}

				// Hits per minute
				
			if ($log_hits_per_minute)
			{
	    		$minute = date( "i" );
	
	    		$query2 = "SELECT id FROM hits_per_minute WHERE sitecode = '".sitecode."' AND hit_date = '".$hit_date."' AND hour = ".$hour." AND minute = ".$minute;
	
    			$result2 = run_query( $query2, $cxn );
					    
                if (query_num_rows( $result2 ) > 0)
                {
                	$data2 = get_row( $result2 );
		
	    			$query5 = "UPDATE hits_per_minute SET hits = hits + 1 WHERE id = ".$data2['id'];
				}
	            else
	    			$query5 = "INSERT INTO hits_per_minute (sitecode, hit_date, hour, minute, hits) VALUES ('".sitecode."', '".$hit_date."', ".$hour.", ".$minute.", 1)";
	
				run_query( $query5, $cxn );
			}
			
                // user agents
/*
 		    $user_agent = val( $_SERVER, "HTTP_USER_AGENT" );
  
  			if ($log_user_agents)
  			{              
	    		$year = date( "Y" );
				$text = $year.": ".$user_agent;
				
	    		$query6 = "SELECT * FROM sys_data WHERE param = 'user_agent' AND value = '".$text."'";
	
	    		if (query_has_rows( $query6, $cxn ))
	    			$query7 = "UPDATE sys_data SET hits = hits + 1 WHERE param = 'user_agent' AND value = '".$text."'";
	            else
	    			$query7 = "INSERT INTO sys_data (param, value, hits) VALUES ('user_agent', '".$text."', 1)";
	
				run_query( $query7, $cxn );
			}
*/			
		}
	}


		/* return an element in an array or an empty string if it doesn't exist */

	function val( $xarray, $variable )
	{
	    if (! isset( $xarray ))
			$value = "";
        else
        {
    		if (array_key_exists( $variable, $xarray ))
    			$value = $xarray[ $variable ];
    		else
    			$value = "";
        }
        
		return ($value);
	}


		/* display an error message and exit */

	function crash( $msg, $cxn )
	{
	    // PHP_SELF
	    
		$page = val( $_SERVER, "REQUEST_URI" );

		$text = "Page: ".$page."  error: ".$msg;
				
		$ip_address = get_ip_address();
		
		$queryx = "INSERT INTO sys_log (event, event_date, event_datetime, text) VALUES ('crash', '".date( "Y-m-d" )."', '".date( "Y-m-d H:i:s" )."', '".prep_for_sql( __FILE__." ".$ip_address." ".$text )."')";

        $result = $cxn->query( $queryx );

		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

		echo red( "<br>".lookup( "The function that you have requested is not available. Please go to the home page and try again.<br><br>If possible, try using a different browser. The site works well with the latest version of Chrome.", $cxn ) )."<br><br><br>";

        echo show_home_link( $cxn );
        
        
    	$date_now = date( "Y-m-d H:i:s" );

        $addr_length = strlen( $ip_address );

        for ($i=(15-$addr_length); $i < 20 && $i > 0; $i--)
            $ip_address .= " ";

        error_log( $date_now." ".$ip_address." ".$page." ".$msg."\n", 3, error_log_filename );
		
		exit();
	}


	function log_error_and_continue( $msg )
	{
		$ip_address = get_ip_address();

		$page = val( $_SERVER, "REQUEST_URI" );
		
    	$date_now = date( "Y-m-d H:i:s" );

        $addr_length = strlen( $ip_address );
        
        for ($i=(15-$addr_length); $i < 20 && $i > 0; $i--)
            $ip_address .= " ";

            
        error_log( $date_now." ".$ip_address." ".$page." ".$msg." <continuing>\n", 3, error_log_filename );
	}


		/* return a string in name case, e.g. New York */

	function name_case( $text )
	{
		$text = trim( $text );

		$out_str = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			if ($i == 0)
				$out_str = strtoupper( substr( $text, 0, 1 ) );
			else
			{
				if (substr( $text, $i - 1, 1 ) == " ")
					$out_str .= strtoupper( substr( $text, $i, 1 ) );
				else
					$out_str .= strtolower( substr( $text, $i, 1 ) );
			}
		}

		return ($out_str);
	}

		/* split a csv string into an array */

    function split_csv( $text )
	{
		$num_items = 0;
		$in_double_quote = false;

		if ($text <> "")
		{
			$pos = 0;
                    
				// skip to start of each field, $pos should be on the first character
				// of each field
            
			while ($pos < strlen( $text ))
			{
				$ch = substr( $text, $pos, 1 );
            
				if ($ch == ",")
				{
					$data[$num_items] = "";
					$num_items++;
					$pos++;
				}
				else
				{
					if ($ch == "\"")
					{
						$in_double_quote = true;
						$pos++;

						if ($pos >= strlen( $text ))
							$field_end = true;
						else
							$ch = substr( $text, $pos, 1 );
					}
					else
						$in_double_quote = false;
                
					$this_field = "";
					$field_end = false;
                
					while (! $field_end)
					{
						if ($pos >= strlen( $text ))
							$field_end = true;
						else
						if ($ch == "\\")
						{
							$pos++;

							if ($pos >= strlen( $text ))
								$field_end = true;
							else
							{
								$ch = substr( $text, $pos, 1 );
								$this_field .= $ch;
								$pos++;
							}
						}
						else
						if ($in_double_quote && $ch == "\"")
						{
							$field_end = true;
							$pos += 2;
						}
						else
						if (! $in_double_quote && $ch == ",")
						{
							$field_end = true;
							$pos++;
						}
						else
						{
							$this_field .= $ch;
							$pos++;
						}

						if ($pos < strlen( $text ))
							$ch = substr( $text, $pos, 1 );
					}
                
					$data[$num_items] = $this_field;
					$num_items++;

                	if ($num_items > 1000)
						echo "Too many CSV fields<br>";
				}
			}

			if (substr( $text, strlen( $text ) - 1, 1) == ",")
			{
				$data[$num_items] = "";
				$num_items++;
			}
		}

		$data['num_fields'] = $num_items;

		return ($data);
	}


		/* returns true if we are showing on a low-res screen */

	function low_res_screen( $cxn )
	{
	    $ip_address = get_ip_address();

	    if (override_screen_size && $ip_address == ip_override_ip_address)
            $low_res = true;
        else
        {
            
            $user_agent_check = false;
            
			$screen_width = acv_session_get( 'screen_width', $cxn );
			
            if ($screen_width == '' || $screen_width == 0)
                $user_agent_check = true;

            if ($screen_width == -1)
 
                $user_agent_check = true;
            
            if ($user_agent_check)
            {
                if ((strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Android" ) !== false) ||
                     (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Opera Mini" ) !== false) ||
                     (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Windows Phone" ) !== false) ||
                     (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Phone" ) !== false) ||
                     (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Mobile" ) !== false) ||
                     (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "iPhone" ) !== false))
        			$low_res = true;
        		else
        			$low_res = false;
            }
            else
            {
        		if ($screen_width <= 510)
        			$low_res = true;
        		else
        			$low_res = false;
            }
        }        

        return ($low_res);
	}


    function browser_recognised( $cxn )
    {
		$query = "SELECT device FROM ".common_data_database_name.".browsers WHERE user_agent_string = '".val( $_SERVER, "HTTP_USER_AGENT" )."'";

		$result = run_query( $query, $cxn );
		
		if (query_num_rows( $result ) > 0)
            return (true);
        else
            return (false);
    }


	function is_medium_width_screen( $cxn )
	{
        if (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "iPad" ) !== false)
			$is_medium_width_screen = true;
		else
		{
			$is_medium_width_screen = false;
			
			$screen_width = acv_session_get( "screen_width", $cxn );
			
					// iPad
					
			if ((! low_res_screen( $cxn )) && $screen_width != '' && $screen_width < 1050)
				$is_medium_width_screen = true;
		}
					
		return ($is_medium_width_screen);
	}



		/* capitalise the first word of each sentence */

	function sentence_case( $text )
	{
	    $first_letter = true;
	    $text2 = "";
	    
        for ($i=0; $i < strlen( $text ); $i++)	    
        {
            $ch = substr( $text, $i, 1 );
            
            if ($first_letter && $ch != ' ')
            {
                $text2 .= strtoupper( $ch );
        	    $first_letter = false;
            }
            else
                $text2 .= $ch;
                
            if ($ch == '.')
	            $first_letter = true;
        }

        return ($text2);        
	}


		// reformat profile text
		
	function fix_formatting( $text )
	{
		$text = sentence_case( $text );

		$text = str_replace( " i ", " I ", $text );
		$text = str_replace( " ,", ",", $text );
		$text = str_replace( " .", ".", $text );
		
        return ($text);        
	}

		/* return the country of origin of the requesting user */

	function get_ip_country( $cxn, $this_ip_address="" )
	{
		if ($this_ip_address != "")
			$ipaddress = $this_ip_address;
		else
			$ipaddress = get_ip_address();

        if (ip_country_override != "")
        {
			if ($ipaddress == ip_override_ip_address)
                return (ip_country_override);
        }
	    
	    $key = "ip_country:".$ipaddress;
	    
        get_cache_item( $key, $found, $value, $cxn );

		if ($found)
			return ($value);
		else
		{
			$country = "";
			
                    // check for IPV4 or IPV6 ip address
                    
	        if (strpos( $ipaddress, ":" ) === false)
	        {
			    $ip_num = Dot2LongIP( $ipaddress );

				$query = "SELECT countryLONG, ipTO FROM ".common_data_database_name.".IPCountry WHERE ipFROM <= ".$ip_num." ORDER BY ipFROM DESC LIMIT 1";

//				$query = "SELECT countryLONG FROM ".common_data_database_name.".IPCountry WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";
	        }			    
			else
			{
			    $ip_num = Dot2LongIPv6( $ipaddress );	

				$query = "SELECT countryLONG, ipTO FROM ".common_data_database_name.".IPCountryV6 WHERE ipFROM <= ".$ip_num." ORDER BY ipFROM DESC LIMIT 1";

//				$query = "SELECT countryLONG FROM ".common_data_database_name.".IPCountryV6 WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";
	        }			    

			if ($ip_num != 0)
			{
				$result = run_query( $query, $cxn );
		
				if (query_num_rows($result) != 0)
				{
					$data = get_row( $result );
	
//	                if ($ip_num <= $data['ipTO'])
    					$country = name_case( $data['countryLONG'] );
				}
			}

            if ($country == "-")
                $country = "";

            if ($country != "")
            {
    			$country = str_replace( "'", "", $country );
    
                if ($country == "Holy See")
                    $country = "United States";
    
    			$query = "SELECT display_name FROM ".common_data_database_name.".country WHERE ip2location_country_name = '".$country."'";
    
    			$result = run_query( $query, $cxn );
    		
    			if (query_num_rows($result) > 0)
    			{
    				$data = get_row( $result );
    	
    				$country = name_case( $data['display_name'] );
    			}
    			else
    			    write_to_error_log( "IP2Location country ".$country." not found" );
            }                

				// If IP data not loaded
				
//			if ($county == '')
//				$country = 'Australia';


            save_cache_item( $key, $country, $cxn );
			
			return ($country);
		}
	}


	function get_ip_details( &$ip_country, &$ip_region, &$ip_city, $cxn )
	{
	    $ip_country = "";
	    $ip_region = "";
	    $ip_city = "";

		$ipaddress = get_ip_address();

	    if (ip_country_override != "")
	    {
			if ($ipaddress == ip_override_ip_address)
			{
			    $ip_country = ip_country_override;
	            $ip_city = ip_city_override;
	           
	            return;
			}
	    }

            // check for IPV4 or IPV6 ip address

        if (strpos( $ipaddress, ":" ) === false)
        {
		    $ip_num = Dot2LongIP( $ipaddress );

			$query = "SELECT * FROM ".common_data_database_name.".IPCountry WHERE ipFROM <= ".$ip_num." ORDER BY ipFROM DESC LIMIT 1";

//				$query = "SELECT countryLONG FROM ".common_data_database_name.".IPCountry WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";
        }			    
		else
		{
		    $ip_num = Dot2LongIPv6( $ipaddress );	

			$query = "SELECT * FROM ".common_data_database_name.".IPCountryV6 WHERE ipFROM <= ".$ip_num." ORDER BY ipFROM DESC LIMIT 1";

//				$query = "SELECT countryLONG FROM ".common_data_database_name.".IPCountryV6 WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";
        }			    

/*
        if (strpos( $ipaddress, ":" ) === false)
        {
		    $ip_num = Dot2LongIP( $ipaddress );

			$query = "SELECT * FROM ".common_data_database_name.".IPCountry WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";
        }			    
		else
		{
		    $ip_num = Dot2LongIPv6( $ipaddress );	

			$query = "SELECT * FROM ".common_data_database_name.".IPCountryV6 WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";
        }			    
*/
		if ($ip_num != 0)
		{
			$result = run_query( $query, $cxn );
	
			if (query_num_rows($result) != 0)
			{
				$data = get_row( $result );

//                if ($ip_num <= $data['ipTO'])
                {
    				$ip_country = name_case( $data['countryLONG'] );
    				$ip_region = name_case( $data['ip_region'] );
    				$ip_city = name_case( $data['ip_city'] );
    
        			if ($ip_country == "-")
                        $ip_country = "";
    
        			if ($ip_region == "-")
                        $ip_region = "";
    
        			if ($ip_city == "-")
                        $ip_city = "";
    
        			$ip_country = str_replace( "'", "", $ip_country );
        			$ip_region = str_replace( "'", "", $ip_region );
        			$ip_city = str_replace( "'", "", $ip_city );
    
                    if ($ip_country == "Holy See")
                        $ip_country = "United States";
        
                    if ($ip_country != "")
                    {
            			$query = "SELECT display_name FROM ".common_data_database_name.".country WHERE ip2location_country_name = '".$ip_country."'";
            
            			$result = run_query( $query, $cxn );
            		
            			if (query_num_rows($result) > 0)
            			{
            				$data = get_row( $result );
            	
            				$ip_country = name_case( $data['display_name'] );
            			}
            			else
            			    write_to_error_log( "IP2Location country ".$ip_country." not found" );
                    }                
                }
			}
		}

//        if ($country == "Holy See")
//            $country = "United States";
	}



		/* return the text IP address */

	function get_ip_address()
	{
		if (getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else
			$ipaddress = getenv('REMOTE_ADDR');

        if (strpos( $ipaddress, "," ) !== false)
        {
//            write_to_error_log( "Ip address: ".$ipaddress );
            
            $ipaddress = substr( $ipaddress, 0, strpos( $ipaddress, "," ) );
        }
        
		return ($ipaddress);
	}


    function get_cache_item( $key, &$found, &$value, $cxn )
    {
    	global $sys_cache_variables;
		    
        $found = false;
        $value = 0;
        
		if (isset( $sys_cache_variables[$key] ))
		{
            $found = true;
			
            $value = $sys_cache_variables[$key];
		}
		else
		{
	   		$query = "SELECT * from sys_cache where param = '".prep_for_sql( $key )."'";
	
	   		$result = run_query( $query, $cxn );
	
	        if (query_num_rows( $result ) > 0)
	        {
	            $found = true;
	            
	   		    $data = get_row( $result );	
	            
	            $value = $data['value'];
				
            	$sys_cache_variables[$key] = $value;
	        }
		}
    }

 
    function save_cache_item( $key, $value, $cxn )
    {
    	global $sys_cache_variables;
    	    
        $date_added = date( "Y-m-d" );

   		$query = "INSERT INTO sys_cache (date_added, param, value) VALUES ('".$date_added."', '".prep_for_sql( $key )."', '".prep_for_sql( $value )."' )";

       	run_query( $query, $cxn );
		
      	$sys_cache_variables[$key] = $value;
    }




		/* convert a string IP address into a number */

	function Dot2LongIP( $IPaddr )
	{
		if ($IPaddr == "")
			return 0;
		else
		{
			$ips[0] = "";
			$ips[1] = "";
			$ips[2] = "";
			$ips[3] = "";

//			$ips = split ("\.", "$IPaddr");

			$j = 0;

			for ($i=0; $i < strlen( $IPaddr ) && $j <= 3; $i++)
			{
				$ch = substr( $IPaddr, $i, 1 );

				if ($ch == ".")
					$j++;
				else
					$ips[$j] .= $ch;
			}

			return ($ips[3] + $ips[2] * 256 + $ips[1] * 256 * 256 + $ips[0] * 256 * 256 * 256);
		}
	}


	function Dot2LongIPv6_IP2l_version_not_in_use ($IPaddr) 
    {
        $int = inet_pton( $IPaddr );

        $bits = 15;

        $ipv6long = 0;

        while ($bits >= 0)
        {
            $bin = sprintf( "%08b", (ord($int[$bits])) );

            if ($ipv6long)
            {
                $ipv6long = $bin . $ipv6long;
            }
            else
            {
                $ipv6long = $bin;
            }

            $bits--;
        }

//        $ipv6long = gmp_strval(gmp_init($ipv6long, 2), 10);


        return $ipv6long;
    }



     function Dot2LongIPv6 ($IPaddr) 
     {
		$acc = "0";
		
        $int = inet_pton( $IPaddr );

		if ((ord($int[15]) & 0x01) != 0)	$acc = add_str( $acc, "1" );
		if ((ord($int[15]) & 0x02) != 0)	$acc = add_str( $acc, "2" );
		if ((ord($int[15]) & 0x04) != 0)	$acc = add_str( $acc, "4" );
		if ((ord($int[15]) & 0x08) != 0)	$acc = add_str( $acc, "8" );

		if ((ord($int[15]) & 0x10) != 0)	$acc = add_str( $acc, "16" );
		if ((ord($int[15]) & 0x20) != 0)	$acc = add_str( $acc, "32" );
		if ((ord($int[15]) & 0x40) != 0)	$acc = add_str( $acc, "64" );
		if ((ord($int[15]) & 0x80) != 0)	$acc = add_str( $acc, "128" );

		if ((ord($int[14]) & 0x01) != 0)	$acc = add_str( $acc, "256" );
		if ((ord($int[14]) & 0x02) != 0)	$acc = add_str( $acc, "512" );
		if ((ord($int[14]) & 0x04) != 0)	$acc = add_str( $acc, "1024" );
		if ((ord($int[14]) & 0x08) != 0)	$acc = add_str( $acc, "2048" );

		if ((ord($int[14]) & 0x10) != 0)	$acc = add_str( $acc, "4096" );
		if ((ord($int[14]) & 0x20) != 0)	$acc = add_str( $acc, "8192" );
		if ((ord($int[14]) & 0x40) != 0)	$acc = add_str( $acc, "16384" );
		if ((ord($int[14]) & 0x80) != 0)	$acc = add_str( $acc, "32768" );

		if ((ord($int[13]) & 0x01) != 0)	$acc = add_str( $acc, "65536" );
		if ((ord($int[13]) & 0x02) != 0)	$acc = add_str( $acc, "131072" );
		if ((ord($int[13]) & 0x04) != 0)	$acc = add_str( $acc, "262144" );
		if ((ord($int[13]) & 0x08) != 0)	$acc = add_str( $acc, "524288" );

		if ((ord($int[13]) & 0x10) != 0)	$acc = add_str( $acc, "1048576" );
		if ((ord($int[13]) & 0x20) != 0)	$acc = add_str( $acc, "2097152" );
		if ((ord($int[13]) & 0x40) != 0)	$acc = add_str( $acc, "4194304" );
		if ((ord($int[13]) & 0x80) != 0)	$acc = add_str( $acc, "8388608" );

		if ((ord($int[12]) & 0x01) != 0)	$acc = add_str( $acc, "16777216" );
		if ((ord($int[12]) & 0x02) != 0)	$acc = add_str( $acc, "33554432" );
		if ((ord($int[12]) & 0x04) != 0)	$acc = add_str( $acc, "67108864" );
		if ((ord($int[12]) & 0x08) != 0)	$acc = add_str( $acc, "134217728" );

		if ((ord($int[12]) & 0x10) != 0)	$acc = add_str( $acc, "268435456" );
		if ((ord($int[12]) & 0x20) != 0)	$acc = add_str( $acc, "536870912" );
		if ((ord($int[12]) & 0x40) != 0)	$acc = add_str( $acc, "1073741824" );
		if ((ord($int[12]) & 0x80) != 0)	$acc = add_str( $acc, "2147483648" );

		if ((ord($int[11]) & 0x01) != 0)	$acc = add_str( $acc, "4294967296" );
		if ((ord($int[11]) & 0x02) != 0)	$acc = add_str( $acc, "8589934592" );
		if ((ord($int[11]) & 0x04) != 0)	$acc = add_str( $acc, "17179869184" );
		if ((ord($int[11]) & 0x08) != 0)	$acc = add_str( $acc, "34359738368" );

		if ((ord($int[11]) & 0x10) != 0)	$acc = add_str( $acc, "68719476736" );
		if ((ord($int[11]) & 0x20) != 0)	$acc = add_str( $acc, "137438953472" );
		if ((ord($int[11]) & 0x40) != 0)	$acc = add_str( $acc, "274877906944" );
		if ((ord($int[11]) & 0x80) != 0)	$acc = add_str( $acc, "549755813888" );

		if ((ord($int[10]) & 0x01) != 0)	$acc = add_str( $acc, "1099511627776" );
		if ((ord($int[10]) & 0x02) != 0)	$acc = add_str( $acc, "2199023255552" );
		if ((ord($int[10]) & 0x04) != 0)	$acc = add_str( $acc, "4398046511104" );
		if ((ord($int[10]) & 0x08) != 0)	$acc = add_str( $acc, "8796093022208" );

		if ((ord($int[10]) & 0x10) != 0)	$acc = add_str( $acc, "17592186044416" );
		if ((ord($int[10]) & 0x20) != 0)	$acc = add_str( $acc, "35184372088832" );
		if ((ord($int[10]) & 0x40) != 0)	$acc = add_str( $acc, "70368744177664" );
		if ((ord($int[10]) & 0x80) != 0)	$acc = add_str( $acc, "140737488355328" );

		if ((ord($int[9]) & 0x01) != 0)	$acc = add_str( $acc, "281474976710656" );
		if ((ord($int[9]) & 0x02) != 0)	$acc = add_str( $acc, "562949953421312" );
		if ((ord($int[9]) & 0x04) != 0)	$acc = add_str( $acc, "1125899906842624" );
		if ((ord($int[9]) & 0x08) != 0)	$acc = add_str( $acc, "2251799813685248" );

		if ((ord($int[9]) & 0x10) != 0)	$acc = add_str( $acc, "4503599627370496" );
		if ((ord($int[9]) & 0x20) != 0)	$acc = add_str( $acc, "9007199254740992" );
		if ((ord($int[9]) & 0x40) != 0)	$acc = add_str( $acc, "18014398509481984" );
		if ((ord($int[9]) & 0x80) != 0)	$acc = add_str( $acc, "36028797018963968" );

		if ((ord($int[8]) & 0x01) != 0)	$acc = add_str( $acc, "72057594037927936" );
		if ((ord($int[8]) & 0x02) != 0)	$acc = add_str( $acc, "144115188075855872" );
		if ((ord($int[8]) & 0x04) != 0)	$acc = add_str( $acc, "288230376151711744" );
		if ((ord($int[8]) & 0x08) != 0)	$acc = add_str( $acc, "576460752303423488" );

		if ((ord($int[8]) & 0x10) != 0)	$acc = add_str( $acc, "1152921504606846976" );
		if ((ord($int[8]) & 0x20) != 0)	$acc = add_str( $acc, "2305843009213693952" );
		if ((ord($int[8]) & 0x40) != 0)	$acc = add_str( $acc, "4611686018427387904" );
		if ((ord($int[8]) & 0x80) != 0)	$acc = add_str( $acc, "9223372036854775808" );

		if ((ord($int[7]) & 0x01) != 0)	$acc = add_str( $acc, "18446744073709551616" );
		if ((ord($int[7]) & 0x02) != 0)	$acc = add_str( $acc, "36893488147419103232" );
		if ((ord($int[7]) & 0x04) != 0)	$acc = add_str( $acc, "73786976294838206464" );
		if ((ord($int[7]) & 0x08) != 0)	$acc = add_str( $acc, "147573952589676412928" );

		if ((ord($int[7]) & 0x10) != 0)	$acc = add_str( $acc, "295147905179352825856" );
		if ((ord($int[7]) & 0x20) != 0)	$acc = add_str( $acc, "590295810358705651712" );
		if ((ord($int[7]) & 0x40) != 0)	$acc = add_str( $acc, "1180591620717411303424" );
		if ((ord($int[7]) & 0x80) != 0)	$acc = add_str( $acc, "2361183241434822606848" );

		if ((ord($int[6]) & 0x01) != 0)	$acc = add_str( $acc, "4722366482869645213696" );
		if ((ord($int[6]) & 0x02) != 0)	$acc = add_str( $acc, "9444732965739290427392" );
		if ((ord($int[6]) & 0x04) != 0)	$acc = add_str( $acc, "18889465931478580854784" );
		if ((ord($int[6]) & 0x08) != 0)	$acc = add_str( $acc, "37778931862957161709568" );

		if ((ord($int[6]) & 0x10) != 0)	$acc = add_str( $acc, "75557863725914323419136" );
		if ((ord($int[6]) & 0x20) != 0)	$acc = add_str( $acc, "151115727451828646838272" );
		if ((ord($int[6]) & 0x40) != 0)	$acc = add_str( $acc, "302231454903657293676544" );
		if ((ord($int[6]) & 0x80) != 0)	$acc = add_str( $acc, "604462909807314587353088" );

		if ((ord($int[5]) & 0x01) != 0)	$acc = add_str( $acc, "1208925819614629174706176" );
		if ((ord($int[5]) & 0x02) != 0)	$acc = add_str( $acc, "2417851639229258349412352" );
		if ((ord($int[5]) & 0x04) != 0)	$acc = add_str( $acc, "4835703278458516698824704" );
		if ((ord($int[5]) & 0x08) != 0)	$acc = add_str( $acc, "9671406556917033397649408" );

		if ((ord($int[5]) & 0x10) != 0)	$acc = add_str( $acc, "19342813113834066795298816" );
		if ((ord($int[5]) & 0x20) != 0)	$acc = add_str( $acc, "38685626227668133590597632" );
		if ((ord($int[5]) & 0x40) != 0)	$acc = add_str( $acc, "77371252455336267181195264" );
		if ((ord($int[5]) & 0x80) != 0)	$acc = add_str( $acc, "154742504910672534362390528" );

		if ((ord($int[4]) & 0x01) != 0)	$acc = add_str( $acc, "309485009821345068724781056" );
		if ((ord($int[4]) & 0x02) != 0)	$acc = add_str( $acc, "618970019642690137449562112" );
		if ((ord($int[4]) & 0x04) != 0)	$acc = add_str( $acc, "1237940039285380274899124224" );
		if ((ord($int[4]) & 0x08) != 0)	$acc = add_str( $acc, "2475880078570760549798248448" );

		if ((ord($int[4]) & 0x10) != 0)	$acc = add_str( $acc, "4951760157141521099596496896" );
		if ((ord($int[4]) & 0x20) != 0)	$acc = add_str( $acc, "9903520314283042199192993792" );
		if ((ord($int[4]) & 0x40) != 0)	$acc = add_str( $acc, "19807040628566084398385987584" );
		if ((ord($int[4]) & 0x80) != 0)	$acc = add_str( $acc, "39614081257132168796771975168" );

		if ((ord($int[3]) & 0x01) != 0)	$acc = add_str( $acc, "79228162514264337593543950336" );
		if ((ord($int[3]) & 0x02) != 0)	$acc = add_str( $acc, "158456325028528675187087900672" );
		if ((ord($int[3]) & 0x04) != 0)	$acc = add_str( $acc, "316912650057057350374175801344" );
		if ((ord($int[3]) & 0x08) != 0)	$acc = add_str( $acc, "633825300114114700748351602688" );

		if ((ord($int[3]) & 0x10) != 0)	$acc = add_str( $acc, "1267650600228229401496703205376" );
		if ((ord($int[3]) & 0x20) != 0)	$acc = add_str( $acc, "2535301200456458802993406410752" );
		if ((ord($int[3]) & 0x40) != 0)	$acc = add_str( $acc, "5070602400912917605986812821504" );
		if ((ord($int[3]) & 0x80) != 0)	$acc = add_str( $acc, "10141204801825835211973625643008" );

		if ((ord($int[2]) & 0x01) != 0)	$acc = add_str( $acc, "20282409603651670423947251286016" );
		if ((ord($int[2]) & 0x02) != 0)	$acc = add_str( $acc, "40564819207303340847894502572032" );
		if ((ord($int[2]) & 0x04) != 0)	$acc = add_str( $acc, "81129638414606681695789005144064" );
		if ((ord($int[2]) & 0x08) != 0)	$acc = add_str( $acc, "162259276829213363391578010288128" );

		if ((ord($int[2]) & 0x10) != 0)	$acc = add_str( $acc, "324518553658426726783156020576256" );
		if ((ord($int[2]) & 0x20) != 0)	$acc = add_str( $acc, "649037107316853453566312041152512" );
		if ((ord($int[2]) & 0x40) != 0)	$acc = add_str( $acc, "1298074214633706907132624082305024" );
		if ((ord($int[2]) & 0x80) != 0)	$acc = add_str( $acc, "2596148429267413814265248164610048" );

		if ((ord($int[1]) & 0x01) != 0)	$acc = add_str( $acc, "5192296858534827628530496329220096" );
		if ((ord($int[1]) & 0x02) != 0)	$acc = add_str( $acc, "10384593717069655257060992658440192" );
		if ((ord($int[1]) & 0x04) != 0)	$acc = add_str( $acc, "20769187434139310514121985316880384" );
		if ((ord($int[1]) & 0x08) != 0)	$acc = add_str( $acc, "41538374868278621028243970633760768" );

		if ((ord($int[1]) & 0x10) != 0)	$acc = add_str( $acc, "83076749736557242056487941267521536" );
		if ((ord($int[1]) & 0x20) != 0)	$acc = add_str( $acc, "166153499473114484112975882535043072" );
		if ((ord($int[1]) & 0x40) != 0)	$acc = add_str( $acc, "332306998946228968225951765070086144" );
		if ((ord($int[1]) & 0x80) != 0)	$acc = add_str( $acc, "664613997892457936451903530140172288" );

		if ((ord($int[0]) & 0x01) != 0)	$acc = add_str( $acc, "1329227995784915872903807060280344576" );
		if ((ord($int[0]) & 0x02) != 0)	$acc = add_str( $acc, "2658455991569831745807614120560689152" );
		if ((ord($int[0]) & 0x04) != 0)	$acc = add_str( $acc, "5316911983139663491615228241121378304" );
		if ((ord($int[0]) & 0x08) != 0)	$acc = add_str( $acc, "10633823966279326983230456482242756608" );

		if ((ord($int[0]) & 0x10) != 0)	$acc = add_str( $acc, "21267647932558653966460912964485513216" );
		if ((ord($int[0]) & 0x20) != 0)	$acc = add_str( $acc, "42535295865117307932921825928971026432" );
		if ((ord($int[0]) & 0x40) != 0)	$acc = add_str( $acc, "85070591730234615865843651857942052864" );
		if ((ord($int[0]) & 0x80) != 0)	$acc = add_str( $acc, "170141183460469231731687303715884105728" );
				
/*		
        $bits = 15;

        $ipv6long = 0;

        while ($bits >= 0)
        {
            $bin = sprintf( "%08b", (ord($int[$bits])) );

            if ($ipv6long)
            {
                $ipv6long = $bin . $ipv6long;
            }
            else
            {
                $ipv6long = $bin;
            }

            $bits--;
        }

        $ipv6long = gmp_strval(gmp_init($ipv6long, 2), 10);
*/

		$ipv6long = $acc;

        return $ipv6long;
    }

		// add two strings of decimal digits. Doesn't include decimal points or signs. Can be different lengths.
		
	function add_str( $s1, $s2 )
	{
		$slen1 = strlen( $s1 );
		$slen2 = strlen( $s2 );
		
		if ($slen1 > $slen2)
			$s_length = $slen1;
		else
			$s_length = $slen2;
			
		$c = 0;
		$acc = "";
		
		for ($i=0; $i < $s_length; $i++)
		{
			if (strlen( $s1 ) - $i - 1 >= 0)
				$p1 = substr( $s1, strlen( $s1 ) - $i - 1, 1 );
			else
				$p1 = '0';
			 
			if (strlen( $s2 ) - $i - 1 >= 0)
				$p2 = substr( $s2, strlen( $s2 ) - $i - 1, 1 );
			else
				$p2 = '0';
			
			$p3 = $p1 + $p2 + $c;
			
			if ($p3 >= 10)
			{
				$c = 1;
				$p3 -= 10;
			}
			else
				$c = 0;

			$acc = $p3 . $acc;		
		}
		
		if ($c == 1)
			$acc = '1'.$acc;
		
		return ($acc);
	}
	


		/* display text in general colours */

	function home_page_text( $cxn, $text )
	{
	    if (! low_res_screen( $cxn ))
	    	return "<span class='ghome_page_text'>".$text."</span>";
	    else
	        return "<span class='ghome_page_text_mobile'>".$text."</span>";
	}

/*
	function glink( $text, $url )
	{
        return "<a class='glink' href='".$url."'>".$text."</a>";
	}
*/

	function black( $text )
	{
        return "<span class='gblack'>".$text."</span>";
	}


	function dtext( $text )
	{
        return "<span class='dtext'>".$text."</span>";
	}

	function gray( $text )
	{
		return "<span class='ggray'>".$text."</span>";
	}
	
	function white( $text )
	{
	    return "<span class='gwhite'>".$text."</span>";
	}

	function blue( $text )
	{
		return "<span class='gblue'>".$text."</span>";
	}

	function red( $text )
	{
		return "<span class='gred'>".$text."</span>";
	}

	function darkgreen( $text )
	{
		return "<span class='gdarkgreen'>".$text."</span>";
	}

	function green( $text )
	{
		return "<span class='ggreen'>".$text."</span>";
	}

	function gold( $text )
	{
		return "<span class='ggold'>".$text."</span>";
	}

	function brown( $text )
	{
		return "<span class='gbrown'>".$text."</span>";
	}

	function paraheading( $text )
	{
		return "<span class='paraheading'>".$text."</span>";
	}

	function watermark( $text )
	{
		return "<span class='gwatermark'>".$text."</span>";
	}

	function watermark_sm( $text )
	{
		return "<span class='gwatermark_sm'>".$text."</span>";
	}

	function fprompt( $text )
	{
		return "<span class='fprompt'>".$text."</span>";
	}


	function mainmenuheading( $text )
	{
		return "<td cellspacing='0' class='mainmenuheading'>".$text."</td>";
	}

	// *** NOTE ** don't use http(s)://XXXXXXX in redirects or it deletes the session variables, just use the file name



		/* show a link to the home page */

	function show_home_link( $cxn )
	{
		return show_link( lookup( "Home Page", $cxn ), "/" );
	}
	

		/* return the first row of a query, generates an error if the query is empty */

	function get_first_row( $query, $cxn )
	{
		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
			crash( "Query is empty: ".$query, $cxn );

		$data = get_row( $result );
		
		return ($data);
	}



		/* fix up a text string for use in an sql query */

	function prep_for_sql( $text )
	{
		$text = str_replace( "'", "''", $text );

		$text = str_replace( "\\", "", $text );

		return ($text);
	}


		// convert date in date_format to YYYY-MM-DD
		// two digit dates are put into the range 1930 to 2030

	function convert_date_to_yyyymmdd( $this_date, $date_format, $cxn )
	{
		$j = 0;

		$parts[0] = "";
		$parts[1] = "";
		$parts[2] = "";

		for ($i=0; $i < strlen($this_date) && $j <= 2; $i++)
		{
			if (is_digit( substr( $this_date, $i, 1 )))
				$parts[$j] = $parts[$j].substr( $this_date, $i, 1 );
			else
				$j = $j + 1;
		}

        if ($date_format == "")
        {
            return ("0000-00-00");
        }
        else
		if ($date_format == "dd/mm/yyyy")
		{
			$day = $parts[0];
			$month = $parts[1];
			$year = $parts[2];
		}
		else
		if ($date_format == "mm/dd/yyyy")
		{
			$month = $parts[0];
			$day = $parts[1];
			$year = $parts[2];
		}
		else
		if ($date_format == "yyyy/mm/dd")
		{
			$year = $parts[0];
			$month = $parts[1];
			$day = $parts[2];
		}
		else
			crash( "Internal Error: invalid date format ".$date_format." in convert date to yyyy-mm-dd", $cxn );

		if (strlen( $day ) == 1)
			$day = "0".$day;

		if (strlen( $month ) == 1)
			$month = "0".$month;

        if ((! is_numeric( $day )) || (! is_numeric( $month )) || (! is_numeric( $year )))
            return ("0000-00-00");
        else
		if ($year < 100)		// 2-digit year
		{
			if ($year < 30)
				$year = $year + 2000;
			else
				$year = $year + 1900;
		}

		return ($year."-".$month."-".$day);
	}


	function convert_date_str_yyyymmdd_to_ddmmyyyy( $date_str )
	{
		return (substr( $date_str, 8, 2 ).'/'.substr( $date_str, 5, 2).'/'.substr( $date_str, 0, 4 ));
	}


	function convert_date_str_ddmmyyyy_to_yyyymmdd( $date_str )
	{
		return (substr( $date_str, 6, 4 ).'-'.substr( $date_str, 3, 2).'-'.substr( $date_str, 0, 2 ));
	}


	function is_digit( $ch )
	{
		if ($ch >= "0" && $ch <= "9")
			return true;
		else
			return false;
	}
	
	
	function sample_image_type( $cxn )
	{	
		$ip_country = get_ip_country( $cxn );

		$query = "SELECT photo_type FROM ".common_data_database_name.".country WHERE display_name = '".$ip_country."'";

		$result = run_query( $query, $cxn );

		if (! query_has_rows( $query, $cxn ))
			$photo_type = "white";
		else
		{
			$data = get_row( $result );
			
			$photo_type = $data['photo_type'];		
		}

		if ($photo_type == "arab")		// don't show arabic photos for security
			$photo_type = "white";

		return ($photo_type);
	}


		// returns true for date ok and false if a date is invalid. Yyyy-mm-dd format.
		
	function check_date_valid( $date_text )
	{
		$ok = true;
		
	    if (strlen( $date_text ) != 10 || $date_text == "0000-00-00")
			$ok =  false;
        else
        {
            $day_text = substr( $date_text, 8, 2 );
            $month_text = substr( $date_text, 5, 2 );
            $year_text = substr( $date_text, 0, 4 );
            
            if ((! is_digit( substr( $day_text, 0, 1 )))   ||
                (! is_digit( substr( $day_text, 1, 1 )))   ||
                (! is_digit( substr( $month_text, 0, 1 ))) ||
                (! is_digit( substr( $month_text, 1, 1 ))) ||
                (! is_digit( substr( $year_text, 0, 1 )))  ||
                (! is_digit( substr( $year_text, 1, 1 )))  ||
                (! is_digit( substr( $year_text, 2, 1 )))  ||
                (! is_digit( substr( $year_text, 3, 1 ))))
    			$ok =  false;
            else            
            if ($month_text == 0 || intval( $month_text ) > 12)
    			$ok =  false;
            else
            {
                if ($month_text == "01" && intval( $day_text ) > 31 )
        			$ok =  false;
        		else
                if ($month_text == "02" && is_leap_year( $year_text ) && intval( $day_text ) > 29 )
        			$ok =  false;
        		else
                if ($month_text == "02" && (! is_leap_year( $year_text )) && intval( $day_text ) > 28 )
        			$ok =  false;
        		else
                if ($month_text == "03" && intval( $day_text ) > 31 )
        			$ok =  false;
        		else
                if ($month_text == "04" && intval( $day_text ) > 30 )
        			$ok =  false;
        		else
                if ($month_text == "05" && intval( $day_text ) > 31 )
        			$ok =  false;
        		else
                if ($month_text == "06" && intval( $day_text ) > 30 )
        			$ok =  false;
        		else
                if ($month_text == "07" && intval( $day_text ) > 31 )
        			$ok =  false;
        		else
                if ($month_text == "08" && intval( $day_text ) > 31 )
        			$ok =  false;
        		else
                if ($month_text == "09" && intval( $day_text ) > 30 )
        			$ok =  false;
        		else
                if ($month_text == "10" && intval( $day_text ) > 31 )
        			$ok =  false;
        		else
                if ($month_text == "11" && intval( $day_text ) > 30 )
        			$ok =  false;
        		else
                if ($month_text == "12" && intval( $day_text ) > 31 )
        			$ok =  false;
            }
        }

		return ($ok);			
	}


    function is_leap_year( $year )
    {
        $leap_year = false;
        
        if (intval( $year / 4 ) == ($year / 4))
            $leap_year = true;

        if (intval( $year / 100 ) == ($year / 100))
            $leap_year = false;
            
        if (intval( $year / 400 ) == ($year / 400))
            $leap_year = true;
    
        return ($leap_year);
    }


		// called by each specific library

	function write_common_styles()
	{
//		$color_scheme = val( , 'color_scheme' );
	}



    function write_acv_styles()
    {
        
	    $fs2 = 14;
	    $fsm = 15;
        
//        $bg_color = "darkblue";
        
		echo ".greenbuttondesktop {text-align: center; cursor: pointer; border: 1px solid ".acv_bg_color."; box-shadow: 5px 5px 5px #afafaf; border-radius: 5px; background: ".acv_bg_color."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		

		echo ".greenbuttondesktop:hover {text-align: center; cursor: pointer; border: 1px solid ".acv_bg_color_hover."; border-radius: 5px; background: ".acv_bg_color_hover."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";


		echo ".graybuttondesktop {text-align: center; cursor: pointer; border: 1px solid #999999; border-radius: 5px; background: #999999; color: ".acv_bg_color."; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		
//#008a00
    	echo ".greenbuttonmobile {text-align: center; cursor: pointer; line-height: 12pt; border:solid green; border-radius: 4px; background: ".acv_bg_color."; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttonmobile:hover {text-align: center; cursor: pointer; line-height: 12pt; border:solid darkgreen; border-radius: 4px; background: ".acv_bg_color_hover."; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".graybuttonmobile {text-align: center; cursor: pointer; line-height: 12pt; border:solid #999999; border-radius: 4px; background: #999999; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		

		echo ".greenbuttonmobile3 {text-align: center; border-left:solid #999999; border-top:solid #999999; border-right:solid #999999; background: ".acv_bg_color."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";


    	echo ".greenbuttonmobile3:hover {text-align: center; border-left:solid #999999; border-top:solid #999999; border-right:solid #999999; background: ".acv_bg_color_hover."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";



		echo ".greenbuttonmobile3_bottom {text-align: center; border-left:solid #999999; border-top:solid #999999; border-bottom:solid #999999; border-right:solid #999999; background: ".acv_bg_color."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";
		
		
		echo ".greenbuttonmobile3_bottom:hover {text-align: center; border-left:solid #999999; border-top:solid #999999; border-bottom:solid #999999; border-right:solid #999999; background: ".acv_bg_color_hover."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";
		
		
		echo ".greenbuttonmobilelink {text-align: center; background: ".acv_bg_color."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; text-decoration: none;";
		echo "    }";

		echo ".greenbuttonmobilelink:hover {text-align: center; background: ".acv_bg_color_hover."; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; text-decoration: none;";
		echo "    }";
    }
    
    

        // show the 'no photo' picture
        
    function show_no_photo( $height, $flags=0 )
    {
        $width = round( $height * 0.80 );
        
        $font_size = round( $height * 0.0848 );
        
		echo "<div class='no_photo' style='";
		
        if (opt_set( $flags, OPT_SHOW_PHOTO_SHOW_BORDER ))
    		echo "border: 8px solid #FFFFFF; ";
    		
    	echo "font-size: ".$font_size."pt; width: ".$width."px; height: ".$height."px;'>";

    	//    	echo "border-radius: 5px; display: inline-block; font-family: verdana; font-size: ".$font_size."pt; color: #000000; background-color: #D8F9FE; width: ".$width."px; height: ".$height."px;' align='center'>";

		if ($height > 150)
		    echo "<br>";
		    
		echo "<br>No Photo<br><br>Available</div>";
    }


    function show_photo_not_enabled( $filename, $height )
    {
        $width = round( $height * 0.80 );
        
        $font_size = round( $height * 0.0848 * 0.8 );
        
		echo "<div style='border: 10px solid #FFFFFF; display: inline-block; font-family: verdana; font-size: ".$font_size."pt; color: #000000; background-color: #D8F9FE; width: ".$width."px; height: ".$height."px;' align='center'>";

		if ($height > 150)
		    echo "<br>";
		    
        if (! low_res_screen( $cxn ))
    		echo "<br>Click to<br><br>view photo</div>";
        else
    		echo "<br>Press to<br><br>view photo</div>";
    }



		// Use CSS and javascript to produce a colored clickable button
		
		// color #40A245 is the mid to pale green from the original GIF buttons. It's a nicer color than HTML 'green' but the text is very hard to read
		// because white text against a light background isn't clear
		
		
	function show_green_button( $cxn, $text, $size, $amp, $page="", $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5="", $param6="", $value6="", $param7="", $value7="", $param8="", $value8="", $param9="", $value9="", $param10="", $value10="", $param11="", $value11="", $param12="", $value12="", $param13="", $value13="", $param14="", $value14="", $param15="", $value15="", $param16="", $value16="" )
	{
		$this_size = $size * 0.85;
		
		$url = url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4, $param5, $value5, $param6, $value6, $param7, $value7, $param8, $value8, $param9, $value9, $param10, $value10, $param11, $value11, $param12, $value12, $param13, $value13, $param14, $value14, $param15, $value15, $param16, $value16 );

        if ($amp)
        {
    		if (! low_res_screen( $cxn ))
    			echo "<div><a href='".$url."' class='greenbuttondesktop' style='text-decoration: none; line-height: 25px;'>".$text."</a></div> ";
//   			echo "<div><a href='".$url."' class='greenbuttondesktop' style='text-decoration: none; line-height: 25px; min-width:".$this_size."px;'>".$text."</a></div> ";
    		else
    			echo "<div><a href='".$url."' class='greenbuttonmobile' style='text-decoration: none; line-height: 24px;'>".$text."</a></div> ";
//    			echo "<div><a href='".$url."' class='greenbuttonmobile' style='text-decoration: none; line-height: 24px; min-width:".$this_size."px;'>".$text."</a></div> ";
        }
        else
        {
//    		if (! low_res_screen( $cxn ))
//    			echo "<div onclick=\"window.location.href='".$url."'\" class='greenbuttondesktop' style='line-height: 25px; min-width:".$this_size."px;'>".$text."</div> ";
//    		else
//    			echo "<div><a href='".$url."' class='greenbuttonmobile' style='text-decoration: none; line-height: 24px; min-width:".$this_size."px;'>".$text."</a></div> ";
        	
    		if (! low_res_screen( $cxn ))
    			echo "<div onclick=\"window.location.href='".$url."'\" class='greenbuttondesktop' style='line-height: 25px; min-width:".$this_size."px;'>".$text."</div> ";
    		else
    			echo "<div onclick=\"window.location.href='".$url."'\" class='greenbuttonmobile' style='line-height: 24px; min-width:".$this_size."px;'>".$text."</div> ";
        }
	}


	function show_red_button( $cxn, $text, $size, $amp, $page="", $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5="", $param6="", $value6="", $param7="", $value7="", $param8="", $value8="", $param9="", $value9="", $param10="", $value10="", $param11="", $value11="", $param12="", $value12="", $param13="", $value13="", $param14="", $value14="", $param15="", $value15="", $param16="", $value16="" )
	{
		$this_size = $size * 0.85;
		
		$url = url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4, $param5, $value5, $param6, $value6, $param7, $value7, $param8, $value8, $param9, $value9, $param10, $value10, $param11, $value11, $param12, $value12, $param13, $value13, $param14, $value14, $param15, $value15, $param16, $value16 );

        if ($amp)
        {
    		if (! low_res_screen( $cxn ))
    			echo "<div><a href='".$url."' class='redbuttondesktop' style='text-decoration: none; line-height: 25px; min-width:".$this_size."px;'>".$text."</a></div> ";
    		else
    			echo "<div><a href='".$url."' class='redbuttonmobile' style='text-decoration: none; line-height: 24px; min-width:".$this_size."px;'>".$text."</a></div> ";
        }
        else
        {
    		if (! low_res_screen( $cxn ))
    			echo "<div onclick=\"window.location.href='".$url."'\" class='redbuttondesktop' style='line-height: 25px; min-width:".$this_size."px;'>".$text."</div> ";
    		else
    			echo "<div onclick=\"window.location.href='".$url."'\" class='redbuttonmobile' style='line-height: 24px; min-width:".$this_size."px;'>".$text."</div> ";

//    		if (! low_res_screen( $cxn ))
//    			echo "<div onclick=\"window.location.href='".$url."'\" class='greenbuttondesktop' style='line-height: 25px; min-width:".$this_size."px;' align='center'>".$text."</div> ";
//    		else
//    			echo "<div onclick=\"window.location.href='".$url."'\" class='greenbuttonmobile' style='line-height: 24px; min-width:".$this_size."px;' align='center'>".$text."</div> ";			
        }
	}


	function show_gray_button( $text, $size, $amp, $page="", $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5="", $param6="", $value6="", $param7="", $value7="", $param8="", $value8="", $param9="", $value9="", $param10="", $value10="", $param11="", $value11="", $param12="", $value12="", $param13="", $value13="", $param14="", $value14=""  )
	{
		$this_size = $size * 0.85;
		
		$url = url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4, $param5, $value5, $param6, $value6, $param7, $value7, $param8, $value8, $param9, $value9, $param10, $value10, $param11, $value11, $param12, $value12, $param13, $value13, $param14, $value14 );

		if (! low_res_screen( $cxn ))
			echo "<div onclick=\"window.location.href='".$url."'\" class='graybuttondesktop' style='line-height: 25px; width:".$this_size."px;' align='center'>".$text."</div> ";
		else
			echo "<div onclick=\"window.location.href='".$url."'\" class='graybuttonmobile' style='line-height: 24px; width:".$this_size."px;' align='center'>".$text."</div> ";			
	}


		// Use CSS and javascript to produce a colored clickable button
/*
	function show_green_button_submit( $text, $size, $html_form_name="form" )	
	{
		$this_size = $size * 0.85;

			// current style, green with square rounded corners	
			
		if (! low_res_screen( $cxn ))
			echo "<div onclick=\"document.forms.".$html_form_name.".submit()\" class='greenbuttondesktop' style='line-height: 25px; min-width:".$this_size."px;' align='center'>".$text."</div> ";			
		else
			echo "<div onclick=\"document.forms.".$html_form_name.".submit()\" class='greenbuttonmobile' style='line-height: 24px; min-width:".$this_size."px;' align='center'>".$text."</div> ";						
	}
*/


		// Use CSS and javascript to produce a colored clickable button
		
	function show_green_button_opaque( $cxn, $text, $size )
	{
		$this_size = $size * 0.85;


			// current style, green with square rounded corners	
			
		if (! low_res_screen( $cxn ))
			echo "<div class='greenbuttondesktop' style='opacity: 0.35; line-height: 25px; width:".$this_size."px;' align='center'>".$text."</div> ";			
		else
			echo "<div class='greenbuttonmobile' style='opacity: 0.35; line-height: 24px; width:".$this_size."px;' align='center'>".$text."</div> ";						
	}

	
	
	function query_num_rows( $result )
	{
        return ($result->num_rows);		
	}


		// Calculate's a person's age. The '$date_text' should be in the format YYYY-MM-DD

	function calc_person_age( $date_text )
	{
		if ($date_text > date( "Y-m-d" ))
            $age = 0;
		else
		{
		    $date_dt = date_create( $date_text );
	
	        if ($date_dt === false)
	            $age = 0;
	        else
	        {
	            $dob_dayofyear = $date_dt->format( "z" );
	            $dob_year = $date_dt->format( "Y" );
	    
	    		if ((date("z")+1) >= $dob_dayofyear)
	    			$age = date( "Y" ) - $dob_year;
	    		else
	    			$age = date( "Y" ) - $dob_year - 1;
	        }
		}
		        
		return ($age);
	}



    function device_type( $cxn )
    {
        if (! low_res_screen( $cxn ))
            return ("desktop");
        else
            return ("mobile");
    }



		/* display a date in the user's chosen format */

	function ad_format_date( $date, $date_format )
	{
        if (substr( $date, 0, 10 ) == "0000-00-00" || strlen( $date ) == 0)
	        return ("");
	    else
		if ($date_format == "dd/mm/yyyy")
			return substr( $date, 8, 2)."/".substr( $date, 5, 2)."/".substr( $date, 0, 4);
		else
		if ($date_format == "mm/dd/yyyy")
			return substr( $date, 5, 2)."/".substr( $date, 8, 2)."/".substr( $date, 0, 4);
		else
		if ($date_format == "yyyy/mm/dd")
			return substr( $date, 0, 4)."/".substr( $date, 5, 2)."/".substr( $date, 8, 2);
		else
        {		
            $this_date = date_create( $date );

            return ($this_date->format( $date_format ));
		}
	}


        // sync version below
        
    function write_screen_parameters_function()
    {
    	echo "<script async>";

            // the js_set_screen_parameters() function is called from <body onload()> when necessary
            
    	echo "function js_set_screen_parameters()";
    	echo "{";
        echo "  var r = new XMLHttpRequest();";

        echo "  t = new Date();";
        
        echo "  r.open( 'GET', '/scripts/set_screen_parameters.php?sw='+screen.width+'&sh='+screen.height+'&hr='+t.getHours(), true );";      // `false` makes the request synchronous

        echo "  r.send( null );";

//        echo "  location.reload();";

        echo "}";
        
        echo "</script>";
    }



    function write_screen_parameters_function_reload()
    {
    	echo "<script>";

            // the js_set_screen_parameters() function is called from <body onload()> when necessary
            
    	echo "function js_set_screen_parameters()";
    	echo "{";
        echo "  var request = new XMLHttpRequest();";

        echo "  request.open( 'GET', '/scripts/set_screen_parameters.php?sw='+screen.width+'&sh='+screen.height+'&hr='+today.getHours(), false );";      // `false` makes the request synchronous

        echo "  request.send( null );";

        echo "  location.reload();";

        echo "}";
        
        echo "</script>";
    }

        // reloads the current page if screen size hasn't been detected
        
    function write_screen_parameters_function_syncronous()
    {
    	echo "<script>";

            // the js_set_screen_parameters() function is called from <body onload()> when necessary
            
    	echo "function js_set_screen_parameters_sync()";
    	echo "{";
        echo "  var request = new XMLHttpRequest();";

        echo "  request.open( 'GET', '/scripts/set_screen_parameters.php?sw='+screen.width+'&sh='+screen.height, false );";      // `false` makes the request synchronous

        echo "  request.send( null );";

        echo "  location.reload();";

        echo "}";
        
        echo "</script>";
    }
    

        // encodes a URL. don't encode the https://
        
    function ad_urlencode( $text )
    {
        $text2 = urlencode( $text );
        
        $text3 = str_replace( "+", "%20", $text2 );
        
        return ($text3);
    }


          // display a number as a whole number if no decimals, or with two decimal places if it has a fractional component
        
    function number_format_needed( $amount )
    {
        if ($amount == "")
            return ("");
        else
        if (intval( $amount ) == $amount)
            return (number_format( $amount, 0 ));
        else
            return (number_format( $amount, 2 ));
    }

    
		// format a number with a fixed number of decimal digits
		
    function number_format_fxd_decimals( $amount, $decimals )
    {
    	$str = (string) round( $amount, $decimals );
    	
    	if ($decimals == 0)
			$str = intval( $amount );
		else
        if (strpos( $str, '.' ) === false)
		{
			$str .= '.';
			
			for ($i=0; $i < $decimals; $i++)
				$str .= '0';
		}
		else
		{
			if (strpos( $str, '.' ) == 0)
				$str = '0'.$str;
			
			$dec = strlen( $str ) - strpos( $str, '.' ) - 1;

			if ($dec < $decimals)
			{
				for ($i=0; $i < ($decimals-$dec); $i++)
					$str .= '0';
			}
			else
			if ($dec > $decimals)
			{
				$str = substr( $str, 0, strlen( $str ) - ($dec-$decimals) );
			}
		}	
		
		return ($str);			
    }


    function get_country_from_ip_country( $ip_country, $cxn )
    {
        return ($ip_country);
/*        
        if (val( , "current_online_ip_country" ) != "" && val( , "current_online_ip_country" ) == $ip_country)
            $country = val( , "current_online_country" );
        else
        {
            $country = "";
    
            if ($ip_country != "")
            {
        		$query = "SELECT display_name FROM ".common_data_database_name.".country WHERE display_name = '".$ip_country."'";
        
        		$result = run_query( $query, $cxn );
        
        		if (query_num_rows( $result ) > 0)
        		{
        			$data = get_row( $result );
        			
        			$country = $data['display_name'];
        		}
                else
                    log_error_and_continue( "IP country not found: >".$ip_country."<" );

                ['current_online_ip_country'] = $ip_country;
                ['current_online_country'] = $country;
            }
        }
        
        return ($country);
*/
    }


    function get_ip_region( $ip_country, $cxn )
    {
	    $key = "ip region".$ip_country;
	    
        get_cache_item( $key, $found, $value, $cxn );

        if ($found)
            $region = $value;
        else
        {
            $region = "";
    
            if ($ip_country != "")
            {
        		$query = "SELECT region FROM ".common_data_database_name.".country WHERE display_name = '".$ip_country."'";
        
        		$result = run_query( $query, $cxn );
        
        		if (query_num_rows( $result ) > 0)
        		{
        			$data = get_row( $result );
        			
        			$region = $data['region'];
        		}
                else
                    log_error_and_continue( "IP country not found: >".$ip_country."<" );

                save_cache_item( $key, $region, $cxn );
            }
        }

        return ($region);
    }


        // display a main menu on the home page
        
    function show_home_page_menu( $cxn )
    {
        $number_menu_columns = 2;
    
    
        $query = "SELECT * FROM ".common_data_database_name.".home_page WHERE sitecode = '".sitecode."'";
        
    	$result = run_query( $query, $cxn );
    
        if (query_num_rows( $result ) > 0)
        {
        	$data = get_row( $result );
    
    //        $number_menu_columns = $data['number_of_menu_columns'];
        }
    
    
        $max_row = 10;
    
        $query = "SELECT MAX(col) as max_col, MAX(row) as max_row FROM ".common_data_database_name.".menu_item WHERE sitecode = '".sitecode."' AND active = 'yes'";
        
    	$result = run_query( $query, $cxn );
    
        if (query_num_rows( $result ) > 0)
        {
        	$data = get_row( $result );
        
            $max_row = $data['max_row'];
            $number_menu_columns = $data['max_col'];
        }
        

        if (! low_res_screen( $cxn ))	
        {
            $total_columns = (($number_menu_columns + ($number_menu_columns-1)) + 2);
            $column_width = 100 / $total_columns;
            
            echo "<table style='border-collapse: collapse' cellspacing=0 cellpadding=0 width='100%'><tr>";
            
            for ($col=0; $col < $total_columns; $col++)
                echo "<td width='".$column_width."%'>&nbsp;</td>";
            
            echo "</tr>";
        }
        else
        {
            echo "<table style='border-collapse: collapse' cellspacing=0 cellpadding=0 width='100%'><tr>";

        	echo "<tr><td width='3%'>&nbsp;</td>";
            
            $column_width = 94 / $number_menu_columns - ($number_menu_columns-1) * 2;

            for ($col=0; $col < $number_menu_columns; $col++)
            {
                echo "<td width='".$column_width."%'>&nbsp;</td>";
                
                if ($col < $number_menu_columns-1)
                    echo "<td width='2%'>&nbsp;</td>";
            }
            
        	echo "<td width='3%'>&nbsp;</td></tr>";
        }
        

//        if (! low_res_screen( $cxn ))	
//        	echo "<table cellspacing=0 cellpadding=1 width='100%'><tr><td width='20%'>&nbsp;</td><td width='20%'>&nbsp;</td><td width='20%'>&nbsp;</td><td width='20%'>&nbsp;</td><td width='20%'>&nbsp;</td></tr>";
//        else
//    	    echo "<table cellspacing=0 cellpadding=1 width='100%'><tr><td style='font-size: 2pt;' width='1%'>&nbsp;</td><td width='48%'>&nbsp;</td><td width='4%'>&nbsp;</td><td width='38%'>&nbsp;</td><td width='0%'></td></tr>";
    
    
//    	echo "<tr><td style='font-size: 2pt;'>&nbsp;</td></tr><tr><td></td>";


        for ($row=1; $row <= $max_row; $row++)
        {
        	echo "<tr><td>&nbsp;</td>";
    
            for ($col=1; $col <= $number_menu_columns; $col++)
            {
                $query = "SELECT * FROM ".common_data_database_name.".menu_item WHERE sitecode = '".sitecode."' AND row = ".$row." AND col = ".$col." AND active = 'yes'";
                
            	$result = run_query( $query, $cxn );
    
    	        if (query_num_rows( $result ) > 0)
    	        {
                	$data = get_row( $result );

                    if ($data['is_heading'] == 'on')
                	    echo "<td style='border: 5px solid #FFFFFF; padding-left: 5px; padding-top: 1px; padding-bottom: 1px'; class='mainmenuheading'>".$data['heading']."</td>";
                	else
                	{
                		$url = url_encode( $data['program_name'], $data['parameter1'], $data['parameter2'], $data['parameter3'], $data['parameter4'], $data['parameter5'], $data['parameter6'], $data['parameter7'], $data['parameter8'], $data['parameter9'], $data['parameter10'] );

                		if (! low_res_screen( $cxn ))
                			echo "<td valign='top' style='border: 6px solid #FFFFFF; padding-left: 5px; padding-top: 2px; padding-bottom: 2px'; class='mainmenuitem' onclick='location.href=\"".$url."\"';'>";			
                		else
                			echo "<td valign='top' style='border: 5px solid #FFFFFF; padding-left: 5px; padding-top: 7px; padding-bottom: 7px'; class='mainmenuitem' onclick='location.href=\"".$url."\"'>";
                
                		echo $data['heading']."</td>";
                	}
    	        }
            	else
                    echo "<td></td>";

                echo "<td></td>";
            }
            
        	echo "<td></td></tr>";
    
//        	echo "<tr><td style='font-size: 2pt;'>&nbsp;</td></tr><tr><td></td>";
        }
    
    //	echo "</tr><tr><td>&nbsp;</td></tr><td></td>";
    
    	echo "</tr></table>";
    }



        // $sender_ max 11 characters
        
        // If 'sender_' is a phone number it will appear in the receiver message as the sender phone number,
        // if it is text it will appear in the receiver message as the name of the sender

    function send_sms( $sender_, $send_to_mobile_number, $text )
    {
        $username = 'markmcilroy';
        $password = 'Tuesday12$';

        $ref = '';
            
        $content =  'username='.rawurlencode( $username ).
                    '&password='.rawurlencode( $password ).
                    '&to='.rawurlencode( $send_to_mobile_number ).
                    '&from='.rawurlencode( $sender_ ).
                    '&message='.rawurlencode( $text ).
                    '&maxsplit=5'.
                    '&ref='.rawurlencode( $ref );
        
        $smsbroadcast_response = send_SMS_go( $content );
        
        return( $smsbroadcast_response );
    }


  	function send_SMS_go( $content )
    {
        $ch = curl_init( 'https://api.smsbroadcast.com.au/api-adv.php' );
        
        curl_setopt( $ch, CURLOPT_POST, true );
        curl_setopt( $ch, CURLOPT_POSTFIELDS, $content );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
		
        $output = curl_exec( $ch );
		
        curl_close( $ch );
		
        return $output;    
    }

	function show_ads_blank_large_banner()
	{
        echo "<table width='100%'><tr><td align='center'>";
        
        echo watermark( "&nbsp;<br>" );
       
        echo "<div style='display:inline-block;width:728px;height:90px'></div>";	    
    	
    	echo "</td></tr></table>";		
	}

	function show_ads_large_banner( $cxn, $amp )
	{
	    if (show_ads( $cxn ))
	    {
            if ($amp)
            {
        		echo "<table width='100%'><tr><td align='center'>\n";
        
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
    
                echo '<amp-ad ';
                echo '     layout="fixed"';
                echo '     width=728';
                echo '     height=90';
                echo '     type="adsense"';
                echo '     data-ad-client="ca-pub-7728790744816510"';
                echo '     data-ad-slot="8395718399"> ';
                echo '</amp-ad>';
    
        		echo "</td></tr></table>\n";		
            }
            else
            {
//        		echo watermark( "Advertisement" )."<br>";
    
        		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
        
        		// <!-- New Ads 2 Wide Banner -->
        		
        		echo "<ins class='adsbygoogle'\n";
             	echo "style='display:inline-block;width:728px;height:90px'\n";
        		echo "data-ad-client='ca-pub-7728790744816510'\n";
        
    //                if ($color_scheme != 2)
            		echo "data-ad-slot='8082913192'></ins>\n";
    //            	else
    //            	    echo "data-ad-slot='9750759608'></ins>\n";
        
        		echo "<script>\n";
        		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
        		echo "</script>\n";
            }
	    }
    }


	function show_ads_billboard( $cxn )
	{
	    if (show_ads( $cxn ))
	    {
    		$color_scheme = acv_session_get( 'color_scheme', $cxn );
    
//    		echo watermark( "Advertisement" )."<br>";
    
    		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
    
    		// <!-- New Ads 2 Billboard -->
    		
    		echo "<ins class='adsbygoogle'\n";
         	echo "style='display:inline-block;width:970px;height:250px'\n";
    		echo "data-ad-client='ca-pub-7728790744816510'\n";
    
            if ($color_scheme != 2)
        		echo "data-ad-slot='2859390498'></ins>\n";
        	else
        	    echo "data-ad-slot='1199534907'></ins>\n";
    
    		echo "<script>\n";
    		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
    		echo "</script>\n";
	    }
    }
	

	function show_responsive_ad_desktop( $cxn, $amp=false )
    {
	    if (show_ads( $cxn ))
        {        
    	    if ($amp)
    	    {
        		echo "<table width='100%'>";
    		
    	    	echo "<tr><td width='100%' align='center'>";
    
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        
        		echo "</td></tr>";
        
        		echo "<tr><td width='100%' align='center'>";
    
                echo '<amp-ad width="100vw" height=320';
                echo '     type="adsense"';
                echo '     data-ad-client="ca-pub-7728790744816510"';
                echo '     data-ad-slot="8046170704"';
                echo '     data-auto-format="rspv"';
                echo '     data-full-width>';
                echo '  <div overflow></div>';
                echo '</amp-ad>';
    
        		echo "</td></tr></table>";
            }
    	    else
            {
        		echo "<table width='100%'>";
    		
    	    	echo "<tr><td width='100%' align='center'>";
    
//                echo watermark( "&nbsp;&nbsp;Advertisement" );
        
        		echo "</td></tr>";
    
        		echo "<tr><td width='100%' align='center'>";
    
            	echo "<script async src='https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script> ";
            	
            	echo "<ins class='adsbygoogle' ";
            	echo "style='display:block;max-width:728px;width:100%;' ";
            	echo "data-ad-client='ca-pub-7728790744816510' ";
            	echo "data-ad-slot='8046170704' ";
            	echo "data-ad-format='auto' ";
            	echo "data-full-width-responsive='true'> ";
            	echo "</ins> ";
            	echo "<script> ";
            	echo "(adsbygoogle = window.adsbygoogle || []).push({}); ";
            	echo "</script> ";
        
        		echo "</td></tr></table>";		
            }
        }
	}


	function show_responsive_ad_mobile( $cxn, $amp=false )
    {
	    if (show_ads( $cxn ))
        {
    	    if ($amp)
    	    {
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
    
                echo '<amp-ad width="100vw" height=320';
                echo '     type="adsense"';
                echo '     data-ad-client="ca-pub-7728790744816510"';
                echo '     data-ad-slot="8980326699"';
                echo '     data-auto-format="rspv"';
                echo '     data-full-width>';
                echo '  <div overflow></div>';
                echo '</amp-ad>';
            }
    	    else
            {
        		echo "<table width='100%'>";
    		
    	    	echo "<tr><td width='100%' align='center'>";
    
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        
        		echo "</td></tr>";
    
        		echo "<tr><td width='100%' align='center'>";
    
            	    // <!-- Responsive Ad Mobile -->
    
            	echo "<script async src='https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script> ";
    
            	echo "<ins class='adsbygoogle' ";
            	echo "style='display:block' ";
            	echo "data-ad-client='ca-pub-7728790744816510' ";
            	echo "data-ad-slot='8980326699' ";
            	echo "data-ad-format='auto' ";
            	echo "data-full-width-responsive='true'> ";
            	echo "</ins> ";
            	echo "<script> ";
            	echo "(adsbygoogle = window.adsbygoogle || []).push({}); ";
            	echo "</script> ";
        
        		echo "</td></tr></table>";		
            }
        }
	}


		// suitable for desktop, and mobile when most of the page is available
		
	function show_ads_large_square( $cxn, $amp=false )
	{
	    if (show_ads( $cxn ))
        {
    	    if ($amp)
    	    {
//                echo watermark( "&nbsp;&nbsp;Advertisement" );
        
        		echo "<amp-ad \n";
        		
        		echo "layout='responsive'\n";
        		echo "width=336\n";
        		echo "height=280\n";
        		echo "type='adsense'\n";
        		echo "     data-ad-client='ca-pub-7728790744816510'\n";
        
    //    		if ($color_scheme != 2)
        		    echo "     data-ad-slot='5950328702'\n";
    //    		else
    //    		    echo "     data-ad-slot='8074963272'\n";
        
        		echo "></amp-ad>\n";
    	    }
    	    else
            {
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        	    
        		echo " <script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
        		
        		// <!-- New Ads 2 Large Square -->
        		
        		echo " <ins class='adsbygoogle'\n";
        		echo "     style='display:inline-block;width:336px;height:280px'\n";
        		echo "     data-ad-client='ca-pub-7728790744816510'\n";
        		
    //    		if ($color_scheme != 2)
        		    echo "     data-ad-slot='5950328702'></ins>\n";
    //    		else
    //    		    echo "     data-ad-slot='8074963272'></ins>\n";
        		    
        		echo " <script>\n";
        		echo " (adsbygoogle = window.adsbygoogle || []).push({});\n";
        		echo " </script>\n";
            }
        }
	}


		// this ad unit is for mobile phones
		
	function show_ads_narrow_banner( $cxn, $amp=false )
	{	
	    if (show_ads( $cxn ))
        {
    	    if ($amp)
    	    {
        		echo "<table width='100%'><tr><td align='center'>\n";
        
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        		
                echo '<amp-ad';
                echo '     layout="fixed"';
                echo '     width=320';
                echo '     height=100';
                echo '     type="adsense"';
                echo '     data-ad-client="ca-pub-7728790744816510"';
                echo '     data-ad-slot="9708017212">';
                echo '</amp-ad>';
    
        		echo "</td></tr></table>\n";		
    	    }
    	    else
            {
        		echo "<table width='100%'><tr><td align='center'>";

//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );

        		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'>";
        		echo "</script>";

        		// <!-- New Ads 2 Narrow Banner -->

        		echo " <ins class='adsbygoogle'";
        		echo " style='display:inline-block;width:320px;height:100px'";
        		echo " data-ad-client='ca-pub-7728790744816510'";
        		echo " data-ad-slot='9708017212'></ins>";
    
        		echo "<script>";
        		echo " (adsbygoogle = window.adsbygoogle || []).push({});\n";
        		echo "</script>\n";
        		
        		echo "</td></tr></table>\n";		
            }
        }
	}
	

	function show_ads_small_square( $cxn, $amp=false )
	{
	    if (show_ads( $cxn ))
        {	    
    	    if ($amp)
    	    {
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        
                echo '<amp-ad';
                echo '     layout="fixed"';
                echo '     width=200';
                echo '     height=200';
                echo '     type="adsense"';
                echo '     data-ad-client="ca-pub-7728790744816510"';
                echo '     data-ad-slot="7947860367">';
                echo '</amp-ad>';
    	    }
    	    else
            {
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        
        		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
        		
                // <!-- New Ads 2 Small Square -->
        		
        		echo "<ins class='adsbygoogle'\n";
        		echo "     style='display:inline-block;width:200px;height:200px'\n";
        		echo "     data-ad-client='ca-pub-7728790744816510'\n";
    		    echo "     data-ad-slot='8995095603'></ins>\n";
        		    
        		echo "<script>\n";
        		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
        		echo "</script>\n";
            }
        }
	}


		// this ad unit is for desktop
		
	function show_ads_medium_skyscraper( $amp=false, $cxn )
	{
	    if (show_ads( $cxn ))
        {	    
    		$color_scheme = acv_session_get( 'color_scheme', $cxn );
    
            if ($amp)
            {
//                echo watermark( "Advertisement<br>" );
    
                echo '<amp-ad';
                echo '     layout="fixed"';
                echo '     width=160';
                echo '     height=600';
                echo '     type="adsense"';
                echo '     data-ad-client="ca-pub-7728790744816510"';
                echo '     data-ad-slot="5484282894">';
                echo '</amp-ad>';
            }
            else
            {
//                echo watermark( "&nbsp;&nbsp;Advertisement<br>" );
        
        		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
        		
        		// <!-- New Ads 2 Medium Skyscraper (Academic Dating) -->
        		
        		echo "<ins class='adsbygoogle'\n";
        		echo "     style='display:inline-block;width:160px;height:600px'\n";
        		echo "     data-ad-client='ca-pub-7728790744816510'\n";
        		
        	    if ($color_scheme != 2)
        		    echo "     data-ad-slot='1036203904'></ins>\n";
        		else
        		    echo "     data-ad-slot='8708430238'></ins>\n";
        		    
        		echo "<script>\n";
        		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
        		echo "</script>\n";
            }
        }
	}


		// this ad unit is for desktop
		
	function show_ads_wide_skyscraper( $cxn )
	{
	    if (show_ads( $cxn ))
        {
    		$color_scheme = acv_session_get( 'color_scheme', $cxn );
    
//            echo watermark( "Advertisement<br>" );
            
    		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>";
    
    		    // New Ads 2 Wide Skyscraper
    		    
    		echo "<ins class='adsbygoogle'";
    		echo "     style='display:inline-block;width:300px;height:600px'";
    		echo "     data-ad-client='ca-pub-7728790744816510'";
    		
    	    if ($color_scheme != 2)
        		echo "     data-ad-slot='6406382751'></ins>";
    	    else	
    		    echo "     data-ad-slot='8265780366'></ins>";
    		    
    		echo "<script>";
    		echo "(adsbygoogle = window.adsbygoogle || []).push({});";
    		echo "</script>";
        }
	}
	

//    function is_subdomain()
//    {
//	    return (false);   
//    }


    function get_heading_the( $country, $cxn )
    {
	    $key = "heading_the:".$country;
	    
        get_cache_item( $key, $found, $value, $cxn );
        
        if ($found)
            $the = $value;
        else
        {
            $the = "";

        	$query = "SELECT prefix FROM ".common_data_database_name.".country WHERE display_name = '".$country."'";
        
        	$result = run_query( $query, $cxn );
        
        	if (query_num_rows($result) > 0)
        	{
        		$data = get_row( $result );	
        
                if ($data['prefix'] != "")
                    $the = "the ";
        	}        

            save_cache_item( $key, $the, $cxn );
        }
        
        return( $the );
    }

?>