<?php

	include "library.php";

	$cxn = start_code();
	
    $cxn_common = db_common_login();
	

	$today_date = date( "Y-m-d" );
	
    $today_date_dd = date( "d/m/Y" );
    
	
	page_header( "Outstanding Invoices", $cxn, $cxn_common );


    $query = "SELECT *, DATEDIFF( CURDATE(), due_date ) as days_overdue FROM invoice WHERE status <> 'paid_in_full' and status <> 'cancelled' and due_date < '".$today_date."' ORDER BY practice, effective_date";
    

	$result = run_query( $query, $cxn );
	
    if (query_num_rows( $result ) == 0)
    {
    	echo black( "There are no outstanding invoices.<br><br>" );
    	
    	echo show_home_link();
    	
    	exit();
    }
    else
    {
    	echo "<style type='text/css'>\n";
    	echo "td ";
    	echo " { ";
    	echo " padding:0 8px 0 8px; ";
    	echo " } ";
    	echo "</style>";
    	
    	
    	echo black( "Today's Date: ".$today_date_dd."<br><br><br>" );
    	
    	echo "<table>";

    	echo "<tr>";

    	echo "<td valign='top' align='left'>".black( "<b>Invoice ID</b>" )."</td>";
    	echo "<td valign='top' align='left'>".black( "<b>Practice</b>" )."</td>";
    	echo "<td valign='top' align='center'>".black( "<b>Effective Date</b>" )."</td>";
    	echo "<td valign='top' align='center'>".black( "<b>Due Date</b>" )."</td>";
    	echo "<td valign='top' align='center'>".black( "<b>Days Overdue</b>" )."</td>";
    	echo "<td valign='top' align='center'>".black( "<b>Total Due</b>" )."</td>";
    	echo "<td valign='top' align='center'>".black( "<b>Received</b>" )."</td>";

    	echo "</tr>";
    	
    	for ($i=0; $i < query_num_rows( $result ); $i++)
    	{
    		$data = get_row( $result );

    		echo "<tr>";

    		echo "<td>".black( $data['id'] )."</td>";
    		echo "<td>".black( $data['practice'] )."</td>";
    		echo "<td>".black( ad_format_date( substr($data['effective_date'], 0, 10), "dd/mm/yyyy" ) )."</td>";
    		echo "<td>".black( ad_format_date( substr($data['due_date'], 0, 10), "dd/mm/yyyy" ) )."</td>";
    		
    		if ($data['days_overdue'] >= 14)
        		echo "<td>".black( $data['days_overdue'] )."</td>";
        	else
        	    echo "<td>&nbsp;</td>";
        	    
    		echo "<td>".black( "$".number_format( $data['total_due'], 2 ) )."</td>";
    		echo "<td>".black( "$".number_format( $data['amount_received'], 2 ) )."</td>";

            echo "<td>".show_link( "Edit", "edit_all_data.php", "formname", "mpl_invoice", "tabletitle", "Invoice", "newrecord", "false", "id", $data['id'] )."</td>";

    		echo "</tr>";
    	}

    	echo "<tr><td>&nbsp;</td></tr>";

    	echo "</table>";
    }			

    echo "<br><br><br>";

    echo show_home_link();
?>

