<?php

    define( "sitename", "Melbourne Paraplanning" );
    define( "sitecode", "MELBOURNE_PARAPLANNING" );
    
    define( "database_name", "academi1_melbournepara" );
	define( "common_data_database_name", "academi1_commondata" );
	define( "pathroot", "/home/academi1/public_html/melbourneparaplanning" );
	define( "forms_library", "/home/academi1/public_html/common_code/forms_library.php" );
	define( "error_log_filename", "/home/academi1/public_html/melbourneparaplanning/error_log.txt" );
    define( "site_url", "https://melbourneparaplanning.com.au" );
    

	include "/home/academi1/public_html/common_code/common_library.php";


	function start_code( $first=false, $db="" )
	{
        if (session_status() != PHP_SESSION_ACTIVE)
    		session_start();


			/* set config options */

		ini_set( "error_log", error_log_filename );

		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

		ini_set( "date.timezone", "Australia/Melbourne" );
		
		$cxn = db_login( database_name );

        return ($cxn);		
	}
		
		
		

		/* generate the heading line for a page */

		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $page_title, $cxn, $home_page=false )
	{
		echo "<meta charset='utf-8'>";
		echo "<meta name='viewport' content='width=device-width, minimum-scale=1, initial-scale=1.0'>";

//        echo "<span style='font-size: 11pt; font-family: verdana;'>This business has closed.<br><br><br>";
	    
//	    exit();
	    
	    
	    echo "<html>";

		echo "<head>";

		echo "<meta charset='utf-8'>";
		echo "<meta name='viewport' content='width=device-width, minimum-scale=1, initial-scale=1.0'>";

        echo "<meta name='keywords' content='Paraplanning,Outsourced,Service,Melbourne,Victoria,Victorian,Australian,Australia'>";

        if ($home_page)
            echo "<meta name='description' content='Melbourne Paraplanning produces quality Statements of Advice for Australian Financial Planning practices. We operate exclusively by phone and email and are available to provide services to Financial Planning practices across Australia.'>";
        else
            echo "<meta name='description' content='Melbourne Paraplanning produces quality Statements of Advice for Australian Financial Planning practices (".$page_title."). We operate exclusively by phone and email and are available to provide services to Financial Planning practices across Australia.'>";


//		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";


//	    if (! use_amp)
//	    {
//            if (val( $_SESSION, "screen_width" ) == "")
//                write_screen_parameters_function_syncronous();
//	    }


            // Google Analytics 
            
        echo "<!-- Global site tag (gtag.js) - Google Analytics -->";
        echo "<script async src='https://www.googletagmanager.com/gtag/js?id=UA-97849346-4'></script>";
        echo "<script>";
        echo "  window.dataLayer = window.dataLayer || [];";
        echo "  function gtag(){dataLayer.push(arguments);}";
        echo "  gtag('js', new Date());";
        echo "  gtag('config', 'UA-97849346-4');";
        echo "</script>";


			// use the old version of the Google Analytics libary until Google Translate supports the new library

//		include "google_analytics_legacy_version.php";

//		include "google_analytics_tracking.php";


		echo '<link rel="icon" type="image/png" sizes="192x192"  href="/images/android-icon-192x192.png">';
		echo '<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">';
		echo '<link rel="icon" type="image/png" sizes="96x96" href="/favicon-96x96.png">';
		echo '<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">';


        $source = val( $_SESSION, "source" );

	    log_hits( $source, $cxn );

		log_page_view( $cxn );


			// define styles 

    	echo "<style>";

		echo "html, body {";
		
		echo "margin:0;";
		echo "padding:0;";
		
//		if (! low_res_screen())
//    		echo "background-image: url( '/images/melbourne-214696_640_2.jpg' ); background-size: cover; background-repeat: no-repeat;";
    		
		echo "}";

		define_styles();

		write_common_styles();
		
		echo "</style>";


		echo "<title>".$page_title."</title></head>";
		
		
//		echo "<body background-image: url( '/images/pexels-photo-380768_280_wide.jpg' );>";

 		echo "<body>";
 		
 		
    	if (! low_res_screen())	
    	{
            $top_section_background = "#ffffff";

            $contact_details_style = "line-height: 16px; font-family: Calibri; font-size: 11.5pt; color: #000000; background-color: ".$top_section_background;
            
  		    echo "<table style='border-collapse: collapse;'><tr><td width='1%' style='background-color: #006000; line-height: 35px; font-family: verdana; font-size: 16pt; color: #ffffff;'>&nbsp;&nbsp;&nbsp;Melbourne&nbsp;Paraplanning&nbsp;&nbsp;&nbsp;</td></tr></table>";
        }
    	else
    	{
    		echo "<table cellspacing='0' width='100%'><tr><td class='home_page_heading' align='left'>&nbsp;&nbsp;Melbourne Paraplanning</td></tr></table>";
    
    		echo "<br>";
    	}
	}


		/* define the CSS styles */

	function define_styles()
	{

			// the following style creates the scrollbar format.
			
		echo    ".main_text_window {";				
		echo    "    scrollbar-face-color: #000000;";
		echo    "    scrollbar-shadow-color: #FFFFFF;";
		echo    "    scrollbar-highlight-color: #FFFFFF;";
		echo    "    scrollbar-3dlight-color: #FFFFFF;";
		echo    "    scrollbar-darkshadow-color: #FFFFFF;";
		echo    "    scrollbar-track-color: #FFFFFF;";
		echo    "    scrollbar-arrow-color: #FFFFFF;";
    	echo    " opacity: 1;";
		echo    " background: #eeeeee;";
		echo    " padding: 30px;";
		echo    " border-radius: 10px;";
		echo    "}";
		echo    "";
		
		echo    ".main_text_window::-webkit-scrollbar {";
		echo    "    width: 12px;";
		echo    "}";
		echo    " ";
		
		echo    ".main_text_window::-webkit-scrollbar-track {";
		echo    "    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.3); ";
		echo    "}";
		echo    " ";
		
		echo    ".main_text_window::-webkit-scrollbar-thumb {";		// Chrome
		echo    "    background: rgba(0,0,20,0.1); ";
		echo    "    -webkit-box-shadow: inset 0 0 6px rgba(0,0,0,0.5); ";
		echo    "}";



		$top_section_color = "#0000a0";

        
		$top_section_color_mobile = "#000000";


		if (! low_res_screen())
		{
            echo ".home_page_heading {line-height: 52px; font-family: Calibri; font-size: 18pt; color: #004499; border-top: 2px solid #ffffff;}";

       		echo ".pageheading      { color: #000000; font-family: verdana; font-weight: bold; font-style: italic; font-size: 11pt}";

   			echo ".generaltext	{ color: #000000; font-family: verdana; font-size: 10pt}";

   			echo ".compacttext	{ color: #000000; font-family: verdana; font-size: 9pt}";

   			echo ".fprompt      { color: #000000; font-family: verdana; font-size: 10.5pt}";

			echo ".gred	{ color: #af0000; font-family: verdana; font-size: 11pt}";

			echo ".ggreen { color: #00af00; font-family: verdana; font-size: 11pt}";

			echo ".gwhite { color: #ffffff; font-family: verdana; font-size: 11pt}";

			echo ".glink { color: #0000bb; font-family: verdana; font-size: 11pt}";
			echo ".glink:hover { color: #007500; font-family: verdana; font-size: 11pt}";

			echo ".compactlink { color: #0000bb; font-family: verdana; font-size: 10pt}";
			echo ".compactlink:hover { color: #007500; font-family: verdana; font-size: 10pt}";

			echo ".gemail { color: #000000; font-family: courier; font-size: 12pt; text-decoration: none}";

            echo ".attribution_link {font-family: verdana; font-size: 8pt; color: #000000;}";
            
            echo ".pricing_table_text { color: #000000; font-family: verdana; font-size: 10pt; }";

            echo ".phone_number {color: #0000bb; text-decoration: none; }";

            echo ".home_page_link {color: #0000bb; font-family: verdana; font-size: 9pt}";
            echo ".home_page_link:hover {color: #8B4513; font-family: verdana; font-size: 9pt}";
            
            
// 000098
		    echo ".menulink      	{padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
		    echo ".menulink:link   	{padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
		    echo ".menulink:hover	{color: #ffffff; background: #006000; cursor: pointer; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    
		}
		else
		{
		    
            echo ".home_page_heading {padding-top: 3; padding-bottom: 3; font-family: Calibri; font-size: 14pt; line-height: 18pt; color: #ffffff; background-color: #006000;}";
            
		    echo ".pageheading  { color: #000000; font-family: arial; font-weight: bold; font-style: italic; font-size: 11pt}";

			echo ".generaltext	{ color: #000000; font-family: verdana; font-size: 11pt}";

   			echo ".compacttext	{ color: #000000; font-family: verdana; font-size: 10pt}";

   			echo ".fprompt      { color: #0000bb; font-family: verdana; font-size: 11pt}";

			echo ".gred	{ color: #af0000; font-family: verdana; font-size: 11pt}";

			echo ".ggreen { color: #00af00; font-family: verdana; font-size: 11pt}";

			echo ".gwhite { color: #000000; font-family: verdana; font-size: 11pt}";

			echo ".gemail { color: #000000; font-family: courier; font-size: 11pt; text-decoration: none}";

			echo ".glink { color: #0000bb; font-family: verdana; font-size: 11pt}";

			echo ".compactlink { color: #0000bb; font-family: verdana; font-size: 10pt}";
			echo ".compactlink { color: #0000bb; font-family: verdana; font-size: 10pt}";

			echo ".menulink         { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";
			echo ".menulink:visited { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";
			echo ".menulink:link  { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";
			echo ".menulink:hover { text-decoration: none; color: ".$top_section_color_mobile."; font-family: verdana; font-size: 9.5pt; line-height: 18px;}";

            echo ".attribution_link {font-family: verdana; font-size: 8pt; color: #000000;}";
            
            echo ".pricing_table_text { color: #000000; font-family: verdana; font-size: 10pt; }";

            echo ".home_page_link {color: #0000bb; font-family: verdana; font-size: 9pt}";
            echo ".home_page_link:hover {color: #007500; font-family: verdana; font-size: 9pt}";
            
            echo ".phone_number {color: #0000bb; text-decoration: none; }";
		}


        $button_color = "#006000;";
        $button_hover = "#888888";

        $mobile_button_color = "#006000";
        $mobile_button_hover = "#888888";
        
        $fs2 = 11;
        $fsm = 11;
        
		echo ".greenbuttondesktop {cursor: pointer; border: 1px solid ".$button_color."; border-radius: 5px; background: ".$button_color."; color: #ffffff; font-family: arial; font-size: ".$fs2."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttondesktop:hover {cursor: pointer; border: 1px solid ".$button_hover."; border-radius: 5px; background: ".$button_hover."; color: #ffffff; font-family: arial; font-size: ".$fs2."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

    	echo ".greenbuttonmobile {cursor: pointer; line-height: 12pt; border: solid 1px ".$mobile_button_color."; border-radius: 4px; background: ".$mobile_button_color."; color: #ffffff; font-family: arial; font-size: ".$fsm."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttonmobile:hover {cursor: pointer; line-height: 12pt; border:solid 1px ".$$mobile_button_hover."; border-radius: 4px; background: ".$mobile_button_hover."; color: #ffffff; font-family: arial; font-size: ".$fsm."pt; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

        echo ".border_collapse { border-collapse: collapse; }";

//		echo "</style>";
    }



    function write_page_text( $this_page, $state_entry=0 )
    {
    	if (! low_res_screen())	
    	{
//            $top_section_background = "#ffffff";

//            $contact_details_style = "line-height: 16px; font-family: Calibri; font-size: 11.5pt; color: #000000; background-color: ".$top_section_background;
            
//  		    echo "<table style='border-collapse: collapse;'><tr><td width='1%' style='background-color: darkblue; line-height: 35px; font-family: verdana; font-size: 16pt; color: #ffffff;'>&nbsp;&nbsp;&nbsp;Melbourne&nbsp;Paraplanning&nbsp;&nbsp;&nbsp;</td></tr></table>";

    	    write_primary_menu( $this_page );

            echo "<table width='100%' style='border-collapse: collapse;'><tr><td width='2%'>&nbsp;</td>";
        }
    	else
    	{
//    		echo "<table cellspacing='0' width='100%'><tr><td class='home_page_heading' align='left'>&nbsp;&nbsp;Melbourne Paraplanning</td></tr></table>";
    
//    		echo "<br>";
    		
    		echo "<table width='100%'><tr><td width='30%' align='center'>";
    	}
    

        if (low_res_screen())
        	write_primary_menu( $this_page );
    
    
    	if (! low_res_screen())	
    	{
    	    echo "<table width='100%'><tr><td width='15%'>&nbsp;</td><td width='60%'>";

            echo "<br>";

//       	    echo "<img alt='Page image 1' src='/images/melbourne-214696_640_2.jpg' style='opacity: 0.9;' width='400'>";		
    
//       	    echo "<img alt='Page image 1' src='/images/melbourne-1587291_1280.jpg' style='opacity: 0.9;' width='400'>";		

    	}
    	else
    		echo "<br><table width='100%'><td width='3%'>&nbsp;</td><td width='94%'>";


//        if (! low_res_screen())
//            echo "<span style='font-family: verdana; font-size: 11pt; color: #ff0000;'>This business is not currently trading.</span><br><br><br>";
        
    		// this is the main text that appears in the main window as selected by the menu
    
//        if ($state_entry)		
//        	include $this_page; 
//        else
        {
//        	include "main_text.php";

            if ($this_page == "splash_city_text.php")
                write_section( "", "splash_city_text.php" );
            else
            if ($this_page == "main_text.php")
            {
                write_section( "", "main_text.php" );

        		echo "</div>";

        		echo "<br>";
        		echo "<br>";
        		echo "<br>";

                write_section( "", "news_text.php" );

        		echo "</div>";

        		echo "<br>";
        		echo "<br>";
        		echo "<br>";

                write_section( "", "resources_text.php" );
            }
            else
            if ($this_page == "service_offering_text.php")
                write_section( "ServiceOffering", "service_offering_text.php" );
            else
            if ($this_page == "pricing_text.php")
                write_section( "Pricing", "pricing_text.php" );
            else
            if ($this_page == "faq_text.php")
                write_section( "FAQ", "faq_text.php" );
            else
            if ($this_page == "about_us_text.php")
                write_section( "AboutUs", "about_us_text.php" );
            else
            if ($this_page == "contact_us_text.php")
                write_section( "ContactUs", "contact_us_text.php" );
            else
            if ($this_page == "legals_text.php")
                write_section( "Legals", "legal_text.php" );
            else
            if ($this_page == "resources_text.php")
                write_section( "Resources", "resources_text.php" );
            else
                write_section( "", $this_page );
        }
        
    	if (! low_res_screen())
    		echo "</div></td><td width='25%'>&nbsp;</td></tr></table>";		
    	else
    		echo "</td><td width='5%'>&nbsp;</td></tr></table>";

		echo "<br>";
		echo "<br>";
		echo "<br>";
		echo "<br>";
		echo "<br>";
		echo "<br>";
		echo "<br>";
		echo "<br>";
    	
    	echo "</body>";
    	
    	echo "</html>";
    }


    function write_section( $tag, $filename )
    {
        if ($filename == "contact_us_text.php" && (low_res_screen()) )
		    echo "<div id='div1' style='padding: 10px;' class='main_text_window' id='div1'>";
		else
            echo "<div id='div1' class='main_text_window' id='div1'>";

    	include $filename;

//        echo "<a style='font-style: italic;' class='compactlink' href='/'>Home</a></div>";    	
    }
		
		
		// write the primary menu
		
	function write_primary_menu( $this_page )
	{
	    if (! low_res_screen())
            echo "<table width='100%' style='border-collapse: collapse;'><tr><td width='2%'>&nbsp;</td>";
	    else
	        echo "<table width='100%'>";

		menu_option( "Home", "/", $this_page, "/", "main_text.php" );

		menu_option( "Service&nbsp;Offering", "/#ServiceOffering", $this_page, "service_offering.php", "service_offering_text.php" );

		menu_option( "Prices", "/#Pricing", $this_page, "pricing.php", "pricing_text.php" );

//		menu_option( "Legal", "/legal.php", $this_page, "legal.php" );

//		menu_option( "Careers", "/careers.php", $this_page, "careers_text.php" );

		menu_option( "FAQ", "/#FAQ", $this_page, "faq.php", "faq_text.php" );

		menu_option( "About Us", "/#AboutUs", $this_page, "about_us.php", "about_us_text.php" );

        menu_option( "Contact Us", "/#ContactUs", $this_page, "contact_us.php", "contact_us_text.php" );

	    if (! low_res_screen())
	        echo "<td width='25%'>&nbsp;</td>";
	    else
	        echo "<tr><td style='font-size: 3pt;'>&nbsp;</td></tr>";

        menu_option( "Client login", "https://clients.melbourneparaplanning.com.au", "", "https://clients.melbourneparaplanning.com.au", "" );


	    if (! low_res_screen())
	        echo "<td width='2%'>&nbsp;</td></tr></table>";
	    else
	        echo "</table>";
    }


		// write one menu option
		
	function menu_option( $prompt, $filename, $this_page, $menu_option_page, $text_page )
	{
	    $small_link = false;
	    
        $background_color = "#eeeeee";

		if (! low_res_screen())
		{
		    if ($small_link)
            	echo "<tr><td height='38pt' width='120px' align='left' class='menulink' onclick='location=\"/".$filename."\"' style='margin-left: 10px; font-size: 12pt'>&nbsp;&nbsp;&nbsp;".$prompt."&nbsp;&nbsp;&nbsp;</a></td></tr>";
            else
               	echo "<td height='34pt' width='10%' align='center' class='menulink'  onclick='location=\"".$menu_option_page."\"'>".$prompt."</td>";
		}
		else
		{
//	        if ($this_page == $menu_option_page)
//		        $background_color = "#001160";
//		    else
//		        $background_color = "#1033c0";

//echo $this_page."<br>";
//echo $text_page."<br>";

	        if ($this_page == $text_page && $this_page != "")
		        $opacity = "opacity: 0.65;";
		    else
		        $opacity = "";

			echo "<tr><td width='6%'>&nbsp;</td><td width='50%' style='line-height: 34px; background-color: #006000; ".$opacity." border-radius: 10px; color: #ffffff; font-size: 12pt; font-family: verdana; text-decoration: none;' onclick=\"window.location.href='".$menu_option_page."'\">&nbsp;&nbsp;&nbsp;".$prompt."</td>";
			
	        echo "<td width='44%'>&nbsp;</td></tr><tr><td style='font-size: 3pt;'>&nbsp;</td></tr>";
	    }
	    
//			echo "<a href='".$filename."' class='menulink'>".$prompt."</a><br><br>";		
	}


    function log_page_view( $cxn )
    {
        $ip_country = get_ip_country( $cxn );
        
        $today_date = date( "Y-m-d" );
        
	    $device = device_type();
        
        
        $query = "SELECT id FROM page_views WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."' AND device = '".$device."'";
        
        
            // on rare occasions there may be two records created for one date if two users are checking and adding at the same time.
            
        if (query_has_rows( $query, $cxn ))
        {
            $query = "UPDATE page_views SET count = count + 1 WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."' AND device = '".$device."'";
            
            $result = run_query( $query, $cxn );
        }
        else
        {
            $query = "INSERT INTO page_views (page_view_date, ip_country, count, device) VALUES ('".$today_date."', '".$ip_country."', 1, '".$device."' )";
            
            $result = run_query( $query, $cxn );            
        }
    }
	
	function db_login( $database )
	{
		$host = "localhost";
		$user = "academi1_mlm1";
		$password = "plastic1";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "<br><span style='font-size: 14pt; font-family: verdana'>".sitename." is currently unavailable.<br><br>Please try again in half an hour.<br><br></span>";
			
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}
	
	
?>