<?php



    			/* startup code to be called at the top of each file */

	function start_code( $first=false, $database="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

		$domain_root = substr( $domain, 4, strlen( $domain ) - 4 );
		$domain_root = substr( $domain_root, 0, strlen( $domain_root ) - 4 );

		session_start();

		$_SESSION['pathroot'] = "/home/academi1/m-m-ventures.com/".$domain_root;


			/* set up variables */

		if ($database != "")
			$_SESSION['database'] = $database;

		if ($_SESSION['database'] != "")
			$database = $_SESSION['database'];

		if ($database == "")
			$database = "academi1_".$domain_root;

		$_SESSION['database'] = $database;

//		echo "database: ".$database."<br><br>";

		$user = val( $_GET, "user" );


			/* remember user across pages */

		if ($user == "mark")
		{
			$_SESSION['user'] = $user;
			$_SESSION['debug'] = true;
			$_SESSION['debug_email'] = "markmcilroy@ozemail.com.au";
		}

			/* set config options */

		ini_set( "error_log", $_SESSION['pathroot']."/error_log.txt" );

		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

		ini_set( "gc_maxlifetime", 3*60*60 );		/* set session timeout to 3 hours */

		if (! $first )
			check_url();

		$cxn = db_login( $database );


			/* check whether the system is available for users */

		$query = "SELECT value FROM sys_config WHERE param = 'system_available' AND value = 'yes'";

		if (val( $_SESSION, 'availableoverride' ) != "true" && $user == "" && ! query_has_rows( $query, $cxn ) && strpos( val( $_SERVER, "SCRIPT_NAME" ), "admin.php" ) === false && strpos( val( $_SERVER, "SCRIPT_NAME" ), "admin_go.php" ) === false)
		{
			echo black( "The system has been taken down for maintainence. Please try again in half an hour." );

			exit();
		}

			/* log page loads if necessary */

		$query = "SELECT id FROM sys_config WHERE param = 'log_page_loads' AND value = 'yes'";

		if (query_has_rows( $query, $cxn ))
		{
			$query = "INSERT INTO page_loads (loaded, ip_address, page) VALUES ('".date("Y-m-d H:i:s")."', '".val( $_SERVER, "REMOTE_ADDR" )."', '".val( $_SERVER, "SCRIPT_NAME" )."')";
			$result = run_query( $query, $cxn );
		}

		return ($cxn);
	}



		/* log into the database and return the connection */

	function db_login( $database )
	{
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";

		$cxn = mysql_connect($host,$user,$password);

		if ($cxn === false)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			exit();
		}

		mysql_select_db ($database);

		return $cxn;
	}



		/* display a date-of-birth in the user's chosen format */

	function format_date_of_birth( $dob, $date_format )
	{
		if ($date_format == "dd/mm/yyyy")
			return substr($dob, 8, 2)."/".substr($dob, 5, 2)."/".substr($dob, 0, 4);
		else
		if ($date_format == "mm/dd/yyyy")
			return substr($dob, 5, 2)."/".substr($dob, 8, 2)."/".substr($dob, 0, 4);
		else
		if ($date_format == "yyyy/mm/dd")
			return substr($dob, 0, 4)."/".substr($dob, 5, 2)."/".substr($dob, 8, 2);
		else
		{
			echo black( "Internal Error: invalid date format" );
			exit();
		}
	}



		/* create a list of countries for a drop-down list */

	function build_country_list( $cxn )
	{
		$query = "SELECT * FROM static_data WHERE type = 'country' ORDER BY value";

		$result = run_query( $query, $cxn );

		$countries = "<option></option>";

		for ($i=0; $i < mysql_num_rows($result); $i++)
		{
			$data = get_row( $result );

			$countries = $countries."<option>".$data['value']."</option>";
		}

		return $countries;
	}


		/* run an SQL query and terminate if it fails */

	function run_query( $query, $cxn )
	{
		$result = mysql_query($query, $cxn);

		if ($result == false)
			crash( "<span class='gblack'>Internal error: ".mysql_error($cxn)."<br><br>Query: ".$query."<br><br>Script terminated</span>", $cxn );

		return $result;
	}



		/* create a HTML string to display hard spaces on the screen to separate words */

	function sp( $num )
	{
//		$str = "<font color='#FFFFFF'>";
		$str = "<span class='invisible'>";

		for ($i=0; $i < $num; $i++)
			$str = $str."i";

//		$str = $str."</font>";
		$str = $str."</span>";

		return $str;
	}



		/* read a row from a query and return it in the format $data['fieldname'] */

	function get_row( $result )
	{
		$row = mysql_fetch_row( $result );

		for ($i=0; $i < mysql_num_fields($result); $i++)
			$data[mysql_field_name( $result, $i )] = $row[$i];

		return $data;
	}


		/* returns the person's age, or 0 if the '$date_text' is not a valid date */
		/* the date-of-birth should be in mysql format YYYY-MM-DD */

	function check_date( $date_text, $cxn )
	{
		$key = rand(0, 2000000000);

		$query = "INSERT INTO test_date (key_id, test_date) values (".$key.", '".$date_text."')";
		$result = run_query( $query, $cxn );

		$query = "SELECT test_date, year(test_date) as dob_year, dayofyear(test_date) as dob_dayofyear FROM test_date WHERE key_id = ".$key;
		$result = run_query( $query, $cxn );

		$data = get_row( $result );

		if ($data['test_date'] == '0000-00-00')
			$age = 0;
		else
		{
			if ((date("z")+1) > $data['dob_dayofyear'])
				$age = date( "Y" ) - $data['dob_year'];
			else
				$age = date( "Y" ) - $data['dob_year'] - 1;
		}

		$query = "DELETE FROM test_date WHERE key_id = ".$key;
		$result = run_query( $query, $cxn );

		return $age;
	}


		/* generate the heading line for a page */


		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn, $on_load="", $dont_jump=false, $home_page=false, $bg_color="" )
	{
			/* redirect to the home page if session is expired */

		if ( val( $_SESSION, "session_active" ) != "yes" && $dont_jump == false)
		{
//			$query = "INSERT INTO sys_log (event, event_datetime) VALUES ('expired_session', '".date("Y-m-d H:i:s")."')";
//			$result = run_query( $query, $cxn );

			jump_to_page( "index.php", "internaljump", "true" );	/* must happen before print output */
			exit();
		}

		$_SESSION['session_active'] = "yes";
		
		if (val( $_SESSION, "id" ) != "")
		{
			$query = "SELECT handle FROM profile WHERE id = ".$_SESSION['id'];
			$result = run_query( $query, $cxn );
			$data = get_row( $result );
			$handle = $data['handle'];
		}

		echo "<html><head><meta http-equiv='expires' content='".date( "D, d M Y", time() + 60*60*24*2 )." 00:00:00 GMT'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";


			/* javascript functions for chat etc. */

		write_js_functions();


			/* define styles */

		$data = define_styles( $home_page );

		$bg = $data['bg'];
		$rose = $data['rose'];

		if ($bg_color != "")
			$bg = $bg_color;

		if ($heading != "")
		{
			if ($on_load != "")
				echo "<title>".$_SESSION['sitename'].": ".$heading."</title></head><body bgcolor='".$bg."' onLoad=\"".$on_load."\">";
			else
				echo "<title>".$_SESSION['sitename'].": ".$heading."</title></head><body bgcolor='".$bg."'>";
		}
		else
		{
			if ($on_load != "")
				echo "<title>".$_SESSION['sitename']."</title></head><body bgcolor='".$bg."' onLoad=\"".$on_load."\">";
			else
				echo "<title>".$_SESSION['sitename']."</title></head><body bgcolor='".$bg."'>";
		}

		if (val( $_SESSION, "debug" ) == true)
		{
			if ($heading != "")
			{
				echo "<table width='100%'><td width='25%'><span class='pgheading'>".$heading."</span></td>";

				echo "<td width='5%'></td>";
				echo "<td width='5%' valign='top'><a class='pinklink' href='".url_encode( "search_profiles.php" )."'>search</a></td>";
				echo "<td width='5%'></td>";
            	echo "<td width='5%' valign='top'><a class='pinklink' href='".url_encode( "mailboxes.php", "box", "inbox" )."'>messages</a></td>";
				echo "<td width='5%'></td>";

				echo "<td width='20%'><font color='#AAAAAA'>".date( "d M Y  g:ia" )."</font></td><td width='10%'><font color='#AAAAAA'><a href='sql_test.php?db=".$_SESSION['database']."'>sql</a>".sp(5).$handle."</font></td>";
//				echo "<td width='20%'><font color='#AAAAAA'>".date( "d M Y  g:ia" )."</font></td><td width='10%'><img src='".$rose."'><font color='#AAAAAA'><a href='sql_test.php?db=".$_SESSION['database']."'>sql</a>".sp(5).$handle."</font></td>";

				echo "<td align = 'CENTER'><a href='".url_encode( "index.php", "internaljump", "true" )."'><img src='buttons/".button_filename( "home" )."' border='0'></a></td></table>";

				echo "<br>";
			}
		}
		else
		{
			if ($heading != "")
			{
				echo "<table width='100%'><td width='30%'><span class='pgheading' valign='center'>".$heading."</span></td>";

				echo "<td width='10%' valign='center'><a class='pinklink' href='".url_encode( "search_profiles.php" )."'>search</a></td>";
				echo "<td width='10%'></td>";
				echo "<td width='10%' valign='center'><a class='pinklink' href='".url_encode( "mailboxes.php", "box", "inbox" )."'>messages</a></td>";
				echo "<td width='10%'></td>";

				echo "<td width='10%'></td>";
//				echo "<td width='10%'><img src='".$rose."'></td>";
				echo "<td width='20%' align = 'CENTER'><a href='".url_encode( "index.php", "internaljump", "true" )."'><img src='buttons/".button_filename( "home" )."' border='0'></a></td></table>";
				echo "<br>";
			}
		}
	}


		/* define the CSS styles */

	function define_styles( $home_page )
	{
		echo "<style type='text/css'>";
//		echo "<!--";

		$color_scheme = val( $_SESSION, 'color_scheme' );

				/* standard */

		if ($color_scheme == "" || $color_scheme == 0 || $color_scheme == 3)
		{
			if ($home_page)
				$bg = '#ffffff';
//				$bg = '#ccffff';
			else
				$bg = '#ffffff';

			$rose = "images/rose.gif";

			$font_name = "Times";
//			$font_name = "Verdana";

			echo "body   		{ color: #000000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo "a:visited	{color: #0000ff; text-decoration: underline}";
			echo "a:link	{color: #0000ff; text-decoration: underline}";

			echo "a.menubaritem			{color: #000000; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:visited {color: #000000; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:link	{color: #000000; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:hover {color: #000000; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";

			echo ".hl {color: #0000ff; background-color: #bbbbbb; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";
			echo ".uhl {color: #0000ff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";

			echo ".gblack         { color: #000000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".gred           { color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".gpink          { color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
//			echo ".gpink          { color: #FF69B4; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".gmidgreen      { color: #008000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".gwhite         { color: #ffffff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".fprompt        { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".fradio         { color: #000000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".dtext          { color: #000000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".paraheading    { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".mainmenuheading    { color: #ff0000; font-family: Arial; font-size: ".fs( 11 )."pt}";
			echo ".mainmenuitem			{color: #0000ff; font-size: ".fs( 11 )."pt; font-family:arial; text-decoration:none}";
			echo ".mainmenuitem:visited	{color: #0000ff; font-size: ".fs( 11 )."pt; font-family:arial; text-decoration:none}";
			echo ".mainmenuitem:link	{color: #0000ff; font-size: ".fs( 11 )."pt; font-family:arial; text-decoration:none}";

			echo ".pgheading      { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 16 )."pt}";
			echo ".homeheading    { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 22 )."pt}";

			echo ".glink		  { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".pinklink:visited { text-decoration: none; color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:link  { text-decoration: none; color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:hover { text-decoration: underline; color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

//			echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
//			echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
//			echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			
			echo ".lpinklink:visited { text-decoration: none; color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:link  { text-decoration: none; color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:hover { text-decoration: underline; color: #ff0000; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

//			echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
//			echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
//			echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".bluelink:visited { text-decoration: underline; color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".bluelink:link  { text-decoration: underline; color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";
			echo ".bluelink:hover { text-decoration: underline; color: #0000ff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".invisible      { color: #ffffff; font-family: ".$font_name."; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #000000; font-family: Arial; font-size: ".fs( 10 )."pt}";

		}
		else
		if ($color_scheme == 2)		/* black screen background */
		{
			$bg = '#000000';
			$rose = "images/roseb.gif";
			
			echo "body   		{ color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo "a			{color: #8888ff; text-decoration: underline}";
			echo "a:visited	{color: #8888ff; text-decoration: underline}";
			echo "a:link	{color: #8888ff; text-decoration: underline}";

			echo "a.menubaritem			{color: #ffffff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:visited {color: #ffffff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:link	{color: #ffffff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:hover {color: #ffffff; background-color: #000000; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";

			echo ".hl {color: #0000ff; background-color: #ffffff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";
			echo ".uhl {color: #0000ff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";

			echo ".gblack         { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gred           { color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gpink          { color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gmidgreen      { color: #00c000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gwhite         { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".fprompt        { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".fradio         { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".dtext          { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".paraheading    { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".mainmenuheading    { color: #00c000; font-family: Arial; font-size: ".fs( 11 )."pt}";
			echo ".mainmenuitem			{color: #8888ff; font-size:".fs( 11 )."pt; font-family:arial; text-decoration:none}";
			echo ".mainmenuitem:visited	{color: #8888ff; font-size:".fs( 11 )."pt; font-family:arial; text-decoration:none}";
			echo ".mainmenuitem:link	{color: #8888ff; font-size:".fs( 11 )."pt; font-family:arial; text-decoration:none}";

			echo ".pgheading      { color: #8888ff; font-family: Times; font-size: ".fs( 16 )."pt}";
			echo ".homeheading    { color: #ff0000; font-family: Times; font-size: ".fs( 22 )."pt}";

			echo ".glink		  { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #8888ff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".invisible      { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #ffffff; font-family: Arial; font-size: ".fs( 10 )."pt}";
		}
		else
		if ($color_scheme == 1)		/* pink italics */
		{
			if ($home_page)
				$bg = '#008200';
			else
				$bg = '#ffffff';

			$rose = "images/rose.gif";

			echo "body   		{ color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo "a			{color: #FF69B4; text-decoration: underline}";
			echo "a:visited	{color: #FF69B4; text-decoration: underline}";
			echo "a:link	{color: #FF69B4; text-decoration: underline}";

			echo "a.menubaritem			{color: #ffffff; font-style: italic; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:visited {color: #ffffff; font-style: italic; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:link	{color: #ffffff; font-style: italic; font-size:".fs( 12 )."pt; font-family:arial; text-decoration:none}";
			echo "a.menubaritem:hover {color: #ffffff; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";

			echo ".hl {color: #0000ff; background-color: #bbbbbb; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";
			echo ".uhl {color: #0000ff; font-size:".fs( 12 )."pt; font-family:arial; text-decoration: none}";

			echo ".gblack         { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gred           { color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gpink          { color: #ff0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gmidgreen      { color: #008000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".gwhite         { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".fprompt        { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".fradio         { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".dtext          { color: #000000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".paraheading    { color: #FF69B4; ; font-style: italic; font-family: Times; font-size: ".fs( 11 )."pt}";
			echo ".mainmenuheading    { color: #f0f000; font-family: Arial; font-size: ".fs( 11 )."pt}";
			echo ".mainmenuitem			{color: #ffffff; font-style: italic; font-size: ".fs( 11 )."pt; font-family:arial; text-decoration:none}";
			echo ".mainmenuitem:visited	{color: #ffffff; font-style: italic; font-size: ".fs( 11 )."pt; font-family:arial; text-decoration:none}";
			echo ".mainmenuitem:link	{color: #ffffff; font-style: italic; font-size: ".fs( 12 )."pt; font-family:arial; text-decoration:none}";

			echo ".pgheading      { color: #0000ff; font-family: Times; font-size: ".fs( 16 )."pt}";
			echo ".homeheading    { color: #f0f000; font-family: Times; font-size: ".fs( 22 )."pt}";

			echo ".glink		  { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #FF69B4; font-style: italic; font-family: Times; font-size: ".fs( 12 )."pt}";
			
			echo ".pinklink:visited { text-decoration: none; color: #FF0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:link  { text-decoration: none; color: #FF0000; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:hover { text-decoration: underline; color: #FF0000; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".invisible      { color: #ffffff; font-family: Times; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #000000; font-family: Arial; font-size: ".fs( 10 )."pt}";
		}


//		echo "//-->";
		echo "</style>";


			/* mouseover highlight bar */

		echo "<script>";
		echo "function hl( idx )	{	document.getElementById(idx).className = \"hl\"; }";
		echo "function uhl( idx )	{	document.getElementById(idx).className = \"uhl\"; }";
		echo "</script>";

		$data['bg'] = $bg;
		$data['rose'] = $rose;

		return ($data);
	}


		/* scale font sizes for lowres screens */

	function fs( $font_size )
	{
		if (low_res_screen())
			$fs2 = $font_size * (9/12);
		else
			$fs2 = $font_size;


			/* large font sizes */

		if (val( $_SESSION, 'color_scheme' ) == 3)
			$fs2 = $fs2 * 1.3;

		return (round( $fs2, 1)."");
	}


		/* return TRUE if a query returned at least one record */

	function query_has_rows( $query, $cxn )
	{
		$result = run_query( $query, $cxn );

		if (mysql_num_rows($result) != 0)
			return (true);
		else
			return (false);
	}



		/* convert a string into a format suitable for HTML display */
		/* replaces '\n' with '<br>' and '<' with '&lt' */

	function convert_to_html( $text )
	{
		$text = htmlspecialchars( $text );		/* changes '<' to '&lt' */
		$text3 = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			$ch = substr( $text, $i, 1 );

			if ($ch == "\n")
				$text3 = $text3."<br>";
			else
				$text3 = $text3.$ch;
		}

		return $text3;
	}



		/* functions for generating HTML form fields */


	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
		echo "<form action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table>\n";
	}



	function form_text( $prompt, $name, $size, $init )
	{
		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input class='finput' type='text' name='".$name."' id='".$name."' size='".$size."' value='".$init."'></td></tr>\n";
	}

	function form_texty( $prompt, $name, $size, $init )
	{
		return "<td><span class='fprompt'>".$prompt."</span></td><td><input class='finput' type='text' name='".$name."' id='".$name."' size='".$size."' value='".$init."'></td>";
	}

	function form_textx( $c, $prompt, $name, $size, $init )
	{
		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><font color='#AAAAAA'>".$c."</font></td><td><input type='text' class='finput' name='".$name."' size='".$size."' value='".$init."'></td></tr>\n";
	}

	function form_password( $prompt, $name, $size, $init )
	{
		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input type='password' class='finput' name='".$name."' size='".$size."' value='".$init."'></td></tr>\n";
	}


	function form_passwordx( $c, $prompt, $name, $size, $init )
	{
		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><font color='#AAAAAA'>".$c."</font></td><td><input type='password' class='finput' name='".$name."' size='".$size."' value='".$init."'></td></tr>\n";
	}


		/* value stored defaults to the text on the screen if 'value' is blank */

	function form_radio( $prompt, $name, $value, $desc, $curr )
	{
		$checked = "";

		if ($value != "")
			$valuex = $value;
		else
			$valuex = $desc;

		if ($curr == $valuex)
			$checked = "checked";

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input type='radio' name='".$name."' value='".$valuex."' ".$checked."><span class='fradio'>".$desc."</span></td>\n";
	}


	function form_radioy( $prompt, $name, $value, $desc, $curr )
	{
		$checked = "";

		if ($value != "")
			$valuex = $value;
		else
			$valuex = $desc;

		if ($curr == $valuex)
			$checked = "checked";

		return "<td><span class='fprompt'>".$prompt."</span></td><td><input type='radio' name='".$name."' value='".$valuex."' ".$checked."><span class='fradio'>".$desc."</span></td>";
	}
	
		/* value stored defaults to the text on the screen if 'value' is blank */

	function form_radiox( $c, $prompt, $name, $value, $desc, $curr )
	{
		$checked = "";

		if ($value != "")
			$valuex = $value;
		else
			$valuex = $desc;

		if ($curr == $valuex)
			$checked = "checked";

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><font color='#AAAAAA'>".$c."</font></td><td><input type='radio' name='".$name."' value='".$valuex."' ".$checked."><span class='fradio'>".$desc."</span></td>\n";
	}


	function form_dropdown( $prompt, $name, $option_str, $init )
	{
		if ($init != "")
		{
			$pos = strpos( $option_str, "<option>".$init."</option>" );

			if ($pos !== false)
			{
				$pos = $pos + 8;
				$option_str = substr( $option_str, 0, $pos - 1 )." selected".substr( $option_str, $pos - 1, strlen( $option_str ) - $pos + 1 );
			}
		}

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><select name='".$name."' class='finput'>".$option_str."</select></td></tr>\n";
	}


	function form_dropdownx( $c, $prompt, $name, $option_str, $init )
	{
		if ($init != "")
		{
			$pos = strpos( $option_str, "<option>".$init."</option>" );

			if ($pos !== false)
			{
				$pos = $pos + 8;
				$option_str = substr( $option_str, 0, $pos - 1 )." selected".substr( $option_str, $pos - 1, strlen( $option_str ) - $pos + 1 );
			}
		}

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><font color='#AAAAAA'>".$c."</font></td><td><select name='".$name."' class='finput'>".$option_str."</select></td></tr>\n";
	}


	function form_textarea( $prompt, $name, $rows, $cols, $init )
	{
		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><textarea name='".$name."' class='finput' rows='".$rows."' cols = '".$cols."'>".$init."</textarea></td></tr>\n";
	}


	function form_textareax( $c, $prompt, $name, $rows, $cols, $init )
	{
		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><font color='#AAAAAA'>".$c."</font></td><td><textarea name='".$name."' class='finput' rows='".$rows."' cols = '".$cols."'>".$init."</textarea></td></tr>\n";
	}


	function form_hidden( $name, $value="" )
	{
		if ($value == "")
			echo "<input type='hidden' name='".$name."' id='".$name."'>\n";
		else
			echo "<input type='hidden' name='".$name."' id='".$name."' value='".$value."'>\n";
	}



	function form_checkbox( $prompt, $name, $curr )
	{
		$checked = "";

		if ($curr == "on")
			$checked = "checked";

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input type='checkbox' name='".$name."' ".$checked."></td></tr>\n";
	}

	function form_checkboxy( $prompt, $name, $curr )
	{
		$checked = "";

		if ($curr == "on")
			$checked = "checked";

		return "<td><span class='fprompt'>".$prompt."</span></td><td><input type='checkbox' name='".$name."' ".$checked."></td>";
	}

	function form_checkboxx( $c, $prompt, $name, $curr )
	{
		$checked = "";

		if ($curr == "on")
			$checked = "checked";

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><font color='#AAAAAA'>".$c."</font></td><td><input type='checkbox' name='".$name."' ".$checked."></td></tr>\n";
	}


		/* re-generate the small jpg files created on file upload */

	function generate_small_jpegs( $cxn )
	{
		$pathroot = val( $_SESSION, "pathroot" );
		
		$query = "SELECT * FROM photos";

		$result = run_query( $query, $cxn );

		for ($i=0; $i < mysql_num_rows($result); $i++)
		{
			$data = get_row( $result );

			$id = $data['member_id'];
			$photo_number = $data['photo_number'];
			$file_extension = $data['file_extension'];

			$destfile = $pathroot."/photos/photo_".$id."_".$photo_number."_l.".$file_extension;
			$destfile_sm = $pathroot."/photos/photo_".$id."_".$photo_number."_sm.".$file_extension;

			list( $width, $height, $type, $attr ) = getimagesize( $destfile );

			if ($height == 0)
				$aspect_ratio = 1;
			else
				$aspect_ratio = $width / $height;

			$new_width = 120 * $aspect_ratio;
			$new_height = 120;

			$image_p = imagecreatetruecolor( $new_width, $new_height );

			$image = imagecreatefromjpeg( $destfile );

			imagecopyresampled( $image_p, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height );

			imagejpeg( $image_p, $destfile_sm, 90 );		/* the 90 is the percentage of original image quality (compression) */
		}
	}



		/* generate a URL with parameters, session id and parameter checking */

	function url_encode_file( $page )
	{
		return ($page);
	}



		/* create a url complete with session id and magic number checking */

	function url_encode( $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5="" )
	{
		if ($param5 != "")
			return (make_url( $page."?".$param1."=".$value1."&".$param2."=".$value2."&".$param3."=".$value3."&".$param4."=".$value4."&".$param5."=".$value5 ));
		else
		if ($param4 != "")
			return (make_url( $page."?".$param1."=".$value1."&".$param2."=".$value2."&".$param3."=".$value3."&".$param4."=".$value4 ));
		else
		if ($param3 != "")
			return (make_url( $page."?".$param1."=".$value1."&".$param2."=".$value2."&".$param3."=".$value3 ));
		else
		if ($param2 != "")
			return (make_url( $page."?".$param1."=".$value1."&".$param2."=".$value2 ));
		else
		if ($param1 != "")
			return (make_url( $page."?".$param1."=".$value1 ));
		else
			return (make_url( $page ));
	}


		/* add a magic number checksum to a URL */

	function make_url( $url )
	{
		if (strpos( $url, "?" ) == false)
			$url = $url."?";
		else
			$url = $url."&";

		$tail = $url;

				/* absolute URL */

		if (substr( $url, 0, 7 ) == "http://"  || substr( $url, 0, 4 ) == "www.")
		{
			$tail = substr( $url, 8, strlen( $url ) - 8 );

			$tail = substr( $tail, strpos( $tail, "/" ) + 1, strlen( $tail ) - strpos( $tail, "/" ) - 1 );
		}
		else
		{
			$path = $_SERVER['REQUEST_URI'];

			$path = substr( $path, 1, strlen( $path ) - 1 );		/* delete leading '/' */

			$ptr = strrpos( $path, '/' );

			$path = substr( $path, 0, $ptr );

			$tail = $path."/".$tail;
		}

//		echo "$tail: ".$tail." ";

		if (SID == "")
			return ($url."magic=".md5( $tail ));
		else
			return ($url."magic=".md5( $tail )."&".SID);
	}



		/* check that the magic number in the URL correctly identifies the parameters, i.e. someone */
		/* isnt trying the bookmark url with changed parmaeters */


	function check_url()
	{
		$url = $_SERVER['REQUEST_URI'];

		$url = substr( $url, 1, strlen( $url ) - 1 );		/* delete leading '/' */

		$pos = strpos( $url, "magic=" );

		$orig_url = substr( $url, 0, $pos );

		$hash = substr( $url, $pos + 6, 32 );

		if ($hash != md5( $orig_url ))
		{
			echo "<span class='gblack'>Corrupted URL<br><br>script terminated<br><br>".$orig_url."</span>";
			exit();
		}
	}



		/* show a photo on the screen */
		/* if 'photo_number' is -1 show the primary photo, otherwise the photo number given */
		/* shows the 'no photo available' image if there is no photo available */


	function show_photo( $member_id, $height, $photo_number, $allow_zoom, $large, $cxn )
	{
		if ($photo_number == -1)
			$query = "SELECT * FROM photos WHERE member_id = ".$member_id." AND primary_photo = 'yes'";
		else
			$query = "SELECT * FROM photos WHERE member_id = ".$member_id." AND photo_number = ".$photo_number;

		$result = run_query( $query, $cxn );

		if (mysql_num_rows($result) == 0)
		{
			if ($height == 120)
				$filename = url_encode_file( "photos/v1_no_photo_120.gif" );
			else
			if ($height == 100)
				$filename = url_encode_file( "photos/v1_no_photo_100.gif" );
			else
			if ($height == 80)
				$filename = url_encode_file( "photos/v1_no_photo_80.gif" );
			else
				$filename = url_encode_file( "photos/no_photo.gif" );

			echo "<img src='".$filename."' width='".$height."' height='".$height."'>";
		}
		else
		{
			$data = get_row( $result );

			$width = $height * $data['aspect_ratio'];

			if ($large)
//				$filename = "/photos/photo_".$member_id."_".$data['photo_number'].".".$data['file_extension'];

				$filename = "/photos/photo_".$member_id."_".$data['photo_number']."_l.".$data['file_extension'];
			else
				$filename = "/photos/photo_".$member_id."_".$data['photo_number']."_sm.".$data['file_extension'];

			if ($allow_zoom)
			{
				echo "<a href='".url_encode( "show_large_photo.php", "showid", $member_id, "photonumber", $photo_number )."'>";
				echo "<img src='".url_encode_file( $filename )."' width='".$width."' height='".$height."' border='0'>";
				echo "</a>";
			}
			else
				echo "<img src='".url_encode_file( $filename )."' width='".$width."' height='".$height."'>";
		}
	}



		/* show a handle on the screen */

	function show_handle( $member_id, $handle, $returnpoint, $startpos )
	{
		if ($startpos == "")
			$startpos = "x";

		$url = url_encode( "display_profile.php", "showid", $member_id, "returnpoint", $returnpoint, "startpos", $startpos );

		return ("<a href='".$url."'><span class='glink'>".$handle."</span></a>");
	}



		/* show a hyperlink button */

	function show_button_h( $gif, $page="", $param1="", $value1="", $param2="", $value2="", $param3="", $value3="", $param4="", $value4="", $param5="", $value5=""  )
	{
		$gif = button_filename( $gif );

		list( $width, $height, $type, $attr ) = getimagesize( $_SESSION['pathroot']."/buttons/".$gif );
		
		echo "<a href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3, $param4, $value4, $param5, $value5 )."'><img src='/buttons/".$gif."' border='0' width='".$width."' height='".$height."' alt='".substr($gif, 0, strlen($gif)-4)."'></a>";
	}


		/* show a form submit button */

	function form_submit( $gif )
	{
		$gif = button_filename( $gif );

		echo "<tr><td></td><td><br><br><input type='image' src='buttons/".$gif."' border='0'></td></tr>";
	}



		/* end of a form  */

	function form_end()
	{
		echo "</table></form>";
	}



		/* show a hyperlink */

	function show_link( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
		return "<a href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3 )."'><span class='glink'>".$prompt."</span></a>";
	}


	function show_linkb( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
		return "<a class='menubaritem' href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3 )."'>".$prompt."</a>";
	}

	function show_linkm( $prompt, $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
		return "<a class='mainmenuitem' href='".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3 )."'>".$prompt."</a>";
	}

	function show_link_encoded( $prompt, $url )
	{
		echo "<a href='".$url."'><span class='glink'>".$prompt."</span></a>";
	}



	function show_return_point( $returnpoint, $startpos, $show_id )
	{
		if ($show_id == "")
		{
			echo "<span class='gblack'>Internal Error: missing id in show_return_point</span>";
			exit();
		}

		if ($returnpoint == "inbox")
			echo show_link( "Return", "mailboxes.php", "box", "inbox" );
		else
		if ($returnpoint == "received")
			echo show_link( "Return", "mailboxes.php", "box", "received" );
		else
		if ($returnpoint == "sent")
			echo show_link( "Return", "mailboxes.php", "box", "sent" );
		else
		if ($returnpoint == "blocked")
			echo show_link( "Return", "mailboxes.php", "box", "blocked" );
		else
		if ($returnpoint == "remembered")
			echo show_link( "Return", "mailboxes.php", "box", "remembered" );
		else
		if ($returnpoint == "credits")
			echo show_link( "Return", "mailboxes.php", "box", "credits" );
		else
		if ($returnpoint == "contacts")
			echo show_link( "Return", "mailboxes.php", "box", "contacts" );
		else
		if ($returnpoint == "main")
			echo show_home_link();
//			echo show_link( "Return", "index.php" );
		else
		if ($returnpoint == "search")
			echo show_link_encoded( "Return", url_encode( "view_profiles.php", "startpos", $startpos )."#id".$show_id );
		else
		{
			echo "<span class='gblack'>Internal Error: return point not recognised ".$returnpoint."</span>";
			exit();
		}
	}



		/* redirect the browser to a new page */

		/* NOTE: must happen before print output */

	function jump_to_page( $page, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
		header( "Location: ".url_encode( $page, $param1, $value1, $param2, $value2, $param3, $value3 ) );
	}



		/* show a form field in printed output (not data entry) */

	function show_field( $prompt, $value, $force_show=false )
	{
//		if ($value != "" || $force_show)
		echo "<tr><td valign='top'><span class='dprompt'>".$prompt."</span></td><td align='left'><span class='dtext'>".convert_to_html( $value )."</span></td></tr>";
	}



		/* display an error message and stop if an input parameter is blank */

	function crash_if_missing( $val, $msg, $cxn )
	{
		if ($val == "")
			crash( "Internal Error: ".$msg, $cxn );
	}


		/* send an email to a member */

	function send_external( $to_id, $subject, $text_body, $html_body, $cxn, $mode=1 )
	{
		$from_name = $_SESSION['sitename'];
		$from_addr = "noreply@academicdating.net";
		$reply_name = $_SESSION['sitename'];
		$reply_addr = "noreply@academicdating.net";

		$query = "SELECT email FROM profile WHERE id = ".$to_id;

		$result = run_query( $query, $cxn );

		$data = get_row( $result );

			/* for prod use the live address, otherwise redirect */

		$domain = val( $_SERVER, "HTTP_HOST" );

		if ($domain == "www.academicdating.net")
			$to_addr = $data['email'];
		else
			$to_addr = "markmcilroy@ozemail.com.au";

		
//		if (val( $_SESSION, "debug_email" ) != "")
//			$to_addr = $_SESSION['debug_email'];
//		else
//			$to_addr = $data['email'];


			/* always redirect */

		if ($mode == 2)
			$to_addr = "markmcilroy@ozemail.com.au";

			
			/* never redirect */

		if ($mode == 3)
			$to_addr = $data['email'];

		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body );

		return ($to_addr);
	}


		/* send an email message with text and html alternatives */

	function send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body )
	{
//		echo black( "Sending to ".$to_addr."<br>" );
		
//		if ($to_addr != "markmcilroy@ozemail.com.au")
		{
				/* MIME boundry */

			$mime_boundary = "--xx--".md5(time());


				/* header */

			$headers = "From: ".$from_name." <".$from_addr.">\n";
			$headers .= "Reply-To: ".$reply_name." <".$reply_addr.">\n";
			$headers .= "MIME-Version: 1.0\n";
			$headers .= "Content-Type: multipart/alternative; boundary=\"".$mime_boundary."\"\n";


				/* text body  */

			$message = "--".$mime_boundary."\n";
			$message .= "Content-Type: text/plain; charset=UTF-8\n";
			$message .= "Content-Transfer-Encoding: 8bit\n\n";

			$message .= $text_body;


				/* html body */

			$message .= "\n--".$mime_boundary."\n";
			$message .= "Content-Type: text/html; charset=UTF-8\n";
			$message .= "Content-Transfer-Encoding: 8bit\n\n";

			$message .= $html_body;


				/* end of message */

			$message .= "\n--".$mime_boundary."--\n\n";

			$mail_sent = @mail( $to_addr, $subject, $message, $headers );
		}

		return ($mail_sent);
	}




		/* keep a database log of hits from users with each screen size */

	function log_screen_size( $width, $height, $cxn )
	{
		$query = "SELECT * FROM sys_data WHERE param = 'screen_size' AND value = '".$width."x".$height."'";

		if (query_has_rows( $query, $cxn ))
		{
			$result = run_query( $query, $cxn );
			$data = get_row( $result );

			$new_count = $data['hits'] + 1;

			$query = "UPDATE sys_data SET hits = ".$new_count." WHERE param = 'screen_size' AND value = '".$width."x".$height."'";
			$result = run_query( $query, $cxn );
		}
		else
		{
			$query = "INSERT INTO sys_data (param, value, hits) VALUES ('screen_size', '".$width."x".$height."', 1)";
			$result = run_query( $query, $cxn );
		}
	}


		/* log the source of our hits */

	function log_hits( $source, $cxn )
	{
		$ip_country = get_ip_country( $cxn );

		$hit_date = date( "Y-m-d" );

		$query = "SELECT id FROM hits WHERE source = '".$source."' AND ip_country = '".$ip_country."' AND hit_date = '".$hit_date."'";

		if (query_has_rows( $query, $cxn ))
		{
			$query = "UPDATE hits SET hits = hits + 1 WHERE source = '".$source."' AND ip_country = '".$ip_country."' AND hit_date = '".$hit_date."'";
			$result = run_query( $query, $cxn );
		}
		else
		{
			$query = "INSERT INTO hits (source, ip_country, hit_date, hits, conversions) VALUES ('".$source."', '".$ip_country."', '".$hit_date."', 1, 0 )";
			$result = run_query( $query, $cxn );
		}
	}

		/* log a new member */

	function log_conversion( $cxn )
	{
		$source = val( $_SESSION, "source" );

		if ($source == "")
			$source = ".blank";

		$ip_country = get_ip_country( $cxn );

		$hit_date = date( "Y-m-d" );

		$query = "SELECT id FROM hits WHERE source = '".$source."' AND ip_country = '".$ip_country."' AND hit_date = '".$hit_date."'";

		if (query_has_rows( $query, $cxn ))
		{
			$query = "UPDATE hits SET conversions = conversions + 1 WHERE source = '".$source."' AND ip_country = '".$ip_country."' AND hit_date = '".$hit_date."'";
			$result = run_query( $query, $cxn );
		}
		else
		{
			$query = "INSERT INTO hits (source, ip_country, hit_date, hits, conversions) VALUES ('".$source."', '".$ip_country."', '".$hit_date."', 0, 1 )";
			$result = run_query( $query, $cxn );
		}
	}	

		/* stop site_info() crashing */

	function log_source( $source, $cxn )
	{
	}


/*
	function log_source( $source, $cxn )
	{
		if ($source == "")
			$source = "unidentified";

		$query = "SELECT * FROM sys_data WHERE param = 'source' AND value = '".$source."'";

		if (query_has_rows( $query, $cxn ))
		{
			$result = run_query( $query, $cxn );
			$data = get_row( $result );

			$new_count = $data['hits'] + 1;

			$query = "UPDATE sys_data SET hits = ".$new_count." WHERE param = 'source' AND value = '".$source."'";
			$result = run_query( $query, $cxn );
		}
		else
		{
			$query = "INSERT INTO sys_data (param, value, hits) VALUES ('source', '".$source."', 1)";
			$result = run_query( $query, $cxn );
		}
	}
*/



		/* log whether the user has javascript active */

	function log_javascript( $has_javascript, $cxn )
	{
		if ($has_javascript != "yes")
			$has_javascript = "no";

		$query = "SELECT * FROM sys_data WHERE param = 'has_javascript' AND value = '".$has_javascript."'";

		if (query_has_rows( $query, $cxn ))
		{
			$result = run_query( $query, $cxn );
			$data = get_row( $result );

			$new_count = $data['hits'] + 1;

			$query = "UPDATE sys_data SET hits = ".$new_count." WHERE param = 'has_javascript' AND value = '".$has_javascript."'";
			$result = run_query( $query, $cxn );
		}
		else
		{
			$query = "INSERT INTO sys_data (param, value, hits) VALUES ('has_javascript', '".$has_javascript."', 1)";
			$result = run_query( $query, $cxn );
		}
	}
	
		/* return an element in an array or an empty string if it doesn't exist */

	function val( $xarray, $variable )
	{
		if (array_key_exists( $variable, $xarray ))
			$value = $xarray[ $variable ];
		else
			$value = "";

		return ($value);
	}


		/* display an error message and exit */

	function crash( $msg, $cxn )
	{
		echo "<span class='gblack'>Internal Error: ".$msg."<br><br><br>A message has been sent to technical support informing them of this problem. We are sorry for the inconvenience.<br><br></span><span class='gred'>Please go to the home page and try this function again.</span><br><br>";

		echo show_home_link();
		
		$query = "INSERT INTO sys_log (event, event_datetime, text) VALUES ('crash', '".date("Y-m-d H:i:s")."', '".prep_for_sql( val( $_SERVER, "REMOTE_ADDR" )." ".$msg )."')";

		$result = mysql_query($query, $cxn);

		if ($_SESSION['database'] == "academi1_academicdating")
			send_email( "System", "markmcilroy@ozemail.com.au", "markmcilroy@ozemail.com.au", "System", "markmcilroy@ozemail.com.au", "Crash", $msg, $msg );
		
		exit();
	}


		/* dump some information to the sys log */

	function dump_data( $msg, $cxn )
	{
		$query = "INSERT INTO sys_log (event, event_datetime, text) VALUES ('data', '".date("Y-m-d H:i:s")."', '".prep_for_sql( $msg )."' )";

		$result = mysql_query($query, $cxn);
	}


		/* send the email to the user allowing them to verify their email address */

	function send_verification_email( $id, $email_verification_code, $cxn )
	{
		$domain = val( $_SERVER, "HTTP_HOST" );
		
		$subject = "Verification email from ".$_SESSION['sitename'];

		$text_body = "To activate your account please paste the following link into your browser and press enter to activate yout account\n\n";
		$text_body .= url_encode( "http://".$domain."/verify_email.php", "verifyid", $id, "code", $email_verification_code );

		$html_body = "To activate your account please click on the link below<br><br>";
		$html_body .= show_link( "activate account", "http://".$domain."/verify_email.php", "verifyid", $id, "code", $email_verification_code );

		return (send_external( $id, $subject, $text_body, $html_body, $cxn ));
	}


		/* welcome letter */

	function send_welcome_letter( $id, $cxn )
	{
		$domain = val( $_SERVER, "HTTP_HOST" );
		
		$subject = "Welcome from ".$_SESSION['sitename'];

		$text_body = "Welcome to ".$_SESSION['sitename']."\n\n";
		$text_body .= "We hope that you enjoy using the site and meet some interesting people.\n";
		$text_body .= "If you have any questions about the site please refer to the Frequently Asked Questions link on the main page.\n\n\n\n";
//		$text_body .= "When you are more familiar with using the site you might wish to consider uploading a photo of yourself.\n\n";
//		$text_body .= "Photos can be uploaded on the 'Manage Photos' screen.\n\n\n\n";
		$text_body .= "Best wishes\n\n";
		$text_body .= $_SESSION['sitename']."\n\n\n\n";
		$text_body .= show_link( "www.academicdating.net", "http://".$domain );

		$html_body = "Welcome to ".$_SESSION['sitename'].".<br><br>";
		$html_body .= "We hope that you enjoy using the site and meet some interesting people.<br><br>";
		$html_body .= "If you have any questions about the site please refer to the Frequently Asked Questions link on the main page.<br><br><br><br>";
//		$html_body .= "When you are more familiar with using the site you might wish to consider uploading a photo of yourself.<br><br>";
//		$html_body .= "Photos can be uploaded on the 'Manage Photos' screen.<br><br><br><br>";
		$html_body .= "Best wishes<br><br>";
		$html_body .= $_SESSION['sitename']."<br><br>";
		$html_body .= show_link( "www.academicdating.net", "http://".$domain );

		return (send_external( $id, $subject, $text_body, $html_body, $cxn ));
	}


		/* new email address confirmation */

	function send_confirmation_email( $id, $cxn )
	{
		$domain = val( $_SERVER, "HTTP_HOST" );
		
		$subject = "Confirmation of new email address";

		$text_body = "This message is an automated message from ".$_SESSION['sitename']." to confirm your new email address\n\n";
		$text_body .= "This message can be deleted";

		$html_body = "This message is an automated message from ".$_SESSION['sitename']." to confirm your new email address<br><br>";
		$html_body .= "This message can be deleted";

		return (send_external( $id, $subject, $text_body, $html_body, $cxn ));
	}


		/* return a string in name case, e.g. New York */

	function name_case( $text )
	{
		$text = trim( $text );

		$out_str = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			if ($i == 0)
				$out_str = strtoupper( substr( $text, 0, 1 ) );
			else
			{
				if (substr( $text, $i - 1, 1 ) == " ")
					$out_str .= strtoupper( substr( $text, $i, 1 ) );
				else
					$out_str .= strtolower( substr( $text, $i, 1 ) );
			}
		}

		return ($out_str);
	}


		/* check for inappropriate words in the profile text */

	function check_banned_words( $text, $cxn )
	{
		$error_str = "";
		$word = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			if (substr( $text, $i, 1 ) == " " ||
				substr( $text, $i, 1 ) == "," ||
				substr( $text, $i, 1 ) == "\n" ||
				$i == strlen( $text ) - 1)
			{
				if ($i == strlen( $text ) - 1)
					$word .= substr( $text, $i, 1 );

				if ($word != "")
				{
					$word = prep_for_sql( $word );
					
					$query = "SELECT id FROM banned_words WHERE word = '".$word."'";
 
//					echo "checking '".$word."'<br>";

					if (query_has_rows( $query, $cxn ))
					{
						if ($error_str == "")
							$error_str = $word;
						else
							$error_str .= ", ".$word;
					}
				}

				$word = "";
			}
			else
				$word .= substr( $text, $i, 1 );
		}

		return ($error_str);
	}


		/* returns true if the text contains an email address */

	function check_for_email( $text, $cxn )
	{
		$word = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			if (substr( $text, $i, 1 ) == " " ||
				substr( $text, $i, 1 ) == "," ||
				substr( $text, $i, 1 ) == "\n" ||
				$i == strlen( $text ) - 1)
			{
				if ($i == strlen( $text ) - 1)
					$word .= substr( $text, $i, 1 );

				if ($word != "")
				{
					if (strpos( $word, "@" ) != false && strpos( $word, "." ) != false)
						return (true);
				}

				$word = "";
			}
			else
				$word .= substr( $text, $i, 1 );
		}

		return (false);
	}


		/* return a random tip of the day */

	function tip_of_the_day( $cxn )
	{
		$query = "SELECT count(*) as num FROM tips";

		$result = mysql_query($query, $cxn);
		$data = get_row( $result );

		$tip = rand(1, $data['num'] );

		$query = "SELECT tip FROM tips WHERE id = ".$tip;

		$result = mysql_query($query, $cxn);
		$data = get_row( $result );

		return ($data['tip']);
	}


		/* split a csv string into an array */

	function split_csv( $text )
	{
		$num_items = 0;
		$in_double_quote = false;

		if ($text <> "")
		{
			$pos = 0;
                    
				// skip to start of each field, $pos should be on the first character
				// of each field
            
			while ($pos < strlen( $text ))
			{
				$ch = substr( $text, $pos, 1 );
            
				if ($ch == ",")
				{
					$data[$num_items] = "";
					$num_items++;
					$pos++;
				}
				else
				{
					if ($ch == "\"")
					{
						$in_double_quote = true;
						$pos++;

						if ($pos >= strlen( $text ))
							$field_end = true;
						else
							$ch = substr( $text, $pos, 1 );
					}
					else
						$in_double_quote = false;
                
					$this_field = "";
					$field_end = false;
                
					while (! $field_end)
					{
						if ($pos >= strlen( $text ))
							$field_end = true;
						else
						if ($ch == "\\")
						{
							$pos++;

							if ($pos >= strlen( $text ))
								$field_end = true;
							else
							{
								$ch = substr( $text, $pos, 1 );
								$this_field .= $ch;
								$pos++;
							}
						}
						else
						if ($in_double_quote && $ch == "\"")
						{
							$field_end = true;
							$pos += 2;
						}
						else
						if (! $in_double_quote && $ch == ",")
						{
							$field_end = true;
							$pos++;
						}
						else
						{
							$this_field .= $ch;
							$pos++;
						}

						if ($pos < strlen( $text ))
							$ch = substr( $text, $pos, 1 );
					}
                
					$data[$num_items] = $this_field;
					$num_items++;

                	if ($num_items > 1000)
						echo "Too many CSV fields<br>";
				}
			}

			if (substr( $text, strlen( $text ) - 1, 1) == ",")
			{
				$data[$num_items] = "";
				$num_items++;
			}
		}

		$data['num_fields'] = $num_items;

		return ($data);
	}


		/* show the information menu line */

	function show_info_menu( $cxn )
	{
//		$bg = "#d9ffff";
		$bg = "#73b8bb";


		echo "<table width='100%' border='0' cellspacing='0'><tr bgcolor='".$bg."'><td><font color='".$bg."'>.</font></td><td>";

		echo "<table width='100%' border='0' cellspacing='0'>";

		echo "<tr bgcolor='".$bg."'><td><span style='font-size:4pt; color:".$bg."'>.</span></td></tr>";

		echo "<tr bgcolor='".$bg."'>";

		echo "<td width='16%' align='center'>";

		echo show_linkb( "&nbsp;&nbsp;Policies&nbsp;&nbsp;", "policies.php" );
//		echo show_linkb( "&nbsp;&nbsp;FAQ&nbsp;&nbsp;", "faq.php" );

		echo "</td>";

		echo "<td width='16%' align='center'>";

		echo show_linkb( "&nbsp;&nbsp;Contact Us&nbsp;&nbsp;", "contact_us.php" );
//		echo show_linkb( "&nbsp;&nbsp;Policies&nbsp;&nbsp;", "policies.php" );

		echo "</td>";

		echo "<td width='17%' align='center'>";

//		echo show_linkb( "&nbsp;&nbsp;Charges&nbsp;&nbsp;", "charges.php" );

		echo "</td>";

		echo "<td width='17%' align='center'>";

//		echo show_linkb( "&nbsp;&nbsp;Contact Us&nbsp;&nbsp;", "contact_us.php" );

		echo "</td>";

		echo "<td width='17%' align='center'>";

//		echo show_linkb( "&nbsp;&nbsp;Advertisements&nbsp;&nbsp;", "ads.php" );

		echo "</td>";

		echo "<td width='17%' align='center'>";

		echo show_linkb( "&nbsp;&nbsp;Tips&nbsp;&nbsp;", "tips.php" );

		echo "</td></tr>";

		echo "<tr bgcolor='".$bg."'><td><span style='font-size:4pt; color:".$bg."'>.</span></td></tr>";

		echo "</table>";

		echo "</tr></td></table>";

	}


		/* returns true if we are showing on a low-res screen */

	function low_res_screen()
	{
		if (val( $_SESSION, 'screen_height' ) != "" && val( $_SESSION, 'screen_height' ) <= 600)
			return true;
		else
			return false;
	}

		/* capitalise the first word of a sentence */

	function sentence_case( $text )
	{
		if ($text == "")
			return "";
		else
		{
			$str1 = strtoupper( substr( $text, 0, 1 ) );
			$str2 = substr( $text, 1, strlen( $text ) - 1 );

			return ($str1.$str2);
		}
	}


		/* returns TRUE if this email requires a credit */

		/* NOTE: must be called before the email is saved otherwise */
		/* it will think an email has been sent in the past */

	function needs_credit( $id, $send_to_id, $cxn )
	{
		$num_sent = 0;

		$needs_credit = false;


			/* check how many members have been contacted today*/

		if (! already_had_contact_today( $id, $send_to_id, $cxn ))
			$num_sent = num_contacted_today( $id, $send_to_id, $cxn );


		if ($num_sent >= 3 && get_membership_type( $id, $cxn ) == "basic" && $id != $send_to_id)
		{
				/* check if the sender is a paying member */

			$query = "SELECT profile.id FROM profile INNER JOIN static_data ON profile.country = static_data.value WHERE profile.id = ".$id." AND static_data.charging = 'yes'";

			if (query_has_rows( $query, $cxn ))
				$sender_pays = true;
			else
				$sender_pays = false;


				/* check if the receiver is a paying member */

			$query = "SELECT profile.id FROM profile INNER JOIN static_data ON profile.country = static_data.value WHERE profile.id = ".$send_to_id." AND static_data.charging = 'yes'";

			if (query_has_rows( $query, $cxn ))
				$receiver_pays = true;
			else
				$receiver_pays = false;


				/* check if the sender has sent an email */

			$query = "SELECT id FROM message WHERE type = 'email' AND sender_id = ".$id." AND receiver_id = ".$send_to_id;

			if (query_has_rows( $query, $cxn ))
				$sender_sent = true;
			else
				$sender_sent = false;


				/* check if the receiver has sent an email */

			$query = "SELECT id FROM message WHERE type = 'email' AND sender_id = ".$send_to_id." AND receiver_id = ".$id;

			if (query_has_rows( $query, $cxn ))
				$receiver_sent = true;
			else
				$receiver_sent = false;


				/* don't have to pay if one of you has already sent an email */

  			if ($sender_sent || $receiver_sent)
				$needs_credit = false;
			else
				$needs_credit = true;
		}

		return ($needs_credit);
	}


			/* check how many members have been contacted today*/

	function num_contacted_today( $id, $send_to_id, $cxn )
	{
		$num_sent = 0;

		$query = "SELECT count(*) as num FROM (SELECT DISTINCT receiver_id FROM message WHERE sender_id = ".$id." AND date(sent) = '".date("Y-m-d")."') x";

		$result = run_query( $query, $cxn );

		if (mysql_num_rows($result) != 0)
		{
			$data = get_row( $result );

			$num_sent = $data['num'];
		}

		return ($num_sent);
	}


		/* return true if we have already had contact with this member today */

	function already_had_contact_today( $id, $send_to_id, $cxn )
	{
		if (query_has_rows( "SELECT id FROM message WHERE ((sender_id = ".$id." AND receiver_id = ".$send_to_id.") OR (sender_id = ".$send_to_id." AND sender_id = ".$id.")) AND date(sent) = '".date("Y-m-d")."'", $cxn ))
			$already = true;
		else
			$already = false;

		return ($already);
	}


		/* return the country of origin of the requesting user */

	function get_ip_country( $cxn )
	{
		$country = "";

		$ipaddress = get_ip_address();

		$ip_num = Dot2LongIP( $ipaddress );

		if ($ip_num != 0)
		{
			$query = "SELECT countryLONG FROM IPCountry WHERE ".$ip_num." BETWEEN ipFROM AND ipTO";

			$result = run_query( $query, $cxn );
	
			if (mysql_num_rows($result) != 0)
			{
				$data = get_row( $result );

				$country = name_case( $data['countryLONG'] );
			}
		}

			/* for safety remove the quote in Cote D'ivoire */

		$country = str_replace( "'", "", $country );

		return ($country);
	}


		/* return the text IP address */

	function get_ip_address()
	{
		if (getenv('HTTP_X_FORWARDED_FOR'))
			$ipaddress = getenv('HTTP_X_FORWARDED_FOR');
		else
			$ipaddress = getenv('REMOTE_ADDR');

		return ($ipaddress);
	}



		/* convert a string IP address into a number */

	function Dot2LongIP( $IPaddr )
	{
		if ($IPaddr == "")
			return 0;
		else
		{
			$ips[0] = "";
			$ips[1] = "";
			$ips[2] = "";
			$ips[3] = "";

//			$ips = split ("\.", "$IPaddr");

			$j = 0;

			for ($i=0; $i < strlen( $IPaddr ) && $j <= 3; $i++)
			{
				$ch = substr( $IPaddr, $i, 1 );

				if ($ch == ".")
					$j++;
				else
					$ips[$j] .= $ch;
			}

			return ($ips[3] + $ips[2] * 256 + $ips[1] * 256 * 256 + $ips[0] * 256 * 256 * 256);
		}
	}
	
		/* return true if the visitor is in a non-charging country */

	function non_charging_country( $cxn )
	{
		if (val( $_SESSION, 'non_charging_override' ) == true)
			return true;
		else
		{
			$no_charge = false;

			$ip_country = get_ip_country( $cxn );

			if ($ip_country != "" && $ip_country != "-")
			{
				$ip_country = prep_for_sql( $ip_country );

				if (query_has_rows( "SELECT id FROM static_data WHERE type = 'country' AND value = '".$ip_country."' AND charging = 'no'", $cxn ))
					$no_charge = true;
			}

			return ($no_charge);
		}
	}

		/* display text in general colours */

	function black( $text )
	{
		return "<span class='gblack'>".$text."</span>";
	}

	function blue( $text )
	{
		return "<span class='gblue'>".$text."</span>";
	}

	function red( $text )
	{
		return "<span class='gred'>".$text."</span>";
	}

	function paraheading( $text )
	{
		return "<span class='paraheading'>".$text."</span>";
	}

	function watermark( $text )
	{
		return "<span class='gwatermark'>".$text."</span>";
	}

	function fprompt( $text )
	{
		return "<span class='fprompt'>".$text."</span>";
	}

	function pink( $text )
	{
		return "<span class='gpink'>".$text."</span>";
	}

	function midgreen( $text )
	{
		return "<span class='gmidgreen'>".$text."</span>";
	}

	function mainmenuheading( $text )
	{
		return "<span class='mainmenuheading'>".$text."</span>";
	}

//	function menuitem( $text )
//	{
//		return "<span class='menuitem'>".$text."</span>";
//	}
	


		/* Javascript functions for chat */

	function write_js_functions()
	{
		if (val( $_SESSION, 'id' ) == "")
		{
			$this_id = "-1";
			$ip_address = get_ip_address();
		}
		else
		{
			$this_id = val( $_SESSION, 'id' );
			$ip_address = "";
		}

		echo "<script type='text/javascript'>

		var xmlHttp;

		function refresh_online_status()
		{
			/*var xmlHttp;*/

			try
			{	 /* Firefox, Opera 8.0+, Safari */
				xmlHttp=new XMLHttpRequest();	 
			}
			catch (e)
				{	 /* Internet Explorer */
				try
					{	  
				     xmlHttp=new ActiveXObject('Msxml2.XMLHTTP');      
				}
				catch (e)
					{	   
					try
					{
						xmlHttp=new ActiveXObject('Microsoft.XMLHTTP');		   
					}
					catch (e)
					{
						/* alert( 'Your browser does not support AJAX!' ); */
						return false;
					}	   
				}	 
			}

				/* if a new chat request comes back, handle it */

			xmlHttp.onreadystatechange =
			function()
			{
				if (xmlHttp.readyState==4)
				{
					var x = xmlHttp.responseText;

						/* if program crashes it will return an	 */
						/* error message not 'x...' or 'ok' */

					if (x.substr(0,1) == 'x')
					{
						var url = 'chat_request.php?requestingid=';
						url += x.substr( 1, x.length - 1 );

							/* only one chat window could be open if window had fixed name */
							/* an error will occur if the window name has a decimal point in it */

						var rand_num = Math.random();

						rand_num += '';
						var window_name = 'AD_chat_' + rand_num.substr( 4, 6 );

						var winRef = window.open( url, window_name );
					}

					xmlHttp = null;
				}
			}

			xmlHttp.open( 'GET', 'online_refresh.php?memberid=".$this_id."&ipaddress=".$ip_address."', true );
			xmlHttp.send( null );
		}

		window.setInterval('refresh_online_status()', 3000);

		</script>";
	}


		/* return the member's membership type */

	function get_membership_type( $id, $cxn )
	{
		$query = "SELECT membership_type FROM profile WHERE id = ".$id;

		$result = run_query( $query, $cxn );

		$data = get_row( $result );

		return ($data['membership_type']);
	}

		/* generate the subscription button */

	function generate_subscription_button( $custom, $gif )
	{
		echo "<form action='https://www.paypal.com/cgi-bin/webscr' method='post'>";
		echo "<input type='hidden' name='cmd' value='_xclick-subscriptions'>";
		echo "<input type='hidden' name='business' value='enquiries@academicdating.net'>";
		echo "<input type='hidden' name='item_name' value='".$_SESSION['sitename']." - Monthly Subscription'>";
		echo "<input type='hidden' name='cancel_return' value='http://www.academicdating.net/payment_failed.php'>";
		echo "<input type='hidden' name='a3' value='25.00'>";
		echo "<input type='hidden' name='p3' value='1'>";
		echo "<input type='hidden' name='t3' value='M'>";
		echo "<input type='hidden' name='src' value='1'>";
		echo "<input type='hidden' name='sra' value='1'>";
		echo "<input type='hidden' name='currency_code' value='USD'>";
		echo "<input type='hidden' name='no_note' value='1'>";
		echo "<input type='hidden' name='custom' value='".$custom."'>";
		echo "<input type='image' src='/buttons/".$gif."' border='0' name='submit' alt='Buy Credits'>";
		echo "<img alt='' border='0' src='https://www.paypal.com/en_AU/i/scr/pixel.gif' width='1' height='1'>";
		echo "</form>";
	}

		/* returns true if this country supports paypal */

	function has_paypal( $cxn )
	{
		return (true);
/*
		$paypal = true;

		$ip_country = get_ip_country( $cxn );

		if ($ip_country != "" && $ip_country != "-")
		{
			$ip_country = prep_for_sql( $ip_country );

			if (query_has_rows( "SELECT id FROM static_data WHERE type = 'country' AND value = '".$ip_country."' AND paypal = 'no'", $cxn ))
				$paypal = false;
		}

		return ($paypal);
*/
	}


		/* show a line of adds */

	function show_ads( $cxn, $show_extra=true, $home_page=false )
	{
		if ($show_extra)
		{

//			if (strtolower( get_ip_country( $cxn ) ) == "ghana" || strtolower( get_ip_country( $cxn ) ) == "senegal" || strtolower( get_ip_country( $cxn ) ) == "nigeria" || strtolower( get_ip_country( $cxn ) ) == "australia")
// affiliate bot african site
//				echo "<table width='100%'><td width='100%' align='center'><a href='http://www.affbot3.com/link-609355-8533-934-11530?plan=177'><img src='images/african_friend_search.jpg' border='0'></td></tr></table><br>";
//			else
				echo "<br><br>";
		}

		show_ads_1_line( $home_page );
	}


	function show_ads_1_line( $home_page )
	{
		echo "<table width='100%'><tr><td align='center'>\n";
		echo "<script type='text/javascript'>\n";
		echo "<!--\n";
		echo "google_ad_client = 'pub-9796091010231719';\n";

//		if ($home_page && val( $_SESSION, 'color_scheme' ) != 2)
//			echo "google_ad_slot = '2357265941';\n";
//		else
		if (val( $_SESSION, 'color_scheme' ) == 2)	/* black background */
			echo "google_ad_slot = '2693025298';\n";	// text and image, black
		else
			echo "google_ad_slot = '6603726634';\n";	// text and image default colors

		echo "google_ad_width = 728;\n";
		echo "google_ad_height = 90;\n";
		echo "//-->\n";
		echo "</script>\n";
		echo "<script type='text/javascript' src='http://pagead2.googlesyndication.com/pagead/show_ads.js'>\n";
		echo "</script>\n";
		echo "</td></tr></table>\n";
	}


		/* create a different resolution of a JPG photo */
		/* filenames as 'xxx.jgp' in public html directory */
		/* set $new_width to 0 for auto-calc based on aspect ratio */

	function create_jpg( $source_file, $dest_file, $new_height, $new_width )
	{
		$domain = val( $_SERVER, "HTTP_HOST" );

		$domain_root = substr( $domain, 4, strlen( $domain ) - 4 );
		$domain_root = substr( $domain_root, 0, strlen( $domain_root ) - 4 );

		$pathroot = "/home/academi1/m-m-ventures.com/".$domain_root;

		$source_file_path = $pathroot."/".$source_file;
		$dest_file_path = $pathroot."/".$dest_file;

		list( $width, $height, $type, $attr ) = getimagesize( $source_file_path );

		if ($height == 0)
			$aspect_ratio = 1;
		else
			$aspect_ratio = $width / $height;

		if ($new_width == 0)
			$new_width = $aspect_ratio * $new_height;


			/*	$new_width = 240; */
			/*	$new_height = 150; */

		$image_p = imagecreatetruecolor( $new_width, $new_height );

		$image = imagecreatefromjpeg( $source_file_path );

		imagecopyresampled( $image_p, $image, 0, 0, 0, 0, $new_width, $new_height, $width, $height );

			/* the 100 is the percentage of original image quality (compression) */

		imagejpeg( $image_p, $dest_file_path, 100 );
	}


		/* return true if the logged-in user is a system profile */

	function is_system_user( $member_id, $cxn )
	{
		$query = "SELECT id FROM profile WHERE id = ".$member_id." AND system_user = 'yes'";

		if (query_has_rows( $query, $cxn ))
			$is_system = true;
		else
			$is_system = false;

		return ($is_system);
	}


		/* show a link to the home page */

	function show_home_link()
	{
		return show_link( "Home Page", "index.php", "internaljump", "true" );
	}
	

		/* return the first row of a query, generates an error if the query is empty */

	function get_first_row( $query, $cxn )
	{
		$result = run_query( $query, $cxn );

		if (mysql_num_rows($result) == 0)
			crash( "Query is empty: ".$query, $cxn );

		return (get_row( $result ));
	}


		/* send myself an email  */

	function alert( $text )
	{
		send_email( "System", "markmcilroy@ozemail.com.au", "markmcilroy@ozemail.com.au", "System", "markmcilroy@ozemail.com.au", $_SESSION['sitename'].": ".$text, "", "" );
	}


		/* determine the filename of a gif button */

	function button_filename( $button )
	{
		$color_scheme = val( $_SESSION, 'color_scheme' );

				/* black background */

		if ($color_scheme == 2)
			$filename = "v1_".$button."_b.gif";
		else
			$filename = "v1_".$button.".gif";

		return ($filename);
	}


		/* fix up a text string for use in an sql query */

	function prep_for_sql( $text )
	{
		$text = str_replace( "'", "''", $text );

		$text = str_replace( "\\", "", $text );

		return ($text);
	}

