<?php
			// (c) Copyright Mark McIlroy 2020

    define( "sitename", "Indie Hair" );
	define( "error_log_filename", "/home/academi1/public_html/indie-hair/error_log.txt" );



    			/* startup code to be called at the top of each file */

	function start_code()
	{
		session_start();


			/* set config options */

		ini_set( "error_log", error_log_filename );

		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
		ini_set( "gc_maxlifetime", 1*60*60 );		/* set session timeout to 1 hour */

		ini_set( "date.timezone", "Australia/Melbourne" );

		
        $cxn = db_login( "academi1_indiehair" );

		return ($cxn);
	}



		/* generate the heading line for a page */

	function page_header( $heading, $cxn )
	{
    	echo "<style> html, body {";
    	echo "margin:0;";
    	echo "padding:0;";
    	echo "}";
    	echo "</style>";

		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";

		echo "<link rel='shortcut icon' href='/favicon-96x96.png' type='image/x-icon'>";
		echo "<link rel='icon' href='/favicon-96x96.png' type='image/x-icon'>";

        echo "<meta name='description' content='Indie Hair is a modern Hair Salon located in Burwood. We offer a full range of hairdressing services including cuts, color, foils etc.'>";
        


			/* define styles */

		echo "<style>";


		define_styles();


		echo "</style>";


        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();


		if ($heading != "")
			echo "<title>".sitename." ".$heading."</title></head>";
		else
			echo "<title>".sitename."</title></head>";


        if (val( $_SESSION, "screen_width" ) == "")
    		echo "<body onload='js_set_screen_parameters();'>";
    	else
    		echo "<body>";

	}


		/* define the CSS styles */

	function define_styles()
	{
	    
        echo "hr { ";
        echo "    color: #DAA520; ";
        echo "} ";
        
        echo ".menu_item { ";
        echo "    margin:0; "; 
        echo "    padding:0; "; 
        echo "    font-family: calibri;  ";
        
        if (! low_res_screen())
            echo "    font-size: 12pt; "; 
        else
        {
            echo "    font-size: 14pt; "; 
            echo "    line-height: 32px;";
        }
        
        echo "    color: #000000; ";
        echo "    border-right: none;  ";
        echo "    border-left: none; "; 
        echo "    border-top: 2px solid #DAA520;  ";
        echo "    border-bottom: 2px solid #DAA520; "; 
        echo "} ";
        
        echo ".menu_item:hover { ";
        echo "    margin:0; "; 
        echo "    padding:0; "; 
        echo "    font-family: calibri;  ";
        
        if (! low_res_screen())
            echo "    font-size: 12pt; "; 
        else
        {
            echo "    font-size: 14pt; "; 
            echo "    line-height: 32px;";
        }

        echo "    cursor: pointer; "; 
        echo "    color: #000000; ";
        echo "    background: #DAA520; ";
        echo "    border-right: none; "; 
        echo "    border-left: none; "; 
        echo "    border-top: 2px solid #DAA520;  ";
        echo "    border-bottom: 2px solid #DAA520; "; 
        echo "} ";
        
        echo ".general_text { ";
        echo "    font-family: calibri;  ";
        echo "    font-size: 12pt; "; 
        echo "    color: #555555; ";
        echo "} ";
        
        echo ".general_heading { ";
        echo "    font-family: calibri;  ";
        echo "    font-style: italic; ";
        echo "    font-size: 14pt; "; 
        echo "    color: #555555; ";
        echo "    border-bottom: solid 1px #555555; ";
        echo "} ";
        
        echo ".glink { ";
        echo "    font-family: calibri;  ";
        echo "    font-size: 12pt; "; 
        echo "    font-style: italic; ";
        echo "    color: #000000; ";
        echo "    text-decoration: underline; ";
        echo "} ";
        
        if (! low_res_screen())
        {
    		echo ".gblue       { color: #000080; font-family: georgia; font-size: 11pt}";
    		echo ".ggray       { color: #555555; font-family: georgia; font-size: 11pt}";
    		echo ".gblack      { color: #000000; font-family: georgia; font-size: 11pt}";
    		echo ".link2       { color: #000080; font-family: georgia; font-size: 11pt}";
        }
    	else
        {
	    	echo ".gblue       { color: #000080; font-family: georgia; font-size: 12pt}";
	    	echo ".ggray       { color: #555555; font-family: georgia; font-size: 12pt}";
    		echo ".gblack      { color: #000000; font-family: georgia; font-size: 12pt}";
	    	echo ".link2       { color: #000080; font-family: georgia; font-size: 12pt}";
        }
        
        if (! low_res_screen())
    		echo ".footerlink  { color: #555555; font-family: georgia; font-size: 11pt}";
    	else
	    	echo ".footerlink  { color: #555555; font-family: georgia; font-size: 12pt}";
        
	}


    function show_main_menu()
    {
        echo "<br>";
        
        if (! low_res_screen())
        {
            echo "<table width='100%'><tr><td width='85%' valign='top' >&nbsp;&nbsp;&nbsp;&nbsp;<img src='/images_Indie_logo_dark.jpg' width=150></td><td valign='top'></td></tr></table><br> ";
    
            echo "<table width='100%' style='border-collapse: collapse; margin: 0; padding: 0; line-height: 25px;'><tr><td width'35%'>&nbsp;</td> ";
            
            echo "<td width='8%' class='menu_item' align='center' onclick='window.location.href=\"/\"'> ";
            echo "HOME</td> ";
        
            echo "<td width='8%' class='menu_item' align='center' onclick='window.location.href=\"/services.php\"'> ";
            echo "SERVICES</td> ";
    
            echo "<td width='8%' class='menu_item' align='center' onclick='window.location.href=\"/team.php\"'> ";
            echo "TEAM</td> ";

            echo "<td width='8%' class='menu_item' align='center' onclick='window.location.href=\"/hours.php\"'> ";
            echo "HOURS</td> ";
    
            echo "<td width='8%' class='menu_item' align='center' onclick='window.location.href=\"/contact_us.php\"'> ";
            echo "CONTACT&nbsp;US</td> ";
    
            echo "<td width='5%'></td></tr></table> ";
        }
        else
        {
            echo "<table width='100%'><tr><td width='85%' valign='top' >&nbsp;&nbsp;&nbsp;&nbsp;<img src='/images_Indie_logo_dark.jpg' width=150></td><td valign='top'></td></tr></table> ";
    
            echo "<table width='100%' style='border-collapse: collapse; margin: 0; padding: 0; line-height: 25px;'><tr><td width'35%'>&nbsp;</td> ";
            echo "<tr><td width='10%' class='menu_item' align='center' onclick='window.location.href=\"/\"'> ";
            echo "HOME</td></tr>";
        
            echo "<tr><td width='10%' class='menu_item' align='center' onclick='window.location.href=\"/services.php\"'> ";
            echo "SERVICES</tr>";
    
            echo "<tr><td width='10%' class='menu_item' align='center' onclick='window.location.href=\"/team.php\"'> ";
            echo "TEAM</tr>";

            echo "<tr><td width='10%' class='menu_item' align='center' onclick='window.location.href=\"/hours.php\"'> ";
            echo "HOURS</tr>";
    
            echo "<tr><td width='10%' class='menu_item' align='center' onclick='window.location.href=\"/contact_us.php\"'> ";
            echo "CONTACT&nbsp;US</tr>";
    
            echo "<td width='5%'></td></tr></table> ";
        }
        
    }
    
    
    function show_salon_address()
    {
        echo "<br><br><br>";
        
        if (! low_res_screen())
            echo "<table width='100%'><tr><td width='25%'>&nbsp;</td><td width='75%'>";
        else
            echo "<table width='100%'><tr><td width='10%'>&nbsp;</td><td width='85%'>";

        show_salon_address_detail();


        echo "</td></tr></table>";

        echo "<br><br><br>";
    }
    

    function show_salon_address_detail()
    {
        echo gray( "SALON ADDRESS<br> ");
        
        if (! low_res_screen())
            echo "<table style='border-collapse: collapse;'><tr><td style='width: 210px; border-bottom: 1px solid #555555; font-size: 3pt'>&nbsp;</td></tr></table>";
        else
            echo "<table style='border-collapse: collapse;'><tr><td style='width: 240px; border-bottom: 1px solid #555555; font-size: 3pt'>&nbsp;</td></tr></table>";
        
        echo "<br>";
        
        echo gray( "Indie Hair<br>" );
        echo gray( "2B Cromwell St.<br>" );
        echo gray( "Burwood 3125<br>" );
        echo gray( "Melbourne<br>" );
        echo "<br>";
        
        echo gray( "Tel: <a href='tel:03 9808 8886'>03 9808 8886</a><br>" );
        echo "<br>";

        echo gray( "Email: <a href='mailto:mail@indie-hair.com.au'>mail@indie-hair.com.au</a><br>" );

        
        if (! low_res_screen())
            echo "<table style='border-collapse: collapse;'><tr><td style='width: 210px; border-bottom: 1px solid #555555; font-size: 3pt'>&nbsp;</td></tr></table>";
        else
            echo "<table style='border-collapse: collapse;'><tr><td style='width: 240px; border-bottom: 1px solid #555555; font-size: 3pt'>&nbsp;</td></tr></table>";
    }


    function show_footer( $cxn )
    {
        show_salon_address();

        if (! low_res_screen())
            echo "<table width='100%'><tr><td width='25%'>&nbsp;</td><td width='75%'>";
        else
            echo "<table width='100%'><tr><td width='10%'>&nbsp;</td><td width='85%'>";
            
        echo "<a href='https://www.facebook.com/indiehairmelb' class='footerlink'>Facebook Indie Hair</a>";

        echo "<br><br><br>";
        
        echo "<a href='/' class='footerlink'>Home</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";
        
        echo "<a href='/services.php' class='footerlink'>Services</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";

        echo "<a href='/team.php' class='footerlink'>Team</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";

        if (low_res_screen())
            echo "<br><br><br>";

        echo "<a href='/hours.php' class='footerlink'>Hours</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";

        echo "<a href='/contact_us.php' class='footerlink'>Contact Us</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";

        echo "<a href='https://www.hbia.com.au/' class='footerlink'>HBIA</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";

        if (low_res_screen())
            echo "<br><br><br>";

        echo "<a href='https://www.redken.com.au' class='footerlink'>Redken</a>";
        echo "<div style='display: inline-block; width: 35px'>&nbsp;</div>";


        echo "<a href='https://www.matrix.com' class='footerlink'>Matrix</a>";
        
        echo "<br><br><br>";
        
        echo gray( "&copy 2018 Indie Ventures<br>" );

        echo "</td></tr></table>";
        
        echo "<br><br><br>";
        echo "<br><br><br>";

    }


	function gray( $text )
	{
		return "<span class='ggray'>".$text."</span>";
	}
	

	function black( $text )
	{
		return "<span class='gblack'>".$text."</span>";
	}
	

	
    function write_screen_parameters_function()
    {
    	echo "<script async>";

    	echo "function js_set_screen_parameters()";
    	echo "{";
        echo "  var request = new XMLHttpRequest();";

        echo "  request.open( 'GET', '/set_screen_parameters.php?sw='+screen.width+'&sh='+screen.height, false );";      // `false` makes the request synchronous

        echo "  request.send( null );";

        echo "}";
        
        echo "</script>";
    }


    
    
	function db_login( $database )
	{
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}


	
		/* return an element in an array or an empty string if it doesn't exist */


	function val( $xarray, $variable )
	{
		if (array_key_exists( $variable, $xarray ))
			$value = $xarray[ $variable ];
		else
			$value = "";

		return ($value);
	}



		/* returns true if we are showing on a low-res screen */


	function low_res_screen()
	{
	    $low_res = false;
	    
	    
	            // initial assesment until screen parameter update runs
	            
		if (val( $_SESSION, 'screen_width' ) == "")
		{
            if ((strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Android" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Windows Phone" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Phone" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "Mobile" ) !== false) ||
                 (strpos( val( $_SERVER, "HTTP_USER_AGENT" ), "iPhone" ) !== false))
    			$low_res = true;
    		else
    			$low_res = false;
		}
		else
		{
    		if (val( $_SESSION, 'screen_width' ) <= 510)
    			$low_res = true;
    		else
    			$low_res = false;
		}

		
		return ($low_res);
	}


		/* run an SQL query and terminate if it fails */


    function run_query( $queryx, &$cxn )
	{
        $result = $cxn->query( $queryx );

		if ($result == false)
		{
		    $result2 = $cxn->query( "SELECT CURRENT_USER();" );

            $data = $result2->fetch_assoc();		    
            
		    if ($data['CURRENT_USER()'] == "academi1_read@localhost")
		        echo red( "Database is open in read-only mode, update not processed.<br><br>" );
    		else
    			crash( "<span class='gblack'>Internal error: ".($cxn->errno)." ".($cxn->error)."\n<br><br>Query: ".$queryx."\n<br><br>Script terminated</span>", $cxn );
		}

		return $result;
	}



		/* read a row from a query and return it in the format $data['fieldname'] */

	function get_row( $result )
	{
        $data = $result->fetch_assoc();

		return $data;
	}



	function show_green_button_submit( $text, $size, $html_form_name="form" )	
	{
		$this_size = $size * 0.85;


			// current style, green with square rounded corners	
			
		if (! low_res_screen())
		{
			echo "<div onclick=\"document.forms.".$html_form_name.".submit()\" class='greenbuttondesktop' style='line-height: 25px; width:".$this_size."px;' align='center'>".$text."</div> ";			
		}
		else
		{
			echo "<div onclick=\"document.forms.".$html_form_name.".submit()\" class='greenbuttonmobile' style='line-height: 22px; width:".$this_size."px;' align='center'>".$text."</div> ";						
		}

	}

		/* fix up a text string for use in an sql query */

	function prep_for_sql( $text )
	{
		$text = str_replace( "'", "''", $text );

		$text = str_replace( "\\", "", $text );

		return ($text);
	}



	function form_textarea( $prompt, $name, $rows, $cols, $init )
	{
//		if (ord(substr( $init, 0, 1 )) == 13)
//			$this_init = " ".$init;
//		else

			$this_init = $init;
	
	    if (! low_res_screen())
		    echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><textarea name='".$name."' class='finput' rows='".$rows."' cols = '".$cols."'>".$this_init."</textarea></td></tr>\n";
		else
		{
	        $width = val( $_SESSION, "screen_width" ) * 0.85;

//            echo $width."<br>";
            
            if ($width == 0)
                $width = 320;
                
		    echo "<tr><td><br><span class='fprompt'>".$prompt."</span><br><textarea name='".$name."' style='width: ".$width."px' class='finput' rows='".$rows."' >".$this_init."</textarea></td></tr>\n";
		}		    
	}


		/* convert a string into a format suitable for HTML display */
		/* replaces '\n' with '<br>' and '<' with '&lt' */

	function convert_to_html( $text )
	{
		$text = htmlspecialchars( $text );		/* changes '<' to '&lt' */
		$text3 = "";

		for ($i=0; $i < strlen( $text ); $i++)
		{
			$ch = substr( $text, $i, 1 );

			if ($ch == "\n")
				$text3 = $text3."<br>";
			else
				$text3 = $text3.$ch;
		}

		return $text3;
	}


		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler )
	{
		                                                                    // box-shadow: 10px 10px 5px #888888;
		echo "<form id='form' name='form' action='".$handler."' method='POST'><table style='border: 1px solid #dddddd; border-radius: 10px; background: #eeeeee;); '>\n";
	}


		/* functions for generating HTML form fields */

	function form_text( $prompt, $name, $size, $init, $auto_focus="false" )
	{
        $init = str_replace( "'", "&#39", $init );

		if ($auto_focus == "true")
			$auto_focus_text = "autofocus";
		else
			$auto_focus_text = "";

        if (! low_res_screen())
    		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input class='finput' ".$auto_focus_text." type='text' name='".$name."' id='".$name."' size='".$size."' value='".$init."'></td></tr>\n";
        else			
		    echo "<tr><td><br><span class='fprompt'>".$prompt."</span><br><input class='finput' ".$auto_focus_text." type='text' name='".$name."' id='".$name."' size='".$size."' value='".$init."'></td></tr>\n";
	}



	function form_checkbox( $prompt, $name, $curr )
	{
		$checked = "";

		if ($curr == "on")
			$checked = "checked";

		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input type='checkbox' id = '".$name."' name='".$name."' ".$checked."></td></tr>\n";
	}


		// new style buttons using CSS and javascript, not GIF's
		
	function form_submit_new( $text, $width )
	{
		echo "<tr><td></td><td><br><br>";

		show_green_button_submit( $text, $width );

		echo "</td></tr>";
	}


		/* end of a form  */

	function form_end()
	{
		echo "</table></form>";
	}


		// write the javascript code to highlight the text box that has the focus in yellow background and put a red border around it
		
		// NOTE: the form_start must have an entry 'id = "form"' as well as 'name = "form"'
		
	function write_yellow_input_boxes()
	{
	
		echo ' <script>';
		echo ' var x = document.getElementById( "form" );';
		echo ' x.addEventListener( "focus", myFocusFunction, true );';
		echo ' function myFocusFunction() ';
		echo ' {';
		echo '     for (var i=0; i < form.elements.length; i++)';
		echo '     {';
		echo '         var e = form.elements[i];';
		echo '';		
		echo '	       if (e.type == "text" || e.type == "textarea" || e.type == "password" || e.type == "select-one")';
		echo '         {';				
		echo '             e.style.backgroundColor = "";';
		echo '             e.style.borderColor = "#cccccc";';
		echo '         }';					
		echo '     }';
		echo '';
		echo '     if (document.activeElement.type == "text" || document.activeElement.type == "textarea" || document.activeElement.type == "password" || document.activeElement.type == "select-one")';
		echo '     {';		
//		echo '         document.activeElement.style.backgroundColor = "lightyellow"; ';
        echo '         document.activeElement.style.borderColor = "red"; ';
		echo '     }';				
		echo ' }';
		echo ' </script>';


			// remove the blue border that Chrome puts around the input box that has the focus
		echo ' <style>';		
		echo 'textarea:focus, select:focus, input:focus ';
		echo '{';
		echo '    outline: none;';
		echo '}	';
		echo ' </style>';
	}	


?>