<?php

	include "library.php";

	include forms_library;

	include ad_forms_library;


	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );
    

			/* get variables */

	$advertiser_id = val( $_SESSION, "advertiser_id" );

	$newadvertiserprofile = val( $_GET, "newadvertiserprofile" );



	$_SESSION['newadvertiserprofile'] = $newadvertiserprofile;
	

		/* check parameters */

	crash_if_missing( $newadvertiserprofile, "newadvertiserprofile missing in edit_advertiser", $cxn );

	
		/* if the user is not logged in them direct them to the login page then back to here */

	if ($newadvertiserprofile == "false" && $advertiser_id == "")
	{
		$_SESSION['nextpage'] = url_encode( "edit_advertiser.php", "newadvertiserprofile", $newadvertiserprofile );

	    jump_to_page( "advertiser_login.php" );		/* must happen before print output */

		exit();
	}

	

		/* this form edit window operates in three modes - a blank screen for a new
		profile, editing retrieved data for editing a profile, and editting the previously
		entered data after a validation error
		*/

		/* set the validation error flag  */

	if (val( $_SESSION, 'validation_error' ) == "true")
		$validation_error = "true";
	else
		$validation_error = "false";	/* blank or set to false */



		/* start the page */

	page_header( "Advertiser Account", $cxn );			
	

//	echo blue( "On completing your profile, you will have the option of only receiving messages from member's who's account details have been verified by the site.<br><br>" );

	if ($newadvertiserprofile == "true")
		echo blue( "To create an advertiser account please complete the information on this page and click on the 'Save' button at the bottom of the page<br><br><br>" );
	else
        echo blue( "Click on the 'Save' button at the bottom of the page to save your changes<br><br><br>" );


	initialise_screen_data( $advertiser_id, $newadvertiserprofile, "advertiser_profile", "advertiser_profile", $validation_error,  $screen_data, $screen_data_error, $cxn );


	if (val( $_SESSION, "validation_errors" ) != "")
		echo red( "<b>Please correct the errors below</b><br><br>".$_SESSION['validation_errors']."<br><br>" );


    form_start( "save_advertiser_go.php" );

	write_yellow_input_boxes();
	

	generate_screen_fields_one_pane( $newadvertiserprofile, "advertiser_profile", "false", $screen_data, $screen_data_error, $cxn );
			

	echo "</table><table width='100%'><td width='15%'></td><td width='20%'></td><td width='65%'></td></tr>";

	if (! low_res_screen())
		echo "<tr><td></td><td align='center'><br><br>";
	else
		echo "<tr><td colspan='3' align='center'><br><br>";
	
	show_green_button_submit( "Save", 80 );
	
	echo "</td></tr>";	


	if (! low_res_screen())
		echo "<tr><td></td><td align='center'><br><br>";
	else
		echo "<tr><td colspan='3' align='center'><br><br>";

	if ($newadvertiserprofile == "false")
		show_green_button( "Delete Account", 135, "delete_advertiser_profile.php" );		


	echo "</td></tr>";

	form_end();

    echo "<br>";


    echo "</body>";
	
    echo "</html>";

?>