<?php

	define( "error_log_filename", "/home/academi1/public_html/aubusinessesforsale/error_log.txt" );
    define( "online_status_filename", "/home/academi1/public_html/aubusinessesforsale/online_status/online_status.txt" );
	define( "database_name", "academi1_aubusinessesforsale" );
	define( "domain", "aubusinessesforsale.com" );
	define( "pathroot", "/home/academi1/public_html/aubusinessesforsale" );
	define( "http_protocol", "https" );
    define( "sitename", "Australian Businesses for Sale Platform" );
	define( "common_data_database_name", "academi1_commondata" );


	include "/home/academi1/public_html/common_code/common_library.php";
	include "/home/academi1/public_html/common_code/forms_library.php";



	function start_code( $first=false, $db="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

//		$domain_root = substr( $domain, 4, strlen( $domain ) - 4 );
//		$domain_root = substr( $domain_root, 0, strlen( $domain_root ) - 4 );

		session_start();

//		$_SESSION['domain'] = $domain;
//		$_SESSION['pathroot'] = "/home/academi1/m-m-ventures.com/aubusinessesforsale";
//      $_SESSION['http_protocol'] = "https";
        
        

			/* set up variables */

//		$database = "academi1_aubusinessesforsale";
//
//        if ($db != "")
//		    $database = $db;
//		    
//        $_SESSION['database'] = $database;
//
//		$user = val( $_GET, "user" );


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", error_log_filename );

			// don't enable these options as they my expose technical details of the site to viewers
		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
		ini_set( "gc_maxlifetime", 3*60*60 );		/* set session timeout to 3 hours */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
		if (! $first )
			check_url();

		$cxn = db_login( database_name );

//                if ($cxn == 0)
//                    echo $domain."<br>";


		return ($cxn);
	}

		
		/* generate the heading line for a page */

		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn, $dont_jump=false )
	{

//		echo "<html><head><meta http-equiv='expires' content='".date( "D, d M Y", time() + 60*60*24*2 )." 00:00:00 GMT'>";

//		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'><meta http-equiv='expires' content='".date( "D, d M Y", time() - 60*60*24 )." 00:00:00 GMT'>";
		
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

        echo "<meta name=\"keywords\" content='Australia,Business,Businesses,Listing,Listings,Sale'>";

        echo "<meta name='description' content='".sitename." is a free website for listing Businesses for Sale in Australia. The site is suitable for listing businesses of all sizes for sale and is completely free to use.'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";
		
		
        echo "<link rel='apple-touch-icon' sizes='57x57' href='/apple-icon-57x57.png'>";
        echo "<link rel='apple-touch-icon' sizes='60x60' href='/apple-icon-60x60.png'>";
        echo "<link rel='apple-touch-icon' sizes='72x72' href='/apple-icon-72x72.png'>";
        echo "<link rel='apple-touch-icon' sizes='76x76' href='/apple-icon-76x76.png'>";
        echo "<link rel='apple-touch-icon' sizes='114x114' href='/apple-icon-114x114.png'>";
        echo "<link rel='apple-touch-icon' sizes='120x120' href='/apple-icon-120x120.png'>";
        echo "<link rel='apple-touch-icon' sizes='144x144' href='/apple-icon-144x144.png'>";
        echo "<link rel='apple-touch-icon' sizes='152x152' href='/apple-icon-152x152.png'>";
        echo "<link rel='apple-touch-icon' sizes='180x180' href='/apple-icon-180x180.png'>";
        echo "<link rel='icon' type='image/png' sizes='192x192' href='/android-icon-192x192.png'>";
        echo "<link rel='icon' type='image/png' sizes='32x32' href='/favicon-32x32.png'>";
        echo "<link rel='icon' type='image/png' sizes='96x96' href='/favicon-96x96.png'>";
        echo "<link rel='icon' type='image/png' sizes='16x16' href='/favicon-16x16.png'>";

			/* javascript functions for chat etc. */


// commented out due to crashes. previously fully functional
//
//		write_js_functions();


//	$_SESSION['sitename'] = 'Australian Businesses for Sale Platform';


			/* define styles */

        echo "<style>";
        
		write_common_styles();
		
		$data = define_styles();

        echo "</style>";

		$bg = $data['bg'];
		$rose = $data['rose'];


        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();

		if ($heading != "")
		{
			echo "<title>".sitename.": ".$heading."</title></head>";
		}
		else
		{
			echo "<title>".sitename."</title></head>";
		}


        if (val( $_SESSION, "screen_width" ) == "")
    		echo "<body onload='js_set_screen_parameters();' bgcolor='".$bg."'>";
    	else
    		echo "<body bgcolor='".$bg."'>";


		if ($heading != "")
		{
		    $show_heading_bar = false;

            if ($show_heading_bar)
            {
            	echo "<style> html, body {";
            	echo "margin:0;";
            	echo "padding:0;";
            	echo "}";
            	echo "</style>";

        		echo "<table cellspacing='0' width='100%'><tr><td style='padding-top: 3; padding-bottom: 3; font-family: Calibri; font-size: 13pt; color: #ffffff; background-color: #004499' valign='middle' align='left'>&nbsp;&nbsp;Australian Businesses for Sale Platform</td></tr></table>";
            }
            else
            {
    			echo "<table width='100%'><td width='30%'><span class='pgheading' valign='center'>".$heading."</span></td>";
    
    			if (! low_res_screen())
    			{
        			echo "<td width='10%' valign='center'><a class='redlink' href='".url_encode( "search_listings.php" )."'>search</a></td>";
        			echo "<td width='10%'></td>";
        			echo "<td width='10%' valign='center'><a class='redlink' href='".url_encode( "mailboxes.php", "box", "inbox" )."'>messages</a></td>";
        			echo "<td width='10%'></td>";
    			}
    			
    			echo "<td width='5%'></td>";
            }

			if ($show_heading_bar)
			    echo "<table width='100%'><tr>";
            
////			if (! low_res_screen())
//				show_google_translate();

			if ($show_heading_bar)
			    echo "<td width='55%' align='left'></td>";
			    
    		echo "<td width='20%' align='center'>";
    		
    		show_green_button( "Home", 80, "/" );
    		
    		echo "</td></tr></table>";

			echo "<br>";
		}
		else
		{
//    		if (! low_res_screen() && ! $home_page)    		
//			{
//				echo "<table width='100%'><tr><td width='80%'></td><td>";
//
//				show_google_translate();
//
//				echo "</td></tr></table>";
//			}
		}

				
		log_page_view( $cxn );
				
	}

		/* define the CSS styles */

	function define_styles()
	{
		$color_scheme = val( $_SESSION, 'color_scheme' );

				/* standard */

//		if ($color_scheme == "" || $color_scheme == 0 || $color_scheme == 3)

		{
			$bg = '#ffffff';

			$rose = "images/rose.gif";
			
			echo "body   		{ color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo "a:visited	{color: #0000bb; text-decoration: underline}";
			echo "a:link	{color: #0000bb; text-decoration: underline}";

			if (! low_res_screen())
			{			
				echo ".mainmenuheading    { color: #cc0000; background-color: #dddddd; font-family: verdana; font-size: ".fs( 12 )."pt}";
							
				echo ".mainmenuitem		{color: #0000cc; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:visited	{color: #0000cc; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:link	{color: #0000cc; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:hover	{color: #cc0000; background-color: #f3f3f3; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
			}
			else
			{
				echo ".mainmenuheading    { color: #cc0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
							
				echo ".mainmenuitem		{color: #0000cc; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:visited	{color: #0000cc; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:link	{color: #0000cc; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
				echo ".mainmenuitem:hover	{color: green; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
			}
			echo ".hl {cursor: pointer; color: #bb0000; background-color: #e0e0e0; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
			echo ".uhl {color: #0000bb; background-color: #f3f3f3; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

			echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gblue          { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".ggrey          { color: #bbbbbb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".gemail         { color: #ff0000; font-family: courier; font-size: ".fs( 12 )."pt}";

			echo ".fprompt        { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".dprompt        { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".dtext          { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".paraheading    { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".pgheading      { color: #007500; font-family: verdana; font-size: ".fs( 16 )."pt}";
			
			if (! low_res_screen())
				echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 26 )."pt}";
			else
				echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 20 )."pt}";
				
			echo ".glink		  { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:visited  { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:link     { color: #007500; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".glink:hover    { color: darkgreen; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".redlink:visited { text-decoration: none; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:link  { text-decoration: none; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".redlink:hover { text-decoration: underline; color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			
			echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".chat		      { color: #000000; font-family: verdana; font-size: ".fs( 10 )."pt}";

		}

		$data['bg'] = $bg;
		$data['rose'] = $rose;

		return ($data);
	}


        
    function log_page_view( $cxn )
    {
        $ip_country = get_ip_country( $cxn );
        
        $today_date = date( "Y-m-d" );
        
        $query = "SELECT id FROM page_views WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."'";
        
        
            // on rare occasions there may be two records created for one date if two users are checking and adding at the same time.
            
        if (query_has_rows( $query, $cxn ))
        {
            $query = "UPDATE page_views SET count = count + 1 WHERE page_view_date = '".$today_date."' AND ip_country = '".$ip_country."'";
            
            $result = run_query( $query, $cxn );
        }
        else
        {
            $query = "INSERT INTO page_views (page_view_date, ip_country, count) VALUES ('".$today_date."', '".$ip_country."', 1 )";
            
            $result = run_query( $query, $cxn );            
        }
    }

		/* create a list of industries for a drop-down list */

	function build_industry_list( $cxn )
	{
//		$query = "SELECT * FROM static_data WHERE type = 'industry' ORDER BY value";
		$query = "SELECT * FROM industry ORDER BY display_name";
		
		$result = run_query( $query, $cxn );

		$industries = "<option></option>";

		for ($i=0; $i < query_num_rows($result); $i++)
		{
			$data = get_row( $result );

			$industries = $industries."<option>".$data['display_name']."</option>";
		}

		return $industries;
	}



	function show_photo( $listing_id, $height, $photo_number, $allow_zoom, $large, $cxn )
	{
		if ($photo_number == -1)
			$query = "SELECT * FROM photos WHERE listing_id = ".$listing_id." AND primary_photo = 'yes'";
		else
			$query = "SELECT * FROM photos WHERE listing_id = ".$listing_id." AND photo_number = ".$photo_number;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
		{
            show_no_photo( $height );
		}
		else
		{
			$data = get_row( $result );

			$width = $height * $data['aspect_ratio'];
			
			$version = $data['version'];
			
			
			    // allow for revised versions of photos due to rotating them etc.
			    
			if ($version == "")
			    $version_str = "";
			else
			    $version_str = "_v".$version;

			if ($large)
				$filename = "/photos/photo_".$listing_id."_".$data['photo_number']."_l".$version_str.".".$data['file_extension'];
			else
				$filename = "/photos/photo_".$listing_id."_".$data['photo_number']."_sm".$version_str.".".$data['file_extension'];

			if ($allow_zoom)
			{
				echo "<a href='".url_encode( "show_large_photo.php", "showid", $listing_id, "photonumber", $photo_number )."'>";
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."' border='0'>";
				echo "</a>";
			}
			else
				echo "<img alt='Member Photo' src='".url_encode_file( $filename )."' width='".$width."' height='".$height."'>";
		}
	}





	function show_listing_number( $listing_id, $returnpoint, $startpos )
	{
		if ($startpos == "")
			$startpos = "x";

		$url = url_encode( "display_listing.php", "showid", $listing_id, "returnpoint", $returnpoint, "startpos", $startpos );

		return ("<a href='".$url."'><span class='glink'>".$listing_id."</span></a>");
	}


	function show_listing_heading( $listing_id, $headline_title, $returnpoint, $startpos )
	{
		if ($startpos == "")
			$startpos = "x";

		$url = url_encode( "display_listing.php", "showid", $listing_id, "returnpoint", $returnpoint, "startpos", $startpos );

		return ("<a class='glink' href='".$url."'>".$headline_title."</a>");
	}



		// don't put in the common library because there is a different tracking ID for each site
		
		// currently uses the Academic Dating tracking ID
		
	function show_google_translate()
        {
            echo "<td width='15%' valign='top'>";
            echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
            echo ' function googleTranslateElementInit() { ';
            echo " new google.translate.TranslateElement({pageLanguage: 'en', gaTrack: true, gaId: 'UA-97849346-2'}, 'google_translate_element'); ";            
            echo ' } ';
            echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
            echo "</td>";
        }



		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
			// azure login credentials
		
//		$host="mlmlocalhost.mysql.database.azure.com";
//		$user="mlm1@mlmlocalhost";
//		$password="Tree$%12";
		
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";


        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}




		// Log into the common database. Must happen AFTER the login to the normal local database $cxn as it's set up for this
		// function only to create a second connection
		
//	function db_common_login()
//	{
//		$host="localhost";
//		$user="academi1_mlm1";
//		$password="plastic1";
//
//
//      $cxn_common = new mysqli( $host, $user, $password, "academi1_commondata" );
//      
//		if ($cxn_common->connect_errno)
//		{
//			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
//			
//			echo "Error number: ".$cxn_common->connect_errno."<br>";
//			echo "Error text: ".$cxn_common->connect_error."<br>";
//
//			exit();
//		}
//
//		return $cxn_common;
//	}	


		/* send an email to a member */

	function send_external( $to_id, $subject, $text_body, $html_body, $cxn, $queue )
	{
		$from_name = sitename;
		$from_addr = "noreply@aubusinessesforsale.com";
		$reply_name = sitename;
		$reply_addr = "noreply@aubusinessesforsale.com";

		$query = "SELECT email_address FROM account WHERE id = ".$to_id;

		$result = run_query( $query, $cxn );

		$data = get_row( $result );

			/* for prod use the live address, otherwise redirect */

		$domain = val( $_SERVER, "HTTP_HOST" );

		$to_addr = $data['email_address'];


		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );


		return ($to_addr);
	}


	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	
		if ($form_name == "abfs_account")
		{
			$screen_data['confirm_email_address'] = $screen_data['email_address'];
			
			$screen_data['confirm_password'] = $screen_data['password'];
			
			if ($newrecord == "false")
				$screen_data['accepts_conditions'] = "on";
		}
		
	}


	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn )
	{
	    
		if ($form_name == "abfs_account")
        {		
			if (! check_username( $newrecord, $screen_data['username'], $id, $cxn ))
			{
				$validation_errors = $validation_errors."This username name has already been used for an existing account<br>";
				$screen_data_error['username'] = "true";
			}
	    }
	
		if ($form_name == "abfs_account" || $form_name == "abfs_listing")
		{
			if ($screen_data['accepts_conditions'] != "on")
			{
				$validation_errors = $validation_errors."You must tick the checkbox at the bottom of the page signifying that you accept the conditions of use of this website.<br>";
	
				$screen_data_error['accepts_conditions'] = "true";
			}
		}
		
	}


		// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	}


	function show_ads( $cxn )
	{
    
		echo "<table width='100%'><tr><td align='center'>\n";

	    show_ads_large_banner();

//		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
//
//            // New Ads 2 Wide Banner (Australian Businesses for Sale)
//
//		echo "<ins class='adsbygoogle'\n";
//		echo "style='display:inline-block;width:728px;height:90px'\n";
//		echo "data-ad-client='ca-pub-7728790744816510'\n";
//		echo "data-ad-slot='9368961125'></ins>\n";
//		echo "<script>\n";
//		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
//		echo "</script>\n";
//
		echo "</td></tr></table>\n";
	}


//    function show_ads_responsive()
//    {
//		echo "<table width='100%'><tr><td align='center'>\n";
//
//		echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n";
//
//		echo "<ins class='adsbygoogle'\n";
//		echo "style='display:block'\n";
//		echo "data-ad-client='ca-pub-7728790744816510'\n";
//		echo "data-ad-slot='1989264595'\n";
//		echo "data-ad-format='auto'></ins>\n";
//		echo "<script>\n";
//		echo "(adsbygoogle = window.adsbygoogle || []).push({});\n";
//		echo "</script>\n";
//
//		echo "</td></tr></table>\n";
//	}



//	function show_ads_narrow_banner()
//	{
//		echo "<table width='100%'><tr><td align='center'>";
//
//        echo "<script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>";
//        
//            // New Ads 2 Narrow Banner (Australian Businesses for Sale Platform)
//        
//        echo "<ins class='adsbygoogle'";
//        echo "style='display:inline-block;width:320px;height:100px'";
//        echo "data-ad-client='ca-pub-7728790744816510'";
//        echo "data-ad-slot='2037366053'></ins>";
//        echo "<script>";
//        echo "(adsbygoogle = window.adsbygoogle || []).push({});";
//        echo "</script>";
//
//		echo "</td></tr></table>\n";
//	}


//	function show_ads_large_square()
//	{
//        echo black( "&nbsp;&nbsp;Advertisement" );
//	    
//		echo " <script async src='//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js'></script>\n ";
//		
//		    // New Ads 2 Large Square (Australian Businesses for Sale Platform)
//		
//		echo " <ins class='adsbygoogle'\n ";
//		echo "     style='display:inline-block;width:336px;height:280px'\n ";
//		echo "     data-ad-client='ca-pub-7728790744816510'\n ";
//		echo "     data-ad-slot='1075761886'></ins>\n ";
//		echo " <script>\n ";
//		echo " (adsbygoogle = window.adsbygoogle || []).push({});\n ";
//		echo " </script>\n ";
//
//	}


	
		// don't put in the common library because different sites have different color schemes
		
	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
			//lightskyblue  #cceeff azure
			// lighter color first
			
		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #bbbbbb; background: linear-gradient(#fcfcfc, #fcfcfc)'>\n";

	}

        // show the menu bar for the FAQ, Policies etc pages
        
	function show_info_menu( $cxn )
	{
		$bg = "#73b8bb";

        echo "<style>";
        echo "table.infomenubartable td {";
        echo "    color: #000000;";
//        echo "    line-height: 25pt;";
        echo "    font-size: ".fs( 12) ."pt;";
        echo "    font-family:verdana;";
        echo "    background-color: #73b8bb;";
        echo "}";
        
        echo "table.infomenubartable td:hover {";
        echo "      background-color: #eeeeee;";
        echo "      cursor: pointer;";
        echo "}";        
        echo "</style>";

		echo "<table class='infomenubartable' width='100%' border='0' cellspacing='0'>";

		echo "<tr bgcolor='".$bg."' >";

		echo show_one_info_menu_item( "FAQ", "faq.php" );
		
		echo show_one_info_menu_item( "Policies", "policies.php" );		
		
		echo show_one_info_menu_item( "Costs", "charges.php" );		

		echo show_one_info_menu_item( "About Us", "about_us.php" );		

		echo show_one_info_menu_item( "Contact Us", "contact_us.php" );		
		
//		echo show_one_info_menu_item( "Tips", "tips.php" );

		echo "</tr>";

		echo "</table>";
	}


        // show one item on the information menu bar
        
	function show_one_info_menu_item( $prompt, $page )
	{
		return "<td height='40' style='background-color: #73b8bb' width='4%'></td><td width='6%' align='center' onclick='location.href=\"".url_encode( $page )."\"'>".$prompt."</td><td style='background-color: #73b8bb' width='4%'></td>";
	}


    function show_latest_listings( $cxn )
    {
    	$query = "SELECT account.id as account_id, listing.id as listing_id, listing.currency_code, listing.price, listing.show_price_on_site, listing.city, listing.state, listing.country, listing.headline_title, listing.short_description from listing INNER JOIN account ON listing.account_id = account.id WHERE account.deleted = 'no' AND listing.deleted = 'no' ORDER BY listing.id DESC LIMIT 10";

    	$result = run_query( $query, $cxn );
    
    	$found_one = "false";
    

    	for ($i=0; $i < query_num_rows($result); $i++)
    	{
    		$found_one = "true";
    
    		$data = get_row( $result );

    		echo "<a name='id".$data['listing_id']."'>";		/* bookmark to go back to search screen */
    
        		echo "<table width='100%'<tr>";
    
    		echo "<td width='5%'>";
    		
    		echo "&nbsp;".watermark( $data['listing_id'] );
    
//    		echo "</td><td width='16%' align='center'>";
    
//    		show_photo( $data['listing_id'], 125, -1, true, false, $cxn );
    
    		echo "</td><td width='10%' align='center'>";
    
            if ($data['show_price_on_site'] == "on")
    			echo black( $data['currency_code']." ".number_format( floatval( $data['price'] )));
    			
    		echo "</td>";
    
    		echo "<td width='42%'><b>";
    		
            $start_pos = 0;
    
    		echo show_listing_heading( $data['listing_id'], $data['headline_title'], "search", $start_pos )."</b><br><br>";

    		echo black( convert_to_html( $data['short_description'] ) )."<br><br></td>";
    		
    		echo "<td width='2%'></td>";
    
            if (! low_res_screen())
            {
        		echo "<td width='8%' aligh='left'>".black( name_case( $data['city'] ) )."</td>";
        		
                if ($data['state'] != "")
            		echo "<td width='8%' aligh='left'>".black( name_case( $data['state'] ) )."</td>";
            	else
            		echo "<td width='8%' aligh='left'></td>";
        		
    			echo "<td width='8%' aligh='left'>".black( $data['country'] )."</td>";
            }
            else
            {
        		echo "<td width='10%' aligh='left'>".black( name_case( $data['city'] ) )."<br><br>";
    
                if ($data['state'] != "")
            		echo black( name_case( $data['state'] ) )."<br><br>";
        		
    			echo black( $data['country'] )."</td>";
            }
    

    		echo "</tr></table><hr>";
    	}

    }


		/* send the email to the user allowing them to verify their email address */

	function send_verification_email( $id, $email_verification_code, $cxn )
	{
		$first_name = "";
	
		$query = "SELECT first_name FROM account WHERE id = ".$id;

		if (query_has_rows( $query, $cxn ))
		{
			$result = run_query( $query, $cxn );
			$data = get_row( $result );
			$first_name = $data['first_name'];
		}

		$domain = val( $_SERVER, "HTTP_HOST" );
		
		$subject = "Verification email from the ".sitename;

		$url = url_encode( http_protocol."://".domain."/verify_email.php", "verifyid", $id, "code", $email_verification_code );
		

		$text_body = "Hi ".$first_name.",\n\nThank you for joining the Australian Businesses for Sale Platform.\n\nTo activate your account please copy and paste the following text into your browser address bar and press enter\n\n";
		$text_body .= $url;

		$text_body .= "If the link does not work when you click on it please copy and paste the following text into your browser address bar and press enter:<br><br>";
		
		$text_body .= $url;


		$html_body = "Hi ".$first_name.",<br><br>Thank you for joining the Australian Businesses for Sale Platform.<br><br>To activate your account please click on the link below<br><br>";
//		$html_body .= show_link( "activate account", http_protocol."://".$domain."/verify_email.php", "verifyid", $id, "code", $email_verification_code );

		$html_body .= "<a href='".$url."'>activate account</a><br><br><br><br>";		
		
		$html_body .= "If the link does not work when you click on it please copy and paste the following text into your browser address bar and press enter:<br><br>";
		
		$html_body .= $url;
		

		return (send_external( $id, $subject, $text_body, $html_body, $cxn, "live" ));
	}


			/* check to see whether a new user has selected an existing handle */

	function check_username($newprofile, $username, $id, $cxn)
	{
		$username = str_replace( "'", "''", $username);

		if ($newprofile == "true")
			$query = "SELECT username FROM username_history WHERE username = '".$username."'";
		else
			$query = "SELECT username FROM username_history WHERE username = '".$username."' AND account_id <> ".$id;

		$result = run_query( $query, $cxn );

		if (query_num_rows($result) == 0)
			return true;
		else
			return false;
	}

    function generate_custom_fields( $newrecord, $form_name, $field_name, $right_side_pane, $screen_data, $screen_data_error, $cxn )
    {
    }
