<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";

	$cxn = start_code( true );


	$start_date = val( $_POST, "start_date" );

	$end_date = val( $_POST, "end_date" );
	

	$report_start_date = convert_date_to_yyyymmdd( $start_date, "dd/mm/yyyy", $cxn );

	$report_end_date = convert_date_to_yyyymmdd( $end_date, "dd/mm/yyyy", $cxn );



    page_header( "", $cxn );


    echo "<br><br><br>";


    $query = "SELECT SUM(price_charged) as total FROM appointment WHERE date >='".$report_start_date."' AND date <= '".$report_end_date."' AND status = 'COMPLETE' and deleted = 'no'";

	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );
		
		$services_sales = $data['total'];
	}

    if ($services_sales == "")
        $services_sales = 0;


    echo black( "Services sales: $".number_format_needed( $services_sales ) );
    
    echo "<br><br>";


    $query = "SELECT SUM(price) as total FROM retail_sale WHERE sale_date >='".$report_start_date."' AND sale_date <= '".$report_end_date."'";

	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );
		
		$retail_sales = $data['total'];
	}

    if ($retail_sales == "")
        $retail_sales = 0;


    echo black( "Retail sales: $".number_format_needed( $retail_sales ) );
    
    echo "<br><br>";


    $query = "SELECT SUM(price) as total FROM gift_voucher WHERE sale_date >='".$report_start_date."' AND sale_date <= '".$report_end_date."'";

	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );
		
		$gift_voucher_sales = $data['total'];
	}

    if ($gift_voucher_sales == "")
        $gift_voucher_sales = 0;

    echo black( "Gift vouchers sold: $".$gift_voucher_sales );
    
    echo "<br><br><br>";


    $query = "SELECT SUM(price_charged) as total FROM ((SELECT price_charged FROM appointment WHERE date >='".$report_start_date."' AND date <= '".$report_end_date."' AND status = 'COMPLETE' AND payment_format = 'EFT' and deleted = 'no')";
    
    $query .= "UNION ALL (SELECT price as price_charged FROM retail_sale WHERE sale_date >='".$report_start_date."' AND sale_date <= '".$report_end_date."' AND payment_format = 'EFT')";

    $query .= "UNION ALL (SELECT price as price_charged FROM gift_voucher WHERE sale_date >='".$report_start_date."' AND sale_date <= '".$report_end_date."' AND payment_format = 'EFT')) as x";


	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );

        $eft_sales = $data['total'];
	}

    if ($eft_sales == "")
        $eft_sales = "0";


    echo black( "EFT sales: $".number_format_needed( $eft_sales ) );
    
    echo "<br><br>";


    $query = "SELECT SUM(price_charged) as total FROM ((SELECT price_charged FROM appointment WHERE date >='".$report_start_date."' AND date <= '".$report_end_date."' AND status = 'COMPLETE' AND payment_format = 'CASH' and deleted = 'no') ";

    $query .= "UNION ALL (SELECT price as price_charged FROM retail_sale WHERE sale_date >='".$report_start_date."' AND sale_date <= '".$report_end_date."' AND payment_format = 'CASH')";

    $query .= "UNION ALL (SELECT price as price_charged FROM gift_voucher WHERE sale_date >='".$report_start_date."' AND sale_date <= '".$report_end_date."' AND payment_format = 'CASH')) as x";


	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );

        $cash_sales = $data['total'];
	}

    if ($cash_sales == "")
        $cash_sales = "0";


    echo black( "Cash sales: $".number_format_needed( $cash_sales ));
    
    echo "<br><br><br><br>";


    echo "&nbsp;&nbsp;<span class='green_heading'>Completed appointments ".$start_date." to ".$end_date."</span>";

    echo "<br><br><br>";


    $query = "SELECT *, appointment.id as appointment_id FROM appointment LEFT JOIN client ON client.id = appointment.client_id WHERE date >='".$report_start_date."' AND date <= '".$report_end_date."' AND status = 'COMPLETE'  and deleted = 'no' ORDER BY date DESC";
    
	$result = run_query( $query, $cxn );

    echo "<table>";

    echo "<tr>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Appointment<br>date" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Client" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Services" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Stylist" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Appointment<br>time" )."</td>";
    echo "<td width='5%' valign='top' align='center'>".blue( "Appointment length" )."</td>";
    echo "<td width='1%' valign='top' align='center'>&nbsp;</td>";
    echo "<td width='30%' valign='top' align='center'>".blue( "Notes" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Status" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Price charged" )."</td>";
    echo "<td width='1%' valign='top' align='center'>&nbsp;</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Payment type" )."</td>";
    echo "<td width='8%' valign='top' align='center'>&nbsp;</td>";
    echo "</tr>";

    $total = 0;


	for ($i=0; $i < query_num_rows( $result ); $i++)
	{
		$data = get_row( $result );

        $services_list = get_services_list( $data['appointment_id'], $cxn );


        $appt_hrs = intval( $data['end_time'] - $data['start_time'] );
        
        $appt_mins = (( $data['end_time'] - $data['start_time'] ) - intval( $data['end_time'] - $data['start_time'] )) * 60;
        
        
        $query2 = "SELECT * FROM times WHERE value = ".$data['start_time'];
    
    	$result2 = run_query( $query2, $cxn );

		$data2 = get_row( $result2 );

        $total += $data['price_charged'];
        
        echo "<tr>";
        echo "<td width='8%'>".black( ad_format_date( $data['date'], "dd/mm/yyyy" ))."</td>";
        echo "<td width='8%'>".black( $data['first_name']." ".$data['surname'] )."</td>";
        echo "<td width='8%'>".black( $services_list )."</td>";
        echo "<td width='8%'>".black( $data['stylist'] )."</td>";
        echo "<td width='8%'>".black( $data2['display_name'] )."</td>";
        
        if ($appt_hrs == 0)
            echo "<td width='5%'>".black( $appt_mins." MIN " )."</td>";
        else
        if ($appt_mins == 0)
            echo "<td width='5%'>".black( $appt_hrs." HR " )."</td>";
        else
            echo "<td width='5%'>".black( $appt_hrs." HR ".$appt_mins." MIN " )."</td>";
        
        echo "<td width='1%'>&nbsp;</td>";
        echo "<td width='30%'>".black( $data['notes'] )."</td>";
        echo "<td width='8%'>".black( $data['status'] )."</td>";
        echo "<td width='8%' align='right'>".black( "$".$data['price_charged'] )."</td>";
        echo "<td width='1%'>&nbsp;</td>";
        echo "<td width='8%'>".black( $data['payment_format'] )."</td>";
        echo "<td width='8%'>&nbsp;</td>";
        echo "</tr>";
	}
    
    echo "</table>";

    echo "<br>";
    echo "<br>";
    
    echo black( "Total sales: ".number_format_needed( $total ) );
    
    
    echo "<br><br><br>";

    echo show_home_link();    

    echo "<br><br><br>";
?>