<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";

	$cxn = start_code( true );


    page_header( "", $cxn );

    echo "<br><br>";



    $query = "SELECT SUM(price) as total FROM retail_sale WHERE sale_date = '".date( "Y-m-d" )."'";

	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );
		
		$retail_sales = $data['total'];
	}

    if ($retail_sales == "")
        $retail_sales = 0;



    $query = "SELECT SUM(price) as total FROM gift_voucher WHERE sale_date = '".date( "Y-m-d" )."'";

	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );
		
		$gift_voucher_sales = $data['total'];
	}

    if ($gift_voucher_sales == "")
        $gift_voucher_sales = 0;



    $query = "SELECT SUM(price_charged) as total FROM ((SELECT price_charged FROM appointment WHERE date = '".date( "Y-m-d" )."' AND status = 'COMPLETE' and deleted = 'no') ";
    
    $query .= "UNION ALL (SELECT price as price_charged FROM retail_sale WHERE sale_date = '".date( "Y-m-d" )."')";

    $query .= "UNION ALL (SELECT price as price_charged FROM gift_voucher WHERE sale_date = '".date( "Y-m-d" )."')) as x";


	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );

        $sales = $data['total'];
	}


    $query = "SELECT SUM(price_charged) as total FROM ((SELECT price_charged FROM appointment WHERE date = '".date( "Y-m-d" )."' AND status = 'COMPLETE' AND payment_format = 'EFT' and deleted = 'no') ";
    
    $query .= "UNION ALL (SELECT price as price_charged FROM retail_sale WHERE sale_date = '".date( "Y-m-d" )."' AND payment_format = 'EFT')";

    $query .= "UNION ALL (SELECT price as price_charged FROM gift_voucher WHERE sale_date = '".date( "Y-m-d" )."' AND payment_format = 'EFT')) as x";


	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );

        $eft_sales = $data['total'];
	}


    $query = "SELECT SUM(price_charged) as total FROM ((SELECT price_charged FROM appointment WHERE date = '".date( "Y-m-d" )."' AND status = 'COMPLETE' AND payment_format = 'CASH' and deleted = 'no') ";

    $query .= "UNION ALL (SELECT price as price_charged FROM retail_sale WHERE sale_date = '".date( "Y-m-d" )."' AND payment_format = 'CASH')";

    $query .= "UNION ALL (SELECT price as price_charged FROM gift_voucher WHERE sale_date = '".date( "Y-m-d" )."' AND payment_format = 'CASH')) as x";


	$result = run_query( $query, $cxn );

	if (query_num_rows( $result ) > 0)
	{
		$data = get_row( $result );

        $cash_sales = $data['total'];
	}

    if ($sales == "")
        $sales = "0";
        
    if ($eft_sales == "")
        $eft_sales = "0";
        
    if ($cash_sales == "")
        $cash_sales = "0";
        

    echo "&nbsp;&nbsp;<span style='font-family: verdana; font-size: 26pt;'>Sales today $".$sales."</span>";
    
    
    echo "<br><br><br>";

    echo black( "EFT Sales today $".$eft_sales );
    
    echo "<br><br>";
    
  
    echo black( "Cash Sales today $".$cash_sales );
    
    echo "<br><br>";
 
    echo black( "Gift vouchers sold: $".$gift_voucher_sales );

    echo "<br><br>";


    echo black( "Retail sales: $".$retail_sales );

    echo "<br><br>";
    echo "<br><br>";
    
  

    echo "&nbsp;&nbsp;<span class='green_heading' >Reports list</span>";
    
    echo "<br><br>";

//    echo "&nbsp;&nbsp;".show_link( "Performance reports", "hourly_stats.php" );
 
//    echo "<br><br>";

    echo "&nbsp;&nbsp;".show_link( "Transaction Report", "reports_get_dates.php" )."<br>";
    
    echo "<br><br><br>";

    echo "&nbsp;&nbsp;<span class='green_heading' >Revenue by day</span>";
    echo "<br><br>";

    revenue_by_day( $cxn );
    
    echo "<br><br>";


    function revenue_by_day( $cxn )
    {
        echo "<table><tr><td>&nbsp;&nbsp;".black( "Day" )."</td><td>&nbsp;&nbsp;".black( "Date" )."</td><td>&nbsp;&nbsp;".black( "Revenue" )."</td></tr>";
        
//		echo "<tr><td>&nbsp;</td></tr>";
        
    	$this_date = date_create( date("Y-m-d") );

        $day_of_week = jddayofweek( gregoriantojd( date("m"), date("d"), date("Y") ) );
    
        for ($i=0; $i < 45; $i++)
        {
            display_day( $day_of_week, $this_date->format( "Y-m-d" ), $this_date->format( "D" ), $this_date->format( "d.m.Y" ), $cxn );
            
        	date_sub( $this_date, date_interval_create_from_date_string( '1 day' ));
    
        	$day_of_week = $day_of_week - 1;
        	
        	if ($day_of_week < 0)
        	    $day_of_week = 6;
        }
        
        echo "</table>";
    }
    
    function display_day( $day_of_week, $this_date_str, $day_str, $date_str, $cxn )
    {
		if ($day_of_week == 0)
		{
        	$start_date = date_create( $this_date_str );
        	
        	date_sub( $start_date, date_interval_create_from_date_string( '6 days' ));

            $start_date_str = $start_date->format( "Y-m-d" );
            

            $query = "SELECT SUM(price_charged) as total_revenue FROM appointment WHERE date >= '".$start_date_str."' AND date <= '".$this_date_str."' AND status = 'COMPLETE' and deleted = 'no'";
    
        	$result = run_query( $query, $cxn );
            
    		$data = get_row( $result );
    		
    		$week_total = $data['total_revenue'];


		    
    		echo "<tr><td>&nbsp;</td></tr>";

    		echo "<tr><td>&nbsp;&nbsp;".black( "Week total" )."</td><td></td>";
    		
    		echo "<td align='right'>&nbsp;&nbsp;".black( "$".number_format( $week_total, 0 ) )."</td></tr>";

//    		echo "<tr><td>&nbsp;&nbsp;".black( "<i>Commission</i>" )."</td><td></td>";
    		
//    		echo "<td align='right'>&nbsp;&nbsp;".black( "<i>$".number_format( $week_total * 0.6, 0 )."</i>" )."</td></tr>";
		}

        
        $query = "SELECT SUM(price_charged) as total_revenue FROM appointment WHERE date = '".$this_date_str."' AND status = 'COMPLETE' and deleted = 'no'";

    	$result = run_query( $query, $cxn );
        
		$data = get_row( $result );
		
		$day_total = $data['total_revenue'];
		
		echo "<tr><td>&nbsp;&nbsp;".black( $day_str )."</td><td>".black( $date_str )."</td>";
		
		echo "<td align='right'>&nbsp;&nbsp;".black( "$".number_format( $day_total, 0 ) )."</td></tr>";
    }

/*
    echo "&nbsp;&nbsp;<span class='green_heading' >Completed appointments today</span>";

    echo "<br><br><br>";


    $query = "SELECT *, appointment.id as appointment_id FROM appointment LEFT JOIN client ON client.id = appointment.client_id WHERE date = '".date( "Y-m-d" )."' AND status = 'COMPLETE' and deleted = 'no' ORDER BY start_time";
    
	$result = run_query( $query, $cxn );

    echo "<table>";

    echo "<tr>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Appointment<br>date" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Client" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Services" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Stylist" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Appointment<br>time" )."</td>";
    echo "<td width='5%' valign='top' align='center'>".blue( "Appointment length" )."</td>";
    echo "<td width='1%' valign='top' align='center'>&nbsp;</td>";
    echo "<td width='30%' valign='top' align='center'>".blue( "Notes" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Status" )."</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Price charged" )."</td>";
    echo "<td width='1%' valign='top' align='center'>&nbsp;</td>";
    echo "<td width='8%' valign='top' align='center'>".blue( "Payment type" )."</td>";
    echo "<td width='8%' valign='top' align='center'>&nbsp;</td>";
    echo "</tr>";


	for ($i=0; $i < query_num_rows( $result ); $i++)
	{
		$data = get_row( $result );

        $services_list = get_services_list( $data['appointment_id'], $cxn );

        $appt_hrs = intval( $data['end_time'] - $data['start_time'] );
        
        $appt_mins = (( $data['end_time'] - $data['start_time'] ) - intval( $data['end_time'] - $data['start_time'] )) * 60;
        
        
        $query2 = "SELECT * FROM times WHERE value = ".$data['start_time'];
    
    	$result2 = run_query( $query2, $cxn );

		$data2 = get_row( $result2 );

        echo "<tr>";
        echo "<td width='8%'>".black( ad_format_date( $data['date'], "dd/mm/yyyy" ))."</td>";
        echo "<td width='8%'>".black( $data['first_name']." ".$data['surname'] )."</td>";
        echo "<td width='8%'>".black( $services_list )."</td>";
        echo "<td width='8%'>".black( $data['stylist'] )."</td>";
        echo "<td width='8%'>".black( $data2['display_name'] )."</td>";
        
        if ($appt_hrs == 0)
            echo "<td width='5%'>".black( $appt_mins." MIN " )."</td>";
        else
        if ($appt_mins == 0)
            echo "<td width='5%'>".black( $appt_hrs." HR " )."</td>";
        else
            echo "<td width='5%'>".black( $appt_hrs." HR ".$appt_mins." MIN " )."</td>";
        
        echo "<td width='1%'>&nbsp;</td>";
        echo "<td width='30%'>".black( $data['notes'] )."</td>";
        echo "<td width='8%'>".black( $data['status'] )."</td>";
        echo "<td width='8%' align='right'>".black( "$".$data['price_charged'] )."</td>";
        echo "<td width='1%'>&nbsp;</td>";
        echo "<td width='8%'>".black( $data['payment_format'] )."</td>";
        echo "<td width='8%'>&nbsp;</td>";
        echo "</tr>";
	}
    
    
    echo "</table>";
*/

    echo "<br><br><br>";

    echo show_home_link();    
    
    echo "<br><br><br>";
    
?>