<?php
			// (c) Copyright Mark McIlroy 2020

	define( "common_data_database_name", "academi1_commondata" );
	define( "sitename", "ACV Appointments" );
	define( "sitecode", "ACV_APPOINTMENTS" );
	
//	define( "from_email_address", "mark.mcilroy@melbourneparaplanning.com" );
//	define( "reply_email_address", "mark.mcilroy@melbourneparaplanning.com" );
//	define( "manager_email_address", "mark.mcilroy@melbourneparaplanning.com" );
	define( "error_log_filename", "/home/academi1/public_html/appts/error_log.txt" );
    define( "form_border_color", "#888888" );

	define( "account_bank",                     "Bank account (1047)"                   );
	define( "account_sales_eft",                "Sales (Salon services EFT) (R1039)"    );
	define( "account_sales_cash",               "Sales (Salon services cash) (R1056)"   );
	define( "account_salon_cash_draw",          "Salon cash draw (A1058)"               );

    define( "calendar_start_time", "9" );
    

	include "/home/academi1/public_html/common_code/common_library.php";
	include "/home/academi1/public_html/common_code/forms_library.php";



    			/* startup code to be called at the top of each file */

	function start_code( $first=false, $db="" )
	{
			/* set up paths */

		$domain = val( $_SERVER, "HTTP_HOST" );

		session_start();

		$_SESSION['domain'] = $domain;

		$_SESSION['pathroot'] = "/home/academi1/public_html/appointments";


			/* set up variables */

		$database = "academi1_appts";


		$user = val( $_GET, "user" );


			/* remember user across pages */

			/* set config options */

		ini_set( "error_log", $_SESSION['pathroot']."/error_log.txt" );

			// don't enable these options as they my expose technical details of the site to viewers
		ini_set( "display_errors", "on" );
		ini_set( "display_startup_errors", "on" );

        error_reporting( E_ALL & ~E_DEPRECATED );
        
		ini_set( "gc_maxlifetime", 1*60*60 );		/* set session timeout to 1 hour */

		ini_set( "date.timezone", "Australia/Melbourne" );
		
//		if (! $first )
//			check_url();

		$cxn = db_login( $database );

	    log_hits( "", $cxn );


		return ($cxn);
	}



		/* generate the heading line for a page */


		/* NOTE: don't call this before any jump_to_page's or the jumps wont work */

	function page_header( $heading, $cxn )
	{
    	echo "<style> html, body {";
    	echo "margin:0;";
    	echo "padding:0;";
    	echo "}";
    	echo "</style>";

        if (val( $_SESSION, "client_view") == "true")
        {
            if (! low_res_screen())    
            	echo "<table cellpadding='0' id='siteheading' cellspacing='0' width='100%'><tr><td style='line-height: 30px; font-family: Calibri; font-size: 16.5pt; color: darkblue; ' align='left'>&nbsp;&nbsp;&nbsp;Indie Hair Appointments Calendar</td></tr></table>";
            else
            	echo "<table cellpadding='0' id='siteheading' cellspacing='0' width='100%'><tr><td style='line-height: 30px; font-family: Calibri; font-size: 14pt; color: darkblue; ' align='left'>&nbsp;&nbsp;&nbsp;Indie Hair Appointments Calendar</td></tr></table>";
        }
        


//        if (low_res_screen())    
//    	    echo "<br>";


        $_SESSION['sitename'] = sitename;

		$_SESSION['session_active'] = "yes";
		
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";

		echo '<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">';
		echo '<link rel="icon" href="/favicon.ico" type="image/x-icon">';



			/* define styles */

		echo "<style>";

		write_common_styles();
		
		define_styles();

		echo "</style>";


        if (val( $_SESSION, "screen_width" ) == "")
            write_screen_parameters_function();

    	echo "<script>";
    	echo "function js_set_screen_parameters2()";
    	echo "{";

        echo "  var request = new XMLHttpRequest();";
        echo "  request.open( 'GET', '/set_screen_parameters.php?sw='+screen.width+'&sh='+screen.height, false );";      // `false` makes the request synchronous
        echo "  request.send( null );";

        echo "  resize_appt_window();";
        
        echo "}";

        echo "function resize_appt_window()";
        echo "{";
        echo "    document.getElementById( 'appt_window' ).style.height = window.outerHeight - 243;";
        
        echo "    scroll_appt_window();";
        echo "}";

        echo "function appt_drag(ev)";
        echo "{";
        echo "    ev.dataTransfer.setData( 'text', ev.target.id );";
        echo "}";

        echo "function appt_drop(ev, stylist, effective_date, this_time)";
        echo "{";
        echo "    ev.preventDefault();";
        echo "    var cell_id = ev.dataTransfer.getData( 'text' );";
        echo "    location.href='/drag_drop_appointment.php?appointmentid='+cell_id+'&stylist='+stylist+'&effectivedate='+effective_date+'&thistime='+this_time;";
        echo "}";
        
        echo "function allowDrop(ev)";
        echo "{";
        echo "    ev.preventDefault();";
        echo "}";
        
        echo "function scroll_appt_window()";
        echo "{";
        
//        if (val( $_SESSION, "mode" ) != "new_appointment" && val( $_SESSION, "current_appointment_id" ) != "")
//            echo "    document.getElementById( '".val( $_SESSION, "current_appointment_id" )."' ).scrollIntoView();";
//        else
//            echo "    document.getElementById( '".val( $_SESSION, "appt_stylist" ).":".val( $_SESSION, "appt_start_date" ).":".val( $_SESSION, "appt_start_time" )."' ).scrollIntoView();";

        if (val( $_SESSION, "mode" ) == "new_appointment")
            echo "    document.getElementById( '".val( $_SESSION, "appt_stylist" ).":".val( $_SESSION, "appt_start_date" ).":".val( $_SESSION, "appt_start_time" )."' ).scrollIntoView();";
        else
        if (val( $_SESSION, "current_appointment_id" ) != "")
            echo "    document.getElementById( '".val( $_SESSION, "current_appointment_id" )."' ).scrollIntoView();";

        echo "    document.getElementById( 'siteheading' ).scrollIntoView();";
            
        echo "}";

        echo "</script>";

		if ($heading != "")
			echo "<title>".sitename.": ".$heading."</title></head>";
		else
			echo "<title>".sitename."</title></head>";


        if (! low_res_screen())
        {
            if (val( $_SESSION, "screen_width" ) == "")
        		echo "<body onload='js_set_screen_parameters2();' onresize='resize_appt_window();'>";
        	else
        		echo "<body onload='resize_appt_window();' onresize='resize_appt_window();'>";
        }
        else
        {
            if (val( $_SESSION, "screen_width" ) == "")
        		echo "<body onload='js_set_screen_parameters();'>";
        	else
        		echo "<body'>";
        }
   
        if (val( $_SESSION, "client_view") != "true")
        {
            show_main_menu();
            
    		echo "<table width='100%'><tr><td width='2%'>&nbsp</td><td width='98%'>";
    
    		if ($heading != "")
    		{
        		echo "<table width='100%' cellpadding='0' cellspacing='0'><tr><td width='80%' class='pgheading' valign='center' style='padding: 0px; border-collapse: collapse;'>".$heading."</td>";
    
    			echo "<td width='20%' align='center'>";
    
    			show_green_button( "Home", 80, "index.php", "internaljump", "true" );
    			
    			echo "</td></tr></table>";
    				
    			echo "<span style='font-size: 4pt'>&nbsp;<br></span>";
    		}
        }
	}


    function reports_heading()
    {
		echo "<html><head><meta name='viewport' content='width=device-width, initial-scale=1.0'>";

		echo "<meta http-equiv='Content-Type' content='text/html; charset=UTF-8'>";

		echo '<link rel="shortcut icon" href="/favicon.ico" type="image/x-icon">';
		echo '<link rel="icon" href="/favicon.ico" type="image/x-icon">';
        
		echo "<style>";

		write_common_styles();
		
		define_styles();

		echo "</style>";

        echo "<br>";
        
		echo "<span style='font-size: 12pt; color: #0000bb; font-family: verdana'>Appointments Reports</span>";
		
		echo "<br><br><br>";
    }

		/* define the CSS styles */

	function define_styles()
	{
		echo "body   		{ color: #000000; verdana; font-size: ".fs( 12 )."pt}";

		echo "a:visited	{color: #0000bb; text-decoration: underline}";
		echo "a:link	{color: #0000bb; text-decoration: underline}";

		echo "a.menubaritem			{color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:visited {color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:link	{color: #000000; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration:none}";
		echo "a.menubaritem:hover   {color: #000000; font-weight: bold; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".hl {cursor: pointer; color: #bb0000; background-color: #eeeeee; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";
		echo ".uhl {color: #0000bb; font-size:".fs( 12 )."pt; font-family:verdana; text-decoration: none}";

		echo ".gblack         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gblue          { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gred           { color: #bb0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".ggreen         { color: #00bb00; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gwatermark     { color: #999999; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gpink          { color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gmidgreen      { color: #008000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gwhite         { color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".ggrey          { color: #bbbbbb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".gbrown         { color: #bf7d40; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".numbergreen    { color: #00a000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".numberred      { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";

        echo ".green_heading  { font-family: verdana; font-size: 11.5pt; color: #008000; }";
        
        
		if (! low_res_screen())
        {				
			echo ".fprompt        { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { padding-left: 2px; margin-right: 3px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { padding-left: 2px; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { padding-left: 2px; color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { padding-left: 2px; color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
        }
        else
        {
			echo ".fprompt        { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput         { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; font-family: verdana; font-size: ".fs( 12 )."pt}";			
			echo ".fradio         { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

			echo ".fprompt_error  { color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".finput_error   { color: #000000; padding-left: 2px; border-style: solid; border-width: 1px; border-color: #cccccc; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
			echo ".fradio_error   { color: #000000; background-color: #ff9999; font-family: verdana; font-size: ".fs( 12 )."pt}";
        }

		echo ".dprompt        { padding-left: 2px; margin-right: 3px; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".dtext          { padding-left: 2px; margin-right: 3px; color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".paraheading    { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".mainmenuheading    { color: #000000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		
		echo ".mainmenuitem			{color: #ffffff; background: darkblue; margin-left: 10px; margin-right: 10px; font-size: ".fs( 13 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:visited	{color: #ffffff; background: darkblue; font-size: ".fs( 13 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:link	{color: #ffffff; background: darkblue; font-size: ".fs( 13 )."pt; font-family:verdana; text-decoration:none}";
		echo ".mainmenuitem:hover	{cursor: pointer; background: #aaaaaa; color: #ffffff; font-size: ".fs( 13 )."pt; font-family:verdana; text-decoration:none;}";

		echo ".mainmenuitem_spacer	{color: #ffffff; background: darkblue; font-size: ".fs( 12 )."pt; font-family:verdana; text-decoration:none}";

	    echo ".menulink2      	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:link  	{color: #000000; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";
	    echo ".menulink2:hover	{color: #bbbbbb; cursor: pointer; border-style: none; padding-left: 0; padding-right: 0; font-size: 13pt; font-family: Calibri; text-decoration:none}";			    

		echo ".pgheading      { color: #0000bb; font-family: verdana; font-size: ".fs( 18 )."pt}";
//		echo ".pgheading      { color: #1E90FF; font-family: verdana; font-size: ".fs( 30 )."pt}";
		echo ".homeheading    { color: #0000bb; font-family: times; font-size: ".fs( 12 )."pt}";

		echo ".glink		  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:visited  { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:link     { color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".glink:hover    { color: darkgreen; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".reportlink		   { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".reportlink:visited  { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".reportlink:link     { text-decoration: none; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".reportlink:hover    { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".pinklink:visited { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".pinklink:link  { text-decoration: none; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".pinklink:hover { text-decoration: underline; color: #FF69B4; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".redlink:visited { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".redlink:link  { text-decoration: none; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".redlink:hover { text-decoration: underline; color: #ff0000; font-family: verdana; font-size: ".fs( 12 )."pt}";
		
		echo ".lpinklink:visited { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".lpinklink:link  { text-decoration: none; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".lpinklink:hover { text-decoration: underline; color: #ffd7ff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".whitelink:visited { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".whitelink:link  { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".whitelink:hover { text-decoration: underline; color: #ffffff; font-family: verdana; font-size: ".fs( 12 )."pt}";

		echo ".bluelink:visited { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".bluelink:link  { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		echo ".bluelink:hover { text-decoration: underline; color: #0000bb; font-family: verdana; font-size: ".fs( 12 )."pt}";
		
		echo ".redbuttondesktop {cursor: pointer; border: 1px solid #d00000; border-radius: 5px; background: #d00000; color: #ffffff; font-family: arial; font-size: 15.25px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		

		echo ".redbuttondesktop:hover {cursor: pointer; border: 1px solid #f00000; border-radius: 5px; background: #f00000; color: #ffffff; font-family: arial; font-size: 15.25px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";


    	echo ".redbuttonmobile {cursor: pointer; line-height: 12pt; border:#d00000; border-radius: 4px; background: #d00000; color: #ffffff; font-family: arial; font-size: 15.25px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".redbuttonmobile:hover {cursor: pointer; line-height: 12pt; border:#f00000; border-radius: 4px; background: #f00000; color: #ffffff; font-family: arial; font-size: 15.25px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";


	    $fs2 = 14;
	    $fsm = 15;


			// this code implements a color on hover on the green buttons

			// include 'background: green' for browsers that don't support gradients
			
//    	echo "<style>";

		echo ".greenbuttondesktop {cursor: pointer; border: 1px solid darkblue; border-radius: 5px; background: darkblue; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		

		echo ".greenbuttondesktop:hover {cursor: pointer; border: 1px solid #0000a0; border-radius: 5px; background: #0000a0; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

/*
		echo ".graybuttondesktop {cursor: pointer; border: 1px solid #999999; border-radius: 5px; background: #999999; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:2px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";
		
*/

    	echo ".greenbuttonmobile {cursor: pointer; line-height: 12pt; border:solid darkcyan; border-radius: 4px; background: darkcyan; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";

		echo ".greenbuttonmobile:hover {cursor: pointer; line-height: 12pt; border:solid #006b6b; border-radius: 4px; background: #006b6b; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";


		echo ".graybuttonmobile {cursor: pointer; line-height: 12pt; border:solid #999999; border-radius: 4px; background: #999999; color: #ffffff; font-family: arial; font-size: ".$fsm."px; ";
		echo "    border-width:1px; padding-left:1px; padding-right:1px; padding-top:1px; display: inline-block; padding-bottom:1px; margin:1px; ";
		echo "    }";



		echo ".greenbuttonmobile3 {border-left:solid #999999; border-top:solid #999999; border-right:solid #999999; background: darkcyan; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";


    	echo ".greenbuttonmobile3:hover {border-left:solid #999999; border-top:solid #999999; border-right:solid #999999; background: #006b6b; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";



		echo ".greenbuttonmobile3_bottom {border-left:solid #999999; border-top:solid #999999; border-bottom:solid #999999; border-right:solid #999999; opacity: 1; background: darkcyan; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";
		
		
		echo ".greenbuttonmobile3_bottom:hover {border-left:solid #999999; border-top:solid #999999; border-bottom:solid #999999; border-right:solid #999999; background: #006b6b; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; display: inline-block; line-height: 50px; width:100%; text-decoration: none;";
		echo "    }";
		
		
		echo ".greenbuttonmobilelink {background: darkcyan; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; text-decoration: none;";
		echo "    }";

		echo ".greenbuttonmobilelink:hover {background: #006b6b; color: #ffffff; font-family: arial; font-size: ".$fs2."px; ";
		echo "    border-width:2px; text-decoration: none;";
		echo "    }";
				
//		echo "</style>";

		
	}


    function set_current_week()
    {
        $start_date = date_create( date("Y-m-d") );

        $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );

        
        $day_of_week = jddayofweek( gregoriantojd( date("m"), date("d"), date("Y") ) );
      
        if ($day_of_week == 0)
            date_sub( $start_date, date_interval_create_from_date_string( '6 days' ));
        else
        if ($day_of_week == 1)
            date_sub( $start_date, date_interval_create_from_date_string( "".($day_of_week-1)." days" ));
        else
        if ($day_of_week == 2)
            date_sub( $start_date, date_interval_create_from_date_string( "1 day" ));
        else
        if ($day_of_week > 2)
            date_sub( $start_date, date_interval_create_from_date_string( "".($day_of_week-1)." days" ));
    
    
	    $end_date = clone( $start_date );

        date_add( $end_date, date_interval_create_from_date_string( '6 days' ));
 
 
        $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_end_date'] = $end_date->format( "Y-m-d" );
    }
    

    function set_current_day()
    {
        $start_date = date_create( date("Y-m-d") );
        

        $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_end_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
    }
  
  
    function forward_one_week()
    {
        $start_date = date_create( val( $_SESSION, "appt_window_start_date" ) );
        
        $end_date = date_create( val( $_SESSION, "appt_window_end_date" ) );
        
        
        date_add( $start_date, date_interval_create_from_date_string( '7 days' ));
        
        date_add( $end_date, date_interval_create_from_date_string( '7 days' ));
        
        
        $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_end_date'] = $end_date->format( "Y-m-d" );

        $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
    }


    function forward_one_day()
    {
        $start_date = date_create( val( $_SESSION, "appt_window_start_date" ) );
        

        date_add( $start_date, date_interval_create_from_date_string( '1 day' ));
        

        $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_end_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
    }
    
    
    function set_appt_window_date( $date2 )
    {
        $this_date = substr( $date2, 17, 4 )."-".substr( $date2, 14, 2 )."-".substr( $date2, 11, 2 );
 
        $start_date = date_create( $this_date );

        if (val( $_SESSION, "appt_window_all_stylists" ) == "on")
        {
            $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
            
            $_SESSION['appt_window_end_date'] = $start_date->format( "Y-m-d" );    
            
            $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
        }
        else
        {
            $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
            
            $day_of_week = jddayofweek( gregoriantojd( substr( $date2, 14, 2 ), substr( $date2, 11, 2 ), substr( $date2, 17, 4 ) ));
          
            if ($day_of_week == 0)
                date_sub( $start_date, date_interval_create_from_date_string( '6 days' ));
            else
            if ($day_of_week > 1)
                date_sub( $start_date, date_interval_create_from_date_string( ($day_of_week-1)." days" ));
        
        
    	    $end_date = clone( $start_date );
    
            date_add( $end_date, date_interval_create_from_date_string( '6 days' ));
     
     
            $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
            
            $_SESSION['appt_window_end_date'] = $end_date->format( "Y-m-d" );       
        }        
    }
    
      
    function backwards_one_week()
    {
        $start_date = date_create( val( $_SESSION, "appt_window_start_date" ) );
        
        $end_date = date_create( val( $_SESSION, "appt_window_end_date" ) );
        
        
        date_sub( $start_date, date_interval_create_from_date_string( '7 days' ));
        
        date_sub( $end_date, date_interval_create_from_date_string( '7 days' ));
        
        
        $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_end_date'] = $end_date->format( "Y-m-d" );

        $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
    }
  

    function backwards_one_day()
    {
        $start_date = date_create( val( $_SESSION, "appt_window_start_date" ) );
        

        date_sub( $start_date, date_interval_create_from_date_string( '1 day' ));
        

        $_SESSION['appt_window_start_date'] = $start_date->format( "Y-m-d" );
        
        $_SESSION['appt_window_end_date'] = $start_date->format( "Y-m-d" );

        $_SESSION['appt_window_target_date'] = $start_date->format( "Y-m-d" );
    }
  
        // modes: 1. week, one stylist
        //        2. day, each stylist
        //        3. week, all stylist
        
        
    function show_left_pane_heading( $stylist, $cxn )
    {
        $text = "";
        
        $report_start_date = val( $_SESSION, "appt_window_start_date" );
        
        $report_end_date = val( $_SESSION, "appt_window_end_date" );
      
      
        echo "<table style='border-collapse: collapse;'>";

    
        if (val( $_SESSION, "appt_window_all_stylists" ) == "on")
        {
            $query = "SELECT * FROM stylist ORDER BY display_name";
        
        	$result = run_query( $query, $cxn );

            echo "<tr><td style='font-family: verdana; font-size: 9pt; width: 75px; height: 33px; border: solid 1px #bbbbbb; font-weight: bold;'>".( ad_format_date( $report_start_date, "D" )."<br>".ad_format_date( $report_start_date, "d.m.Y" ) )."</td>";
            
        	for ($i=0; $i < query_num_rows( $result ); $i++)
        	{
    	    	$data = get_row( $result );
    	    	
                echo "<td align='center' style='font-size: 12pt; width: 88px; border: solid 1px #bbbbbb; font-weight: bold'>".$data['display_name']."</td>";
        	}
        	
            echo "<td style='width: 18px'>&nbsp;</td></tr></table>";
        }
        else
        {
            $this_date_dt = date_create( $report_start_date );
    
            $this_date_str = $this_date_dt->format( "Y-m-d" );
    
                // height set in for table
                
            echo "<tr><td style='font-size: 10pt; width: 75px; border: solid 1px #bbbbbb;'>".black( "<b>".$stylist."</b>" )."</td>";

            while ($this_date_str <= $report_end_date)
            {
                if (! low_res_screen())
                    echo "<td style='font-family: arial; font-size: 9pt; width: 88px; border: solid 1px #bbbbbb; color: #000000'>".($this_date_dt->format( "D" )."<br>".$this_date_dt->format( "d.m.Y" ))."</td>";
                else
                    echo "<td style='font-size: 10pt; font-family: arial; width: 55px; height: 35px; border: solid 1px #bbbbbb; color: #000000'>".$this_date_dt->format( "D" )."<br>".$this_date_dt->format( "d.m" )."</td>";
                    
    
            	date_add( $this_date_dt, date_interval_create_from_date_string( "1 day" ));
        	
                $this_date_str = $this_date_dt->format( "Y-m-d" );
            }
            
            echo "</td><td style='width: 18px'>&nbsp;</td></tr></table>";
        }    
    }

              
                  
    function show_left_pane( $cxn )
    {
        $text = "";
        
        $report_start_date = val( $_SESSION, "appt_window_start_date" );
        
        $report_end_date = val( $_SESSION, "appt_window_end_date" );
      
      
        echo "<table style='border-collapse: collapse;'>";
    

        $hour = calendar_start_time;
        
        $hairdresser = val( $_SESSION, "appt_window_stylist" );
        
        for (; $hour <= 11; $hour++)
        {
            echo "<tr>";
        
            show_time( $hour.":00 AM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour, $cxn );

            echo "</tr>";
    
            echo "<tr>";
        
            show_time( $hour.":15 AM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour + 0.25, $cxn );

            echo "</tr>";
    
            echo "<tr>";
        
            show_time( $hour.":30 AM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour + 0.5, $cxn );

            echo "</tr>";
    
    
            echo "<tr>";
        
            show_time( $hour.":45 AM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour + 0.75, $cxn );

            echo "</tr>";
        }


        for ($hour = 12, $hour_24 = 12; ($hour == 12 || $hour <= 8); $hour++, $hour_24++)
        {
            echo "<tr>";
        
            show_time( $hour.":00 PM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour_24, $cxn );

            echo "</tr>";
    
            echo "<tr>";
        
            show_time( $hour.":15 PM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour_24 + 0.25, $cxn );

            echo "</tr>";
    
            echo "<tr>";
        
            show_time( $hour.":30 PM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour_24 + 0.5, $cxn );

            echo "</tr>";
    
    
            echo "<tr>";
        
            show_time( $hour.":45 PM" );
            
            show_line( $hairdresser, $report_start_date, $report_end_date, $hour_24 + 0.75, $cxn );

            echo "</tr>";
            
            
            if ($hour == 12)
                $hour = 0;
        }


        echo "<tr>";
    
        show_time( "9:00 PM" );
        
        show_line( $hairdresser, $report_start_date, $report_end_date, 21, $cxn );

        echo "</tr>";
    
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";
       
    
        echo "</table>";
    }


    function show_line( $hairdresser, $report_start_date, $report_end_date, $hour_24, $cxn )
    {
        $this_date_dt = date_create( $report_start_date );

        $this_date_str = $this_date_dt->format( "Y-m-d" );

        if (val( $_SESSION, "appt_window_all_stylists" ) == "on")
        {
            $query = "SELECT * FROM stylist ORDER BY display_name";
        
        	$result = run_query( $query, $cxn );

        	for ($i=0; $i < query_num_rows( $result ); $i++)
        	{
    	    	$data = get_row( $result );
    	    	
                show_cell( $data['display_name'], $this_date_dt, $this_date_str, $hour_24, $cxn );
        	}
        }
        else
        {
            while ($this_date_str <= $report_end_date)
            {
                show_cell( $hairdresser, $this_date_dt, $this_date_str, $hour_24, $cxn );
    
    
            	date_add( $this_date_dt, date_interval_create_from_date_string( "1 day" ));
        	
                $this_date_str = $this_date_dt->format( "Y-m-d" );
            }
        }        
    }



    function show_cell( $stylist, $this_date, $this_date_str, $this_time, $cxn )
    {
        $text = '';
        
        $rostered_on = false;

        $day_of_week_text = day_of_week_to_text( jddayofweek( gregoriantojd( $this_date->format( "m" ), $this_date->format( "d" ), $this_date->format( "Y") ) ) );


        $query3 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date = '".$this_date_str."' AND type = 'override_this_day_only'";

    	$result3 = run_query( $query3, $cxn );

        if (query_num_rows( $result3 ) > 0)
        {
                // override hours for this day

            $query3 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND ".$this_time." >= start_time AND ".$this_time." < finish_time AND effective_date = '".$this_date_str."' AND type = 'override_this_day_only'";

        	$result3 = run_query( $query3, $cxn );
                
            if (query_num_rows( $result3 ) > 0)
                $rostered_on = true;
        }
        else
        {
            $query3 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date <= '".$this_date_str."' AND day_of_week_text = '".$day_of_week_text."' AND type = 'regular_hours' ORDER BY effective_date DESC";

        	$result3 = run_query( $query3, $cxn );
    
            if (query_num_rows( $result3 ) > 0)
            {
    	    	$data3 = get_row( $result3 );


                    // check all on-off times for the latest hours
                    
                $query4 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date = '".$data3['effective_date']."' AND day_of_week_text = '".$day_of_week_text."'";
                
            	$result4 = run_query( $query4, $cxn );
                
            	for ($j=0; $j < query_num_rows( $result4 ); $j++)
            	{
        	    	$data4 = get_row( $result4 );

                    if ($this_time >= $data4['start_time'] && $this_time < $data4['finish_time'])
                        $rostered_on = true;
            	}
            }
        }            
        

        $query = "SELECT appointment.*, client.first_name, client.surname, client.blockout_time FROM appointment LEFT JOIN client ON client.id = appointment.client_id WHERE stylist = '".$stylist."' AND date = '".$this_date_str."' AND deleted = 'no' ORDER BY id";
        
    	$result = run_query( $query, $cxn );

	    $foreground = "#000000";
	    
	    if ($rostered_on)
        {
    	    if (intval( $this_time ) == $this_time || intval( $this_time+0.5 ) == ($this_time+0.5))
                $background = "#e6efef";
            else
                $background = "#ffffff";
        }        
        else
        {
            if (val( $_SESSION, "client_view") == "true")
                $background = "#888888";
            else
                $background = "#dddddd";
        }
        
                
        $rowspan = 1;
	    $show_this_row = true;
        $edit_id = "";
        $client_id = "";
        $blank_appointment = true;
        $found_count = 0;

        if (query_num_rows( $result ) > 0)
        {
        	for ($i=0; $i < query_num_rows( $result ); $i++)
        	{
    	    	$data = get_row( $result );

    	    	if (round( $data['start_time'], 2 ) == round( $this_time, 2 ))
    	    	{
    	    	    $appointment_id = $data['id'];
    	    	    $elapsed = ($data['end_time'] - $data['start_time']);
                    $rowspan = $elapsed / 0.25;

    	    	    $foreground = "#ffffff";
    	    	    
    	    	    
                    $services = "";
	                
	                $query2 = "SELECT * FROM appointment_service WHERE appointment_id = ".$appointment_id." ORDER BY service";
    
                    $result2 = run_query( $query2, $cxn );
    	
                	for ($j=0; $j < query_num_rows( $result2); $j++)
                	{
            	    	$data2 = get_row( $result2 );
            	    	
            	    	$services .= "<br>".$data2['service'];
                	}   	 
                	
                	
	    	        if ($rowspan > 2)
    	    	    {
    	    	        $text = $data['first_name']."<br>".$data['surname']."<br>".$services;
    	    	    }
    	    	    else
    	    	    if ($rowspan > 1)
    	    	        $text = $data['first_name']."<br>".$data['surname']."<br>".substr( $services, 0, 18 );
    	    	    else
        	    	    $text = $data['first_name']." ".substr( $data['surname'], 0, 1 ).substr( $services, 0, 18 );   


                    if (val( $_SESSION, "client_view") == "true")
                        $text = "Appointment Not Available";
       	    	}
                else
    	    	if (round( $data['start_time'], 2 ) <= round( $this_time, 2 ) && round( $data['end_time'], 2 ) >= round( $this_time + 0.25, 2 ))
    	    	    $show_this_row = false;


            	if (round( $data['start_time'], 2 ) <= round( $this_time, 2 ) && round( $data['end_time'], 2 ) >= round( $this_time + 0.25, 2 ))
    	    	{
    	    	    $found_count++;
                    $edit_id = $data['id'];
                    $client_id = $data['client_id'];
                    $blank_appointment = false;
                    
                    if (val( $_SESSION, "client_view") == "true")
                        $background = "#005000";
                    else
    	    	    if ($data['blockout_time'] == 'on')
                        $background = "#2F4F4F";
                    else
     	    	    if ($data['status'] == 'COMPLETE')
                        $background = "#888888";
                    else
    	    	    if ($data['status'] == 'NOSHOW')
                        $background = "#ff0000";
                    else
    	    	    if ($data['status'] == 'CURRENT')
                        $background = "#008000";
                    else
                        echo red( "System issue, appointment status not recognised<br>" );
    	    	}
        	}
        }
            
        if ($found_count > 1)
            echo red( "System error, overlapping appointments for ".$stylist." on ".$this_date_str." at ".$this_time."<br><br>" );

        if ($show_this_row)
        {
            if ($blank_appointment)
            {
                
                echo "<td rowspan=".$rowspan." valign='top'";

                echo " id='".$stylist.":".$this_date_str.":".$this_time."' ";
                
                echo "ondragover='allowDrop(event);'";

                echo "ondrop='appt_drop(event, \"".$stylist."\", \"".$this_date_str."\", \"".$this_time."\");' ";


                if (val( $_SESSION, "client_view") == "true")
                    echo "align='center' ";
                else
                    echo "align='center' onclick='location.href=\"/new_appointment.php?starttime=".$this_time."&startdate=".$this_date_str."&stylist=".$stylist."\";' ";


                    // height set in show_time();
                    
                if (! low_res_screen())
                    echo "style='line-height: 8.75pt; font-family: arial; font-size: 8.75pt; width: 88px; height: 16px; color: ".$foreground."; background: ".$background."; border: solid 1px #bbbbbb;' ";
                else
                    echo "style='line-height: 8.75pt; font-family: arial; font-size: 8pt; width: 55px; color: ".$foreground."; background: ".$background."; border: solid 1px #bbbbbb;' ";
                    
                echo " >".$text."</td>";
            }
            else
            {
                echo "<td rowspan=".$rowspan." valign='top'";

//                echo "<td rowspan=".$rowspan." valign='top' draggable='true' ";

                echo "ondragstart='appt_drag(event);' ";

                if (val( $_SESSION, "client_view") == "true")
                    echo "align='center' ";
                else
                    echo "id=".$appointment_id." align='center' onclick='location.href=\"/appointment.php?editid=".$edit_id."&clientid=".$client_id."\";' ";


                    // height set in show_time();
                
                if (! low_res_screen())
                    echo "style='line-height: 8pt; font-family: arial; font-size: 8.25pt; width: 88px; height: 16px; color: ".$foreground."; background: ".$background."; border: solid 1px #bbbbbb;' ";
                else
                    echo "style='line-height: 8.75pt; font-family: arial; font-size: 8.25pt; width: 55px; color: ".$foreground."; background: ".$background."; border: solid 1px #bbbbbb;' ";
                
                echo ">".$text."</td>";
            }
        }
    }
    
    
    function show_main_menu()
    {
        echo "<table width='100%' style='border-collapse: collapse;'><tr>";

        if (! low_res_screen())
		    echo show_one_menu_item( "Appointments", "/" );		
		else
            echo show_one_menu_item( "Apptmt", "/" );		
            
        if (! low_res_screen())
    		echo show_one_menu_item( "New&nbsp;Appointment", "/new_appointment.php?startdate=".date( "Y-m-d" ) );		
        else
    		echo show_one_menu_item( "New Apptmt", "/new_appointment.php?startdate=".date( "Y-m-d" ) );		

		echo show_one_menu_item( "Client History", "main_menu_view_client.php" );

		echo show_one_menu_item( "New Client", "/client.php?edit_mode=main_menu_new_client" );		

		echo show_one_menu_item( "Retail", "/retail_sale.php" );

		echo show_one_menu_item( "Cash draw", "/cash_draw_transaction.php" );

		echo show_one_menu_item( "Reports", "/reports.php" );

        echo "<td width='10%' class='mainmenuitem_spacer'>&nbsp;</td>";

		echo show_one_menu_item( "Help", "/help.php" );

		echo show_one_menu_item( "Other", "/other.php" );

		echo show_one_menu_item( "Logout", "/logout.php" );

        echo "<td width='4%' class='mainmenuitem_spacer'>&nbsp;</td>";
        
		echo "</tr>";

		echo "</table>";
	}


        // show one item on the information menu bar
        
	function show_one_menu_item( $prompt, $page )
	{
		return "<td height='32' class='mainmenuitem_spacer' width='1%'></td><td class='mainmenuitem' align='center' onclick='location.href=\"".url_encode( $page )."\"'>".$prompt."</td><td class='mainmenuitem_spacer' width='1%'></td>";
	}



    function make_date_option_string( $appt_date_str )
    {
        $date_option_str = "";
    
        if (val( $_SESSION, "client_view") == "true")
    	    $this_date = date_create( date("Y-m-d") );
        else    
        if ($appt_date_str < date( "Y-m-d" ))    
        	$this_date = date_create( $appt_date_str );
        else
    	    $this_date = date_create( date("Y-m-d") );

        if (val( $_SESSION, "client_view") != "true")
        	date_sub( $this_date, date_interval_create_from_date_string( '5 days' ));

        $day_of_week = jddayofweek( gregoriantojd( $this_date->format( "m" ), $this_date->format( "d" ), $this_date->format( "Y") ) );
    
        for ($i=0; $i < 120; $i++)
        {
            if ($this_date->format( "Y-m-d" ) == $appt_date_str)
                $date_option_str .= "<option selected>".$this_date->format( "D" )."&nbsp;&nbsp;&nbsp;&nbsp;".$this_date->format( "d.m.Y" )."</option>";
            else
                $date_option_str .= "<option>".$this_date->format( "D" )."&nbsp;&nbsp;&nbsp;&nbsp;".$this_date->format( "d.m.Y" )."</option>";

        
            if ($day_of_week == 0)
                $date_option_str .= "<option></option>";
                
        	$day_of_week++;
    	
        	if ($day_of_week >= 7)
        	    $day_of_week = 0;

        	date_add( $this_date, date_interval_create_from_date_string( '1 day' ));
        }
        
        return ($date_option_str);
    }
    
    
    function show_time( $time_text )
    {
        if (! low_res_screen())
            echo "<td valign='top' style='font-size: 9pt; font-family: arial; width: 75px; height: 26px; border: solid 1px #bbbbbb;'>".$time_text."</td>";
        else
            echo "<td valign='top' style='font-size: 10pt; font-family: arial; width: 75px; height: 26px; border: solid 1px #bbbbbb;'>".$time_text."</td>";
    }


    function search_client()
    {
        echo "<table>";
        
        form_start( "search_client.php" );
        
        $first_name = val( $_SESSION, "last_added_client_first_name" );

        $surname = val( $_SESSION, "last_added_client_surname" );


//        $first_name = "";

//        $surname = "";

        
        form_field( "First name", "first_name", "autofocus", 15, $first_name );
        form_field( "Surname", "surname", "", 15, $surname );
        form_field( "Mobile number", "phone_number", "", 15, "" );

        echo "<tr><td>&nbsp;</td></tr>";
        echo "<tr><td>&nbsp;</td></tr>";

        echo "<tr><td>";
        
        show_green_button_submit( "Search", 85, "form" );

        echo "</td></tr>";

        echo "</table>";
        
	    if (val( $_SESSION, "last_added_client_id" ) != "")
	    {
	        echo "<br><br><br>";
	    
            echo "<a class='glink' href='/select_client.php?clientid=".val( $_SESSION, "last_added_client_id" )."'>".val( $_SESSION, "last_added_client_first_name" )." ".val( $_SESSION, "last_added_client_surname" )."</a>";
	    }
    }    
    
    
    
    function show_main_display( $cxn )
    {
        if (val( $_SESSION, "appt_window_start_date" ) == "")
            set_current_week();

        if (val( $_SESSION, "appt_window_stylist" ) == "")
            $_SESSION['appt_window_stylist'] = "Penny";

        $stylist = val( $_SESSION, "appt_window_stylist" );
        

        if (! low_res_screen())
		    echo "<table style='display: inline-block'><tr><td>";
		

        if (val( $_SESSION, "appt_window_all_stylists" ) == "on")
        {
            if (val( $_SESSION, "client_view") != "true" || $_SESSION['appt_window_start_date'] > date( "Y-m-d" ))
                show_green_button( "Back 1 day", 150, "/move_appt_window.php", "movetype", "backwardsoneday" );
                
            show_green_button( "Current day", 140, "/move_appt_window.php", "movetype", "currentday" );
             
            if (low_res_screen())
                echo "<br>";
             
            show_green_button( "Forward 1 day", 150, "/move_appt_window.php", "movetype", "forwardsoneday" );
        }
        else
        {
            if (val( $_SESSION, "client_view") != "true" || $_SESSION['appt_window_start_date'] > date( "Y-m-d" ))
                show_green_button( "Back 1 week", 150, "/move_appt_window.php", "movetype", "backwardsoneweek" );
            
            show_green_button( "Current week", 140, "/move_appt_window.php", "movetype", "currentweek" );

            if (low_res_screen())
                echo "<br>";
             
            show_green_button( "Forward 1 week", 150, "/move_appt_window.php", "movetype", "forwardsoneweek" );
        }

        if (! low_res_screen())
		    echo "</td><td>";
       
        echo "&nbsp;&nbsp;&nbsp;";
       
        $date_option_str = make_date_option_string( val( $_SESSION, "appt_window_target_date" ) );
       
        $stylists = build_dropdown_list( "stylist", $cxn, "display_name", false );


//        echo "<form id='form9' name='form9' action='move_appt_window_set_date.php' style='display: inline-block;' method='POST'>";
        
        $date_str = "";

        echo "<script>";
        echo "function reload_home()";
        echo "{";
        if (val( $_SESSION, "client_view") == "true")
            echo "           location.href = '/?date2='+document.getElementById('date2').value+'&clientview=true';";
        else
            echo "           location.href = '/?stylist='+document.getElementById('stylist').value+'&date2='+document.getElementById('date2').value+'&allstylists='+document.getElementById('all_stylists').checked;";
        echo "}";
        echo "</script>";
        
        
        $pos = strpos( $stylists, "<option>".$stylist."</option>" );

		if ($pos !== false)
		{
			$pos = $pos + 8;
			$stylists = substr( $stylists, 0, $pos - 1 )." selected".substr( $stylists, $pos - 1, strlen( $stylists ) - $pos + 1 );
		}        
		
        if (low_res_screen())
		    echo "<table style='display: inline-block'><tr>";
		
        if (val( $_SESSION, "client_view") != "true")
        {
    		echo "<td valign='center'>";
		
            echo "<select onchange='reload_home();' id='stylist' name='stylist' class='finput'>".$stylists."</select>&nbsp;&nbsp;&nbsp;";

		    echo "</td>";
        }
        
        echo "<td>";
        
        if (! low_res_screen())
            echo "<select onchange='reload_home();' id='date2' name='date2' class='finput' style='font-family: courier; font-size: 9.5pt; color: #000000;'>".$date_option_str."</select>&nbsp;&nbsp;&nbsp;";
        else
            echo "<select onchange='reload_home();' id='date2' name='date2' class='finput' style='font-family: courier; font-size: 10pt; font-weight: bold; color: #000000;'>".$date_option_str."</select>&nbsp;&nbsp;&nbsp;";

		echo "</td>";
		
        if (val( $_SESSION, "client_view") != "true")
        {
    		echo "<td>";
            
            if (val( $_SESSION, "appt_window_all_stylists" ) == "on")
                echo "<input onchange='reload_home();' type='checkbox' id='all_stylists' name='all_stylists' checked>".black( "Show all stylists" )."</input>&nbsp;&nbsp;&nbsp;";
            else
                echo "<input onchange='reload_home();' type='checkbox' id='all_stylists' name='all_stylists'>".black( "Show all stylists" )."</input>&nbsp;&nbsp;&nbsp;";

            echo "</td>";
        }
    
        echo "</tr></table>";
        
        
        echo "<br>";
        
        echo "<span style='font-size: 6pt;'><br></span>";
        
        echo "<table width='100%'><tr><td valign='top' width='65%'>";
        
        
        echo "<div style='vertical-align: top; height: 33px;'>";

        show_left_pane_heading( val( $_SESSION, "appt_window_stylist" ), $cxn );
    
        echo "</div>";
        
        if (! low_res_screen())
            echo "<div id='appt_window' onload='scroll_appt_window();' style='vertical-align: top; display: inline-block; height: 550px; overflow: scroll;'>";
        else
            echo "<div id='appt_window' onload='scroll_appt_window();' style='vertical-align: top; display: inline-block; width: 520px; height: 1350px; overflow: scroll;'>";
            
        show_left_pane( $cxn );
    
        echo "</div>";
    
        echo "</td><td width='35%' valign='top'>";
 
    }
   

	function form_start( $handler, $param1="", $value1="", $param2="", $value2="", $param3="", $value3="" )
	{
		echo "<form id='form' name='form' action='".url_encode( $handler, $param1, $value1, $param2, $value2, $param3, $value3 )."' method='POST'><table style='border: 1px solid #888888;'>";
	}


    function form_field( $prompt, $field_name, $auto_focus_text, $size, $init )    
    {
        $init = str_replace( "'", "&#39", $init );
        
        if (! low_res_screen())
    		echo "<tr><td><span class='fprompt'>".$prompt."</span></td><td><input class='finput' ".$auto_focus_text." name='".$field_name."' type='text' size='".$size."' value='".$init."'></td></tr>";
        else			
		    echo "<tr><td><span class='fprompt'>".$prompt."</span><br><input class='finput' ".$auto_focus_text." name='".$field_name."' type='text' size='".$size."' value='".$init."'></td></tr>";
    }
   

		// must have a blank function with this name because it is called by the central validation routine
		
	function additional_validations( $id, $form_name, $newrecord, &$validation_errors, &$screen_data, &$screen_data_error, $cxn )
	{
	    if ($form_name == "mpl_quote")
	    {
	        if ($screen_data['adviser'] == "" && $screen_data['practice'] == "")
	        {
    			$validation_errors = $validation_errors."You must select either a Practice or an Adviser<br>";
				
				$screen_data_error['practice'] = "true";
				$screen_data_error['adviser'] = "true";				
	        }
	    }
	}
	
	
	function additional_screen_initialisations( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	    if ($form_name == "appt_retail_sale" && $newrecord == "true")
	    {
	        $screen_data['sale_date'] = date( "d/m/Y" );
	    }
	    

	    if ($form_name == "appt_gift_voucher" && $newrecord == "true")
	    {
	        $screen_data['sale_date'] = date( "d/m/Y" );
	    }
	}
	
			// don't delete this function it is called by the general save function
		
	function additional_changes_before_database_save( $id, $newrecord, $form_name, $table_name, &$screen_data, $cxn )
	{
	
		if ($form_name == "task")
		{
			if ($newrecord == "true")
				$screen_data['date_created'] = date("Y-m-d H:i:s");
			
			$screen_data['date_modified'] = date("Y-m-d H:i:s");
		}
	
	}



		// don't put in the common library because there is a different tracking ID for each site
		
		// currently uses the Academic Dating tracking ID
		
	function show_google_translate()
        {
            echo "<td width='15%' valign='top'>";
            echo ' <div id="google_translate_element"></div><script type="text/javascript"> ';
            echo ' function googleTranslateElementInit() { ';
            echo " new google.translate.TranslateElement({pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.SIMPLE, gaTrack: true, gaId: 'UA-97849346-1'}, 'google_translate_element'); ";
            echo ' } ';
            echo ' </script><script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script> ';
            echo "</td>";
        }



        /* send an email to a member */

	function send_external( $to_addr, $subject, $text_body, $html_body, $cxn, $queue )
	{
		$from_name = business_name;
		$from_addr = from_email_address;
		$reply_name = business_name;
		$reply_addr = reply_email_address;

		send_email( $from_name, $from_addr, $to_addr, $reply_name, $reply_addr, $subject, $text_body, $html_body, $cxn, $queue );

		return ($to_addr);
	}



		// Don't put this function in the common library because it's different for SSL and non SSL connections
		
		/* log into the database and return the connection */
		

	function db_login( $database )
	{
		$host="localhost";
		$user="academi1_mlm1";
		$password="plastic1";

        $cxn = new mysqli( $host, $user, $password, $database );

		if ($cxn->connect_errno)
		{
			echo "The system is currently unavailable.<br><br>Please try again in half an hour.";
			
			echo "Error number: ".$cxn->connect_errno."<br>";
			echo "Error text: ".$cxn->connect_error."<br>";

			exit();
		}

		return $cxn;
	}



    function sign_format( $number, $text )
    {
        if ($number >= 0)
            return( "<span class='numbergreen'>".$text."</span>" );
        else
            return( "<span class='numberred'>".$text."</span>" );
    }
    

    function round_discount( $total_price, $discount )
    {
        $amount_due = round( $total_price * (1 - ($discount/100)), 2);
        
        if ($amount_due > 100)
            $amount_due = round( $amount_due - 0.5, 0 );
  
        return ($amount_due);
    }
    
    
    
        // sum of a transaction type within date range
        
    function get_transaction_total( $type, $start_date, $end_date, $cxn )
    {
    	$query = "SELECT sum(net_amount) as total FROM transaction INNER JOIN accounts ON accounts.display_name = transaction.account WHERE accounts.type = '".$type."' and effective_date >= '".$start_date."' AND effective_date <= '".$end_date."'";

    	$result = run_query( $query, $cxn );

    	if (query_num_rows( $result ) == 0)
            $total = 0;
        else
        {
		    $data = get_row( $result );

    		$total = $data['total'];
        }

        return ($total);
    }
    
    

    function list_appt_services( $appointment_id, &$total_price, &$manual_override, &$discount, $show_price_charged, $edit_id, $cxn )
    {
        $discount = "";
        $manual_override = "";
        $price_charged = "";
        
        
        $query = "SELECT discount, manual_override, price_charged FROM appointment WHERE id = ".$appointment_id;
        
        $result = run_query( $query, $cxn );
        
    	$data = get_row( $result );
    
        $discount = $data['discount'];
        
        $manual_override = $data['manual_override'];

        $price_charged = $data['price_charged'];

        
        $query = "SELECT appointment_service.*, appointment.discount, appointment.manual_override, appointment.price_charged FROM appointment_service ";
        $query .= "LEFT JOIN appointment ON appointment.id = appointment_service.appointment_id WHERE appointment_service.appointment_id = ".$appointment_id." ORDER BY service";
        
        $result = run_query( $query, $cxn );
        
        $total_price = 0;

        
        echo "<table style='border: 1px solid ".form_border_color."'>";

        if (query_num_rows( $result ) == 0)
            echo "<tr><td colspan='2' style='font-family: verdana; font-size: 10pt; color: #0000bb'>Select below to add services to this appointment</td</tr>";
        else
            echo "<tr><td colspan='3' style='font-family: verdana; font-size: 10pt; color: #0000bb'>Services this appointment, select below to add more</td></tr>";

        echo "<tr><td>&nbsp;</td></tr>";
        
        
        for ($i=0; $i < query_num_rows( $result ); $i++)
        {
        	$data = get_row( $result );
        
//            $discount = $data['discount'];
            
//            $manual_override = $data['manual_override'];

//            $price_charged = $data['price_charged'];
            
            
            if (round( $data['price'], 0 ) == $data['price'])
                $price_str = round( $data['price'], 0 );
            else
                $price_str = $data['price'];
                
                
            $total_price += $data['price'];
            
            echo "<tr><td style='padding-left: 25px'>".black( $data['service'] )."</td><td style='padding-left: 25px' align='right'>".black( "$".$price_str )."</td><td style='padding-left: 25px'><a class='glink' href='/delete_appt_service.php?apptserviceid=".$data['id']."'>delete</a></td><tr>";
        }
        
        echo "<tr><td>&nbsp;</td></tr>";
    
        if (($manual_override == '' || $manual_override == 0) && ($discount == '' || $discount == 0))
            echo "<tr><td style='padding-left: 25px'>".black( "<b>Calculated total</b>" )."</td><td style='padding-left: 25px' align='right'>".black( "<b>$".$total_price )."</b></td><tr>";
        else
            echo "<tr><td style='padding-left: 25px'>".black( "Calculated total" )."</td><td style='padding-left: 25px' align='right'>".black( "$".$total_price )."</td><tr>";
    
        echo "<tr><td>&nbsp;</td></tr>";
        
        if ($show_price_charged && ($price_charged != "" && $price_charged != 0))
        {
            echo "<tr><td style='padding-left: 25px'>".black( "Price actually charged" )."</td><td style='padding-left: 25px' align='right'>".black( "$".number_format_needed( $price_charged ) )."</td>";
            
//           if ($show_delete)
//                echo "<td style='padding-left: 25px'><a href='/delete_manual_override.php?returnurl=/appointment.php?editid=".$edit_id."'>delete</a></td>";
            
            echo "<tr>";
    
            echo "<tr><td>&nbsp;</td></tr>";
        }    
    }
    
  
    function send_SMS_go($content) 
    {
        $ch = curl_init('https://api.smsbroadcast.com.au/api-adv.php');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $content);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $output = curl_exec ($ch);
        curl_close ($ch);
        return $output;    
    }


    function send_sms( $destination, $text )
    {
        $username = 'markmcilroy';
        $password = 'Tuesday12$';

//        $destination = '0400000000'; //Multiple numbers can be entered, separated by a comma

        $source    = 'Indie Hair';

//        $text = 'This is our test message.';

//        $ref = 'abc123';

        $ref = '';
            
        $content =  'username='.rawurlencode($username).
                    '&password='.rawurlencode($password).
                    '&to='.rawurlencode($destination).
                    '&from='.rawurlencode($source).
                    '&message='.rawurlencode($text).
                    '&maxsplit=5'.
                    '&ref='.rawurlencode($ref);
        
        $smsbroadcast_response = send_SMS_go($content);
        
        return ($smsbroadcast_response);
        
/*        
        $response_lines = explode("\n", $smsbroadcast_response);
        
        foreach( $response_lines as $data_line)
        {
            $message_data = "";
            $message_data = explode(':',$data_line);
            
            if($message_data[0] == "OK")
            {
                echo "The message to ".$message_data[1]." was successful, with reference ".$message_data[2]."\n";
            }
            else
            if( $message_data[0] == "BAD" )
            {
                echo "The message to ".$message_data[1]." was NOT successful. Reason: ".$message_data[2]."\n";
            }
            else
            if( $message_data[0] == "ERROR" )
            {
                echo "There was an error with this request. Reason: ".$message_data[1]."\n";
            }
        }
*/        
    }
    

    function show_add_service( $cxn )
    {
     	$services = build_dropdown_list( "service", $cxn );
     	
    	echo "<form id='form8' name='form8' action='".url_encode( "add_service.php" )."' method='POST'><table style='border: 1px solid #888888;'>";

    
        form_dropdown( "Service", "service", $services, "" );
            
        echo "<tr><td>&nbsp;</td></tr>";
    
        echo "<tr><td>";
            
        show_green_button_submit( "Add service", 125, "form8" );
      
        echo "</table></form>";  
    
        echo "<br><br>";
            
    }
  
  
    function check_for_conflicts( $mode, $stylist, $effective_date, $appointment_id, $start_time, $end_time, $cxn )
    {
        $ok = true;
        
        if ($mode == "new_appointment")
            $query = "SELECT * FROM appointment WHERE stylist = '".$stylist."' AND date = '".$effective_date."' AND deleted = 'no'";
        else
            $query = "SELECT * FROM appointment WHERE stylist = '".$stylist."' AND date = '".$effective_date."' AND deleted = 'no' AND id <> ".$appointment_id;

    	$result = run_query( $query, $cxn );
        
    	for ($i=0; $i < query_num_rows( $result ) && $ok; $i++)
    	{
	    	$data = get_row( $result );

            $this_start_time = $data['start_time'];
            
            $this_end_time = $data['end_time'];;

            $ok = false;
            
            if ($start_time >= $this_end_time || $end_time <= $this_start_time)
                $ok = true;
    	}

        return ($ok);
    }


    
    function get_services_list( $appointment_id, $cxn )
    {
        $service_list = "";

        $query = "SELECT * FROM appointment_service WHERE appointment_id = ".$appointment_id." ORDER BY service";
        
    	$result = run_query( $query, $cxn );
    
    	for ($j=0; $j < query_num_rows( $result ); $j++)
    	{
    		$data = get_row( $result );
    		
    		if ($j > 0)
    		    $service_list .= "<br>";
    		    
    		$service_list .= $data['service'];
    	}
        
        return ($service_list);
    }
    
    
    function get_expense_allocation_pa( $effective_date, $cxn )
    {
    	$query = "SELECT expense_allocation_pa FROM expense_allocation WHERE effective_date <= '".$effective_date."' ORDER BY effective_date DESC";

    	$result = run_query( $query, $cxn );

    	if (query_num_rows( $result ) == 0)
            $expense_allocation_pa = 0;
        else
        {
		    $data = get_row( $result );

    		$expense_allocation_pa = $data['expense_allocation_pa'];
        }
    
        return ($expense_allocation_pa);
    }
    
    

    function generate_custom_fields( $newrecord, $form_name, $field_name, $right_side_pane, $screen_data, $screen_data_error, $cxn )
    {
        if ($form_name == "task" || $form_name == "mpl_quote")
        {
            write_update_function();
            
            $number_of_strategies_list = "<option></option><option>1</option><option>2</option><option>3</option><option>4</option><option>5</option><option>6</option><option>7</option><option>8</option><option>9</option><option>10</option><option>11</option><option>12</option>";
        
            $number_of_strategies = $screen_data['number_of_strategies'];
            
        	if ($number_of_strategies != "")
        	{
        		$pos = strpos( $number_of_strategies_list, "<option>".$number_of_strategies."</option>" );
        
        		if ($pos !== false)
        		{
        			$pos = $pos + 8;
        			$number_of_strategies_list = substr( $number_of_strategies_list, 0, $pos - 1 )." selected".substr( $number_of_strategies_list, $pos - 1, strlen( $number_of_strategies_list ) - $pos + 1 );
        		}
        	}
        
        	echo "<tr><td><span class='fprompt'>Number of strategies</span></td><td></td>";
        	
            if ($form_name == "task")
            	echo "<td><select id='number_of_strategies' name='number_of_strategies' class='finput' onchange='UpdateFee();'>".$number_of_strategies_list."</select></td></tr>";

            if ($form_name == "mpl_quote")
            	echo "<td><select id='number_of_strategies' name='number_of_strategies' class='finput' onchange='UpdateFee2();'>".$number_of_strategies_list."</select></td></tr>";
            	
        }    
    }

	
    function write_update_function()
    {
        echo "<script>";
        
        echo "function UpdateFee()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var soa_fee = document.getElementById( 'quoted_price' );";

        echo "  var paraplanner_commission = document.getElementById( 'paraplanner_commission' );";

        echo "  soa_fee.value = ".fee_calc_formula;

        echo "  paraplanner_commission.value = ".commission_calc_formula;

        echo "  checker_commission.value = ".checker_commission_calc_formula;
        echo "}";
        

        echo "function UpdateFee2()";
        
        echo "{";

        echo "  var NumberofStrategies = document.getElementById( 'number_of_strategies' );";

        echo "  var amount = document.getElementById( 'amount' );";

        echo "  amount_ex_gst.value = ".fee_calc_formula;
        
          echo "   gst.value =  parseInt(amount_ex_gst.value) * 0.1; ";
        
        echo "   if (gst.value.substr(gst.value.length-2, 1 ) == '.') ";
        echo "      gst.value = gst.value + '0'; ";

        echo "   total.value =  parseFloat(amount_ex_gst.value) + parseFloat(gst.value); ";

        echo "   if (total.value.substr(total.value.length-2, 1 ) == '.') ";
        echo "      total.value = total.value + '0'; ";
        
        echo "}";

        echo "</script>";
    }        
	
?>