<?php
			// (c) Copyright Mark McIlroy 2020

	include "library.php";

	$cxn = start_code();
	

	$end_date = date_create( date("Y-m-d") );

    $start_date = date_create( date("Y-m-d") );

  
    reports_heading();
    
	
      // 0 = Sunday

    $day_of_week = jddayofweek( gregoriantojd( date("m"), date("d"), date("Y") ) );
  
    if ($day_of_week == 0)
        date_sub( $start_date, date_interval_create_from_date_string( '6 days' ));
    else
    if ($day_of_week > 1)
        date_sub( $start_date, date_interval_create_from_date_string( "'".($day_of_week-1)." days'" ));


    $days_this_week = $day_of_week;
    
    echo "<table>";
    
	echo "<tr><td valign='top'>&nbsp;&nbsp;<b>".black( "Week Ending" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Stylist hours" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Hours occupied" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Total Revenue<br>&nbsp;&nbsp;Incl. GST" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "% stylist<br>occupied" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Salon income<br>&nbsp;&nbsp;while occupied<br>&nbsp;&nbsp;per hour" )."</b></td>";
	echo "<td valign='top'>&nbsp;&nbsp;<b>".black( "Total hourly<br>&nbsp;&nbsp;salon income<br>&nbsp;&nbsp;per hour" )."</b></td></tr>";

    $total_stylist_hours = 0;
    $total_occupied_time = 0;
    $total_revenue = 0;
    
    $week = 1;
    
    
    while ($end_date->format( "Y-m-d" ) > '2018-11-11')
    {
        display_week( $week, $end_date->format( "d.m.Y" ), $days_this_week, $start_date->format( "Y-m-d" ), $end_date->format( "Y-m-d" ), $total_stylist_hours, $total_occupied_time, $total_revenue, $cxn );

    	date_sub( $start_date, date_interval_create_from_date_string( '7 days' ));
    	
    	
    	$end_date = clone( $start_date );
    	
    	date_add( $end_date, date_interval_create_from_date_string( '6 days' ));
    	
    	$days_this_week = 7;
    	$week++;
    }


	echo "</table>";

	echo "<br><br>";

    echo black( "Previous 4 weeks"."<br><br><br>" );

    echo black( "Average revenue incl. GST: $".number_format( $total_revenue / 4, 0 ) );

	echo "<br><br>";
    
    echo black( "Average occupied hours: ".number_format( ($total_occupied_time / $total_stylist_hours )*100, 0 )."%" );

	echo "<br><br>";

    echo black( "Average occupied hourly income rate: $".number_format( $total_revenue / $total_occupied_time, 0 ) );
    
	echo "<br><br>";

    echo black( "Average effective hourly income: $".number_format( $total_revenue / $total_stylist_hours, 0 ) );
    

	echo "<br><br><br>";
	
	echo show_link( "Back", "/index_reports.php" );

	echo "<br><br><br>";
  

    function display_week( $week, $week_ending, $days_this_week, $report_start_date, $report_end_date, &$total_stylist_hours, &$total_occupied_time, &$total_revenue, $cxn )
    {
        $this_date_dt = date_create( $report_start_date );

        $this_date_str = $this_date_dt->format( "Y-m-d" );

        $stylist_hours = 0;
        $occupied_time = 0;
        $revenue = 0;

        while ($this_date_str <= $report_end_date)
        {
            $stylist_hours += stylist_hours_this_day( $this_date_str, $cxn );

            $query = "SELECT appointment.*, client.blockout_time, SUM(appointment_service.price) as calculated_price FROM appointment INNER JOIN client ON appointment.client_id = client.id LEFT JOIN appointment_service ON appointment_service.appointment_id = appointment.id WHERE date = '".$this_date_str."' AND (status = 'COMPLETE' OR status = 'CURRENT') AND deleted = 'no' AND blockout_time IS NULL GROUP BY appointment.id";

        	$result = run_query( $query, $cxn );
            
        	for ($i=0; $i < query_num_rows( $result ); $i++)
        	{
        		$data = get_row( $result );
            
                $occupied_time += $data['end_time'] - $data['start_time'];
    
                
                if ($week <= 4)
                    $total_occupied_time += $data['end_time'] - $data['start_time'];


                if ($data['price_charged'] == "")
                {
                    $revenue += $data['calculated_price'];
     
                    if ($week <= 4)
                        $total_revenue += $data['calculated_price'];
                }
                else
                {
                    $revenue += $data['price_charged'];

                    if ($week <= 4)
                        $total_revenue += $data['price_charged'];
                }
        	}

        	date_add( $this_date_dt, date_interval_create_from_date_string( "1 day" ));
    	
            $this_date_str = $this_date_dt->format( "Y-m-d" );
        }
  
        if ($week <= 4)
            $total_stylist_hours += $stylist_hours;
        
		echo "<tr><td>&nbsp;&nbsp;".black( $week_ending )."</td>";
		echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $stylist_hours, 2 ) )."</td>";
		echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $occupied_time, 2 ) )."</td>";
		echo "<td align='right'>&nbsp;&nbsp;".black( "$".number_format( $revenue, 0 ) )."</td>";
		
		if ($stylist_hours != 0)
		    echo "<td align='right'>&nbsp;&nbsp;".black( number_format( ($occupied_time / $stylist_hours) * 100, 0 )."%" )."</td>";
		else
		    echo "<td></td>";
		   
		if ($occupied_time != 0)
		    echo "<td align='right'>&nbsp;&nbsp;".black( "$".number_format( $revenue / $occupied_time, 0 ) )."</td>";
		else
		    echo "<td></td>";

		if ($occupied_time != 0)
		    echo "<td align='right'>&nbsp;&nbsp;".black( "$".number_format( $revenue / $stylist_hours, 0 ) )."</td></tr>";
		else
		    echo "<td></td></tr>";
		
    }
        

    function stylist_hours_this_day( $this_date_str, $cxn )
    {
        $day_of_week_text = day_of_week_to_text( jddayofweek( gregoriantojd( substr( $this_date_str, 5, 2 ), substr( $this_date_str, 8, 2 ), substr( $this_date_str, 0, 4 ) )) );

        $hours_rostered_on = 0;
        

        $query = "SELECT display_name FROM stylist";
        
    	$result = run_query( $query, $cxn );
        
    	for ($i=0; $i < query_num_rows( $result ); $i++)
    	{
	    	$data = get_row( $result );
        
            $stylist = $data['display_name'];
                
            
            $query3 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date = '".$this_date_str."' AND type = 'override_this_day_only'";
    
        	$result3 = run_query( $query3, $cxn );
    
    
            if (query_num_rows( $result3 ) > 0)
            {
    	    	$data3 = get_row( $result3 );
        
                $query4 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date = '".$data3['effective_date']."' AND type = 'override_this_day_only'";
                
            	$result4 = run_query( $query4, $cxn );
                
            	for ($j=0; $j < query_num_rows( $result4 ); $j++)
            	{
        	    	$data4 = get_row( $result4 );
    
                    $hours_rostered_on += $data4['finish_time'] - $data4['start_time'] - $data4['meal_breaks'];
            	}
            }
            else
            {
                $query3 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date <= '".$this_date_str."' AND day_of_week_text = '".$day_of_week_text."' AND type = 'regular_hours' ORDER BY effective_date DESC";
    
            	$result3 = run_query( $query3, $cxn );
        
                if (query_num_rows( $result3 ) > 0)
                {
        	    	$data3 = get_row( $result3 );
    
                    $query4 = "SELECT * FROM roster WHERE stylist = '".$stylist."' AND effective_date = '".$data3['effective_date']."' AND day_of_week_text = '".$day_of_week_text."'";
                    
                	$result4 = run_query( $query4, $cxn );
                    
                	for ($j=0; $j < query_num_rows( $result4 ); $j++)
                	{
            	    	$data4 = get_row( $result4 );
    
//                        echo $this_date_str." ".$day_of_week." ".$stylist." ".($data4['finish_time'] - $data4['start_time'])."<br>";
                    
                        $hours_rostered_on += $data4['finish_time'] - $data4['start_time'] - $data4['meal_breaks'];
                	}
                }
            }            
            
//            echo $this_date_str." ".$day_of_week." ".$stylist." ".$hours_rostered_on."<br>";
        }
        
        return ($hours_rostered_on);
    }  

?>