<?php

	include "library.php";

	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );


    $pay_run_id = val( $_POST, "pay_run_id" );
    
    

	page_header( "Show pay run", $cxn );


	$date_today = date( "Y-m-d H:i:s" );


    $query = "SELECT * FROM pay_run WHERE id = ".$pay_run_id;
    
    $result = run_query( $query, $cxn );
    
	$data = get_row( $result );


	$pay_run_date = $data['run_date'];
	
    $report_start_date = $data['start_of_period'];

    $report_end_date = $data['end_of_period'];


    $start_date = date_create( $report_start_date );

    $end_date = date_create( $report_end_date );


	echo black( "<br><br><b>".$start_date->format( "D d/m/Y" )." to ".$end_date->format( "D d/m/Y" )."</b><br><br><br><br>" );

	
    $query = "SELECT * FROM pay_run_line WHERE pay_run_id = ".$pay_run_id." ORDER BY employee_name";
    
    $result = run_query( $query, $cxn );
    
    echo "<table>";
    
    echo "<td>".blue( "Pay run ID" )."</td>";
    echo "<td>".blue( "Pay run date" )."</td>";
    echo "<td>".blue( "Employee name" )."</td>";
    echo "<td>".blue( "Hours worked" )."</td>";
    echo "<td>".blue( "Salary due" )."</td>";
    echo "<td>".blue( "Tax" )."</td>";
    echo "<td>".blue( "Net pay" )."</td>";
    echo "<td>".blue( "Superannuation" )."</td>";
    echo "<td>".blue( "Annual leave accumulated this period" )."</td>";
    echo "<td>".blue( "Personal leave accumulated this period" )."</td>";
    echo "</tr>";
    
    echo "<tr><td>&nbsp;</td></tr>";

    $total_salary_due = 0;
    $total_tax = 0;
    $total_net_pay = 0;
    $total_superannuation = 0;
    
    
    for ($i=0; $i < query_num_rows( $result ); $i++)
    {
        $data = get_row( $result );
        
        $total_salary_due += $data['salary_due'];
        $total_tax += $data['tax'];
        $total_net_pay += $data['net_pay'];
        $total_superannuation += $data['superannuation'];
        
        echo "<tr>";
        echo "<td>".black( $data['pay_run_id'] )."</td>";
        echo "<td>".black( $data['pay_run_date'] )."</td>";
        echo "<td>".black( $data['employee_name'] )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( $data['hours_worked'] )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['salary_due'], 2 ) )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['tax'], 0 ) )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['net_pay'], 2 ) )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['superannuation'], 2 ) )."</td>";
        echo "<td align='right'>".black( $data['annual_leave_accumulated_this_period'] )."</td>";
        echo "<td align='right'>".black( $data['personal_leave_accumulated_this_period'] )."</td>";
        echo "</tr>";
    }

    echo "<tr><td>&nbsp;</td></tr>";
  
    echo "<tr>";
    echo "<td>".black( "Total" )."</td>";
    echo "<td></td>";
    echo "<td></td>";
    echo "<td></td>";
    echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $total_salary_due, 2 ) )."</td>";
    echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $total_tax, 0 ) )."</td>";
    echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $total_net_pay, 2 ) )."</td>";
    echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $total_superannuation, 2 ) )."</td>";
    echo "<td></td>";
    echo "<td></td>";
    echo "</tr>";
  
    echo "</table>";
    
?>