<?php

	include "library.php";

	$cxn = start_code();

    exit_if_search_bot();

    exit_if_session_expired( $cxn );


    $start_date = val( $_POST, "start_date" );

	$end_date = val( $_POST, "end_date" );
	
   
     
	$report_start_date = convert_date_to_yyyymmdd( $start_date, "dd/mm/yyyy", $cxn );

	$report_end_date = convert_date_to_yyyymmdd( $end_date, "dd/mm/yyyy", $cxn );

    

	page_header( "Superannuation", $cxn );


	echo black( $start_date." to ".$end_date."<br><br><br><br>" );


    $query = "SELECT * FROM pay_run_line WHERE pay_run_date >= '".$report_start_date."' AND pay_run_date <= '".$report_end_date."' ORDER BY employee_name";
    
    $result = run_query( $query, $cxn );
    
 
    for ($i=0; $i < query_num_rows( $result ); $i++)
    {
        $data = get_row( $result );
        
        if (! isset( $total_super[$data['employee_name']] ))
            $total_super[$data['employee_name']] = 0;
            
        $total_super[$data['employee_name']] += $data['superannuation'];
    }
    
    
    $query2 = "SELECT DISTINCT employee_name FROM pay_run_line WHERE pay_run_date >= '".$report_start_date."' AND pay_run_date <= '".$report_end_date."' ORDER BY employee_name";
    
    $result2 = run_query( $query2, $cxn );
    
    $grand_total = 0;
 
    echo "<table>";
    
    
    echo "<tr>";
    
    echo "<td>".blue( "Employee name" )."</td>";
    
    echo "<td>".blue( "Total superannuation in the period" )."</td>";
    
    echo "</tr>";
    
    echo "<tr><td>&nbsp;</td></tr>";
      
    for ($i=0; $i < query_num_rows( $result2 ); $i++)
    {
        $data2 = get_row( $result2 );
       
        $grand_total += $total_super[$data2['employee_name']];
        
        
        echo "<tr>";
        
        echo "<td>".black( $data2['employee_name'] )."</td>";
        
        echo "<td align='right'>".black( number_format( $total_super[$data2['employee_name']], 2 ))."</td>";
        
        echo "</tr>";
    }
        
    echo "<tr>";
    
    echo "<td>".black( "Total" )."</td>";
    
    echo "<td align='right'>".black( number_format( $grand_total, 2 ) )."</td>";
    
    echo "</tr>";
    
    echo "</table>";
    
    echo "<br><br><br>";
    
    echo blue( "Details of pay runs" );
    
    echo "<br><br>";
    

    $query = "SELECT * FROM pay_run_line WHERE pay_run_date >= '".$report_start_date."' AND pay_run_date <= '".$report_end_date."' ORDER BY pay_run_id, employee_name";
    
    $result = run_query( $query, $cxn );

    echo "<table>";
    
    echo "<td>".blue( "Pay run ID" )."</td>";
    echo "<td>".blue( "Pay run date" )."</td>";
    echo "<td>".blue( "Employee name" )."</td>";
    echo "<td>".blue( "Hours worked" )."</td>";
    echo "<td>".blue( "Salary due" )."</td>";
    echo "<td>".blue( "Tax" )."</td>";
    echo "<td>".blue( "Net pay" )."</td>";
    echo "<td>".blue( "Superannuation" )."</td>";
    echo "<td>".blue( "Annual leave accumulated this period" )."</td>";
    echo "<td>".blue( "Personal leave accumulated this period" )."</td>";
    echo "</tr>";
 
    echo "<tr><td>&nbsp;</td></tr>";
    
    for ($i=0; $i < query_num_rows( $result ); $i++)
    {
        $data = get_row( $result );
        
        echo "<tr>";
        echo "<td>".black( $data['pay_run_id'] )."</td>";
        echo "<td>".black( $data['pay_run_date'] )."</td>";
        echo "<td>".black( $data['employee_name'] )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( $data['hours_worked'] )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['salary_due'], 2 ) )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['tax'], 0 ) )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['net_pay'], 2 ) )."</td>";
        echo "<td align='right'>&nbsp;&nbsp;".black( number_format( $data['superannuation'], 2 ) )."</td>";
        echo "<td align='right'>".black( $data['annual_leave_accumulated_this_period'] )."</td>";
        echo "<td align='right'>".black( $data['personal_leave_accumulated_this_period'] )."</td>";
        echo "</tr>";
    }
    
    echo "</table>";
   
    
?>
