<?php

	include "library.php";

	$cxn = start_code();
	

	page_header( "Hours worked by week", $cxn );


    $end_date = date_create( date( "Y-m-d" ) );


    $day_of_week = jddayofweek( gregoriantojd( date( "m" ), date("d"), date("Y") ) );

    if ($day_of_week != 0)
	    date_add( $end_date, date_interval_create_from_date_string( (7-$day_of_week)." days" ));


	$start_date = clone( $end_date );
	
	date_sub( $start_date, date_interval_create_from_date_string( '14 days' ));


    $start_date_text = $start_date->format( "d/m/Y" );

    $end_date_text = $end_date->format( "d/m/Y" );


	form_start( "list_hours_worked_by_week.php" );

	write_yellow_input_boxes();
	
	echo "<tr></tr><tr><td>&nbsp;</td></tr>";


	form_text( "Start Date", "start_date", 10, $start_date_text, "true" );

	form_text( "End Date", "end_date", 10, $end_date_text );
	
	echo "<tr><td>&nbsp;</td></tr>";


	form_submit_new( "Go", 50 );

	form_end();
	
	
?>	